/***************************************************************************
                          framedlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qvalidator.h>
#include <klocale.h>
#include <kapp.h>
#include <kcolorbtn.h>
#include "framedlg.h"
#include "kpldoc.h"
#include "edittextdlg.h"
#include "arrayitem.h"
#include "funitem.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "utils.h"

FrameDlg::FrameDlg(QWidget* parent, KplDoc* model, int it) :
 QDialog(parent, 0, true), m(model), item(it), iex(999), iey(999)
{
  pfd = (FrameItem*) m->itd.at(item);
  fd = *pfd;
  setCaption(i18n("Frame"));
  resize(520, 430);
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  QGridLayout* grid = new QGridLayout(vbox, 3, 2);
  grid->addWidget(bg = new QButtonGroup(0, Qt::Vertical, i18n("Axis mode"),
                                        this), 0, 0);
  QVBoxLayout* vbox2 = new QVBoxLayout(bg->layout(), 8);
  vbox2->addWidget(new QRadioButton(i18n("Frame only"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Tics"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Tics with numbers"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Grid"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Grid with numbers"), bg));
  ((QRadioButton*) bg->find(fd.gridmode))->setChecked(true);
  vbox2 = new QVBoxLayout(6);
  grid->addLayout(vbox2, 0, 1);
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, i18n("Window"), this);
  vbox2->addWidget(g);
  QGridLayout* grid2 = new QGridLayout(g->layout(), 2, 7, 6);
  grid2->addWidget(new QLabel(i18n("Left margin"), g), 0, 0);
  grid2->addWidget(ex0 = new KplDoubleEdit(fd.xw0, 0.0, 200.0, g), 0, 1);
  grid2->addWidget(new QLabel("cm", g), 0, 2);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid2->addWidget(new QLabel(i18n("Width"), g), 0, 4);
  grid2->addWidget(exl = new KplDoubleEdit(fd.xw, 0.5, 200.0, g), 0, 5);
  grid2->addWidget(new QLabel("cm", g), 0, 6);
  grid2->addWidget(new QLabel(i18n("Bottom margin"), g), 1, 0);
  grid2->addWidget(ey0 = new KplDoubleEdit(fd.yw0, 0.0, 200.0, g), 1, 1);
  grid2->addWidget(new QLabel("cm", g), 1, 2);
  grid2->addWidget(new QLabel(i18n("Height"), g), 1, 4);
  grid2->addWidget(eyl = new KplDoubleEdit(fd.yw, 0.5, 200.0, g), 1, 5);
  grid2->addWidget(new QLabel("cm", g), 1, 6);
  vbox2->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Scaling"), this));
  grid2 = new QGridLayout(g->layout(), 2, 7, 6);
  grid2->addWidget(new QLabel("xmin", g), 0, 0);
  grid2->addWidget(exMin = new KplDoubleEdit(fd.xmi, fd.logx ? 1.0e-99 : -1.0e99,
                                             1.0e99, g, "%.6lg"), 0, 1);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid2->addWidget(new QLabel("xmax", g), 0, 3);
  grid2->addWidget(exMax = new KplDoubleEdit(fd.xma, fd.logx ? 1.0e-99 : -1.0e99,
                                             1.0e99, g, "%.6lg"), 0, 4);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 5);
  grid2->addWidget(logX = new QCheckBox("log", g), 0, 6);
  logX->setChecked(fd.logx);
  connect(logX, SIGNAL(toggled(bool)), SLOT(slotLogToggled(bool)));
  grid2->addWidget(new QLabel("ymin", g), 1, 0);
  grid2->addWidget(eyMin = new KplDoubleEdit(fd.ymi, fd.logy ? 1.0e-99 : -1.0e99,
                                             1.0e99, g, "%.6lg"), 1, 1);
  grid2->addWidget(new QLabel("ymax", g), 1, 3);
  grid2->addWidget(eyMax = new KplDoubleEdit(fd.yma, fd.logy ? 1.0e-99 : -1.0e99,
                                             1.0e99, g, "%.6lg"), 1, 4);
  grid2->addWidget(logY = new QCheckBox("log", g), 1, 6);
  logY->setChecked(fd.logy);
  connect(logY, SIGNAL(toggled(bool)), SLOT(slotLogToggled(bool)));
  grid->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Colors"), this),
                  1, 0);
  grid2 = new QGridLayout(g->layout(), 2, 2, 6);
  grid2->addWidget(new QLabel(i18n("Frame"), g), 0, 0);
  grid2->addWidget(colFrame = new KColorButton(QColor(fd.colFrame), g), 0, 1);
  grid2->addWidget(new QLabel(i18n("Grid"), g), 1, 0);
  grid2->addWidget(colGrid = new KColorButton(QColor(fd.colGrid), g), 1, 1);
  grid->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Axes"), this),
                  1, 1);
  grid2 = new QGridLayout(g->layout(), 2, 8, 6);
  grid2->addWidget(new QLabel("xtic", g), 0, 0);
  grid2->addWidget(exTic = new KplDoubleEdit(fd.xtic, 0.0, 0.0, g, "%.6lg"),
                   0, 1);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid2->addWidget(new QLabel("mticx", g), 0, 3);
  grid2->addWidget(emTicx = new KplSpinBox(0, 10, 1, g), 0, 4);
  emTicx->setValue(fd.mticx);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 5);
  grid2->addWidget(new QLabel("ndigx", g), 0, 6);
  grid2->addWidget(enDigx = new KplSpinBox(-1, 8, 1, g), 0, 7);
  enDigx->setValue(fd.ndigx);
  grid2->addWidget(new QLabel("ytic", g), 1, 0);
  grid2->addWidget(eyTic = new KplDoubleEdit(fd.ytic, 0.0, 0.0, g, "%.6lg"),
                   1, 1);
  grid2->addWidget(new QLabel("mticy", g), 1, 3);
  grid2->addWidget(emTicy = new KplSpinBox(0, 10, 1, g), 1, 4);
  emTicy->setValue(fd.mticy);
  grid2->addWidget(new QLabel("ndigy", g), 1, 6);
  grid2->addWidget(enDigy = new KplSpinBox(-1, 8, 1, g), 1, 7);
  enDigy->setValue(fd.ndigy);
  grid->addLayout(vbox2 = new QVBoxLayout(6), 2, 0);
  vbox2->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Automatic"),
                   this));
  QVBoxLayout* vbox3 = new QVBoxLayout(g->layout(), 6);
  vbox3->addWidget(autoNorm = new QCheckBox(i18n("Normalization"), g));
  autoNorm->setChecked(m->aut.autoNorm && (!(fd.logx || fd.logy)));
  connect(autoNorm, SIGNAL(toggled(bool)), SLOT(slotNormToggled(bool)));
  QPushButton* b = new QPushButton(i18n("Autoscale"), g);
  vbox3->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotAutoScale()));
  bool e = false;
  if ((item + 1) < (int) m->itd.count())
    for (KplItem* itm = m->itd.at(item + 1); itm; itm = m->itd.next()) {
      switch (itm->iType()) {
        case KplItem::Array:
        case KplItem::Function:
        case KplItem::ParFunction:
          e = true;
          break;
        default:
          break;
      }
      if (itm->iType() == KplItem::Frame)
        break;
    }
  b->setEnabled(e);
  autoNorm->setEnabled(e);
  grid->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Labels"), this),
                  2, 1);
  grid2 = new QGridLayout(g->layout(), 3, 6, 6);
  grid2->addWidget(new QLabel("iex", g), 0, 0);
  grid2->addWidget(ex = new KplSpinBox(-99, 99, 1, g), 0, 1);
  ex->setValue(fd.iex);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid2->addWidget(new QLabel(i18n("x axis"), g), 0, 3);
  grid2->addWidget(eLetX = new QLineEdit(fd.sx, g), 0, 4);
  grid2->addWidget(b = new QPushButton("...", g), 0, 5);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetX()));
  grid2->addWidget(new QLabel("iey", g), 1, 0);
  grid2->addWidget(ey = new KplSpinBox(-99, 99, 1, g), 1, 1);
  ey->setValue(fd.iey);
  grid2->addWidget(new QLabel(i18n("y axis"), g), 1, 3);
  grid2->addWidget(eLetY = new QLineEdit(fd.sy, g), 1, 4);
  grid2->addWidget(b = new QPushButton("...", g), 1, 5);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetY()));
  grid2->addWidget(new QLabel(i18n("Heading"), g), 2, 3);
  grid2->addWidget(eLetH = new QLineEdit(fd.sh, g), 2, 4);
  grid2->addWidget(b = new QPushButton("...", g), 2, 5);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetH()));
  QHBoxLayout* hbox = new QHBoxLayout(vbox2, 6);
  hbox->addWidget(new QLabel(i18n("Symbol size"), this));
  hbox->addWidget(eRelSiz = new KplSpinBox(10, 800, 1, this));
  eRelSiz->setValue(qRound(100 * fd.relsiz));
  eRelSiz->setSuffix(" %");
  hbox = new QHBoxLayout(vbox, 6);
  hbox->addWidget(b = new QPushButton(i18n("Help"), this));
  connect(b, SIGNAL(clicked()), SLOT(slotHelp()));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(b = new QPushButton(i18n("OK"), this));
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(slotOK()));
  hbox->addWidget(b = new QPushButton(i18n("Apply"), this));
  connect(b, SIGNAL(clicked()), SLOT(slotApply()));
  hbox->addWidget(b = new QPushButton(i18n("Cancel"), this));
  connect(b, SIGNAL(clicked()), SLOT(reject()));
}

FrameDlg::~FrameDlg()
{
}

void FrameDlg::getValues(bool ok)
{
  fd.xmi = exMin->value();
  fd.xma = exMax->value();
  fd.ymi = eyMin->value();
  fd.yma = eyMax->value();
  fd.logx = logX->isChecked();
  fd.logy = logY->isChecked();
  fd.xtic = exTic->value();
  fd.ytic = eyTic->value();
  fd.xw0 = ex0->value();
  fd.yw0 = ey0->value();
  fd.xw = exl->value();
  fd.yw = eyl->value();
  fd.colFrame = colFrame->color().rgb();
  fd.colGrid = colGrid->color().rgb();
  fd.iex = ex->interpretedValue();
  fd.iey = ey->interpretedValue();
  fd.mticx = emTicx->interpretedValue();
  fd.mticy = emTicy->interpretedValue();
  fd.ndigx = enDigx->interpretedValue();
  fd.ndigy = enDigy->interpretedValue();
  fd.sx = eLetX->text();
  fd.sy = eLetY->text();
  fd.sh = eLetH->text();
  fd.relsiz = 0.01 * eRelSiz->interpretedValue();
  fd.gridmode = -1;
  QRadioButton* rb;
  do
    rb = (QRadioButton*) bg->find(++fd.gridmode);
  while (!rb->isChecked());
  if ((iex != 999) && (iey != 999)) {
    for (KplItem* itm = m->itd.at(item + 1); itm; itm = m->itd.next()) {
      itm->normalize(fx, fy);
      if (itm->iType() == KplItem::Frame)
        break;
    }
  }
  *pfd = fd;
  m->setModified();
  m->backupItems();
  if (ok)
    accept();
}

void FrameDlg::editText(QLineEdit* ed)
{
  EditTextDlg dlg(this, ed);
  dlg.exec();
}

void FrameDlg::slotLogToggled(bool state)
{
  QCheckBox* b = (QCheckBox*) sender();
  if ((b == logX) || (b == logY)) {
    KplSpinBox* nd;
    KplDoubleEdit *mi, *ma;
    if (b == logX) {
      nd = enDigx;
      mi = exMin;
      ma = exMax;
    } else {
      nd = enDigy;
      mi = eyMin;
      ma = eyMax;
    }
    nd->setEnabled(!state);
    double bottom = state ? 1.0e-99 : -1.0e99;
    mi->validator->setBottom(bottom);
    ma->validator->setBottom(bottom);
  }
  if (state)
    autoNorm->setChecked(false);
}

void FrameDlg::slotNormToggled(bool state)
{
  if (state) {
    logX->setChecked(false);
    logY->setChecked(false);
  }
}

void FrameDlg::slotEditLetX()
{
  editText(eLetX);
}

void FrameDlg::slotEditLetY()
{
  editText(eLetY);
}

void FrameDlg::slotEditLetH()
{
  editText(eLetH);
}

void FrameDlg::slotAutoScale()
{
  double xmi, xma, ymi, yma, xtic, ytic;
  int mticx, mticy, ndigx, ndigy;
  m->autoScaleFrame(autoNorm->isChecked(), item, &iex, &iey, &fx, &fy,
                    &xmi, &xma, &ymi, &yma, &xtic, &ytic, &mticx, &mticy,
                    &ndigx, &ndigy, exl->value() / eyl->value(),
                    logX->isChecked(), logY->isChecked());
  if ((iex != 999) && (iey != 999)) {
    ex->setValue(iex);
    emTicx->setValue(mticx);
    enDigx->setValue(ndigx);
    exMin->setText(QString::number(xmi));
    exMax->setText(QString::number(xma));
    exTic->setText(QString::number(xtic));
    ey->setValue(iey);
    emTicy->setValue(mticy);
    enDigy->setValue(ndigy);
    eyMin->setText(QString::number(ymi));
    eyMax->setText(QString::number(yma));
    eyTic->setText(QString::number(ytic));
  }
}

void FrameDlg::slotOK()
{
  getValues(true);
}

void FrameDlg::slotApply()
{
  getValues(false);
}

void FrameDlg::slotHelp()
{
  kapp->invokeHelp("SEC-FRAME");
}
