//----------------------------------------------------------------------------
//    filename             : kbearextmditaskbar.h
//----------------------------------------------------------------------------
//    Project              : Qt MDI extension
//
//    begin                : 07/1999       by Szymon Stefanek as part of kvirc
//                                         (an IRC application)
//    changes              : 09/1999       by Falk Brettschneider to create an
//                           - 06/2000     stand-alone Qt extension set of
//                                         classes and a Qt-based library
//
//    copyright            : (C) 1999-2000 by Falk Brettschneider
//                                         and
//                                         Szymon Stefanek (stefanek@tin.it)
//    email                :  gigafalk@yahoo.com (Falk Brettschneider)
//----------------------------------------------------------------------------
//  changes for KBear
//  20000820 - Name changed to KBearExtMdi....
//  20000912 - Changed inheritance to KToolBar
//
//----------------------------------------------------------------------------
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU Library General Public License as
//    published by the Free Software Foundation; either version 2 of the
//    License, or (at your option) any later version.
//
//----------------------------------------------------------------------------

#ifndef KBEAREXTMDITASKBAR_H_
#define KBEAREXTMDITASKBAR_H_

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtoolbar.h>
#include <qlist.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qpushbutton.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <ktoolbar.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include <kbearextmdidefines.h>

class KBearExtMdiMainFrm;
class KBearExtMdiChildView;
class KBearExtMdiTaskBar;

/**
  * @short Internal class.
  *
  * It's a special kind of QPushButton catching mouse clicks.
  * And you have the ability to abbreviate the text that it fits in the button.
  */
class KBearExtMdiTaskBarButton : public QPushButton
{
   Q_OBJECT
// methods
public:
   /** 
   * Constructor (sets to toggle button, adds a tooltip (caption) and sets to NoFocus 
   */
   KBearExtMdiTaskBarButton( KBearExtMdiTaskBar *pTaskBar, KBearExtMdiChildView *win_ptr);
   /** 
   * Destructor 
   */
   ~KBearExtMdiTaskBarButton();
   /** 
   * text() returns the possibly abbreviated text including the dots in it. But actualText() returns the full text. 
   */
   QString actualText() const;
   /** 
   * Given the parameter newWidth this function possibly abbreviates the parameter string and sets a new button text. 
   */
   void fitText(const QString&, int newWidth);
   /** 
   * Sets the text and avoids any abbreviation. Memorizes that text in m_actualText, too. 
   */
   void setText(const QString&);
signals:
   /** 
   * Emitted when the button has been clicked. Internally connected to setFocus of the according MDI view. 
   */
   void clicked(KBearExtMdiChildView*);
   /** 
   * Internally connected with @ref KBearExtMdiMainFrm::activateView
   */
   void leftMouseButtonClicked(KBearExtMdiChildView*);
   /** 
   * Internally connected with @ref KBearExtMdiMainFrm::taskbarButtonRightClicked
   */
   void rightMouseButtonClicked(KBearExtMdiChildView*);
   /** 
   * Emitted when the button text has changed. Internally connected with @ref KBearExtMdiTaskBar::layoutTaskBar
   */
   void buttonTextChanged(int);
public slots:
   /** 
   * A slot version of setText 
   */
   void setNewText(const QString&);
protected slots:
   /** 
   * Reimplemented from its base class to catch right and left mouse button clicks 
   */
   void mousePressEvent( QMouseEvent*);

// attributes
public:
   /** 
   * The according MDI view 
   */
   KBearExtMdiChildView *m_pWindow;
protected:
   /** 
   * Internally we must remember the real text because the button text can be abbreviated. 
   */
   QString m_actualText;
};

/**
 * @short Internal class.
 *
 * It's a special kind of QToolBar that acts as taskbar for child views.
 * KBearExtMdiTaskBarButtons can be added or removed dynamically.<br>
 * The button sizes are adjusted dynamically, as well.
 */
class KBearExtMdiTaskBar : public KToolBar
{
   Q_OBJECT
public:
   /** 
   * Constructor (NoFocus, minimum width = 1, an internal QList of taskbar buttons (autodelete)) 
   */
   KBearExtMdiTaskBar(KBearExtMdiMainFrm *parent );
   /** 
   * Destructor (deletes the taskbar button list) 
   */
   ~KBearExtMdiTaskBar();
   /** 
   *Add a new @ref KBearExtMdiTaskBarButton . The width doesn't change.
   * If there's not enough space, all taskbar buttons will be resized to a new smaller size.
   * Probably button texts must be abbreviated now. 
   */
   KBearExtMdiTaskBarButton * addWinButton(KBearExtMdiChildView *win_ptr);
   /** 
   * Removes a @ref KBearExtMdiTaskBarButton and deletes it. If the rest of the buttons are smaller
   * than they usually are, all those buttons will be resized in a way that the new free size is used as well. 
   */
   void removeWinButton(KBearExtMdiChildView *win_ptr, bool haveToLayoutTaskBar = TRUE);
   /** 
   * Returns the neighbor taskbar button of the taskbar button of the MDI view given by parameter
   * bRight specifies the side, of course left is used if bRight is false. 
   */
   KBearExtMdiTaskBarButton * getNextWindowButton(bool bRight,KBearExtMdiChildView *win_ptr);
   /** 
   * Get the button belonging to the MDI view given as parameter. 
   */
   KBearExtMdiTaskBarButton * getButton(KBearExtMdiChildView *win_ptr);
protected:
   /** 
   * Reimplemented from its base class to call layoutTaskBar, additionally. 
   */
   void resizeEvent( QResizeEvent*);
protected slots:
   /** 
   * Checks if all buttons fits into this. If not, it recalculates all button widths
   * in a way that all buttons fits into the taskbar and have got equal width.
   * The text of the buttons will be abbreviated when nessecary, all buttons get a
   * fixed width and show() is called for each one.
   * If one drags the taskbar to a vertical orientation, the button width is set to 80 pixel. 
   */
   void layoutTaskBar( int taskBarWidth = 0);
public slots:
   /** 
   * Pushes the desired taskbar button down (switch on), the old one is released (switched off).
   * Actually it's a radiobutton group behaviour. 
   */
   void setActiveButton(KBearExtMdiChildView *win_ptr);
protected:
   /** 
   * A list of taskbar buttons.
   * Note: Each button stands for one MDI view (toolviews doesn't have got a taskbar button). 
   */
   QList<KBearExtMdiTaskBarButton>*  m_pButtonList;
   /** 
   * The belonging MDI mainframe (parent widget of this) 
   */
   KBearExtMdiMainFrm*               m_pFrm;
   /** 
   * The MDI view belonging to the currently pressed taskbar button 
   */
   KBearExtMdiChildView*             m_pCurrentFocusedWindow;
   /** 
   * A stretchable widget used as 'space' at the end of a half filled taskbar 
   */
   QLabel*                       m_pStretchSpace;
};

#endif //KBEAREXTMDITASKBAR_H_
