//----------------------------------------------------------------------------
//    filename             : kbearextmdimainfrm.h
//----------------------------------------------------------------------------
//    Project              : Qt MDI extension
//
//    begin                : 07/1999       by Szymon Stefanek as part of kvirc
//                                         (an IRC application)
//    changes              : 09/1999       by Falk Brettschneider to create an
//                           - 06/2000     stand-alone Qt extension set of
//                                         classes and a Qt-based library
//                         : 02/2000       by Massimo Morin (mmorin@schedsys.com)
//    patches              : */2000        by Lars Beikirch (Lars.Beikirch@gmx.net)
//
//    copyright            : (C) 1999-2000 by Falk Brettschneider
//                                         and
//                                         Szymon Stefanek (stefanek@tin.it)
//    email                :  gigafalk@yahoo.com (Falk Brettschneider)
//----------------------------------------------------------------------------
//  changes for KBear  - Bjrn Sahlstrm bjorn.sahlstrom@mail.bip.net
//  20000820 - Name changed to KBearExtMdi...
//						- Added a QSplitter in the working area
//						- Changed inheritance in KBearExtMdiMainFrm from QMainWindow to KMainWindow
//----------------------------------------------------------------------------
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU Library General Public License as
//    published by the Free Software Foundation; either version 2 of the
//    License, or (at your option) any later version.
//
//----------------------------------------------------------------------------

#ifndef KBEAREXTMDIMAINFRM_H_
#define KBEAREXTMDIMAINFRM_H_

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qlist.h>
#include <qrect.h>
#include <qpopupmenu.h>
#include <qapplication.h>
#include <qmenubar.h>
#include <qsplitter.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kmainwindow.h>
#include <kapp.h>
#include <klocale.h>
#include <kglobal.h>
#include <kstddirs.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearextmdichildview.h"
#include "kbearextmditaskbar.h"
#include "kbearextmdimainfrm.h"
#include "kbearextmdichildarea.h"
#include "kbearextmdiiterator.h"
#include "kbearextmdilistiterator.h"
#include "kbearextmdinulliterator.h"

namespace KBearExtMdi {

/**
* During @ref KBearExtMdiMainFrm::addWindow the enum AddWindowFlags is used to determine how the view is initialy being added to the MDI system
*/
typedef enum {
      /**
      * standard is: show normal, attached, visible, document view (not toolview)
      */
      StandardAdd = 0,
      /**
      * add a maximized view
      */
      Maximize    = 1,
      /**
      * add a minimized view
      */
      Minimize    = 2,
      /**
      * add a view that is not visible for the moment but under MDI control
      */
      Hide        = 4,
      /**
      * add a view that appears toplevel
      */
      Detach      = 8,
      /**
      * add the view as tool view. That means it is stay-on-top and toplevel
      */
      ToolWindow  = 16
   } AddWindowFlags;

}; //namespace

/**
 * @short Internal class
 *
 * This special event is needed because the view has to inform the main frame that it`s being closed.
 */
class KBearExtMdiViewCloseEvent : public QCustomEvent
{
public:
   KBearExtMdiViewCloseEvent( KBearExtMdiChildView* pWnd) : QCustomEvent(QEvent::User,pWnd) {};
};

/**
  * @short Base class for all your special main frames.
  *
  * It contains the child frame area and a child view taskbar.
  * Defines some virtual functions for later common use.
  * Provides functionality for docking/undocking view windows and manages the taskbar.<br>
  * Usually you just need to know about this class and the child view class.
  */
class KBearExtMdiMainFrm : public KMainWindow
{
   friend class KBearExtMdiChildView;
   friend class KBearExtMdiTaskBar;

   Q_OBJECT

// attributes
protected:
   KBearExtMdiChildArea        *m_pMdi;
   KBearExtMdiTaskBar          *m_pTaskBar;
   QList<KBearExtMdiChildView> *m_pWinList;
   KBearExtMdiChildView        *m_pCurrentWindow;
   QPopupMenu              *m_pWindowPopup;
   QPopupMenu              *m_pTaskBarPopup;
   QPopupMenu              *m_pWindowMenu;
   QPopupMenu              *m_pDockMenu;
   QPopupMenu              *m_pPlacingMenu;
   QMenuBar                *m_pMainMenuBar;

   QPixmap                 *m_pUndockButtonPixmap;
   QPixmap                 *m_pMinButtonPixmap;
   QPixmap                 *m_pRestoreButtonPixmap;
   QPixmap                 *m_pCloseButtonPixmap;

  QToolButton             *m_pUndock;
   QToolButton             *m_pMinimize;
   QToolButton             *m_pRestore;
   QToolButton             *m_pClose;
   QPoint                  m_undockPositioningOffset;
   bool                    m_bTopLevelMode;
   bool                    m_bMaximizedChildFrmMode;
   int                     m_oldMainFrmHeight;
   int                     m_oldMainFrmMinHeight;
   int                     m_oldMainFrmMaxHeight;
	QSplitter* p_mySplitter;

// methods
public:
   /**
   * Constructor.
   */
   KBearExtMdiMainFrm( QWidget* parentWidget, const char* name = "", WFlags flags = WType_TopLevel);
   /**
   * Destructor.
   */
   ~KBearExtMdiMainFrm();
   /**
   * Returns whether the application's MDI views are in maximized state or not.
   */
   bool isInMaximizedChildFrmMode() { return m_bMaximizedChildFrmMode; };
   /**
   * Returns whether the MDI application is in Toplevel mode or not. Toplevel mode means that
   * all MDI views are undocked by one method call @ref KBearExtMdiMainFrm::switchToToplevelMode .
   * You can call this 'event' via 'Window' menu.
   */
   bool isInTopLevelMode() { return m_bTopLevelMode; };
   /**
   * Returns the focused attached MDI view.
   */
   KBearExtMdiChildView * activeWindow();
   /**
   * Returns a popup menu filled according to the MDI view state. You can override this
   * method to insert additional entries there. The popup menu is usually popuped when the user
   * clicks with the right mouse button on a taskbar entry. The default entries are:
   * Undock/Dock, Restore/Maximize/Minimize, Close and an empty sub-popup ( @ref KBearExtMdiMainFrm::windowPopup )
   * menu called Operations.
   */
   virtual QPopupMenu * taskBarPopup(KBearExtMdiChildView *pWnd,bool bIncludeWindowPopup = FALSE);
   /**
//   * Returns a popup menu with only a title "Window". You can fill it with own operations entries
//   * on the MDI view. This popup menu is inserted as last menu item in @ref KBearExtMdiMainFrm::taskBarPopup .
//   */
//   virtual QPopupMenu * windowPopup(KBearExtMdiChildView *pWnd,bool bIncludeTaskbarPopup = TRUE);
   /**
   * Called in the constructor (forces a resize of all MDI views)
   */
   virtual void applyOptions();
   /**
   * Returns the KBearExtMdiChildView belonging to the given caption string.
   */
   KBearExtMdiChildView * findWindow(const QString& caption);
   /**
   * Returns whether this MDI child view is under MDI control (using @ref KBearExtMdiMainFrm::addWindow ) or not.
   */
   bool windowExists(KBearExtMdiChildView *pWnd);
   /**
   * Catches certain Qt events and processes it here.
   * Currently, here this catches only the @ref KBearExtMdiViewCloseEvent (a KBearExtMDI user event) which is sent
   * from itself in @ref KBearExtMdiMainFrm::childWindowCloseRequest right after a @ref KBearExtMdiChildView::closeEvent .
   * The reason for this event to itself is simple: It just wants to break the function call stack.
   * It continues the processing with calling @ref KBearExtMdiMainFrm::closeWindow .
   * You see, a @ref KBearExtMdiChildView::close is translated to a @ref KBearExtMdiMainFrm::closeWindow .
   * It is necessary that the main frame has to start an MDI view close action because it must
   * remove the MDI view from MDI control, additionally.
   *
   * This method calls QMainWindow::event , additionally.
   */
   virtual bool event(QEvent* e);
   /**
   * If there's a main menubar given, it will create the 4 maximize mode buttons there (undock, minimize, restore, close).
   */
   virtual void setSysButtonsAtMenuPosition();
   /**
   * Returns the height of the taskbar.
   */
   virtual int taskBarHeight() { return m_pTaskBar->height(); };
   /**
   * Sets an offset value that is used on @ref KBearExtMdiMainFrm::detachWindow . The undocked window
   * is visually moved on the desktop by this offset.
   */
   virtual void setUndockPositioningOffset( QPoint offset) { m_undockPositioningOffset = offset; };
   /**
   * If you don't want to know about the inner structure of the KBearExtMDI system, you can use
   * this iterator to handle with the MDI view list in a more abstract way.
   * The iterator hides what special data structure is used in KBearExtMDI.
   */
   KBearExtMdiIterator<KBearExtMdiChildView*>* createIterator() {
      if ( m_pWinList == 0L) {
         return new KBearExtMdiNullIterator<KBearExtMdiChildView*>();
      } else {
         return new KBearExtMdiListIterator<KBearExtMdiChildView, KBearExtMdiChildView*>( *m_pWinList);
      }
   }
   /**
   * Returns a popup menu that contains the MDI controlled view list.
   * Additionally, this menu provides some placing actions for these views.
   * Usually, you insert this popup menu in your main menubar as "Window" menu.
   */
   QPopupMenu* windowMenu() { return m_pWindowMenu; };
   /**
   * Sets a background colour for the MDI view area widget.
   */
   virtual void setBackgroundColor( const QColor &c) { m_pMdi->setBackgroundColor( c); };
   /**
   * Sets a background pixmap for the MDI view area widget.
   */
   virtual void setBackgroundPixmap( const QPixmap &pm) { m_pMdi->setBackgroundPixmap( pm); };
   /**
   * Sets a size that is used as the default size for a newly to the MDI system added @ref KBearExtMdiChildView .
   *  By default this size is 600x400. So all non-resized added MDI views appear in that size.
   */
   void setDefaultChildFrmSize( const QSize& sz)
      { m_pMdi->m_defaultChildFrmSize = sz; };
   /**
   * Returns the default size for a newly added KBearExtMdiChildView. See @ref KBearExtMdiMainFrm::setDefaultChildFrmSize .
   */
   QSize defaultChildFrmSize()
      { return m_pMdi->m_defaultChildFrmSize; };
   /**
   * Do nothing when in Toplevel mode
   */
   virtual void setMinimumSize( int minw, int minh);
   /**
   * Returns the Childframe mode height of this. Makes only sense when in Toplevel mode.
   */
   int childFrameModeHeight() { return m_oldMainFrmHeight; };

public slots:
   /**
    * One of the most important methods at all!
    * Adds a KBearExtMdiChildView to the MDI system. The main frame takes it under control.
    * You can specify here whether:
    * <UL><LI>the view should be attached or detached.</LI>
    * <LI>shown or hidden</LI>
    * <LI>maximized, minimized or restored (normalized)</LI>
    * <LI>added as tool view (stay-on-top and toplevel) or added as document-type view.
    */
   virtual void addWindow( KBearExtMdiChildView* pView, int flags = KBearExtMdi::StandardAdd);
   /**
   * See @ref the method above for more details. Additionally, it moves to point pos.
   */
   virtual void addWindow( KBearExtMdiChildView* pView, QPoint pos, int flags = KBearExtMdi::StandardAdd);
   /**
   * See @ref the method above for more details. Additionally, it sets the geometry.
   */
   virtual void addWindow( KBearExtMdiChildView* pView, QRect rectNormal, int flags = KBearExtMdi::StandardAdd);
   /**
   * Removes a KBearExtMdiChildView from the MDI system and from the main frame`s control.
   * Note: The view will not be deleted, but it's getting toplevel (reparent to 0)!
   */
   virtual void removeWindowFromMdi(KBearExtMdiChildView *pWnd);
   /**
   * Removes a KBearExtMdiChildView from the MDI system and from the main frame`s control.
   * Note: The view will be deleted!
   */
   virtual void closeWindow(KBearExtMdiChildView *pWnd, bool layoutTaskBar = TRUE);
   /**
   * Switches the KBearExtMdiTaskBar on and off.
   */
   virtual void slot_toggleTaskBar();
   /**
    * Makes a main frame controlled undocked KBearExtMdiChildView docked.
    * Doesn't work on KBearExtMdiChildView which aren't added to the MDI system.
    * Use addWindow() for that.
    */
   virtual void attachWindow(KBearExtMdiChildView *pWnd,bool bShow=TRUE);
   /**
    * Makes a docked KBearExtMdiChildView undocked.
    * The view window still remains under the main frame's MDI control.
    */
   virtual void detachWindow(KBearExtMdiChildView *pWnd,bool bShow=TRUE);
   /**
   * Someone wants that the MDI view to be closed. This method sends a KBearExtMdiViewCloseEvent to itself
   * to break the function call stack. See also @ref KBearExtMdiMainFrm::event .
   */
   virtual void childWindowCloseRequest(KBearExtMdiChildView *pWnd);
   /**
   * Close all views
   */
   virtual void closeAllViews();
   /**
   * Iconfiy all views
   */
   virtual void iconifyAllViews();
   /**
   * Closes the view of the active (topchild) window
   */
   virtual void closeActiveView();
   /**
   * Undocks all view windows (unix-like)
   */
   virtual void switchToToplevelMode();
   /**
   * Docks all view windows (Windows-like)
   */
   virtual void switchToChildframeMode();
   /**
   * Tells the MDI system a QMenu where it can insert buttons for
   * the system menu, undock, minimize, restore actions.
   * If no such menu is given, KBearExtMDI simply overlays the buttons
   * at the upper right-hand side of the main widget.
   */
   virtual void setMenuForSDIModeSysButtons( QMenuBar* = 0);
   /**
   * Shows the view taskbar. This should be connected with your "View" menu.
   */
   virtual void showViewTaskBar();
   /**
   * Hides the view taskbar. This should be connected with your "View" menu.
   */
   virtual void hideViewTaskBar();
   /**
   * Update of the window menu contents.
   */
   virtual void fillWindowMenu();

   /**
   * Cascades the windows without resizing them.
   */
   virtual void cascadeWindows() { m_pMdi->cascadeWindows(); }
   /**
   * Cascades the windows resizing them to the maximum available size.
   */
   virtual void cascadeMaximized() { m_pMdi->cascadeMaximized(); };
   /**
   * Maximizes only in vertical direction.
   */
   virtual void expandVertical() { m_pMdi->expandVertical(); };
   /**
   * Maximizes only in horizontal direction.
   */
   virtual void expandHorizontal() { m_pMdi->expandHorizontal(); };
   /**
   * Tile Pragma
   */
   virtual void tilePragma() { m_pMdi->tilePragma(); };
   /**
   * Tile Anodine
   */
   virtual void tileAnodine() { m_pMdi->tileAnodine(); };
   /**
   * Tile Vertically
   */
   virtual void tileVertically() { m_pMdi->tileVertically(); };
protected:
//   /**
//   * Calls the destructor by delete.
//   */
//   virtual void closeEvent(QCloseEvent *e);
   /**
   * Redirect the focus to the MDI area widget ( @ref KBearExtMdiChildArea ).
   */
   virtual void focusInEvent(QFocusEvent *);
   /**
   *
   */
   virtual void resizeEvent(QResizeEvent * );
   /**
   * Creates a new MDI taskbar (showing the MDI views as taskbar entries) and shows it.
   */
   virtual void createTaskBar();
   /**
   * Creates the MDI view area and connects some signals and slots with the KBearExtMdiMainFrm widget.
   */
   virtual void createMdiManager();
   /**
   * Usually called from @ref KBearExtMdiMainFrm::addWindow when adding a tool view window. It reparents the given widget
   * as toplevel and stay-on-top on the application's main widget.
   */
   virtual void addToolWindow( KBearExtMdiChildView* pWnd);

protected slots: // Protected slots
   /**
   * Sets the focus to this MDI view, raises it, activates its taskbar button and updates
   * the system buttons in the main menubar when in maximized (Maximize mode).
   */
   virtual void activateView(KBearExtMdiChildView *pWnd);
   /**
   * Activates the MDI view (see @ref KBearExtMdiMainFrm::activateView ) and popups the taskBar popup menu (see @ref KBearExtMdiMainFrm::taskBarPopup ).
   */
   virtual void taskbarButtonRightClicked(KBearExtMdiChildView *pWnd);
   /**
   * Turns the system buttons for maximize mode (SDI mode) on, and connects them with the current child frame
   */
   void setMaximizeModeOn();
   /**
   * Turns the system buttons for maximize mode (SDI mode) off, and disconnects them
   */
   void setMaximizeModeOff( KBearExtMdiChildFrm* oldChild);
   /**
   * Reconnects the system buttons form maximize mode (SDI mode) with the new child frame
   */
   void updateSysButtonConnections( KBearExtMdiChildFrm* oldChild, KBearExtMdiChildFrm* newChild);
   /**
   * Usually called when the user clicks an MDI view item in the "Window" menu.
   */
   void windowMenuItemActivated(int id);
   /**
   * Usually called when the user clicks an MDI view item in the sub-popup menu "Docking" of the "Window" menu.
   */
   void dockMenuItemActivated(int id);
   /**
   * Popups the "Window" menu. See also @ref KBearExtMdiMainFrm::windowPopup .
   */
   void popupWindowMenu(QPoint p);

signals:
   /** 
   * Signals the last attached @ref KBearExtMdiChildView has been closed
   */
   void lastChildFrmClosed();
   /** 
   * Signals the last KBearExtMdiChildView (that is under MDI control) has been closed
   */
   void lastChildViewClosed();
   /**
   * Signals that the Toplevel mode has been leaved
   */
   void leavedTopLevelMode();
};

#endif //KBEAREXTMDIMAINFRM_H_
