//----------------------------------------------------------------------------
//    filename             : kbearextmdilistiterator.h
//----------------------------------------------------------------------------
//    Project              : Qt MDI extension
//
//    begin                : 02/2000       by Massimo Morin
//    changes              : 02/2000       by Falk Brettschneider to create an
//                           - 06/2000     stand-alone Qt extension set of
//                                         classes and a Qt-based library
//
//    copyright            : (C) 1999-2000 by Massimo Morin (mmorin@schedsys.com)
//                                         and
//                                         Falk Brettschneider
//    email                :  gigafalk@yahoo.com (Falk Brettschneider)
//----------------------------------------------------------------------------
//  changes for KBear
//  20000820 - Name changed to KBearExtMdi...
//
//----------------------------------------------------------------------------
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU Library General Public License as
//    published by the Free Software Foundation; either version 2 of the
//    License, or (at your option) any later version.
//
//----------------------------------------------------------------------------

#ifndef KBEAREXTMDILISTITERATOR_H_
#define KBEAREXTMDILISTITERATOR_H_

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qlist.h>


template <class Item, class ItemPtr>
class KBearExtMdiListIterator : public KBearExtMdiIterator<ItemPtr> {
public:
   KBearExtMdiListIterator(QList<Item>& list) {
      m_iterator = new QListIterator<Item>(list);
   }

   virtual void first() {
      m_iterator->toFirst();
   }
   virtual void next()  { ++(*m_iterator); }
   virtual bool isDone() const { return m_iterator->current() == NULL; }
   virtual ItemPtr currentItem() const { return m_iterator->current(); }

   virtual ~KBearExtMdiListIterator() {
      delete m_iterator;
   }
  
private:
   QListIterator<Item> *m_iterator;
};

#endif // KBEAREXTMDILISTITERATOR_H_
