/*
 * play.c
 *
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 *
 */

#include "rogue.h"
#include "dun.h"

boolean interrupted = 0, warn_on_search = 0, warn_on_rest = 0;
char *unknown_command = "unknown command";

extern short party_room, bear_trap;
extern char hit_message[];
extern boolean wizard, trap_door, hit_msg_shown;

play_level(ch, count)
short ch;
int count;
{
	hit_msg_shown = 0;
	interrupted = 0;
CH:
	switch(ch) {
	case '.':
		rest((count > 0) ? count : 1);
		break;
	case 's':
		search(((count > 0) ? count : 1), 0);
		break;
	case 'f':
		fight(0);
		break;
	case 'F':
		fight(1);
		break;
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'y':
	case 'u':
	case 'n':
	case 'b':
		(void) one_move_rogue(ch, 1);
		break;
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'B':
	case 'Y':
	case 'U':
	case 'N':
	case 'h'+CMD_RUN:
	case 'j'+CMD_RUN:
	case 'k'+CMD_RUN:
	case 'l'+CMD_RUN:
	case 'y'+CMD_RUN:
	case 'u'+CMD_RUN:
	case 'n'+CMD_RUN:
	case 'b'+CMD_RUN:
		multiple_move_rogue(ch);
		break;	
	case 'e':
		eat();
		break;
	case 'q':
		quaff();
		break;
	case 'r':
		read_scroll();
		break;
	case 'm':
		move_onto();
		break;
	case 'd':
		drop();
		break;
	case 'P':
		put_on_ring();
		break;
	case 'R':
		remove_ring();
		break;
	case '>':
		if (drop_check()) {
			ccmd=CMD_NEW_LEVEL;
			return;
		}
		break;
	case '<':
		if (check_up()) {
			ccmd=CMD_NEW_LEVEL;
			return;
		}
		break;
	case ')':
	case ']':
		inv_armor_weapon(ch == ')');
		break;
	case '=':
		inv_rings();
		break;
	case '^':
		id_trap();
		break;
	case 'I':
		single_inv(0);
		break;
	case 'T':
		take_off();
		break;
	case 'W':
		wear();
		break;
	case 'w':
		wield();
		break;
	case 'z':
		zapp();
		break;
	case 't':
		throw();
		break;
	case 'v':
		{
		    char buf[MSGLEN];
		    snprintf(buf, MSGLEN, _i18n("KRogue %s, based on:"), KR_VERSION);
		    message(buf);
		}
		message(_i18n("rogue-clone: Version II. (Tim Stoehr was here), tektronix!zeus!tims"), 0);
		break;
/*	case ' ':
		break;*/
	case '\023':
		if (wizard) {
			draw_magic_map();
		}
		break;
	case '\024':
		if (wizard) {
			show_traps();
		}
		break;
	case '\017':
		if (wizard) {
			show_objects();
		}
		break;
	case '\001':
		show_average_hp();
		break;
	case '\015':
		if (wizard) {
			show_monsters();
		}
		break;
	case ',':
		kick_into_pack();
		break;
	case CMD_IDENTIFY:
		idntfy();
		break;
	}
	if (hit_message[0]) {
		message(hit_message, 1);
		hit_message[0] = 0;
		hit_msg_shown = 1;
	}
	if ((ch == '.') && warn_on_rest && hit_msg_shown) 
		message(_i18n("while you were resting"));
	if ((ch == 's') && warn_on_search && hit_msg_shown) 
		message(_i18n("while you were searching"));
}
