#ifndef KDUN_H
#define KDUN_H
#include <qscrollview.h>
#include <qpopupmenu.h>

#define PIXMAP_X 9
#define PIXMAP_Y 20

class QPixmap;
class KConfig;

struct obj;
typedef struct obj object;

class KDun:public QWidget
{
  Q_OBJECT
public:
  KDun(QWidget *qw=NULL, const char *name=NULL);
  virtual int restoreFile(const char *fn);
  virtual int initDungeon(const char *fn=NULL);
  virtual void initLevel(bool restore);
  virtual void updatePixmap(int row1, int col1, int row2, int col2);
  virtual void killedBy(object *monster, short other, bool really=true);
  virtual void win();
  virtual void storeMap(const QString &fn);
  virtual void storeItemPix(int num, const QString &fn);
  virtual void saveProperties(KConfig *);
  virtual void readProperties(KConfig *);
  virtual void paintPixmap(const QRect &r);
  virtual bool customWhatsThis() const;
  QPixmap *itempix[10];
protected:
  QPixmap *pixmap, *dung;
  int whatx, whaty;
  int killoth;
  QPopupMenu whatsthis;
  void focusObject(int x, int y);
  void paintEvent(QPaintEvent *);
  void keyPressEvent(QKeyEvent *);
  void mousePressEvent(QMouseEvent *);
  void focusInEvent(QFocusEvent *);
  void focusOutEvent(QFocusEvent *);
public slots:
  void charfile();
  void highscores();
  void uhighscores();
  void load();
  void quit();
  void quit(bool really);
  void initLevel();
  void clear();
  void whats();
  void qhHyperlink(QString s);
  void qhClose();
};

#define DCOLS 80
#define DROWS 24

class KDunView:public QScrollView
{
  Q_OBJECT
public:
  KDunView(QWidget *p);
  void setFullSizeHint();
  void writeCfg(KConfig *cfg);
  QSize sizeHint() const {return hint;}
public slots:
  void makeCellVisible(int row, int col);
protected:
  virtual void resizeEvent(QResizeEvent *);
  QSize hint;
};

extern KDun *dun;
#endif
