#include <klocale.h>
#include <kglobal.h>
#include <kconfig.h>
#include <qfile.h>
#include <qdir.h>
#include <kapp.h>
#include "kcharfdlg.h"

KCharFDlg::KCharFDlg(QWidget *parent, const char *name)
:QDialog(parent,name,true)
{
  KConfig *cfg;
  initDialog();
/*  QDir dir(kapp->kde_localedir());
  QStrList list(*dir.entryList(QDir::Dirs));
  autodel.setAutoDelete(true);
  char *loc;
  KConfig loccfg(kapp->kde_configdir()+"/kcmlocalerc");
  lang->insertItem(i18n("English"));
  for (loc=list.first(); loc; loc=list.next())
    if (QFile::exists(kapp->kde_localedir()+"/"+loc+"/LC_MESSAGES/krogue.mo"))
    {
      loccfg.setGroup(loc);
      QString *str=new QString(loccfg.readEntry("Name", loc));
      *str=*str+" ("+loc+")";
      autodel.append(str);
      lang->insertItem(*str);
      if (kapp->getLocale()->language() == loc)
        lang->setCurrentItem(lang->count()-1);
    }*/
  setCaption(i18n("Create character file"));
  connect(ok, SIGNAL(clicked()), SLOT(accept()));
  connect(cancel, SIGNAL(clicked()), SLOT(reject()));
  cfg=KGlobal::config();
  cfg->setGroup("Settings");
  switch (cfg->readNumEntry("CfType", 2))
  {
    case 1: radio1sl(); break;
    case 3: radio3sl(); break;
    case 2:
    default:
      radio2sl(); break;
  }
  connect(radio1, SIGNAL(clicked()), SLOT(radio1sl()));
  connect(radio2, SIGNAL(clicked()), SLOT(radio2sl()));
  connect(radio3, SIGNAL(clicked()), SLOT(radio3sl()));
}

KCharFDlg::~KCharFDlg()
{
}

void KCharFDlg::accept()
{
  KConfig *cfg;
  cfg=KGlobal::config();
  cfg->setGroup("Settings");
  cfg->writeEntry("CfType", current);
  QDialog::accept();
}

#define RADIOSL(i) void KCharFDlg::radio ## i ## sl(void) { \
				current=(i); \
				radio ## i ## ->setFocus(); \
				radio1->setChecked(i == 1); \
				radio2->setChecked(i == 2); \
				radio3->setChecked(i == 3); \
			}
				
RADIOSL(1);
RADIOSL(2);
RADIOSL(3)
