#include "kpooka.h"
#include <kfiledialog.h>
#include <kapp.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <qtextview.h>

FILE *theFile;
QString DATADIR;

KPooka::KPooka ()
{
// Make "Game" menu & put it into the menubar
	QPopupMenu *gamemenu = new QPopupMenu;
	gamemenu->insertItem(i18n("&New"), this, SLOT(backToLevel1()));
	gamemenu->insertItem( i18n( "&Quit" ), kapp, SLOT(quit()), CTRL+Key_Q );

// Make "Level" menu & put it into the menubar
	QPopupMenu* levelmenu = new QPopupMenu;
	levelmenu->insertItem(i18n("&Restart"), this, SLOT(restartLevel()), Key_Escape);
	levelmenu->insertItem(i18n("&Next"), this, SLOT(nextLevel()), Key_N);

// Make "Options" menu
//	QPopupMenu* optionsmenu = new QPopupMenu;
	optionsmenu = new QPopupMenu;
	optionsmenu->setCheckable (true);
	QuickModeID = optionsmenu->insertItem (i18n("Quick mode"), this, SLOT (quickMode()), 0);

	QString about =
	i18n("kpooka 1.0\n\n"
		"(c) 2000 Mr. Bogus\n"
		"paulrahme@yahoo.com\n"
		"This game comes with ABSOLUTELY NO WARRANTY\n"
		"This is free software, and you are welcome to redistribute it\n"
		"under certain conditions\n");

	QPopupMenu *helpmenu = helpMenu( about );
	KMenuBar *menu = new KMenuBar( this );
	menu->insertItem(i18n("&Game"), gamemenu);
	menu->insertItem(i18n("&Level"), levelmenu);
	menu->insertItem(i18n("&Options"), optionsmenu);
	menu->insertSeparator();
	menu->insertItem( i18n( "&Help" ), helpmenu);
	setMenu( menu );

// Make a pixmap in the main window
        block1 = new Block( this, "block1" );
        block1->setBackgroundColor( QColor( 255, 255, 255) );
        block1->show();
        setView(block1, FALSE);

	KConfig *kconf = kapp->config();
        if (kconf)
        {
                kconf->setGroup("General");
                maxLevel = kconf->readNumEntry("Level");
                bQuickMode = kconf->readBoolEntry ("QuickMode");
                optionsmenu->setItemChecked (QuickModeID, bQuickMode);
                if (maxLevel == 0)      // make sure at least the first level is read
                        maxLevel = 1;   // eggert.ehmke@berlin.de
        }
        else
        {
                maxLevel = 1;
        }
        theLevel = 0;
	while (theLevel < maxLevel)
		readLevel();
}

void KPooka::readLevel()
{

// grab the width & height of the level
        char theText[50];
        int temp;
        bool oneTeleportFound = 0;
        // exit gracefully if the level file is read to end of file
        // eggert.ehmke@berlin.de
        fgets(theText, 50, theFile);
        if ( strlen(theText) < 2 )
        {
                KMessageBox::information(this, i18n("Congratulations !! \
You solved all the levels.\n\
Now it's your turn ! Design some more and send them to me.\n\
Mr. Bogus (paulrahme@yahoo.com)"));

		return;
        }
        // eggert.ehmke@berlin.de
        // insert the level number into the caption bar
	theText[strlen(theText)-1]=0;
        QString caption;
        caption.sprintf ("KPooka level %d : %s", theLevel+1, theText);
        setCaption (caption);
        fscanf(theFile, "%i", &temp);
        block1->level_width=temp;
        fscanf(theFile, "%i", &temp);
        block1->level_height=temp;
// make sure the teleports are by default way off the screen in case there are none on this level
        block1->teleport_position[0][0]=500;
        block1->teleport_position[0][1]=500;
        block1->teleport_position[1][0]=500;
        block1->teleport_position[1][1]=500;

   // read the level itself in from the file
/*
        0 = blank
        2 = start (red block)
        5 = teleport
        9 = exit
        10 = normal (green) block
        11 = unmovable (grey/cement) block
*/

        for (int i=0; i<block1->level_height; i++)
        {
//printf("\n");
		for (int j=0; j<block1->level_width; j++)
                {
                        fscanf(theFile,"%i", &temp);
//printf("%i ",temp);
                        block1->level[j][i]=temp;
                        block1->backuplevel[j][i]=temp;
                        if (temp==2) // startpos
                        {
                                block1->x=j;
                                block1->y=i;
                                block1->start_position[0]=j;
                                block1->start_position[1]=i;
                        }
                        if (temp == 5) // teleport
                        {
                                if  (oneTeleportFound)
                                {
                                        block1->teleport_position[1][0]=j;
                                        block1->teleport_position[1][1]=i;
                                } else
                                {
                                        block1->teleport_position[0][0]=j;
                                        block1->teleport_position[0][1]=i;
                                        oneTeleportFound = 1;
                                }
                        }
                        if (temp==9) // exit
                        {
                                block1->exit_position[0]=j;
                                block1->exit_position[1]=i;
                        }
                }
        }
        fgetc(theFile); fgetc(theFile); // read the end of the last line and the blank line after the level
        // resize the window to fit & shrinkwrap around the level
        block1->setMinimumSize( block1->level_width*30, block1->level_height*30 );
        block1->setMaximumSize( block1->level_width*30, block1->level_height*30 );
        block1->resize(block1->level_width*30,block1->level_height*30);
        setMinimumSize( block1->level_width*30, block1->level_height*30+29 );
//        resize(block1->level_width*30,block1->level_height*30+29);
        resize(0,0);
        update();

        theLevel++;

};

void KPooka::backToLevel1()
{
        rewind(theFile);
        theLevel=0;
        readLevel();
}

void KPooka::nextLevel()
{
        if (theLevel<maxLevel)
                readLevel();
}

void KPooka::restartLevel()
{
        for (int i=0; i<block1->level_height; i++)
                for (int j=0; j<block1->level_width; j++)
                        block1->level[j][i] = block1->backuplevel[j][i];
        block1->x=block1->start_position[0];
        block1->y=block1->start_position[1];
        block1->repaint(FALSE);
}

void KPooka::quickMode ()
{
        bQuickMode = !bQuickMode;
        optionsmenu->setItemChecked (QuickModeID, bQuickMode);
	KConfig *kconf = kapp->config();
        kconf->setGroup("General");
        kconf->writeEntry("QuickMode", bQuickMode);
}

bool KPooka::queryExit()
{
        return TRUE;

        // hmmm.. this does still not work, it quits anyway
/*      bool result = QMessageBox::critical(this, i18n("Really?"),
                                                 i18n("Do you really want to quit?"),
                                                 QMessageBox::Yes,
                                                 QMessageBox::No) == QMessageBox::Yes;
        return result;
*/};

void KPooka::keyPressEvent( QKeyEvent *event )
{
// by default red blobby was on a 0 block
	int oldValue=0;

// if it's on a teleport, put a 5 there else it'll put a blank where red blobby was
	if ( (block1->x==block1->teleport_position[0][0]) && (block1->y==block1->teleport_position[0][1])
	  || (block1->x==block1->teleport_position[1][0]) && (block1->y==block1->teleport_position[1][1]) )
		oldValue=5;

	switch ( event->key() )
	{
	case Key_Right:
		if ( (block1->level[block1->x+1][block1->y]==10)
			&& (block1->x<block1->level_width-2) )
		{
			int blockx=block1->x+1, blocky=block1->y;
			while ( (block1->level[blockx+1][blocky]<5)
					 && (blockx<block1->level_width-1) )
			{
				blockx++;
				if (!bQuickMode)
				{
					block1->level[blockx][blocky]=99;
					block1->level[blockx-1][blocky]=100;
					block1->repaint(FALSE);
					usleep(frameDelay);
					block1->level[blockx-1][blocky]=101;
					block1->repaint(FALSE);
					usleep(frameDelay);
					block1->level[blockx-1][blocky]=102;
					block1->repaint(FALSE);
					usleep(frameDelay);
				}

				block1->level[blockx][blocky]=10;
				block1->level[blockx-1][blocky]=0;
				block1->repaint(FALSE);
				if (!bQuickMode)
					usleep(frameDelay*10);
			}
		}
		if ( (block1->level[block1->x+1][block1->y]<10)
			&& (block1->x<block1->level_width-1) )
		{
			if (!bQuickMode)
			{
				block1->level[block1->x+1][block1->y]=99;
				block1->level[block1->x][block1->y]=200;
				block1->repaint(FALSE);
				usleep(frameDelay*10);
			}
			block1->level[block1->x][block1->y]=oldValue;
			block1->x++;
			block1->level[block1->x][block1->y]=2;
			block1->repaint(FALSE);
		}
		event->accept();
		break;

	case Key_Left:
		if ( (block1->level[block1->x-1][block1->y]==10)
			&& (block1->x>1) ) // block to the left, x>1
		{
			int blockx=block1->x-1, blocky=block1->y;
			while ( (block1->level[blockx-1][blocky]<5)
					 && (blockx>0) )
			{
				blockx--;
				if (!bQuickMode)
				{
					block1->level[blockx][blocky]=99;
					block1->level[blockx][blocky]=103;
					block1->repaint(FALSE);
					usleep(frameDelay);
					block1->level[blockx][blocky]=104;
					block1->repaint(FALSE);
					usleep(frameDelay);
					block1->level[blockx][blocky]=105;
					block1->repaint(FALSE);
					usleep(frameDelay);
				}
				block1->level[blockx][blocky]=10;
				block1->level[blockx+1][blocky]=0;
				block1->repaint(FALSE);
				if (!bQuickMode)
					usleep(frameDelay*10);
			}
		}
		if ( (block1->level[block1->x-1][block1->y]<10)
			&& (block1->x>0) )
		{
			if (!bQuickMode)
			{
				block1->level[block1->x][block1->y]=99;
				block1->level[block1->x-1][block1->y]=201;
				block1->repaint(FALSE);
				usleep(frameDelay*10);
			}
			block1->level[block1->x][block1->y]=oldValue;
			block1->x--;
			block1->level[block1->x][block1->y]=2;
			block1->repaint(FALSE);
		}
		event->accept();
		break;

	case Key_Up:
		if ( (block1->level[block1->x][block1->y-1]==10)
			&& (block1->y>1) ) // block above, y>1
		{
			int blockx=block1->x, blocky=block1->y-1;
			while ( (block1->level[blockx][blocky-1]<5)
					 && (blocky>0) )
			{
				blocky--;
				if (!bQuickMode)
				{
					block1->level[blockx][blocky]=99;
					block1->level[blockx][blocky]=109;
					block1->repaint(FALSE);
					usleep(frameDelay);
					block1->level[blockx][blocky]=110;
					block1->repaint(FALSE);
					usleep(frameDelay);
					block1->level[blockx][blocky]=111;
					block1->repaint(FALSE);
					usleep(frameDelay);
				}
				block1->level[blockx][blocky]=10;
				block1->level[blockx][blocky+1]=0;
				block1->repaint(FALSE);
				if (!bQuickMode)
					usleep(frameDelay*10);
			}
		}
		if ( (block1->level[block1->x][block1->y-1]<10)
			&& (block1->y>0) )
		{
			if (!bQuickMode)
			{
				block1->level[block1->x][block1->y]=99;
				block1->level[block1->x][block1->y-1]=203;
				block1->repaint(FALSE);
				usleep(frameDelay*10);
			}
			block1->level[block1->x][block1->y]=oldValue;
			block1->y--;
			block1->level[block1->x][block1->y]=2;
			block1->repaint(FALSE);
		}
		event->accept();
			break;

	case Key_Down:
		if ( (block1->level[block1->x][block1->y+1]==10)
			&& (block1->y<block1->level_height-2) )
		{
			int blockx=block1->x, blocky=block1->y+1;
			while ( (block1->level[blockx][blocky+1]<5)
					 && (blocky<block1->level_height-1) )
			{
				blocky++;
				if (!bQuickMode)
				{
					block1->level[blockx][blocky]=99;
					block1->level[blockx][blocky-1]=106;
					block1->repaint(FALSE);
					usleep(frameDelay);
					block1->level[blockx][blocky-1]=107;
					block1->repaint(FALSE);
					usleep(frameDelay);
					block1->level[blockx][blocky-1]=108;
					block1->repaint(FALSE);
					usleep(frameDelay);
				}
				block1->level[blockx][blocky]=10;
				block1->level[blockx][blocky-1]=0;
				block1->repaint(FALSE);
				if (!bQuickMode)
					usleep(frameDelay*10);
			}
		}
		if ( (block1->level[block1->x][block1->y+1]<10)
			&& (block1->y<block1->level_height-1) )
		{
			if (!bQuickMode)
			{
				block1->level[block1->x][block1->y+1]=99;
				block1->level[block1->x][block1->y]=202;
				block1->repaint(FALSE);
				usleep(frameDelay*10);
			}
			block1->level[block1->x][block1->y]=oldValue;
			block1->y++;
			block1->level[block1->x][block1->y]=2;
			block1->repaint(FALSE);
		}
		event->accept();
			break;

	default:
			event->ignore();
		}
// if it's at a teleport...
		if ( (block1->x==block1->teleport_position[0][0]) && (block1->y==block1->teleport_position[0][1]) )
		{
			block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=51;
			block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=56;
			block1->repaint(FALSE);
			block1->repaint(FALSE);
			usleep (frameDelay*10);
			block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=52;
			block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=55;
			block1->repaint(FALSE);
			usleep (frameDelay*10);
			block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=53;
			block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=54;
			block1->repaint(FALSE);
			usleep (frameDelay*10);
			block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=54;
			block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=53;
			block1->repaint(FALSE);
			usleep (frameDelay*10);
			block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=55;
			block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=52;
			block1->repaint(FALSE);
			usleep (frameDelay*10);
			block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=56;
			block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=51;
			block1->repaint(FALSE);
			usleep (frameDelay*10);
			block1->level[block1->x][block1->y]=5;
			block1->x = block1->teleport_position[1][0];
			block1->y = block1->teleport_position[1][1];
			block1->level[block1->x][block1->y]=25; // red blob in teleport
			block1->repaint(FALSE);
		} else // don't move it back again! hence the else
		{
			if ( (block1->x==block1->teleport_position[1][0]) && (block1->y==block1->teleport_position[1][1]) )
			{
				block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=51;
				block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=56;
				block1->repaint(FALSE);
				usleep (frameDelay*10);
				block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=52;
				block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=55;
				block1->repaint(FALSE);
				usleep (frameDelay*10);
				block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=53;
				block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=54;
				block1->repaint(FALSE);
				usleep (frameDelay*10);
				block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=54;
				block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=53;
				block1->repaint(FALSE);
				usleep (frameDelay*10);
				block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=55;
				block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=52;
				block1->repaint(FALSE);
				usleep (frameDelay*10);
				block1->level[block1->teleport_position[1][0]][block1->teleport_position[1][1]]=56;
				block1->level[block1->teleport_position[0][0]][block1->teleport_position[0][1]]=51;
				block1->repaint(FALSE);
				usleep (frameDelay*10);
				block1->level[block1->x][block1->y]=5;
				block1->x = block1->teleport_position[0][0];
				block1->y = block1->teleport_position[0][1];
				block1->level[block1->x][block1->y]=25; // red blob in teleport
				block1->repaint(FALSE);
			}
		}
// if it's at the exit...
		if ( (block1->x==block1->exit_position[0]) && (block1->y==block1->exit_position[1]) )
		{
// Animate the red blobby getting sucked down the exit
		block1->level[block1->x][block1->y]=501;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		block1->level[block1->x][block1->y]=502;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		block1->level[block1->x][block1->y]=503;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		block1->level[block1->x][block1->y]=504;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		block1->level[block1->x][block1->y]=505;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		block1->level[block1->x][block1->y]=506;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		block1->level[block1->x][block1->y]=507;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		block1->level[block1->x][block1->y]=508;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		block1->level[block1->x][block1->y]=509;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		block1->level[block1->x][block1->y]=510;
		block1->repaint(FALSE);
		usleep (frameDelay*10);
		readLevel();
		if (theLevel>maxLevel)
		{
			KConfig *kconf = kapp->config();
			kconf->setGroup("General");
			kconf->writeEntry("Level", theLevel);
		}
		block1->repaint(FALSE);
	}
};

int main( int argc, char **argv )
{
	KApplication a( argc, argv, "kpooka");

// Open the level file...
	theFile = fopen(KGlobal::dirs()->findResource("appdata","level.dat"),"ro");
	if ( theFile == NULL )
		{ fprintf(stderr, "Cannot open level.dat, theFile = %i\n",theFile); }
//		{ fprintf(stderr, "Cannot open level.dat, theFile = %i\n",theFile); exit(1); }

	KPooka *kpooka=new KPooka();
//	kpooka->resize( 400, 300 );

	a.setMainWidget( kpooka );
	kpooka->show();

	return a.exec();
}
