/***************************************************************************
                          kmudapi.h
                      -------------------
    description          :
    begin                : Thu Jun 1 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KMUDAPI_H
#define KMUDAPI_H

#include <qobject.h>
#include <qpopupmenu.h>

class KmudApp;
class KmudView;
class KmudDoc;
class CTelnet;
class CMudLog;
class CMapWindow;

/**
  *@author Stephan Uhlmann
  */

class KmudAPI : public QObject  {
	Q_OBJECT

public: 

	KmudAPI(KmudApp* app);
	~KmudAPI();

	// some general get methods some important classes in Kmud
	KmudApp* getApp();
	KmudView* getView();
	KmudDoc* getDoc();
	CTelnet* getConnection();
	CMudLog* getMudLog();
	CMapWindow* getMapper();

	// special actions
	int writeToSocket(QString str);
	QPopupMenu* getPluginMenu();


private:
	KmudApp* kmudapp;
};

#endif
