/***************************************************************************
                          dlgprofilealiasesinput.cpp
                      -------------------
    description          :
    begin                : Sat Jan 29 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgprofilealiasesinput.h"

DlgProfileAliasesInput::DlgProfileAliasesInput(QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Aliases"));

	initDialog();

	macro_value = 0;
	key_modifiers = NoButton;
	myParent = parent;
	connect( ok_Button, SIGNAL(clicked()), SLOT(slotOKPressed()));
	connect( cancel_Button, SIGNAL(clicked()), SLOT(slotCancelPressed()));
	connect( change_Button, SIGNAL(clicked()), SLOT(slotChangePressed()));
}

DlgProfileAliasesInput::~DlgProfileAliasesInput(){
}

// PUBLIC METHODS

QString DlgProfileAliasesInput::getAlias() {
	return aliasName_LineEdit->text();
}

QString DlgProfileAliasesInput::getDefinition() {
	return aliasDefinition_LineEdit->text();
}

int DlgProfileAliasesInput::getMacro()  {
	return macro_value;
}

ButtonState DlgProfileAliasesInput::getModifiers() {
  return key_modifiers;
}

void DlgProfileAliasesInput::setAlias(QString alias) {
	aliasName_LineEdit->setText(alias);
}

void DlgProfileAliasesInput::setDefinition(QString definition) {
	aliasDefinition_LineEdit->setText(definition);
}

void DlgProfileAliasesInput::setMacro(int macro) {
	macro_Label->setText(((DlgProfileAliases *)myParent)->translateKey(macro, key_modifiers));
	macro_value = macro;
}

void DlgProfileAliasesInput::setModifiers(ButtonState modifiers) {
	macro_Label->setText(((DlgProfileAliases *)myParent)->translateKey(macro_value, modifiers));
  key_modifiers = modifiers;
}

// SLOTS

void DlgProfileAliasesInput::slotOKPressed() {
	accept();
}

void DlgProfileAliasesInput::slotCancelPressed() {
	reject();
}

void DlgProfileAliasesInput::slotChangePressed() {
	DlgProfileMacros dlg(this, "Macros");

	if (dlg.exec())
	{
		macro_value = dlg.getMacro();
		key_modifiers = dlg.getModifiers();
		macro_Label->setText(((DlgProfileAliases *)myParent)->translateKey(macro_value, key_modifiers));
	}
}

