/***************************************************************************
                          dlgconnectionwizardinput.cpp
                      -------------------
    description          :
    begin                : Tue Jan 18 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgconnectionwizardinput.h"

DlgConnectionWizardInput::DlgConnectionWizardInput(KmudDoc* document, QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Connection Wizard - Character settings"));

	initDialog();

	doc=document;

	if (doc->numProfs()==0) charProfileSelect_Button->setEnabled(false);
	if (doc->numMuds()==0) mudListSelect_Button->setEnabled(false);

	connect( ok_Button, SIGNAL(clicked()), SLOT(slotOKPressed()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );
	connect( charProfileSelect_Button, SIGNAL(clicked()), SLOT(slotSelectProfilePressed()) );
	connect( mudListSelect_Button, SIGNAL(clicked()), SLOT(slotSelectMudPressed()) );

	login_LineEdit->setFocus();

	Password_LineEdit->setEchoMode (QLineEdit::Password);

	setLogin("");
	setProfile("");
	setMudTitle("");
	setMudHost("");
	setMudPort("");
	setPassword("");
}

DlgConnectionWizardInput::~DlgConnectionWizardInput(){
}

void DlgConnectionWizardInput::slotOKPressed()
{
	if (getMudPort()=="") setMudPort("23");

	QString s=getMudPort();
	bool validPort;
	s.toUInt(&validPort);

	if ( (getLogin()=="") || (getMudTitle()=="") || (getMudHost()=="") )
	{
		QMessageBox NotAllEntered("Kmud",i18n("Please fill out at least Charactername, Mud-Title and Host."),QMessageBox::Information,
			QMessageBox::Ok | QMessageBox::Default,0,0,0,"NotAllEnteredMessageBox",TRUE,0);
		NotAllEntered.exec();			
	}
	else
		if (!validPort)
		{
			QMessageBox BadPort("Kmud",i18n("Entered port is not a valid portnumber."),QMessageBox::Information,
				  						  QMessageBox::Ok | QMessageBox::Default,0,0,0,"BadPortMessageBox",TRUE,0);
			BadPort.exec();			
		}
		else
		{
			if (getProfile()=="") // if not yet set (new)...
				setProfile(getLogin()+"@"+getMudTitle());  // ...then set it now
			accept();
		}
}


void DlgConnectionWizardInput::slotSelectMudPressed()
{
	DlgSelectMud d(doc,this,"SelectMudDialog");
	QString s;
	CMudProfile* mud=NULL;

	if (d.exec())
	{
		mud=d.getSelectedMud();
		if (mud!=NULL)
		{
			setMudTitle(mud->getTitle());
			setMudHost(mud->getHostName());
			s.setNum(mud->getPort());
			setMudPort(s);
			setNamePrompt(mud->getNamePrompt());
			setPasswordPrompt(mud->getPasswordPrompt());
		}
	}
}

void DlgConnectionWizardInput::slotSelectProfilePressed()
{
	DlgSelectProfile d(doc,this,"SelectProfileDialog");
	QFileInfo fi;
	CCharacterProfile* prof;

	if (d.exec())
	{
		prof=d.getSelectedProfile();
		if (prof)
		{
			fi.setFile("",prof->getFileName());
			setProfile(fi.baseName());
		}
		else
		{
			setProfile("");
		}
	}
}

QString DlgConnectionWizardInput::getLogin()
{
	return login_LineEdit->text();
}

QString DlgConnectionWizardInput::getMudHost()
{
	return mudHost_LineEdit->text();
}

QString DlgConnectionWizardInput::getMudPort()
{
	return mudPort_LineEdit->text();
}

QString DlgConnectionWizardInput::getMudTitle()
{
	return mudTitle_LineEdit->text();
}

QString DlgConnectionWizardInput::getNamePrompt()
{
  return mudNamePrompt_LineEdit->text();
}

QString DlgConnectionWizardInput::getPassword()
{
	return Password_LineEdit->text();
}

QString DlgConnectionWizardInput::getPasswordPrompt()
{
  return mudPasswordPrompt_LineEdit->text();
}

QString DlgConnectionWizardInput::getProfile()
{
	return charProfileShow_Label->text();
}

void DlgConnectionWizardInput::setLogin(QString s)
{
	login_LineEdit->setText(s);
}

void DlgConnectionWizardInput::setMudHost(QString s)
{
	mudHost_LineEdit->setText(s);
}

void DlgConnectionWizardInput::setMudPort(QString s)
{
	mudPort_LineEdit->setText(s);
}

void DlgConnectionWizardInput::setMudTitle(QString s)
{
	mudTitle_LineEdit->setText(s);
}

void DlgConnectionWizardInput::setNamePrompt(QString s)
{
  mudNamePrompt_LineEdit->setText(s);
}

void DlgConnectionWizardInput::setPassword(QString pw)
{
	Password_LineEdit->setText(pw);
}

void DlgConnectionWizardInput::setPasswordPrompt(QString s)
{
  mudPasswordPrompt_LineEdit->setText(s);
}

void DlgConnectionWizardInput::setProfile(QString s)
{
	charProfileShow_Label->setText(s);
}

