/***************************************************************************
                          search.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: search.h
	Last generated: Thu Jul 20 23:16:10 2000

 *********************************************************************/

#ifndef Search_included
#define Search_included

#include "searchdata.h"
#include "kaspaurl.h"
#include "kaspabase.h"

class MyKaspaBase: public KaspaBase
{
private:
  MyKaspaBase(const MyKaspaBase&);
	MyKaspaBase& operator=(const MyKaspaBase&);

public:
	inline bool idle() { return ::idle(); }
  MyKaspaBase(Sql *conn): KaspaBase(conn) {};
  MyKaspaBase(const char *dbname): KaspaBase(dbname) {};
};

class Search : public SearchData
{
    Q_OBJECT
private:
		Search(const Search&);
		Search& operator=(const Search&);
		MyKaspaBase *base;
		KaspaURL _url;

public:
    Search(KaspaURL url, Sql *conn, QWidget* parent = 0L, const char* name = 0L);
    virtual ~Search();
		bool closeRequest() { if(isWorking()) return false; else return true; }
		virtual bool isValid() { return true; }
		virtual bool isWorking() { return base->isWorking(); }
		virtual bool isReadOnly() { return false; }
		const char *url() { return _url; }
		void setInvalidGUI() { SearchData::setInvalidGUI(); lockGUI(); }
		void setWorkingGUI() { SearchData::setWorkingGUI(); lockGUI(); }
		void setReadWriteGUI() { SearchData::setReadWriteGUI(); unlockGUI(); }
public slots:
		void startSearch();
		void open(Oid o, const char *data, bool);

};
#endif // Search_included




