/***************************************************************************
                          partmemo.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: partmemomemo.cpp
	Last generated: Sun Sep 26 14:08:25 1999

 *********************************************************************/

#include <kapp.h>
#include <qstring.h>
#include <kiconloader.h>
#include <kmessagebox.h>

#include "partmemo.h"
#include "kaspawidget.h"
#include "resource.h"
#include "selectiondlg.h"
#include "notetreedlg.h"
#include <qmessagebox.h>
#include <klocale.h>

#define Inherited PartMemoData

CommandSetup partmemocs[] = {	{ID_PARTMEMO_DELREC,  	RW},
															{ID_PARTMEMO_SHOWPART,	RW+RO},
															{ID_PARTMEMO_SHOWPUBL,	RW+RO},
															{ID_PARTMEMO_FLUSH, 		RW},
															{ID_PARTMEMO_RESET,			RW+RO+INV} };


// PartMemoBase-Constructor reads row matching WHERE-Clause.
PartMemo::PartMemo(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name)
{
	debug("PartMemo::PartMemo(QString, QWidget, char*)");
  partmemo = new PartBase(url.where(), conn);
  ASSERT(partmemo);
	QString s("kaspa://partmemo#where oid="); s+=QString().setNum(partmemo->id());
	_url=s;
}

PartMemo::~PartMemo()
{
	debug("PartMemo::~PartMemo()");
	delete partmemo;
}

bool PartMemo::isValid() {
	try {
	  return partmemo->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}

void PartMemo::reread() {
	setWorkingGUI();
	try {
	  partmemo->reset();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
 	setFields();
}

void PartMemo::setFields() {
	try {
	  if(isValid()) {
			setWorkingGUI();
			PublTitle *pt=partmemo->getPartPubl();
			if(!pt) { KMessageBox::error(this, i18n("Part has no Publication!")); return; }
  		no->setText(QString().setNum(partmemo->getNumber()));
		  publtitle->setText(pt->getTitle());
  		parttitle->setText(partmemo->getTitle());
	  	memo->setText(partmemo->getMemo());
			delete pt;
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
	setupGUI();
}

void PartMemo::flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void PartMemo::save(bool block) {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
    	  if(strcmp(memo->text(), partmemo->getMemo()))
      	  partmemo->setMemo(memo->text());
	      partmemo->flush(block);
  	}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void PartMemo::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
	for(unsigned int i=0; i<sizeof(partmemocs)/sizeof(CommandSetup); i++)
		emit enableCommand(partmemocs[i].command, ((partmemocs[i].setup&INV)==INV));
}	

void PartMemo::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
 	unlockGUI();
	for(unsigned int i=0; i<sizeof(partmemocs)/sizeof(CommandSetup); i++)
		emit enableCommand(partmemocs[i].command, ((partmemocs[i].setup&RW)==RW));
}

void PartMemo::setWorkingGUI() {
	Inherited::setWorkingGUI();
	if(isReadOnly() || !isValid())
		lockGUI();
	else
		unlockGUI();
	memo->setEnabled(TRUE);
	for(unsigned int i=0; i<sizeof(partmemocs)/sizeof(CommandSetup); i++)
		emit enableCommand(partmemocs[i].command, ((partmemocs[i].setup&WORK)==WORK));
}

void PartMemo::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	memo->setEnabled(FALSE);
	for(unsigned int i=0; i<sizeof(partmemocs)/sizeof(CommandSetup); i++)
		emit enableCommand(partmemocs[i].command, ((partmemocs[i].setup&RO)==RO));
}


void PartMemo::del() {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()&&deleteDlg()) {
			setWorkingGUI();
	  	partmemo->deleteRec();
		  setInvalidGUI();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

bool PartMemo::closeRequest() {
//	setWorkingGUI();
	save(true);
	setupGUI();
  return TRUE;
}

void PartMemo::showPart() {
	requestPart(partmemo->id());
}	

void PartMemo::showPubl() {
	PublTitle *pt=partmemo->getPartPubl();
	if(!pt) { KMessageBox::error(this, i18n("Part has no Publication!")); return; }
	requestPublication(pt->getOid());
	delete pt;
}

KToolBar *PartMemo::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
	toolbar->insertButton(BarIcon("showpubl.xpm"), ID_PARTMEMO_SHOWPUBL, SIGNAL(clicked()),
				this, SLOT(showPubl()), true, i18n("Show Publication") );
	toolbar->insertButton(BarIcon("showpart.xpm"), ID_PARTMEMO_SHOWPART, SIGNAL(clicked()),
				this, SLOT(showPart()), true, i18n("Show Part") );

	toolbar->insertLineSeparator();
	toolbar->insertButton(BarIcon("filedel.xpm"), ID_PARTMEMO_DELREC, SIGNAL(clicked()),
				this, SLOT(del()), true, i18n("Delete Record") );

	toolbar->insertLineSeparator();
	toolbar->insertButton(BarIcon("filefloppy.xpm"), ID_PARTMEMO_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
	toolbar->insertButton(BarIcon("reload.xpm"), ID_PARTMEMO_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
	return toolbar;
}


















































