/***************************************************************************
                          part.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: part.cpp
	Last generated: Sun Sep 26 13:50:53 1999

 *********************************************************************/


#include <kapp.h>
#include <qstring.h>
#include <kiconloader.h>
#include <qobjectlist.h>
#include <qlayout.h>
#include <kmessagebox.h>

#include "part.h"
#include "kaspawidget.h"
#include "resource.h"
#include "selectiondlg.h"
#include "notetreedlg.h"
#include "qmessagebox.h"
#include "fileiodlg.h"
#include <klocale.h>

#define Inherited PartData

CommandSetup partcs[] = {	{ID_PART_DELREC,  	RW},
													{ID_PART_FLUSH,  		RW},
													{ID_PART_RESET, 		RW+RO+INV},
													{ID_PART_INSLINK, 	RW+RO},
													{ID_PART_REMLINK, 	RW+RO},
													{ID_PART_SHOWPUBL, 	RW+RO},
													{ID_PART_SHOWMEMO, 	RW+RO},
													{ID_PART_SHOWINTRO, RW+RO},
										/*			{ID_PART_NEWAUTHOR, RW+RO},
													{ID_PART_INSAUTHOR, RW+RO},
													{ID_PART_REMAUTHOR, RW+RO}, */
													{ID_PART_EDITDATA,  RW+RO},
													{ID_PART_NEWLINK,		RW+RO} };

// PartBase-Constructor reads row matching WHERE-Clause.
Part::Part(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name), pt(0L)
{
	setTabOrder(number, title);
	setTabOrder(title, language);
	setTabOrder(language, key);
	setTabOrder(key, pages);
	setTabOrder(pages, bibtex);

	debug("Part::Part(QString, QWidget, char*)");
  part = new PartBase(url.where(), conn);
  ASSERT(part);
	part->setCallBack(&idle);
	if(isValid())
		pt=part->getPartPubl();
	QString s("kaspa://part#where oid="); s+=QString().setNum(part->id());
	_url=s;

  connect(notes,   SIGNAL(open(Oid, bool)), this, SLOT(requestNote(Oid, bool)));
	connect(authors, SIGNAL(open(Oid, bool)), this, SLOT(requestAuthor(Oid, bool)));
	connect(files, SIGNAL(open(Oid, bool)), this, SLOT(requestHTMLData(Oid, bool)));
	notes->setTitle(i18n("Links"));
	authors->setTitle(i18n("Authors"));
	files->setTitle(i18n("Files"));
}

Part::~Part()
{
	debug("Part::~Part()");
	delete part;
	delete pt;
}

bool Part::isValid() {
	try {
	  return part->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}

void Part::reread() {
	if(isValid())
		setWorkingGUI();
	try {
	  part->reset();
		if(isValid())
			pt=part->getPartPubl();
		else
			pt=0L;
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
  	setFields();
}

void Part::setFields() {
  if(isValid()) {
		setWorkingGUI();
	  title->setText(part->getTitle());
		havefirstfile=!(part->getFirstFile()==InvalidOid);

  	language->setText(part->getLanguage());
	  pages->setText(part->getPages());
		number->setText(QString().setNum(part->getNumber()));
		if(!pt) KMessageBox::error(this, "Part has no Publication!");
		publication->setText(pt->getTitle());
		authors->set(part->getPartAuthors());
	  bibtex->setText(part->getBibTex());
  	key->setText(part->getKey());
	  notes->set(part->getLinks());
		includebibtex->setChecked(part->getCreateBibTex());
		created->setText(QString("created: ")+part->getCreated());
		modified->setText(QString("modified: ")+part->getModified());


		files->set(part->getFiles());
		QObjectList *list = this->queryList( "QLayout", 0, TRUE, FALSE );
		QObjectListIt it( *list );
		QObject * obj;
		while ( (obj=it.current()) != 0 ) {
			++it;
			((QLayout*)obj)->activate();
		}
		delete list;
	}
	setupGUI();
}

void Part::flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void Part::save(bool block) {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
      if(strcmp(title->text(), part->getTitle()))
     	  part->setTitle(title->text());
	    if(strcmp(bibtex->text(), part->getBibTex()))
	      part->setBibTex(bibtex->text());
  	  if(strcmp(language->text(), part->getLanguage()))
      	part->setLanguage(language->text());
	 	  if(strcmp(pages->text(), part->getPages()))
	       part->setPages(pages->text());
  	  if(strcmp(key->text(), part->getKey()))
    	   part->setKey(key->text());
    	if(atoi(number->text())!=part->getNumber())
	       part->setNumber(number->text());
    	if(includebibtex->isChecked()!=part->getCreateBibTex())
	       part->setCreateBibTex(includebibtex->isChecked());
  	  part->flush(block);
	  }
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Part::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
	for(unsigned int i=0; i<sizeof(partcs)/sizeof(CommandSetup); i++)
		if(partcs[i].command==ID_PART_SHOWINTRO)
			emit enableCommand(ID_PART_SHOWINTRO, ( ((partcs[i].setup&INV)==INV)&&havefirstfile) );
		else
			emit enableCommand(partcs[i].command, ((partcs[i].setup&INV)==INV));
	emit enableCommand(ID_PART_NEWAUTHOR, false);
	emit enableCommand(ID_PART_INSAUTHOR, false);
	emit enableCommand(ID_PART_REMAUTHOR, false);
}	

bool Part::isCollection() {
	if(!pt) { KMessageBox::error(this, "Part has no Publication!"); return false; }
	int e=pt->getEntryType();
	switch(e) {
		case BT_INCOLLECTION:
		case BT_JOURNAL:
		case BT_INBOOK:
		case BT_INPROCEEDING:
			return true;
		default:
			return false;
	}
}


void Part::unlockGUI(bool working) {
	publication->setEnabled(!isReadOnly());
	nolabel->setEnabled(!isReadOnly());
	number->setEnabled(!isReadOnly());
	titlelabel->setEnabled(!isReadOnly());
	title->setEnabled(!isReadOnly());
	pageslabel->setEnabled(!isReadOnly());
	pages->setEnabled(!isReadOnly());

	bool c=isCollection();
	files->setEnabled(!working);
  authors->setEnabled(!working&&c);
  notes->setEnabled(!working);

	emit enableCommand(ID_PART_NEWAUTHOR, !working && c);
	emit enableCommand(ID_PART_INSAUTHOR, !working && c);
	emit enableCommand(ID_PART_REMAUTHOR, !working && c);

	authors->setEnabled(!isReadOnly()&&c);
	bibtex->setEnabled(!isReadOnly()&&c);
	bibtexlabel->setEnabled(!isReadOnly()&&c);
	languagelabel->setEnabled(!isReadOnly()&&c);
	key->setEnabled(!isReadOnly()&&c);
	keylabel->setEnabled(!isReadOnly()&&c);
	includebibtex->setEnabled(!isReadOnly()&&c);
	generatebibtex->setEnabled(!isReadOnly()&&c);
}

void Part::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
	for(unsigned int i=0; i<sizeof(partcs)/sizeof(CommandSetup); i++) {
		switch(partcs[i].command) {
			case ID_PART_SHOWINTRO:
				emit enableCommand(ID_PART_SHOWINTRO, ( ((partcs[i].setup&RW)==RW)&&havefirstfile) );
			break;
			default:
				emit enableCommand(partcs[i].command, ((partcs[i].setup&RW)==RW));
		}
	}
	unlockGUI(false);
}

void Part::setWorkingGUI() {
/*	if(isReadOnly() || !isValid())
		lockGUI();
	else */
	unlockGUI(true);
	Inherited::setWorkingGUI();
	for(unsigned int i=0; i<sizeof(partcs)/sizeof(CommandSetup); i++)
		if(partcs[i].command==ID_PART_SHOWINTRO)
			emit enableCommand(ID_PART_SHOWINTRO, ( ((partcs[i].setup&WORK)==WORK)&&havefirstfile) );
		else
			emit enableCommand(partcs[i].command, ((partcs[i].setup&WORK)==WORK));

}

void Part::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	unlockGUI(false);
	for(unsigned int i=0; i<sizeof(partcs)/sizeof(CommandSetup); i++)
		if(partcs[i].command==ID_PART_SHOWINTRO)
			emit enableCommand(ID_PART_SHOWINTRO, ( ((partcs[i].setup&RO)==RO)&&havefirstfile) );
		else
			emit enableCommand(partcs[i].command, ((partcs[i].setup&RO)==RO));
}


void Part::del() {
	try {
	  if(isValid() && !isReadOnly() && !isWorking() && deleteDlg()) {
			setWorkingGUI();
	  	part->deleteRec();
		  setInvalidGUI();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

bool Part::closeRequest() {
//	setWorkingGUI();
 	save(true);
	setupGUI();
 	return TRUE;
}
	

void Part::editData() {
	QString s("kaspa://editpartdata#where oid=");
	s+=QString().setNum(part->id());
	requestURL(s, false);
}

void Part::newLink() {
	try {
		setWorkingGUI();
		Oid o=part->createNote();
		requestNote(o);
		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
	
void Part::insLink() {
	try {
		SelectionDlg dlg(part->getNotes(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			part->insertLink(o);
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	
void Part::remLink() {
	try {
		Oid o=notes->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		part->removeLink(o);
		save();
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
		
void Part::newAuthor() {
	try {
		setWorkingGUI();
		Oid o=part->createAuthor();
		save();
		requestAuthor(o, false);
		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Part::insAuthor() {
	try {
		SelectionDlg dlg(part->getAuthors(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			part->insertAuthor(o);
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Part::remAuthor() {
	try {
		Oid o=authors->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		part->removeAuthor(o);
		save();
		setFields();	
   } catch(KaspaErr& err) {
    err.print();
    QMessageBox::warning(this, i18n("Error"), err.error());
  }
}

void Part::showPubl() {
	if(!pt) { KMessageBox::error(this, "Part has no Publication!"); return; }
	requestPublication(pt->getOid());
}

void Part::showPartMemo() {
	requestPartMemo(part->id());
}

void Part::showIntro() {
	requestHTMLData(part->getFirstFile());
}

KToolBar *Part::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
  toolbar->insertButton(BarIcon("showmemo.xpm"), ID_PART_SHOWMEMO, SIGNAL(clicked()),
				this, SLOT(showPartMemo()), true, i18n("Show Memo") );
  toolbar->insertButton(BarIcon("showpubl.xpm"), ID_PART_SHOWPUBL, SIGNAL(clicked()),
				this, SLOT(showPubl()), true, i18n("Show Publication") );
  toolbar->insertButton(BarIcon("showintro.xpm"), ID_PART_SHOWINTRO, SIGNAL(clicked()),
				this, SLOT(showIntro()), true, i18n("Show Intro") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("newnote.xpm"), ID_PART_NEWLINK, SIGNAL(clicked()),
				this, SLOT(newLink()), true, i18n("New Note") );
  toolbar->insertButton(BarIcon("insnote.xpm"), ID_PART_INSLINK, SIGNAL(clicked()),
				this, SLOT(insLink()), true, i18n("Insert Note") );
  toolbar->insertButton(BarIcon("delnote.xpm"), ID_PART_REMLINK, SIGNAL(clicked()),
				this, SLOT(remLink()), true, i18n("Delete Note") );

	toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("newauthor.xpm"), ID_PART_NEWAUTHOR, SIGNAL(clicked()),
				this, SLOT(newAuthor()), true, i18n("New Author") );
  toolbar->insertButton(BarIcon("insauthor.xpm"), ID_PART_INSAUTHOR, SIGNAL(clicked()),
				this, SLOT(insAuthor()), true, i18n("Insert Author") );
  toolbar->insertButton(BarIcon("delauthor.xpm"), ID_PART_REMAUTHOR, SIGNAL(clicked()),
				this, SLOT(remAuthor()), true, i18n("Remove Author") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("fileopen.xpm"), ID_PART_EDITDATA, SIGNAL(clicked()),
				this, SLOT(editData()), true, i18n("Edit Files") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filedel.xpm"), ID_PART_DELREC, SIGNAL(clicked()),
				this, SLOT(del()), true, i18n("Delete Record") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filefloppy.xpm"), ID_PART_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
  toolbar->insertButton(BarIcon("reload.xpm"), ID_PART_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}


void Part::generateBibTex() {
	if(!bibtex->text().isEmpty()&&
     (KMessageBox::warningYesNo(this, i18n("Overwrite old entry?"), i18n("Generate BibTex") )==2)) return;
	
	save(true);

	PublTitle *p=part->getPartPubl();
	if(!p) { KMessageBox::error(this, "Part has no Publication!"); return; }
	QString crossref("Ref");
	crossref+=QString().setNum(p->getOid());

	AuthorName *a=part->getPartAuthors();
	QString entry;
	int publindex=0;
	if(a)	{
		entry=a->getLastName();
		publindex=part->bibTexIndex(a->getOid(), p->getYear(), p->getOid());
	}
	else  entry="NoName"+QString().setNum(part->id())+"_";

	entry+=p->getYear();
	if(publindex>0 && publindex <27)
		entry+=('a'+publindex-1);

	QString author;
	for(AuthorName *b=a; b; b=b->getNext()) {
		author+=b->getLastName();
		author+=", ";
		author+=b->getFirstName();
		if(b->getNext())
			author+=" and ";
	}
	QString note;

	switch(p->getEntryType()) {
/* Crossref-Entrys for Part-BibTex-generation */
		case BT_JOURNAL:
				bt.article(entry,
								author, 					/* author		*/
								part->getTitle(),	/* title		*/
								"", 							/* journal	*/
								"", 							/* year			*/
								"", 							/* volume		*/
								"", 							/* number		*/
								part->getPages(),	/* pages		*/
								"", 							/* month		*/
								"", 							/* note			*/
								part->getKey(),
								crossref);
		break;

		case BT_INBOOK:
				bt.inbook(entry,
									author,							/* author 		*/
									"",									/* editor 		*/
									"",									/* title 			*/
									QString().setNum(part->getNumber()),	/* chapterno	*/
									part->getPages(),		/* pages 			*/
									"", 								/* publisher	*/
									"",									/* year 			*/
									"",									/* volume			*/
									"",									/* number			*/
									"",									/* series			*/
									"",									/* type				*/
									"",									/* address		*/
									"",									/* edition		*/
									"",									/* month			*/
									"",									/* note				*/
									part->getKey(),
								  crossref);
			break;

			case BT_INCOLLECTION:
					 bt.incollection(entry,
													 author,								/* author			*/
													 part->getTitle(),			/* title			*/
													 "", 										/* booktitle	*/
													 "",										/* publisher	*/
													 "",										/* year				*/
													 "",										/* editor 		*/
													 "",										/* volume			*/
													 "",										/* number			*/
													 "", 										/* series			*/
													 "", 										/* type				*/
													 QString().setNum(part->getNumber()),			/* chapterno	*/
													 part->getPages(),			/* pages			*/
													 "",										/* address		*/
													 "",										/* edition		*/
													 "",										/* month			*/
													 "",										/* note				*/
													 part->getKey(),
												 	 crossref);
			break;

			case BT_INPROCEEDING:
					 bt.inproceedings(entry,
													 author,									/* author			*/
													 part->getTitle(),				/* title			*/
													 "",											/* booktitle	*/
													 "",											/* year				*/
													 "",											/* editor			*/
													 "", 										/* volume			*/
													 "", 										/* number			*/
													 "",											/* series			*/
													 part->getPages(),				/* pages			*/
													 "",											/* address		*/
													 "", 										/* month			*/
  												 "",											/* organization	*/
													 "", 										/* publisher	*/
													 "",											/* note				*/
					 								 part->getKey(),
													 crossref);
			break;


	}
	bibtex->setText(bt.getEntry());
	delete p;
	delete a;
}



















