/***************************************************************************
                          linklistbox.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Oct 20 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "linklistbox.h"
#include "kapp.h"
#include <qpoint.h>
#include <klocale.h>

LinkListBox::LinkListBox(QWidget *parent=0, const char *name=0):
		KaspaListBox(parent, name) {
	pop.insertItem(i18n("Open"), this, SLOT(slotOpen()));
	pop.insertItem(i18n("Open in new Window"), this, SLOT(slotNewWindow()));

	connect(this, SIGNAL(rightButtonPressed(QListBoxItem*, constQPoint&)),
					this, SLOT(slotPopupMenu( QListBoxItem *, const QPoint &)));

	connect(this, SIGNAL(selected(int)),
					this, SLOT(slotSelected(int)));
}

LinkListBox::~LinkListBox(){
}
void LinkListBox::slotSelected(int index) {
	emit open(getCurrentOid(), false);
	emit open(getCurrentOid(), getCurrentData(), false);
}

void LinkListBox::slotOpen() {
	emit open(getCurrentOid(), false);
	emit open(getCurrentOid(), getCurrentData(), false);
}


void LinkListBox::slotNewWindow() {
	emit open(getCurrentOid(), true);
	emit open(getCurrentOid(), getCurrentData(), true);
}

void LinkListBox::slotPopupMenu(QListBoxItem *item, const QPoint& p) {
	/* if(title)	pop.setTitle(title,0,0); */
	if(currentItem()!=-1) {
  	setCurrentItem(item);
  	pop.popup(QCursor::pos());
  }
}