/***************************************************************************
                          fileiodlg.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: fileiodlg.h
	Last generated: Sat Apr 1 16:05:39 2000

 *********************************************************************/

#ifndef FileIODlg_included
#define FileIODlg_included

#include "fileiodlgdata.h"
#include "kaspaurl.h"
#include "partbase.h"
#include <qlayout.h>
#include <qdir.h>

class FileIODlg : public FileIODlgData
{
    Q_OBJECT

private:
		FileIODlg(const FileIODlg&);
		FileIODlg& operator=(const FileIODlg&);

		QDir *dir;
		bool running;
		KaspaURL _url;
		PartBase *part;
		Sql	*sql;
		PartDataName *partfiles;

public:

    FileIODlg(KaspaURL url, Sql *conn, QWidget* parent = 0L, const char* name = 0L);
    virtual ~FileIODlg();
		bool closeRequest() { if(isWorking()) return false; else return true; }
		const char *url() { return _url; }
		virtual bool isValid() { return part->isValid(); }
		virtual bool isWorking() { return running; }
		virtual bool isReadOnly() { return false; }
		void setInvalidGUI() { FileIODlgData::setInvalidGUI(); lockGUI(); }
		void setWorkingGUI() { FileIODlgData::setWorkingGUI(); lockGUI(); }
		void setReadWriteGUI() { FileIODlgData::setReadWriteGUI(); unlockGUI(); }
		void reset();
public slots:
		void dirSelected(int index);
		void selectAll();
		void importItem();
		void exportItem();
		void deleteItem();
		void readPartData();
		void readDirData();
		void setIndexFile();
//	  void link();
};
#endif // FileIODlg_included