/***************************************************************************
                          partdatabase.h  -  description
                             -------------------
    begin                : Wed Oct 13 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef PARTDATABASE_H
#define PARTDATABASE_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <table.h>

/**
  *@author Jan Mueller
  */

class PartDataBase : public Table  {
 private:
  PartDataBase(const PartDataBase&);
	PartDataBase& operator=(const PartDataBase&);	

 	void initWhere(const char *where);
 public:

  /** Reads row with the SQL-WHERE clause "where". "where" must not return more than one record.
   */
	PartDataBase(Oid part, Sql *conn);
  PartDataBase(Oid part, const char *dbname);
  PartDataBase(const char *where, Sql *conn);
  PartDataBase(const char *where, const char *dbname);

  /** Updates row, if data has changed and not readonly-mode.
   */
  virtual ~PartDataBase();

  const char *getFilename();
  PartTitle *getPartTitle();
	Oid getPartNo();
  PublTitle *getPublTitle();
	const char *getType();
	const unsigned char *getData(long &l);
	unsigned char *getImage(const char *name, long *l);
	long getDataLength();
	
  void setFilename(const char *s);
  void setType(char *t);
	void setData(unsigned char *d, long l);

  virtual const char *getWhereClause() { return _where; }
	Oid createNote();
	NoteTitle *getNotes();

 private:
  KaspaRec *invalid();
  KaspaRec *read(const char *where);
  void write(const char *where, bool block=false);
  void del(const Oid o);
  PartDataRec *partdata();
  char *_where;
};

#endif
