/***************************************************************************
                          kaspaparser.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Don Jun 15 22:33:56 CEST 2000
                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include "analyze.h"
/* file modes (defnd in libpq-fs.h are redfnd in fcntl.h */
#undef S_IFDIR
#undef S_IFREG
#undef S_ISDIR
#undef S_ISLNK
#undef S_IRUSR
#undef S_IWUSR
#undef S_IXUSR
#undef S_IRWXU
#undef S_IRGRP
#undef S_IWGRP
#undef S_IXGRP
#undef S_IRWXG
#undef S_IROTH
#undef S_IWOTH
#undef S_IXOTH
#undef S_IRWXO
#include "fcntl.h"

#define lockfile "/tmp/kaspa-parser-lock"

bool locked=false;
Analyze parser;


void del_lockfile(void) {
	if(locked) unlink(lockfile);
}

void bye(void) {
	cout<<"\n Terminated";
	del_lockfile();
}

void termination_handler (int signum) {
	cout<<"\nCaught termination signal. Trying to abort process...\n";
	cout.flush();
	parser.cancel();
}

void cleanup_handler (int signum) {
	del_lockfile();
}

int main(int argc, char** argv){
	atexit(bye);
	signal (SIGINT, termination_handler);
	signal (SIGTERM, termination_handler);
	signal (SIGHUP, termination_handler);
	signal (SIGSEGV, cleanup_handler);
	signal (SIGABRT, cleanup_handler);
	signal (SIGILL, cleanup_handler);

	cout<<"Create Index for Kaspaliste";
	#ifdef VERSION
	cout<<" v"<<VERSION;
	#endif
	cout<<". (C) Jan Mueller 1999-2000\n\n" \
   "This program is free software; you can redistribute it and/or modify\n" \
   "it under the terms set out in the COPYING file, which is included\n" \
   "in the kaspaliste source distribution.\n" \
   "This program is distributed in the hope that it will be useful,\n" \
   "but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
   "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
   "COPYING file for more details.\n";
	cout.flush();

	if(open(lockfile, O_CREAT | O_EXCL)==-1) {
		cout<<"\nParsing already in progress? " \
				  "If not, delete the lock file '"<<lockfile<<"'.\n";
		exit(1);
	}
	locked=true;

try {
	for(int i=0; i<argc; i++) {
  	if(!strcmp(argv[i], "-f")) {
			i++;
			parser.addSuffix(argv[i]);
			continue;
		}

		if(!strcmp(argv[i], "-r")) {
			parser.setRebuild(true);
			continue;
		}

		if(!strcmp(argv[i], "-l")) {
			i++;
			int max=atoi(argv[i]);
			if(max<0||max>100) {
				cout << "-l: range 0-100\n";
				exit(1);
			}
			parser.setLimit(max);
		}
	}

	parser.work();
} catch (KaspaErr &err) {
	cout<<"Error: "<< err.error();
}
return EXIT_SUCCESS;
}

