//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///   Display status messages.
    ///   You can insert text labels or custom widgets. Their geometry is managed
    ///   internally. KStatusBar resizes itself, but positioning is left to
    ///   KMainWindow (or to you, if you don't use KMainWindow ).
    ///   A special type of item is a message which is a temporary text-message
    ///   displayed on top of other items in full-width. Messages are visible for
    ///   specified time, or until you call the slot QStatusBar.Clear(). See
    ///   QStatusBar.Message for details.
    ///   It is useful to connect the KActionCollection signals to the
    ///   QStatusBar.Message slots.
    ///   KStatusBar inherits QStatusBar, you can freely use all QStatusBar
    ///   methods.
    ///   Empty text items are not visible. They will become visible when you change
    ///   (add) text.
    ///  See <see cref="IKStatusBarSignals"></see> for signals emitted by KStatusBar
    /// </remarks>        <author> Mark Donohoe (donohoe@kde.org) Maintained by Sven Radej <radej@kde.org>
    /// </author>
    ///         <short> %KDE statusbar widget.</short>
    ///         <see> KActionCollection</see>
    [SmokeClass("KStatusBar")]
    public class KStatusBar : QStatusBar, IDisposable {
        protected KStatusBar(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KStatusBar), this);
        }
        /// <remarks>
        ///   Constructs a status bar. <code>parent</code> is usually KMainWindow.
        ///    </remarks>        <short>     Constructs a status bar.</short>
        public KStatusBar(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KStatusBar#", "KStatusBar(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KStatusBar() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KStatusBar", "KStatusBar()", typeof(void));
        }
        /// <remarks>
        ///   Inserts a temporary text label into the status bar.
        ///   Parameter <code>stretch</code> is passed to QStatusBar.AddWidget .
        /// <param> name="text" The label's text string.
        /// </param><param> name="id" id of item
        /// </param><param> name="stretch" stretch passed to QStatusBar.AddWidget
        /// </param>   </remarks>        <short>     Inserts a temporary text label into the status bar.</short>
        ///         <see> QStatusbar.AddWidget</see>
        public void InsertItem(string text, int id, int stretch) {
            interceptor.Invoke("insertItem$$$", "insertItem(const QString&, int, int)", typeof(void), typeof(string), text, typeof(int), id, typeof(int), stretch);
        }
        public void InsertItem(string text, int id) {
            interceptor.Invoke("insertItem$$", "insertItem(const QString&, int)", typeof(void), typeof(string), text, typeof(int), id);
        }
        /// <remarks>
        ///   Inserts a permanent text label into the status bar.
        ///   Parameter <code>stretch</code> is passed to QStatusBar.AddWidget .
        /// <param> name="text" The label's text string.
        /// </param><param> name="id" id of item
        /// </param><param> name="stretch" stretch passed to QStatusBar.AddPermanentWidget
        /// </param>   </remarks>        <short>     Inserts a permanent text label into the status bar.</short>
        ///         <see> QStatusbar.AddPermanentWidget</see>
        public void InsertPermanentItem(string text, int id, int stretch) {
            interceptor.Invoke("insertPermanentItem$$$", "insertPermanentItem(const QString&, int, int)", typeof(void), typeof(string), text, typeof(int), id, typeof(int), stretch);
        }
        public void InsertPermanentItem(string text, int id) {
            interceptor.Invoke("insertPermanentItem$$", "insertPermanentItem(const QString&, int)", typeof(void), typeof(string), text, typeof(int), id);
        }
        /// <remarks>
        ///   Inserts a fixed width temporary text label into status bar. The width
        ///   will be set according to <code>text</code>, but will remain fixed even if you
        ///   change text.  You can change fixed width by calling setItemFixed.
        /// <param> name="text" The label's text string
        /// </param><param> name="id" id of item
        ///    </param></remarks>        <short>     Inserts a fixed width temporary text label into status bar.</short>
        public void InsertFixedItem(string text, int id) {
            interceptor.Invoke("insertFixedItem$$", "insertFixedItem(const QString&, int)", typeof(void), typeof(string), text, typeof(int), id);
        }
        /// <remarks>
        ///   Inserts a fixed width permanent text label into status bar. The width
        ///   will be set according to <code>text</code>, but will remain fixed even if you
        ///   change text.  You can change fixed width by calling setItemFixed.
        /// <param> name="text" The label's text string
        /// </param><param> name="id" id of item
        ///    </param></remarks>        <short>     Inserts a fixed width permanent text label into status bar.</short>
        public void InsertPermanentFixedItem(string text, int id) {
            interceptor.Invoke("insertPermanentFixedItem$$", "insertPermanentFixedItem(const QString&, int)", typeof(void), typeof(string), text, typeof(int), id);
        }
        /// <remarks>
        ///   Removes an item.
        /// <param> name="id" The item to remove.
        ///    </param></remarks>        <short>     Removes an item.</short>
        public void RemoveItem(int id) {
            interceptor.Invoke("removeItem$", "removeItem(int)", typeof(void), typeof(int), id);
        }
        /// <remarks>
        ///   Returns true if an item with <code>id</code> exists already in KStatusBar,
        ///   otherwise returns false.
        /// <param> name="id" id of the item
        ///    </param></remarks>        <short>     Returns true if an item with <code>id</code> exists already in KStatusBar,   otherwise returns false.</short>
        public bool HasItem(int id) {
            return (bool) interceptor.Invoke("hasItem$", "hasItem(int) const", typeof(bool), typeof(int), id);
        }
        /// <remarks>
        ///  The text of an item, if it exists.
        ///    </remarks>        <short>    The text of an item, if it exists.</short>
        public string ItemText(int id) {
            return (string) interceptor.Invoke("itemText$", "itemText(int) const", typeof(string), typeof(int), id);
        }
        /// <remarks>
        ///  Changes the text in a status bar field.
        ///  The item will be resized to fit the text. If you change text to be empty,
        ///  item will not be visible (until you add some text).
        /// <param> name="text" The label's text string
        /// </param><param> name="id" The id of item.
        ///    </param></remarks>        <short>    Changes the text in a status bar field.</short>
        public void ChangeItem(string text, int id) {
            interceptor.Invoke("changeItem$$", "changeItem(const QString&, int)", typeof(void), typeof(string), text, typeof(int), id);
        }
        /// <remarks>
        ///  Sets the alignment of item <code>id.</code> By default all fields are aligned
        ///  <code>AlignHCenter</code> | <code>AlignVCenter.</code> See QLabel.SetAlignment for details.
        ///   </remarks>        <short>    Sets the alignment of item <code>id.</code></short>
        public void SetItemAlignment(int id, uint alignment) {
            interceptor.Invoke("setItemAlignment$$", "setItemAlignment(int, Qt::Alignment)", typeof(void), typeof(int), id, typeof(uint), alignment);
        }
        /// <remarks>
        ///  Sets item <code>id</code> to have fixed width. This cannot be undone, but you can
        ///  always set new fixed width.
        /// <param> name="id" id of item
        /// </param><param> name="width" fixed width in pixels. Default -1 is to adapt to text width.
        ///    </param></remarks>        <short>    Sets item <code>id</code> to have fixed width.</short>
        public void SetItemFixed(int id, int width) {
            interceptor.Invoke("setItemFixed$$", "setItemFixed(int, int)", typeof(void), typeof(int), id, typeof(int), width);
        }
        public void SetItemFixed(int id) {
            interceptor.Invoke("setItemFixed$", "setItemFixed(int)", typeof(void), typeof(int), id);
        }
        [SmokeMethod("eventFilter(QObject*, QEvent*)")]
        protected new virtual bool EventFilter(QObject arg1, QEvent arg2) {
            return (bool) interceptor.Invoke("eventFilter##", "eventFilter(QObject*, QEvent*)", typeof(bool), typeof(QObject), arg1, typeof(QEvent), arg2);
        }
        ~KStatusBar() {
            interceptor.Invoke("~KStatusBar", "~KStatusBar()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KStatusBar", "~KStatusBar()", typeof(void));
        }
        protected new IKStatusBarSignals Emit {
            get { return (IKStatusBarSignals) Q_EMIT; }
        }
    }

    public interface IKStatusBarSignals : IQStatusBarSignals {
        /// <remarks>
        ///   Emitted when mouse is pressed over item <code>id.</code>
        ///   Connect to this signal if you want to respond to mouse press events.
        ///    </remarks>        <short>     Emitted when mouse is pressed over item <code>id.</code></short>
        [Q_SIGNAL("void pressed(int)")]
        void Pressed(int arg1);
        /// <remarks>
        ///   Emitted when mouse is released over item <code>id.</code>
        ///   Connect to this signal if you want to respond to mouse release events (clicks).
        ///    </remarks>        <short>     Emitted when mouse is released over item <code>id.</code></short>
        [Q_SIGNAL("void released(int)")]
        void Released(int arg1);
    }
}
