//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///  KLanguageButton is a pushbutton which allows a language to be selected from
    ///  a popup list.
    ///  Languages are identified by their ISO 639-1 codes, e.g. en, pt_BR.
    ///   See <see cref="IKLanguageButtonSignals"></see> for signals emitted by KLanguageButton
    /// </remarks>        <short>    KLanguageButton is a pushbutton which allows a language to be selected from  a popup list.</short>
    [SmokeClass("KLanguageButton")]
    public class KLanguageButton : QWidget, IDisposable {
        protected KLanguageButton(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KLanguageButton), this);
        }
        /// <remarks>
        ///  Constructs a button whose text is determined by the current language
        ///  in the popup list.
        /// <param> name="parent" the parent of the button
        ///    </param></remarks>        <short>    Constructs a button whose text is determined by the current language  in the popup list.</short>
        public KLanguageButton(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLanguageButton#", "KLanguageButton(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KLanguageButton() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLanguageButton", "KLanguageButton()", typeof(void));
        }
        /// <remarks>
        ///  Constructs a button with static text.
        /// <param> name="text" the text of the button
        /// </param><param> name="parent" the parent of the button
        ///    </param></remarks>        <short>    Constructs a button with static text.</short>
        public KLanguageButton(string text, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLanguageButton$#", "KLanguageButton(const QString&, QWidget*)", typeof(void), typeof(string), text, typeof(QWidget), parent);
        }
        public KLanguageButton(string text) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLanguageButton$", "KLanguageButton(const QString&)", typeof(void), typeof(string), text);
        }
        /// <remarks>
        ///  Sets the locale to display language names. By default, KGlobal.Locale() is used.
        /// <param> name="locale" locale to use
        ///    </param></remarks>        <short>    Sets the locale to display language names.</short>
        public void SetLocale(KLocale locale) {
            interceptor.Invoke("setLocale#", "setLocale(const KLocale*)", typeof(void), typeof(KLocale), locale);
        }
        /// <remarks>
        ///  Sets a static button text.
        /// <param> name="text" button text
        ///    </param></remarks>        <short>    Sets a static button text.</short>
        public void SetText(string text) {
            interceptor.Invoke("setText$", "setText(const QString&)", typeof(void), typeof(string), text);
        }
        /// <remarks>
        ///  Specifies whether language codes should be shown alongside language names
        ///  in the popup. Calling this method does not affect any previously
        ///  inserted language texts, so it should normally be called before
        ///  populating the list.
        /// <param> name="show" true to show codes, false to hide codes
        ///    </param></remarks>        <short>    Specifies whether language codes should be shown alongside language names  in the popup.</short>
        public void ShowLanguageCodes(bool show) {
            interceptor.Invoke("showLanguageCodes$", "showLanguageCodes(bool)", typeof(void), typeof(bool), show);
        }
        /// <remarks>
        ///  Load all known languages into the popup list.
        ///  The current language in the list is set to the default language for the
        ///  current locale (as modified by setLocale()).
        ///    </remarks>        <short>    Load all known languages into the popup list.</short>
        public void LoadAllLanguages() {
            interceptor.Invoke("loadAllLanguages", "loadAllLanguages()", typeof(void));
        }
        /// <remarks>
        ///  Inserts a language into the combo box.
        ///  Normally the display name of the language is obtained automatically, but
        ///  if either the language code does not exist, or there are special display
        ///  requirements, the name of the language can be specified in <code>name.</code>
        /// <param> name="languageCode" the code for the language
        /// </param><param> name="name" language name. If empty, the name is obtained automatically.
        /// </param><param> name="index" the insertion position, or -1 to insert in alphabetical order
        ///    </param></remarks>        <short>    Inserts a language into the combo box.</short>
        public void InsertLanguage(string languageCode, string name, int index) {
            interceptor.Invoke("insertLanguage$$$", "insertLanguage(const QString&, const QString&, int)", typeof(void), typeof(string), languageCode, typeof(string), name, typeof(int), index);
        }
        public void InsertLanguage(string languageCode, string name) {
            interceptor.Invoke("insertLanguage$$", "insertLanguage(const QString&, const QString&)", typeof(void), typeof(string), languageCode, typeof(string), name);
        }
        public void InsertLanguage(string languageCode) {
            interceptor.Invoke("insertLanguage$", "insertLanguage(const QString&)", typeof(void), typeof(string), languageCode);
        }
        /// <remarks>
        ///  Inserts a separator item into the combo box. A negative index will append the item.
        /// <param> name="index" the insertion position
        ///    </param></remarks>        <short>    Inserts a separator item into the combo box.</short>
        public void InsertSeparator(int index) {
            interceptor.Invoke("insertSeparator$", "insertSeparator(int)", typeof(void), typeof(int), index);
        }
        public void InsertSeparator() {
            interceptor.Invoke("insertSeparator", "insertSeparator()", typeof(void));
        }
        /// <remarks>
        ///  Returns the number of items in the combo box.
        ///    </remarks>        <short>    Returns the number of items in the combo box.</short>
        public int Count() {
            return (int) interceptor.Invoke("count", "count() const", typeof(int));
        }
        /// <remarks>
        ///  Removes all combobox items.
        ///    </remarks>        <short>    Removes all combobox items.</short>
        public void Clear() {
            interceptor.Invoke("clear", "clear()", typeof(void));
        }
        /// <remarks>
        ///  Returns the language code of the combobox's current item.
        /// </remarks>        <return> the current item's language code
        ///    </return>
        ///         <short>    Returns the language code of the combobox's current item.</short>
        public string Current() {
            return (string) interceptor.Invoke("current", "current() const", typeof(string));
        }
        /// <remarks>
        ///  Checks whether the specified language is in the popup list.
        /// <param> name="languageCode" the language's code
        /// </param></remarks>        <return> true if in the list
        ///    </return>
        ///         <short>    Checks whether the specified language is in the popup list.</short>
        public bool Contains(string languageCode) {
            return (bool) interceptor.Invoke("contains$", "contains(const QString&) const", typeof(bool), typeof(string), languageCode);
        }
        /// <remarks>
        ///  Sets a given language to be the current item.
        /// <param> name="languageCode" the language's code
        ///    </param></remarks>        <short>    Sets a given language to be the current item.</short>
        public void SetCurrentItem(string languageCode) {
            interceptor.Invoke("setCurrentItem$", "setCurrentItem(const QString&)", typeof(void), typeof(string), languageCode);
        }
        ~KLanguageButton() {
            interceptor.Invoke("~KLanguageButton", "~KLanguageButton()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KLanguageButton", "~KLanguageButton()", typeof(void));
        }
        protected new IKLanguageButtonSignals Emit {
            get { return (IKLanguageButtonSignals) Q_EMIT; }
        }
    }

    public interface IKLanguageButtonSignals : IQWidgetSignals {
        /// <remarks>
        ///  This signal is emitted when a new item is activated.
        /// <param> name="languageCode" code of the activated language
        ///    </param></remarks>        <short>    This signal is emitted when a new item is activated.</short>
        [Q_SIGNAL("void activated(QString)")]
        void Activated(string languageCode);
        /// <remarks>
        ///  This signal is emitted when a new item is highlighted.
        /// <param> name="languageCode" code of the highlighted language
        ///    </param></remarks>        <short>    This signal is emitted when a new item is highlighted.</short>
        [Q_SIGNAL("void highlighted(QString)")]
        void Highlighted(string languageCode);
    }
}
