#
#  pyParts.py (C) 2002 Jim Bublitz <jbublitz@nwinternet.com>
#

"""

This is an extemely simple and crude example of using
a KHTMLPart - I put it together mostly to make sure
the openURL method worked correctly after some modifications
done in KParts::ReadOnlyPart. It took exactly four lines
added to a basic PyKDE app framework to display a URL
via the 'net:

    self.w  = KHTMLPart (self, "HTMLPart", self);
    self.w.openURL (KURL ("http://www.kde.org"));
    self.w.view ().setGeometry (30, 55, 500, 400);
    self.w.show ();

(Actually 5 lines if you count the 'import' line)

You can play around with the commented out lines or add
additional code to make this do something useful. The
.rc for khtnmlpart (sorry, I never looked it up), doesn't
seem to provide much help. Also, to follow links, you
probably need to connect some signals to slots. I
haven't tried it, but this should work with a plain
KMainWindow or other widget too.

The KDE website also incorporates gifs, jpegs, and
I believe CSS too. Playing around with some other
sites, it appears the font defaults could use some
improvement.

NOTE!!! For this to work, you (obviously) need to have
a route to the internet established or specify a local
URL - PyKDE/KDE will take care of everything else.

Perceptive users will notice the KHTMLPart code is
lifted from the KDE classref.

"""

# If you import more classes, don't forget to add them here (some of these
# are extras/not used)

from kdecore import KCmdLineArgs, KURL, KApplication, i18n, KAboutData, BarIcon, KLibLoader

from kdeui import KMainWindow, KMessageBox, KAction, KStdAction, KKeyDialog, KEditToolbar

from qt import  QString, QStringList

from kio import KTrader

from khtml import KHTMLPart, KHTMLView

# Importing the KParts namespace gets us all of the KParts:: classes
from kparts import KParts, createReadOnlyPart, createReadWritePart

import sys, os

FALSE = 0
TRUE  = not FALSE

TOOLBAR_EXIT = 0
TOOLBAR_OPEN = 1

# Note that we use KParts.MainWindow, not KMainWindow as the superclass
# (KParts.MainWindow subclasses KMainWindow). Also, be sure the 'apply'
# clause references KParts.MainWindow - it's a hard bug to track down
# if it doesn't.

class pyPartsMW (KParts.MainWindow):
        def __init__ (self, *args):
                apply (KParts.MainWindow.__init__, (self,) + args)

                # Create the actions for our menu/toolbar to use
                # Keep in mind that the part loaded will provide its
                # own menu/toolbar entries

                # check out KParts.MainWindow's ancestry to see where
                # some of this and later stuff (like self.actionCollection () )
                # comes from

                quitAction    = KStdAction.quit (self.close, self.actionCollection ())

                self.m_toolbarAction = KStdAction.showToolbar(self.optionsShowToolbar, self.actionCollection());
                self.m_statusbarAction = KStdAction.showStatusbar(self.optionsShowStatusbar, self.actionCollection());

                KStdAction.keyBindings(self.optionsConfigureKeys, self.actionCollection());
                KStdAction.configureToolbars(self.optionsConfigureToolbars, self.actionCollection());

                self.path = os.getcwd () + '/'
                self.setGeometry (0, 0, 600, 500)

                # point to our XML file
                self.setXMLFile (self.path + "pyParts.rc", FALSE)

                # The next few lines are all that's necessary to
                # create a web browser (of course you have to edit
                # this file to change url's)

                self.w   = KHTMLPart (self, "HTMLPart", self);
                self.w.openURL (KURL ("http://www.kde.org"));

                self.w.view ().setGeometry (30, 55, 500, 400);


#                self.v = KHTMLView (self.w, self)

#                self.setCentralWidget (self.v)

#                self.createGUI (self.w)

                self.w.show ();




        # slots for our actions
        def optionsShowToolbar (self):
                if self.m_toolbarAction.isChecked():
                        self.toolBar().show()
                else:
                        self.toolBar().hide()

        def optionsShowStatusbar (self):
                if self.m_statusbarAction.isChecked ():
                        self.statusBar().show()
                else:
                        self.statusBar().hide()


        def optionsConfigureKeys (self):
                KKeyDialog.configureActionKeys (self.actionCollection(), self.xmlFile ())


        def optionsConfigureToolbars (self):
                dlg = KEditToolbar (self.actionCollection(), self.xmlFile ())
                if dlg.exec_loop ():
                        self.createGUI(self);


        # some boilerplate left over from pyKLess/KLess
        def queryClose(self):
                res = KMessageBox.warningYesNoCancel(self,\
                        i18n("Save changes to Document?<br>(Does not make sense, we know, but it is just a programming example :-)"))
                if res == KMessageBox.Yes:
	        #// save document here. If saving fails, return FALSE
	                return TRUE

                elif res == KMessageBox.No:
                        return TRUE

                else: #// cancel
	                return FALSE

        def queryExit(self):
                #// this slot is invoked in addition when the *last* window is going
                #// to be closed. We could do some final cleanup here.
                return TRUE #// accept

        # I'm not sure the session mgmt stuff here works

        # Session management: save data
        def saveProperties(self, config):
        # This is provided just as an example.
        # It is generally not so good to save the raw contents of an application
        # in its configuration file (as this example does).
        # It is preferable to save the contents in a file on the application's
        # data zone and save an URL to it in the configuration resource.
                config.writeEntry("text", self.edit.text())


        # Session management: read data again
        def readProperties(self, config):
        # See above
                self.edit.setText(config.readEntry("text"))



#------------- main ----------------------------

# A Human readable description of your program
description = "KHTMLPart - simple example"
# The version
version = "0.1"

# stuff for the "About" menu
aboutData = KAboutData ("pyKHTMLPart", "pyHTMLPart",\
    version, description, KAboutData.License_GPL,\
    "(c) 2002, Jim Bublitz")

aboutData.addAuthor ("Jim Bublitz", "Example for PyKDE", "jbublitz@nwinternet.com")

# This MUST go here (before KApplication () is called)
KCmdLineArgs.init (sys.argv, aboutData)

app = KApplication ()

if (app.isRestored()):
        RESTORE(KLess)
else:
        # no session management: just create one window
        # this is our KParts::MainWindow derived class
        parts = pyPartsMW (None, "pyParts")
        if len(sys.argv) > 1:
        # read kcmdlineargs.h for the full unabridged instructions
        # on using KCmdLineArgs, it's pretty confusing at first, but it works
        # This is pretty useless in this program - you might want to
        # expand this in your app (to load a file, etc)
                args = KCmdLineArgs.parsedArgs()

parts.show()
app.exec_loop()
