import imp
import os
import string
import sys
import SCons.Errors
import SCons.Tool
def platform_default():
    osname=os.name
    if osname=='posix':
        if string.find(sys.platform, 'darwin') != -1:
            return 'darwin'
        else:
            return 'posix'
    else:
        return sys.platform
def platform_module(name=platform_default()):
    full_name='SCons.Platform.' + name
    if not sys.modules.has_key(full_name):
        try:
            file, path, desc=imp.find_module(name, sys.modules['SCons.Platform'].__path__)
            mod=imp.load_module(full_name, file, path, desc)
            setattr(SCons.Platform, name, mod)
        except ImportError:
            raise SCons.Errors.UserError, "No platform named '%s'" % name
        if file:
            file.close()
    return sys.modules[full_name]
def DefaultToolList(platform, env):
    return SCons.Tool.tool_list(platform, env)
class PlatformSpec:
    def __init__(self, name):
        self.name=name
    def __str__(self):
        return self.name
def Platform(name=platform_default()):
    module=platform_module(name)
    spec=PlatformSpec(name)
    spec.__call__=module.generate
    return spec
