#ifndef _PLUGIN_KATE_HELLOWORLD_H_
#define _PLUGIN_KATE_HELLOWORLD_H_

#include <kate/application.h>
#include <kate/docmanager.h>
#include <kate/document.h>
#include <kate/mainwindow.h>
#include <kate/plugin.h>
#include <kate/view.h>
#include <kate/viewmanager.h>

#include <klibloader.h>
#include <klocale.h>

class KatePluginFactory : public KLibFactory
{
  Q_OBJECT

  public:
    KatePluginFactory();
    virtual ~KatePluginFactory();

    virtual QObject* createObject( QObject* parent = 0, const char* pname = 0, const char* name = "QObject", const QStringList &args = QStringList() );

  private:
    static KInstance* s_instance;
};

class KatePluginHelloWorld : public Kate::Plugin
{
  Q_OBJECT

  public:
    KatePluginHelloWorld( QObject* parent = 0, const char* name = 0 );
    virtual ~KatePluginHelloWorld();

    Kate::PluginView *createView (Kate::MainWindow *win);

  public slots:
    void slotInsertHello();
};

#endif
