(require 'sawfish.wm.util.recolor-image)

;; Customization

(defgroup Sweetpill "Saruman Sweetpill"
    :group appearance)

(defcustom Sweetpill:title-color (get-color "#aabbaa")
    "Title color"
    :type color
    :group (appearance Sweetpill)
    :after-set (lambda () (recolor-title) (after-setting-frame-option)))

(defcustom Sweetpill:focused-text-color "#ffffff"
    "Focused frame text color"
    :type color
    :group (appearance Sweetpill)
    :after-set after-setting-frame-option)

(defcustom Sweetpill:unfocused-text-color "#dae2e1"
    "Unfocused frame text color"
    :type color
    :group (appearance Sweetpill)
    :after-set after-setting-frame-option)

(defcustom Sweetpill:title-font 
    "-b&h-lucida-bold-r-normal-*-*-100-*-*-p-*-iso8859-1"
    "Frame title font"
    :type font
    :group (appearance Sweetpill)
    :after-set after-setting-frame-option)


;; images

(define topleft-images (make-image "topleft-i.png"))

(define top-images     (set-image-border (make-image "top-i.png") 12 12 0 0))

(define topright-images (make-image "topright-i.png"))

(define lefttop-images (make-image "lefttop-i.png"))

(define menubutton-images (list (make-image "menubutton-i.png")
                         (make-image "menubutton-a.png")
                         nil
                         (make-image "menubutton-c.png")))

(define title-left-images (list (make-image "title-left-i.png")
                         (make-image "title-left-a.png")))

(define title-images (list (set-image-border (make-image "title-i.png") 3 3 0 0)
                    (make-image "title-a.png")))

(define title-right-images (list (make-image "title-right-i.png")
                          (make-image "title-right-a.png")))

(define min-button-images (list (make-image "min-button-i.png")
                         (make-image "min-button-a.png")
                         nil
                         (make-image "min-button-c.png")))

(define max-button-images (list (make-image "max-button-i.png")
                         (make-image "max-button-a.png")
                         nil
                         (make-image "max-button-c.png")))

(define kill-button-images (list (make-image "kill-button-i.png")
                          (make-image "kill-button-a.png")
                          nil
                          (make-image "kill-button-c.png")))

(define righttop-images (make-image "righttop-i.png"))

(define right-images (make-image "right-i.png"))

(define left-images (make-image "left-i.png"))

(define bottomleft-images (make-image "bottomleft-i.png"))

(define bottom-images (make-image "bottom-i.png"))

(define bottomright-images (make-image "bottomright-i.png"))

(define top2-images (make-image "top2-i.png"))

(define bottomleft-shaded-images (make-image "bottomleft-shaded-i.png"))

(define bottom-shaded-images (make-image "bottom-shaded-i.png"))

(define bottomright-shaded-images (make-image "bottomright-shaded-i.png"))

(define top2-transient-images (make-image "top2-transient-i.png"))

;; Customization purposes

(define title-font (lambda (w) Sweetpill:title-font))

(define title-colors (lambda (w) (list Sweetpill:unfocused-text-color 
                           Sweetpill:focused-text-color)))

(define (recolor-title)
    (let ((recolorer (make-image-recolorer Sweetpill:title-color
                                           #:zero-channel red-channel
                                           #:index-channel green-channel)))
        (mapc (lambda (x) (mapc recolorer x))
              (list title-left-images title-images title-right-images))
              ))

(recolor-title)

(let*
    (

     (default-frame
       `(((left-edge . -6)
          (top-edge . -26)
          (background . ,topleft-images)
          (class . top-left-corner))
         ((right-edge . 69)
          (left-edge . 31)
          (top-edge . -26)
          (background . ,top-images)
          (class . top-border))
         ((right-edge . -6)
          (background . ,topright-images)
          (top-edge . -26)
          (class . top-right-corner))
         ((top-edge . -22)
          (left-edge . -6)
          (background . ,lefttop-images)
          (class . top-left-corner))
         ((left-edge . 0)
          (top-edge . -22)
          (background . ,menubutton-images)
          (class . menu-button))
         ((left-edge . 17)
          (top-edge . -22)
          (background . ,title-left-images)
          (class . title))
         ((left-edge . 31)
          (right-edge . 69)
          (font . ,title-font)
          (top-edge . -22)
          (y-justify . 4)
          (x-justify . 2)
          (text . ,window-name)
          (foreground . ,title-colors)
          (class . title)
          (background . ,title-images))
         ((class . title)
          (right-edge . 55)
          (background . ,title-right-images)
          (top-edge . -22))
         ((background . ,min-button-images)
          (top-edge . -22)
          (right-edge . 36)
          (class . iconify-button))
         ((right-edge . 17)
          (background . ,max-button-images)
          (top-edge . -22)
          (class . maximize-button))
         ((right-edge . 0)
          (background . ,kill-button-images)
          (top-edge . -22)
          (class . close-button))
         ((top-edge . 0)
          (bottom-edge . 20)
          (background . ,left-images)
          (left-edge . -6)
          (class . left-border))
         ((bottom-edge . 20)
          (background . ,right-images)
          (top-edge . 0)
          (right-edge . -6)
          (class . right-border))
         ((background . ,left-images)
          (height . 20)
          (bottom-edge . 0)
          (left-edge . -6)
          (class . bottom-left-corner))
         ((background . ,right-images)
          (height . 20)
          (bottom-edge . 0)
          (right-edge . -6)
          (class . bottom-right-corner))
         ((background . ,bottomleft-images)
          (bottom-edge . -6)
          (left-edge . -6)
          (class . bottom-left-corner))
         ((right-edge . 17)
          (background . ,bottom-images)
          (bottom-edge . -6)
          (left-edge . 17)
          (class . bottom-border))
         ((background . ,bottomright-images)
          (bottom-edge . -6)
          (right-edge . -6)
          (class . bottom-right-corner))
         ((right-edge . 17)
          (top-edge . -26)
          (background . ,top2-images)
          (class . top-border))
         ((background . ,righttop-images)
          (top-edge . -22)
          (right-edge . -6)
          (class . top-right-corner))))

      (titleonly-frame
       `(((left-edge . -6)
          (top-edge . -26)
          (background . ,topleft-images)
          (class . top-left-corner))
         ((left-edge . 31)
          (right-edge . 69)
          (top-edge . -26)
          (background . ,top-images)
          (class . top-border))
         ((right-edge . -6)
          (background . ,topright-images)
          (top-edge . -26)
          (class . top-right-corner))
         ((top-edge . -22)
          (left-edge . -6)
          (background . ,lefttop-images)
          (class . top-left-corner))
         ((left-edge . 0)
          (top-edge . -22)
          (background . ,menubutton-images)
          (class . menu-button))
         ((left-edge . 17)
          (background . ,title-left-images)
          (top-edge . -22)
          (class . title))
         ((left-edge . 31)
          (font . ,title-font)
          (top-edge . -22)
          (right-edge . 69)
          (y-justify . 4)
          (x-justify . 2)
          (text . ,window-name)
          (foreground . ,title-colors)
          (class . title)
          (background . ,title-images))
         ((right-edge . 55)
          (class . title)
          (background . ,title-right-images)
          (top-edge . -22))
         ((background . ,min-button-images)
          (top-edge . -22)
          (right-edge . 36)
          (class . iconify-button))
         ((right-edge . 17)
          (background . ,max-button-images)
          (top-edge . -22)
          (class . maximize-button))
         ((right-edge . 0)
          (background . ,kill-button-images)
          (top-edge . -22)
          (class . close-button))
         ((right-edge . -6)
          (top-edge . -22)
          (background . ,righttop-images)
          (class . top-right-corner))
         ((right-edge . 17)
          (top-edge . -26)
          (background . ,top2-images)
          (class . top-border))
         ((left-edge . -6)
          (top-edge . -2)
          (background . ,bottomleft-shaded-images)
          (class . title))
         ((right-edge . 17)
          (top-edge . -2)
          (left-edge . 17)
          (background . ,bottom-shaded-images)
          (class . title))
         ((background . ,bottomright-shaded-images)
          (top-edge . -2)
          (right-edge . -6)
          (class . title))))

      (transient-frame
       `(((top-edge . -26)
          (left-edge . -6)
          (background . ,topleft-images)
          (class . top-left-corner))
         ((right-edge . 31)
          (left-edge . 31)
          (top-edge . -26)
          (background . ,top-images)
          (class . top-border))
         ((right-edge . -6)
          (background . ,topright-images)
          (top-edge . -26)
          (class . top-right-corner))
         ((left-edge . -6)
          (background . ,lefttop-images)
          (top-edge . -22)
          (class . top-left-corner))
         ((left-edge . 17)
          (background . ,title-left-images)
          (top-edge . -22)
          (class . title))
         ((left-edge . 31)
          (font . ,title-font)
          (right-edge . 31)
          (top-edge . -22)
          (y-justify . 4)
          (x-justify . 2)
          (text . ,window-name)
          (foreground . ,title-colors)
          (class . title)
          (background . ,title-images))
         ((right-edge . 17)
          (class . title)
          (background . ,title-right-images)
          (top-edge . -22))
         ((right-edge . -6)
          (background . ,righttop-images)
          (top-edge . -22)
          (class . top-right-corner))
         ((background . ,left-images)
          (bottom-edge . 20)
          (top-edge . 0)
          (left-edge . -6)
          (class . left-border))
         ((bottom-edge . 20)
          (background . ,right-images)
          (top-edge . 0)
          (right-edge . -6)
          (class . right-border))
         ((background . ,left-images)
          (height . 20)
          (bottom-edge . 0)
          (left-edge . -6)
          (class . bottom-left-corner))
         ((background . ,right-images)
          (height . 20)
          (bottom-edge . 0)
          (right-edge . -6)
          (class . bottom-right-corner))
         ((background . ,bottomleft-images)
          (bottom-edge . -6)
          (left-edge . -6)
          (class . bottom-left-corner))
         ((right-edge . 17)
          (background . ,bottom-images)
          (bottom-edge . -6)
          (left-edge . 17)
          (class . bottom-border))
         ((background . ,bottomright-images)
          (bottom-edge . -6)
          (right-edge . -6)
          (class . bottom-right-corner))
         ((right-edge . 0)
          (top-edge . -22)
          (background . ,kill-button-images)
          (class . close-button))
         ((left-edge . 0)
          (background . ,menubutton-images)
          (top-edge . -22)
          (class . menu-button))
         ((top-edge . -26)
          (right-edge . 17)
          (background . ,top2-transient-images)
          (class . top-border))))

      (transientshaded-frame
       `(((left-edge . -6)
          (top-edge . -26)
          (background . ,topleft-images)
          (class . top-left-corner))
         ((right-edge . 31)
          (left-edge . 31)
          (top-edge . -26)
          (background . ,top-images)
          (class . top-border))
         ((right-edge . -6)
          (background . ,topright-images)
          (top-edge . -26)
          (class . top-right-corner))
         ((left-edge . -6)
          (background . ,lefttop-images)
          (top-edge . -22)
          (class . top-left-corner))
         ((left-edge . 17)
          (background . ,title-left-images)
          (top-edge . -22)
          (class . title))
         ((left-edge . 31)
          (font . ,title-font)
          (right-edge . 31)
          (top-edge . -22)
          (y-justify . 4)
          (x-justify . 2)
          (text . ,window-name)
          (foreground . ,title-colors)
          (class . title)
          (background . ,title-images))
         ((right-edge . 17)
          (class . title)
          (background . ,title-right-images)
          (top-edge . -22))
         ((right-edge . -6)
          (background . ,righttop-images)
          (top-edge . -22)
          (class . top-right-corner))
         ((top-edge . -22)
          (right-edge . 0)
          (background . ,kill-button-images)
          (class . close-button))
         ((left-edge . 0)
          (background . ,menubutton-images)
          (top-edge . -22)
          (class . menu-button))
         ((top-edge . -26)
          (right-edge . 17)
          (background . ,top2-transient-images)
          (class . top-border))
         ((background . ,bottomleft-shaded-images)
          (top-edge . -2)
          (left-edge . -6)
          (class . title))
         ((background . ,bottom-shaded-images)
          (top-edge . -2)
          (right-edge . 17)
          (left-edge . 17)
          (class . title))
         ((background . ,bottomright-shaded-images)
          (top-edge . -2)
          (right-edge . -6)
          (class . title))))
    )

    (add-frame-style 'Saruman-Sweetpill
        (lambda (w type)
            (case type
              ((default) default-frame)
              ((transient) transient-frame)
              ((shaped) titleonly-frame)
              ((shaped-transient) transientshaded-frame))))
)
