;; FBX-1 for the 'Sawfish' Window Manager for X
;; by Fabien Grumelard
;; email : fabix@netcourrier.com

(let*
    ((title-width (lambda (w)
		    (let
			((w-width (car (window-dimensions w))))
		      (- (min (max (/ w-width 2) 100) w-width) 16))))
     
     ;; Image Defintions (colorisations and scaling borders too) ====---     

     (top-images (mapcar (lambda (i)
			   (set-image-border i 26 8 1 1))
			 (list (make-image "top.png")
			       (make-image "top.png")
			       (make-image "top.png")
			       (make-image "top.png"))))

     (left-images (make-image "left.png"))
     (right-images (make-image "right.png"))

     (bottom-left-images (list (make-image "bottom-left.png")
			       (make-image "active-bottom-left.png")
                               (make-image "over-bottom-left.png")
                               (make-image "down-bottom-left.png")))
     (bottom-right-images (list (make-image "bottom-right.png")
				(make-image "active-bottom-right.png")
				(make-image "over-bottom-right.png")
				(make-image "down-bottom-right.png")))

     (bottom-images (set-image-border (make-image "bottom.png") 3 3 1 1))

     (title-images (mapcar (lambda (i)
			     (set-image-border i 3 3 1 1))
			   (list (make-image "title.png")
				 (make-image "active-title.png")
				 (make-image "active-title.png")
				 (make-image "active-title.png"))))

     (button-menu-images (list (make-image "inactive-button-menu.png")
			       (make-image "active-button-menu.png")
			       (make-image "over-button-menu.png")
			       (make-image "down-button-menu.png")))

     (black-image (make-image "black.png"))

     ;; Frame Definitions =============---------

     (frame `(((background . ,top-images)
	       (left-edge . -5)
	       (right-edge . -5)
	       (top-edge . -24))
	      ((background . ,left-images)
	       (left-edge . -5)
	       (top-edge . 0)
	       (bottom-edge . 5)
	       (class . left-border))	
              ((background . ,right-images)
               (right-edge . -5)
               (top-edge . 0)
               (bottom-edge . 5)
	       (class . right-border)) 
              ((background . ,bottom-left-images)
               (left-edge . -5)
	       (bottom-edge . -6)
	       (class . bottom-left-corner)) 
              ((background . ,bottom-right-images)
               (right-edge . -5)
               (bottom-edge . -6)
               (class . bottom-right-corner))
	      ((background . ,bottom-images)
	       (left-edge . 17)
	       (right-edge . 17)
	       (bottom-edge . -6)
	       (class . bottom-border))

	      ;; Title =====------

              ((background . ,title-images)
	       (foreground . black)
               (text . ,window-name)
               (x-justify . 4)
               (y-justify . center)
               (left-edge . 4)
               (right-edge . 22)
               (top-edge . -19)
	       (class . title))

	      ;; buttons ====----
	      ((background . ,button-menu-images)
	       (top-edge . -18)
	       (right-edge . 4)
	       (class . menu-button))
	      ))

     (frame-shaped `(((background . ,top-images)
		      (left-edge . -8)
		      (right-edge . -5)
		      (top-edge . -24))

		     ((background . ,black-image)
		      (left-edge . -5)
		      (right-edge . -5)
		      (top-edge . -1)
		      (height . 2))

		     ;; Title =====------

		     ((background . ,title-images)
		      (foreground . black)
		      (text . ,window-name)
		      (x-justify . 4)
		      (y-justify . center)
		      (left-edge . 25)
		      (right-edge . 2)
		      (top-edge . -19)
		      (class . title))

		     ;; buttons ====----
		     ((background . ,button-menu-images)
		      (top-edge . -18)
		      (right-edge . 4)
		      (class . menu-button))
		     ))

     )

  (add-frame-style 'FBX-1
		   (lambda (w type)
		     (case type
		       ((default) frame)
		       ((transient) frame)
		       ((shaped) frame-shaped)
		       ((shaped-transient) frame-shaped)))))
