; AmiMar/theme.jl
; Licence: freeware
; Szerzo: succuba@elmki.sulinet.hu

(let*
 ;; Cimsor pixelszelesseg beallitasa
 ((title-width (lambda (w) 
	(let ((w-width 
	  (car (window-dimensions w)))) 
	    (max 0 (min (- w-width 100) (text-width (window-name w)))))))

  ;; --- Tema kidolgozasa, kepek, betuk, szinek, keretek ---
  (

  ;; Kezdeti beallitasok importalasa a beallitopanelrol meg egyebek
   (define titlebar-title (lambda (w) (window-name w)))
   (define titlefont  (lambda () (get-font "-*-lucidatypewriter-bold-r-normal-*-*-120-*-*-p-*-iso8859-2")))
   (define t-titlefont  (lambda () (get-font "-*-lucidatypewriter-bold-r-normal-*-*-120-*-*-p-*-iso8859-2")))
   (define titlefont-colors (list (get-color "#200020002000") (get-color "#000000000000") (get-color "#400040004000") (get-color "#FF00F800E800")))

   ;; --- Kepi elemek listaja: inaktiv, aktiv, eger alatti, kattintott ---
     
   ;; Cimsor                  41 x 24
   (define title-images       (list (make-image "title-i-tiled.png")
                                    (make-image "title-a-tiled.png")))

   ;; Ablak nyomogombjai (inaktiv, fokusztalt, eger alatti, kattintott)
   ;; Mini gomb               23 x 24
   (define iconify-images     (list (make-image "btn-min-i.png") 
                                    (make-image "btn-min-a.png") 
                                    (make-image "btn-min-h.png") 
                                    (make-image "btn-min-c.png")))
   ;; Maxi gomb               23 x 24
   (define maximize-images    (list (make-image "btn-max-i.png") 
                                    (make-image "btn-max-a.png")
                                    (make-image "btn-max-h.png")
                                    (make-image "btn-max-c.png")))
   ;; Bezar gomb              23 x 24
   (define close-images       (list (make-image "btn-cl-i.png")
                                    (make-image "btn-cl-a.png")
                                    (make-image "btn-cl-h.png")
                                    (make-image "btn-cl-c.png")))
   ;; Menu gomb               23 x 24
   (define menu-images        (list (make-image "btn-menu-i.png")
                                    (make-image "btn-menu-a.png")
                                    (make-image "btn-menu-h.png")
                                    (make-image "btn-menu-c.png")))
  
   ;; Tranziens gombok
   ;; Menu gomb               24 x 16
   (define tmenu-images       (list (make-image "btn-tmenu-i.png")
                                    (make-image "btn-tmenu-a.png")
                                    (make-image "btn-tmenu-h.png")
                                    (make-image "btn-tmenu-c.png")))
   ;; Bezar gomb              24 x 16
   (define tclose-images       (list (make-image "btn-tcl-i.png")
                                    (make-image "btn-tcl-a.png")
                                    (make-image "btn-tcl-h.png")
                                    (make-image "btn-tcl-c.png")))

   ;; Ablakszegelyek (inaktiv, fokuszalt)
   ;; Felso                   41 x 16
   (define border-top         (list (make-image "title-t-i-tiled.png") 
                                    (make-image "title-t-a-tiled.png")))
   ;; Also                    41 x 10
   (define border-bottom      (list (make-image "border-b-i-tiled.png") 
                                    (make-image "border-b-a-tiled.png")))
   ;; Jobb                    8 x 112
   (define border-right       (list (make-image "border-r-i.png")
                                    (make-image "border-r-a.png")))
   ;; Bal                     8 x 112
   (define border-left        (list (make-image "border-l-i.png") 
                                    (make-image "border-l-a.png")))
     
   ;; Ablak sarkok
   ;; Bal felso tranziens     28 x 16
   (define corner-tl-2        (list (make-image "corner-tlt-i.png") 
                                    (make-image "corner-tlt-a.png")
                                nil (make-image "corner-tlt-a.png")))
   ;; Jobb felso tranziens    28 x 16
   (define corner-tr-2        (list (make-image "corner-trt-i.png") 
                                    (make-image "corner-trt-a.png")
                                nil (make-image "corner-trt-a.png")))
   ;; Bal felso               28 x 24
   (define corner-tl          (list (make-image "corner-tl-i.png")
                                    (make-image "corner-tl-a.png")))
   ;; Jobb felso              74 x 24
   (define corner-tr          (list (make-image "corner-tr-i.png")
                                    (make-image "corner-tr-a.png")))
   ;; Bal also meretezo       24 x 10
   (define corner-bl          (list (make-image "corner-bl-i.png") 
                                    (make-image "corner-bl-a.png")))
   ;; Jobb also meretezo      24 x 10
   (define corner-br          (list (make-image "corner-br-i.png") 
                                    (make-image "corner-br-a.png")))
   ;; --- Keplista vege ---
  
   ;; normal cimsor

   (define (build-tiles)
     (mapc (lambda (i) (image-put i 'tiled t))
	      `(,@title-images ,@border-top ,@border-bottom)))

   (build-tiles)

   (define ntitle
     `(((background  . ,title-images)
	    (foreground  . ,titlefont-colors)
	    (font        . ,titlefont)
	    (text        . ,window-name)
	    (x-justify   . center)
	    (y-justify   . center)
	    (top-edge    . -24)
	    (left-edge   . 22)
	    (right-edge  . 68)
	    (class       . title))

       ((background  . ,corner-tl)
        (top-edge    . -24)
        (left-edge   . -6)
        (class       . top-left-corner))

       ((background  . ,corner-tr)
        (top-edge    . -24)
        (right-edge  . -6)
        (class       . top-right-corner))))

   ;; Tranziens normal cimsor
   (define tntitle
     `(((background  . ,border-top)
        (font        . ,t-titlefont)
	    (foreground  . ,titlefont-colors)
	    (text        . ,window-name)
	    (x-justify   . center)
	    (y-justify   . center)
	    (top-edge    . -16)
	    (left-edge   . 22)
	    (right-edge  . 22)
	    (class       . title))

       ((background  . ,corner-tl-2)
	    (top-edge    . -16)
		(left-edge   . -6)
		(class       . top-left-corner))

       ((background  . ,corner-tr-2)
        (top-edge    . -16)
		(right-edge  . -6)
		(class       . top-right-corner))))

   ;; Ablakszegelyek
   (define bord
     `(((background  . ,border-left)
	    (top-edge    . 0)
	    (bottom-edge . 0)
	    (left-edge   . -4) 
	    (class       . left-border))

	   ((background  . ,border-right)
	    (top-edge    . 0)
	    (bottom-edge . 0)
	    (right-edge  . -4)
	    (class       . right-border))

	   ((background  . ,border-bottom)
	    (bottom-edge . -10)
	    (right-edge  . 22)  
	    (left-edge   . 22)   
	    (class       . bottom-border))

	   ((background  . ,corner-bl)
	    (bottom-edge . -10)
	    (left-edge   . -6)  
	    (class       . bottom-left-corner))

	   ((background  . ,corner-br)
	    (bottom-edge . -10)
	    (right-edge  . -6) 
	    (class       . bottom-right-corner))))

   ;; Normal gombok
   (define nbtn
     `(((background   . ,menu-images)
        (top-edge     . -24)
	    (left-edge    . -5)
	    (class        . menu-button))

	   ((background  . ,iconify-images)
	    (top-edge    . -24)
	    (right-edge  . 41) 
	    (class       . iconify-button))

	   ((background  . ,maximize-images)
	    (top-edge    . -24)
	    (right-edge  . 18)
	    (class       . maximize-button))

	   ((background  . ,close-images)
	    (top-edge    . -24)
	    (right-edge  . -5)
	    (class       . close-button))))

   ;; Tranziens gombok
   (define tbtn
     `(((background  . ,tmenu-images)
        (top-edge    . -16)
        (left-edge   . -6)
        (class       . menu-button))

       ((background  . ,tclose-images)
        (top-edge   . -16)
        (right-edge . -6)
	    (class      . close-button))))

   ;; --- Itt kezdodik a keretek definicioja ---   

   ;; --- Normal keret (inaktiv) ---
   (define nfrm
     `(,@ntitle ,@nbtn ,@bord)) ;; --- Vege a normal keretnek ---

   ;; --- Nem teglalap alaku ablakok kerete (csak cimsor) ---
   (define shpfrm
     `(,@ntitle ,@nbtn)) ;; --- Vege a shaped keretnek ---

   ;; --- Tranziens keret (parbeszedablak) ---
   (define tnfrm
     `(,@tntitle ,@tbtn ,@bord)) ;; --- Vege a tranziens keretnek ---
	
   ;; --- Tranziens-shaped keret (csak cimsor, tranziens) ---
   (define tshpfrm
     `(,@tntitle ,@tbtn)) ;; --- Vege a tranziens-shaped keretnek ---
  
  ) ;; --- Vege a pixelszelessegdefinicionak

 ) ;; --- Vege a keretdefinicionak ---

 ;; --- Temadefinicio ---  
 (add-frame-style 'AmiMar
   (lambda (w type)   
     (case type
      ((default) nfrm)
      ((shaped) shpfrm)
      ((shaded) shpfrm)
      ((transient) tnfrm)
      ((shaped-transient) tshpfrm)
      ((shaded-transient) tshpfrm)
      ((unframed) nil-frame)))) ;; --- Temadefinicio vege ---

 (call-after-property-changed 'WM-NAME
    (lambda ()
       (rebuild-frames-with-style 'AmiMar)))
) 
;; --- Ez itt a fajl vege. Tovabb olvasni nem erdemes ;-) ---