/*
 *	interface_theme.h
 */

#ifndef __INTERFACE_THEME_H__
#define __INTERFACE_THEME_H__

#include <math.h>
#include <gtk/gtk.h>

#ifdef G_LOG_DOMAIN
#undef G_LOG_DOMAIN
#endif
#define	G_LOG_DOMAIN	"Interface-Theme"


/* Default Data values */
#define INTERFACE_SHADE_MUL					16384.0

#define INTERFACE_DEFAULT_SHINE				1.5
#define INTERFACE_DEFAULT_SHADE				0.6666667
#define INTERFACE_DEFAULT_SCROLLBAR_WIDTH	15


/* Frame types */
typedef enum {
	INTERFACE_SHADOW_NONE		= GTK_SHADOW_NONE,
	INTERFACE_SHADOW_IN			= GTK_SHADOW_IN,
	INTERFACE_SHADOW_OUT			= GTK_SHADOW_OUT,
	INTERFACE_SHADOW_MENU = INTERFACE_SHADOW_OUT,
	INTERFACE_SHADOW_ETCHED_IN	= GTK_SHADOW_ETCHED_IN,
	INTERFACE_SHADOW_ETCHED_OUT	= GTK_SHADOW_ETCHED_OUT,

	INTERFACE_SHADOW_BUTTON_IN,
	INTERFACE_SHADOW_NONE_OUT,
	INTERFACE_SHADOW_NONE_IN,
	INTERFACE_SHADOW_IN_FOCUSED,
	INTERFACE_SHADOW_THIN_OUT,
	INTERFACE_SHADOW_THIN_IN,
	
	INTERFACE_SHADOW_NOTE,
	INTERFACE_SHADOW_LAST
} InterfaceShadowType;


/* Images */
#define INTERFACE_RADIO_SIZE			13
#define INTERFACE_CHECK_SIZE			14
#define INTERFACE_CHECK_MENU_SIZE	8
#define INTERFACE_RADIO_MENU_SIZE	6

typedef enum {
	INTERFACE_IMAGE_CHECK_BUTTON_NORMAL,
	INTERFACE_IMAGE_CHECK_BUTTON_PRELIGHT,
	INTERFACE_IMAGE_CHECK_BUTTON_INSENSITIVE,
	INTERFACE_IMAGE_CHECK_BUTTON_ACTIVE,
	
	INTERFACE_IMAGE_CHECK_MENU_NORMAL,
	INTERFACE_IMAGE_CHECK_MENU_PRELIGHT,
	INTERFACE_IMAGE_CHECK_MENU_INSENSITIVE,

	INTERFACE_IMAGE_RADIO_NORMAL_OUT,
	INTERFACE_IMAGE_RADIO_PRELIGHT_OUT,
	INTERFACE_IMAGE_RADIO_INSENSITIVE_OUT,
	INTERFACE_IMAGE_RADIO_NORMAL_IN,
	INTERFACE_IMAGE_RADIO_PRELIGHT_IN,
	INTERFACE_IMAGE_RADIO_INSENSITIVE_IN,
	INTERFACE_IMAGE_RADIO_ACTIVE_IN,
	
	INTERFACE_IMAGE_RADIO_MENU_NORMAL,
	INTERFACE_IMAGE_RADIO_MENU_PRELIGHT,
	INTERFACE_IMAGE_RADIO_MENU_INSENSITIVE,

	INTERFACE_IMAGE_NOTEBOOK_CORNER_NORMAL,
	INTERFACE_IMAGE_NOTEBOOK_CORNER_ACTIVE,
	INTERFACE_IMAGE_NOTEBOOK_CORNER_INSENSITIVE,

	INTERFACE_IMAGE_DIMPLE_NORMAL,
	INTERFACE_IMAGE_DIMPLE_PRELIGHT,
	
	INTERFACE_IMAGE_LAST
} InterfaceImageType;

typedef struct _InterfaceImage		InterfaceImage;
typedef struct _InterfaceColorUsage	InterfaceColorUsage;

struct _InterfaceColorUsage {
	guint8	flags[5];
};

enum {
	INTERFACE_USE_FG = 1,
	INTERFACE_USE_BG = 2,
	INTERFACE_USE_TEXT = 4,
	INTERFACE_USE_BASE = 8
};

#define INTERFACE_USE(pen, state)		((INTERFACE_USE_ ## pen) * 5 + state)

typedef enum {
	INTERFACE_MASK_CHECK,
	INTERFACE_MASK_RADIO,
	INTERFACE_MASK_RADIO_ITEM,
	INTERFACE_MASK_CORNER,
	INTERFACE_MASK_DIMPLE,

	INTERFACE_MASK_LAST
} InterfaceMaskIndex;

struct _InterfaceImage {
	const char		**xpm;
	InterfaceMaskIndex	mask;
	const guchar	*remap;
	GtkStateType	state_type:8;
	guint8			color_usage;
};


/* Configuration */
enum {
	INTERFACE_TOKEN_FIRST = G_TOKEN_LAST + 1,
	INTERFACE_TOKEN_TRUE = INTERFACE_TOKEN_FIRST,
	INTERFACE_TOKEN_FALSE,
	
	INTERFACE_TOKEN_STEPPER_ENDS,
	INTERFACE_TOKEN_STEPPER_ARROWS,
	INTERFACE_TOKEN_STEPPER_BOX,
	INTERFACE_TOKEN_SCROLLBAR_WIDTH,
	INTERFACE_TOKEN_SCROLLBAR_KNOB,
	INTERFACE_TOKEN_PANED_KNOB,
	INTERFACE_TOKEN_HANDLE_KNOB,
	INTERFACE_TOKEN_BUTTONDEF_SHADOW,
	INTERFACE_TOKEN_TOOLTIP_SHADOW,
	
	INTERFACE_TOKEN_THIN,
	INTERFACE_TOKEN_SHINE,
	INTERFACE_TOKEN_SHADE,
	
	INTERFACE_TOKEN_NONE,
	INTERFACE_TOKEN_DIMPLE,
	INTERFACE_TOKEN_LINES,
	INTERFACE_TOKEN_HOLES,
	INTERFACE_TOKEN_BUDS,

	INTERFACE_TOKEN_NORMAL,
	INTERFACE_TOKEN_PRELIGHT,
	INTERFACE_TOKEN_ACTIVE,
	INTERFACE_TOKEN_SELECTED,
	INTERFACE_TOKEN_INSENSITIVE,
	
	INTERFACE_TOKEN_SHADOW_IN,
	INTERFACE_TOKEN_SHADOW_OUT,
	INTERFACE_TOKEN_SHADOW_MENU,
	INTERFACE_TOKEN_SHADOW_ETCHED_IN,
	INTERFACE_TOKEN_SHADOW_ETCHED_OUT,
	INTERFACE_TOKEN_SHADOW_BUTTON_IN,
	INTERFACE_TOKEN_SHADOW_NONE_OUT,
	INTERFACE_TOKEN_SHADOW_NONE_IN,
	INTERFACE_TOKEN_SHADOW_IN_FOCUSED,
	INTERFACE_TOKEN_SHADOW_THIN_OUT,
	INTERFACE_TOKEN_SHADOW_THIN_IN,
	INTERFACE_TOKEN_SHADOW_NOTE,
	
	INTERFACE_TOKEN_LAST
};

enum {
	INTERFACE_DATA_STEPPER_ENDS		= 0x01,
	INTERFACE_DATA_STEPPER_ARROWS	= 0x02,
	INTERFACE_DATA_STEPPER_BOX		= 0x04,
	INTERFACE_DATA_SCROLLBAR_WIDTH	= 0x08,
	INTERFACE_DATA_SCROLLBAR_KNOB	= 0x10,
	INTERFACE_DATA_PANED_KNOB		= 0x20,
	INTERFACE_DATA_HANDLE_KNOB		= 0x40,
	INTERFACE_DATA_BUTTONDEF_SHADOW	= 0x80,
	INTERFACE_DATA_TOOLTIP_SHADOW	= 0xC0,
	INTERFACE_DATA_THIN				= 0xF0,
	INTERFACE_DATA_SHADE				= 0x00106,
	INTERFACE_DATA_SHINE				= 0x04006
};

typedef enum {
	INTERFACE_KNOB_NONE,
	INTERFACE_KNOB_DIMPLE,
	INTERFACE_KNOB_LINES,
	INTERFACE_KNOB_HOLES,
	INTERFACE_KNOB_BUDS
} InterfaceKnobStyle;

typedef struct {
	gint16		ref_count;

	gboolean	thin			: 1;
	gboolean	stepper_ends	: 1;
	gboolean	stepper_arrows	: 1;
	gboolean	stepper_box		: 1;
	
	InterfaceKnobStyle	scrollbar_knob;
	InterfaceKnobStyle	paned_knob;
	InterfaceKnobStyle	handle_knob;
	InterfaceShadowType	buttondef_shadow;
	InterfaceShadowType	tooltip_shadow;

	guint32		config;
	
	guint8		scrollbar_width;
	guint8		npixmaps;

	guint8		dirty;
	guint16		shine[5];
	guint16		shade[5];

	GdkPixmap	*pixmaps[INTERFACE_IMAGE_LAST];
} InterfaceThemeData;


/* in interface_theme_color.c */
typedef struct _InterfaceRGB {
	gdouble		r, g, b;
} InterfaceRGB;

typedef struct _InterfaceHSL {
	gdouble		h, s, l;
} InterfaceHSL;

enum {
	/* colors in the style */
	INTERFACE_FG, INTERFACE_BG,
	INTERFACE_LIGHT, INTERFACE_DARK, INTERFACE_MID,
	INTERFACE_TEXT, INTERFACE_BASE,
	INTERFACE_WHITE, INTERFACE_BLACK,
	
	/* conditional */       
	INTERFACE_THIN,
	
	/* change hue only */
	INTERFACE_HUE,
	
	/* blends */
	INTERFACE_BI,
	INTERFACE_TRI,
	INTERFACE_QUAD,
	
	/* static */
	INTERFACE_USER
};

enum {
	INTERFACE_NORMAL = 0,
	INTERFACE_ACTIVE = 1,
	INTERFACE_PRELIGHT = 2,
	INTERFACE_SELECTED = 3,
	INTERFACE_INSENSITIVE = 4,
	INTERFACE_CURRENT = 5,
	INTERFACE_PARENT = 0x10
};


/* interface_theme_color.c */
void		interface_rgb_to_hsl (const InterfaceRGB *src, InterfaceHSL *dst);
void		interface_hsl_to_rgb (const InterfaceHSL *src, InterfaceRGB *dst);
		
void		interface_color_to_hsl (const GdkColor *src, InterfaceHSL *dst);
void		interface_hsl_to_color (const InterfaceHSL *src, GdkColor *dst);
		
void		interface_color_to_rgb (const GdkColor *src, InterfaceRGB *dst);
void		interface_rgb_to_color (const InterfaceRGB *src, GdkColor *dst);

gboolean	interface_color_equal (const GdkColor *a, const GdkColor *b);

void		interface_shade_color (const GdkColor *src, GdkColor *dst, gdouble k);
void		interface_blend_color (const GdkColor *a, const GdkColor *b, gdouble k, GdkColor *dst);


/* interface_theme_main.c */
void		interface_xpm_remap (const GtkStyle *style, const GtkStyle *style2,
							GtkStateType state_type, const guchar * stream, char **xpm);

#define interface_mask_get(i) \
	interface_masks[interface_images[i].mask]

GdkPixmap *	interface_pixmap_get (GdkWindow *window, GtkStyle *style,
							 const GtkStyle *style2, InterfaceImageType image_type);

gboolean	interface_pixmap_use_colors (InterfaceImageType image_type, guint8 usage);

char **		interface_xpm_copy (const char **xpm);
void		interface_xpm_free (char **xpm);


/* interface_theme_patches.c */
void		interface_patches_install ();
void		interface_patches_remove ();


/* Exported data structures */
extern		GtkStyleClass	interface_class;
extern		GtkStyleClass	interface_thin_class;

extern		GdkBitmap		* interface_masks[INTERFACE_MASK_LAST];
extern		InterfaceImage		interface_images[INTERFACE_IMAGE_LAST];

#endif

