/* report.c generated by valac, the Vala compiler
 * generated from report.vala, do not modify */

/*
 * Copyright (C) 2008-2009 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* A Vala.Report subclass for reporting errors in Anjuta UI */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>


#define TYPE_ANJUTA_REPORT (anjuta_report_get_type ())
#define ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANJUTA_REPORT, AnjutaReport))
#define ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANJUTA_REPORT, AnjutaReportClass))
#define IS_ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANJUTA_REPORT))
#define IS_ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANJUTA_REPORT))
#define ANJUTA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANJUTA_REPORT, AnjutaReportClass))

typedef struct _AnjutaReport AnjutaReport;
typedef struct _AnjutaReportClass AnjutaReportClass;
typedef struct _AnjutaReportPrivate AnjutaReportPrivate;

#define ANJUTA_REPORT_TYPE_ERROR (anjuta_report_error_get_type ())
typedef struct _AnjutaReportError AnjutaReportError;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _anjuta_report_error_free0(var) ((var == NULL) ? NULL : (var = (anjuta_report_error_free (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _AnjutaReport {
	ValaReport parent_instance;
	AnjutaReportPrivate * priv;
};

struct _AnjutaReportClass {
	ValaReportClass parent_class;
};

struct _AnjutaReportError {
	ValaSourceReference* source;
	gboolean error;
	char* message;
};

struct _AnjutaReportPrivate {
	IAnjutaDocumentManager* _docman;
	ValaList* errors;
	GStaticRecMutex __lock_errors;
};


static gpointer anjuta_report_parent_class = NULL;
static GType anjuta_report_type_id = 0;

GType anjuta_report_get_type (void) G_GNUC_CONST;
GType anjuta_report_register_type (GTypeModule * module);
static GType anjuta_report_error_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static AnjutaReportError* anjuta_report_error_dup (const AnjutaReportError* self);
static void anjuta_report_error_free (AnjutaReportError* self);
static void anjuta_report_error_copy (const AnjutaReportError* self, AnjutaReportError* dest);
static void anjuta_report_error_destroy (AnjutaReportError* self);
#define ANJUTA_REPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ANJUTA_REPORT, AnjutaReportPrivate))
enum  {
	ANJUTA_REPORT_DUMMY_PROPERTY,
	ANJUTA_REPORT_DOCMAN
};
void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor);
IAnjutaDocumentManager* anjuta_report_get_docman (AnjutaReport* self);
void anjuta_report_clear_error_indicators (AnjutaReport* self);
void anjuta_report_on_hover_over (AnjutaReport* self, IAnjutaEditorHover* editor, GObject* pos);
static void anjuta_report_real_warn (ValaReport* base, ValaSourceReference* source, const char* message);
static void anjuta_report_real_err (ValaReport* base, ValaSourceReference* source, const char* message);
gboolean anjuta_report_errors_found (AnjutaReport* self);
AnjutaReport* anjuta_report_new (void);
AnjutaReport* anjuta_report_construct (GType object_type);
void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value);
static void anjuta_report_finalize (GObject* obj);
static void anjuta_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void anjuta_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor) {
	GError * _inner_error_;
	IAnjutaEditor* _tmp0_;
	IAnjutaIndicable* ind;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	_inner_error_ = NULL;
	ind = _g_object_ref0 ((_tmp0_ = editor, IANJUTA_IS_INDICABLE (_tmp0_) ? ((IAnjutaIndicable*) _tmp0_) : NULL));
	if (ind == NULL) {
		_g_object_unref0 (ind);
		return;
	}
	ianjuta_indicable_clear (ind, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ind);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		ValaIterator* _e_it;
		_e_it = vala_iterable_iterator ((ValaIterable*) self->priv->errors);
		while (TRUE) {
			AnjutaReportError* e;
			const char* _tmp1_;
			if (!vala_iterator_next (_e_it)) {
				break;
			}
			e = (AnjutaReportError*) vala_iterator_get (_e_it);
			_tmp1_ = ianjuta_document_get_filename (IANJUTA_DOCUMENT (editor), &_inner_error_);
			if (_inner_error_ != NULL) {
				_anjuta_report_error_free0 (e);
				_vala_collection_object_unref0 (_e_it);
				_g_object_unref0 (ind);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (g_str_has_suffix (vala_source_file_get_filename (vala_source_reference_get_file ((*e).source)), _tmp1_)) {
				IAnjutaIterable* begin_iter;
				IAnjutaIterable* end_iter;
				IAnjutaIndicableIndicator _tmp4_ = 0;
				begin_iter = _g_object_ref0 (ianjuta_editor_get_line_begin_position (editor, vala_source_reference_get_first_line ((*e).source), &_inner_error_));
				if (_inner_error_ != NULL) {
					_anjuta_report_error_free0 (e);
					_vala_collection_object_unref0 (_e_it);
					_g_object_unref0 (ind);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					gint i;
					i = 1;
					{
						gboolean _tmp2_;
						_tmp2_ = TRUE;
						while (TRUE) {
							if (!_tmp2_) {
								i++;
							}
							_tmp2_ = FALSE;
							if (!(i < vala_source_reference_get_first_column ((*e).source))) {
								break;
							}
							ianjuta_iterable_next (begin_iter, &_inner_error_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (begin_iter);
								_anjuta_report_error_free0 (e);
								_vala_collection_object_unref0 (_e_it);
								_g_object_unref0 (ind);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
				end_iter = _g_object_ref0 (ianjuta_editor_get_line_begin_position (editor, vala_source_reference_get_last_line ((*e).source), &_inner_error_));
				if (_inner_error_ != NULL) {
					_g_object_unref0 (begin_iter);
					_anjuta_report_error_free0 (e);
					_vala_collection_object_unref0 (_e_it);
					_g_object_unref0 (ind);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					gint i;
					i = 0;
					{
						gboolean _tmp3_;
						_tmp3_ = TRUE;
						while (TRUE) {
							if (!_tmp3_) {
								i++;
							}
							_tmp3_ = FALSE;
							if (!(i < vala_source_reference_get_last_column ((*e).source))) {
								break;
							}
							ianjuta_iterable_next (end_iter, &_inner_error_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (end_iter);
								_g_object_unref0 (begin_iter);
								_anjuta_report_error_free0 (e);
								_vala_collection_object_unref0 (_e_it);
								_g_object_unref0 (ind);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
				if ((*e).error) {
					_tmp4_ = IANJUTA_INDICABLE_CRITICAL;
				} else {
					_tmp4_ = IANJUTA_INDICABLE_WARNING;
				}
				ianjuta_indicable_set (ind, begin_iter, end_iter, _tmp4_, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (end_iter);
					_g_object_unref0 (begin_iter);
					_anjuta_report_error_free0 (e);
					_vala_collection_object_unref0 (_e_it);
					_g_object_unref0 (ind);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (end_iter);
				_g_object_unref0 (begin_iter);
			}
			_anjuta_report_error_free0 (e);
		}
		_vala_collection_object_unref0 (_e_it);
	}
	_g_object_unref0 (ind);
}


void anjuta_report_clear_error_indicators (AnjutaReport* self) {
	GError * _inner_error_;
	ValaList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	self->priv->errors = (_tmp0_ = (ValaList*) vala_array_list_new (ANJUTA_REPORT_TYPE_ERROR, (GBoxedCopyFunc) anjuta_report_error_dup, anjuta_report_error_free, g_direct_equal), _vala_collection_object_unref0 (self->priv->errors), _tmp0_);
	_tmp1_ = ianjuta_document_manager_get_doc_widgets (self->priv->_docman, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = (GList*) _tmp1_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GtkWidget* doc;
			doc = _g_object_ref0 ((GtkWidget*) doc_it->data);
			{
				if (IANJUTA_IS_INDICABLE (doc)) {
					ianjuta_indicable_clear (IANJUTA_INDICABLE (doc), &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (doc);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_object_unref0 (doc);
			}
		}
	}
}


void anjuta_report_on_hover_over (AnjutaReport* self, IAnjutaEditorHover* editor, GObject* pos) {
	GError * _inner_error_;
	IAnjutaIterable* position;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (pos != NULL);
	_inner_error_ = NULL;
	position = _g_object_ref0 (IANJUTA_ITERABLE (pos));
	{
		g_static_rec_mutex_lock (&self->priv->__lock_errors);
		{
			{
				ValaIterator* _error_it;
				_error_it = vala_iterable_iterator ((ValaIterable*) self->priv->errors);
				while (TRUE) {
					AnjutaReportError* _error_;
					const char* _tmp0_;
					IAnjutaIterable* begin;
					IAnjutaIterable* end;
					gboolean _tmp3_ = FALSE;
					gint _tmp4_;
					if (!vala_iterator_next (_error_it)) {
						break;
					}
					_error_ = (AnjutaReportError*) vala_iterator_get (_error_it);
					_tmp0_ = ianjuta_document_get_filename (IANJUTA_DOCUMENT (editor), &_inner_error_);
					if (_inner_error_ != NULL) {
						_anjuta_report_error_free0 (_error_);
						_vala_collection_object_unref0 (_error_it);
						goto __finally8;
					}
					if (!g_str_has_suffix (vala_source_file_get_filename (vala_source_reference_get_file ((*_error_).source)), _tmp0_)) {
						_anjuta_report_error_free0 (_error_);
						continue;
					}
					begin = _g_object_ref0 (ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) editor, vala_source_reference_get_first_line ((*_error_).source), &_inner_error_));
					if (_inner_error_ != NULL) {
						_anjuta_report_error_free0 (_error_);
						_vala_collection_object_unref0 (_error_it);
						goto __finally8;
					}
					{
						gint i;
						i = 0;
						{
							gboolean _tmp1_;
							_tmp1_ = TRUE;
							while (TRUE) {
								if (!_tmp1_) {
									i++;
								}
								_tmp1_ = FALSE;
								if (!(i < vala_source_reference_get_first_column ((*_error_).source))) {
									break;
								}
								ianjuta_iterable_next (begin, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_object_unref0 (begin);
									_anjuta_report_error_free0 (_error_);
									_vala_collection_object_unref0 (_error_it);
									goto __finally8;
								}
							}
						}
					}
					end = _g_object_ref0 (ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) editor, vala_source_reference_get_last_line ((*_error_).source), &_inner_error_));
					if (_inner_error_ != NULL) {
						_g_object_unref0 (begin);
						_anjuta_report_error_free0 (_error_);
						_vala_collection_object_unref0 (_error_it);
						goto __finally8;
					}
					{
						gint i;
						i = 0;
						{
							gboolean _tmp2_;
							_tmp2_ = TRUE;
							while (TRUE) {
								if (!_tmp2_) {
									i++;
								}
								_tmp2_ = FALSE;
								if (!(i < vala_source_reference_get_last_column ((*_error_).source))) {
									break;
								}
								ianjuta_iterable_next (end, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_object_unref0 (end);
									_g_object_unref0 (begin);
									_anjuta_report_error_free0 (_error_);
									_vala_collection_object_unref0 (_error_it);
									goto __finally8;
								}
							}
						}
					}
					_tmp4_ = ianjuta_iterable_compare (position, begin, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (end);
						_g_object_unref0 (begin);
						_anjuta_report_error_free0 (_error_);
						_vala_collection_object_unref0 (_error_it);
						goto __finally8;
					}
					if (_tmp4_ >= 0) {
						gint _tmp5_;
						_tmp5_ = ianjuta_iterable_compare (position, end, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_object_unref0 (end);
							_g_object_unref0 (begin);
							_anjuta_report_error_free0 (_error_);
							_vala_collection_object_unref0 (_error_it);
							goto __finally8;
						}
						_tmp3_ = _tmp5_ <= 0;
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						ianjuta_editor_hover_display (editor, position, (*_error_).message, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_object_unref0 (end);
							_g_object_unref0 (begin);
							_anjuta_report_error_free0 (_error_);
							_vala_collection_object_unref0 (_error_it);
							goto __finally8;
						}
						_g_object_unref0 (end);
						_g_object_unref0 (begin);
						_anjuta_report_error_free0 (_error_);
						_vala_collection_object_unref0 (_error_it);
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_errors);
						}
						_g_object_unref0 (position);
						return;
					}
					_g_object_unref0 (end);
					_g_object_unref0 (begin);
					_anjuta_report_error_free0 (_error_);
				}
				_vala_collection_object_unref0 (_error_it);
			}
		}
		__finally8:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_errors);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (position);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (position);
}


static gpointer _vala_source_reference_ref0 (gpointer self) {
	return self ? vala_source_reference_ref (self) : NULL;
}


static void anjuta_report_real_warn (ValaReport* base, ValaSourceReference* source, const char* message) {
	AnjutaReport * self;
	GError * _inner_error_;
	self = (AnjutaReport*) base;
	g_return_if_fail (message != NULL);
	_inner_error_ = NULL;
	if (source == NULL) {
		return;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_errors);
		{
			AnjutaReportError _tmp2_;
			AnjutaReportError _tmp1_;
			AnjutaReportError _tmp0_ = {0};
			vala_collection_add ((ValaCollection*) self->priv->errors, (_tmp2_ = _tmp1_ = (memset (&_tmp0_, 0, sizeof (AnjutaReportError)), _tmp0_.source = _vala_source_reference_ref0 (source), _tmp0_.message = g_strdup (message), _tmp0_.error = FALSE, _tmp0_), &_tmp2_));
			anjuta_report_error_destroy (&_tmp1_);
		}
		__finally9:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_errors);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void anjuta_report_real_err (ValaReport* base, ValaSourceReference* source, const char* message) {
	AnjutaReport * self;
	GError * _inner_error_;
	self = (AnjutaReport*) base;
	g_return_if_fail (message != NULL);
	_inner_error_ = NULL;
	if (source == NULL) {
		return;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_errors);
		{
			AnjutaReportError _tmp2_;
			AnjutaReportError _tmp1_;
			AnjutaReportError _tmp0_ = {0};
			vala_collection_add ((ValaCollection*) self->priv->errors, (_tmp2_ = _tmp1_ = (memset (&_tmp0_, 0, sizeof (AnjutaReportError)), _tmp0_.source = _vala_source_reference_ref0 (source), _tmp0_.message = g_strdup (message), _tmp0_.error = TRUE, _tmp0_), &_tmp2_));
			anjuta_report_error_destroy (&_tmp1_);
		}
		__finally10:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_errors);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean anjuta_report_errors_found (AnjutaReport* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_collection_get_size ((ValaCollection*) self->priv->errors) != 0;
	return result;
}


AnjutaReport* anjuta_report_construct (GType object_type) {
	AnjutaReport * self;
	self = (AnjutaReport*) vala_report_construct (object_type);
	return self;
}


AnjutaReport* anjuta_report_new (void) {
	return anjuta_report_construct (TYPE_ANJUTA_REPORT);
}


IAnjutaDocumentManager* anjuta_report_get_docman (AnjutaReport* self) {
	IAnjutaDocumentManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_docman;
	return result;
}


void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value) {
	IAnjutaDocumentManager* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_docman = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_docman), _tmp0_);
	g_object_notify ((GObject *) self, "docman");
}


static void anjuta_report_error_copy (const AnjutaReportError* self, AnjutaReportError* dest) {
	dest->source = _vala_source_reference_ref0 (self->source);
	dest->error = self->error;
	dest->message = g_strdup (self->message);
}


static void anjuta_report_error_destroy (AnjutaReportError* self) {
	_vala_source_reference_unref0 (self->source);
	_g_free0 (self->message);
}


static AnjutaReportError* anjuta_report_error_dup (const AnjutaReportError* self) {
	AnjutaReportError* dup;
	dup = g_new0 (AnjutaReportError, 1);
	anjuta_report_error_copy (self, dup);
	return dup;
}


static void anjuta_report_error_free (AnjutaReportError* self) {
	anjuta_report_error_destroy (self);
	g_free (self);
}


static GType anjuta_report_error_get_type (void) {
	static volatile gsize anjuta_report_error_type_id__volatile = 0;
	if (g_once_init_enter (&anjuta_report_error_type_id__volatile)) {
		GType anjuta_report_error_type_id;
		anjuta_report_error_type_id = g_boxed_type_register_static ("AnjutaReportError", (GBoxedCopyFunc) anjuta_report_error_dup, (GBoxedFreeFunc) anjuta_report_error_free);
		g_once_init_leave (&anjuta_report_error_type_id__volatile, anjuta_report_error_type_id);
	}
	return anjuta_report_error_type_id__volatile;
}


static void anjuta_report_class_init (AnjutaReportClass * klass) {
	anjuta_report_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AnjutaReportPrivate));
	VALA_REPORT_CLASS (klass)->warn = anjuta_report_real_warn;
	VALA_REPORT_CLASS (klass)->err = anjuta_report_real_err;
	G_OBJECT_CLASS (klass)->get_property = anjuta_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = anjuta_report_set_property;
	G_OBJECT_CLASS (klass)->finalize = anjuta_report_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANJUTA_REPORT_DOCMAN, g_param_spec_object ("docman", "docman", "docman", IANJUTA_TYPE_DOCUMENT_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void anjuta_report_instance_init (AnjutaReport * self) {
	self->priv = ANJUTA_REPORT_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_errors);
	self->priv->errors = (ValaList*) vala_array_list_new (ANJUTA_REPORT_TYPE_ERROR, (GBoxedCopyFunc) anjuta_report_error_dup, anjuta_report_error_free, g_direct_equal);
}


static void anjuta_report_finalize (GObject* obj) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (obj);
	_g_object_unref0 (self->priv->_docman);
	g_static_rec_mutex_free (&self->priv->__lock_errors);
	_vala_collection_object_unref0 (self->priv->errors);
	G_OBJECT_CLASS (anjuta_report_parent_class)->finalize (obj);
}


GType anjuta_report_get_type (void) {
	return anjuta_report_type_id;
}


GType anjuta_report_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (AnjutaReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) anjuta_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnjutaReport), 0, (GInstanceInitFunc) anjuta_report_instance_init, NULL };
	anjuta_report_type_id = g_type_module_register_type (module, VALA_TYPE_REPORT, "AnjutaReport", &g_define_type_info, 0);
	return anjuta_report_type_id;
}


static void anjuta_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (object);
	switch (property_id) {
		case ANJUTA_REPORT_DOCMAN:
		g_value_set_object (value, anjuta_report_get_docman (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void anjuta_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (object);
	switch (property_id) {
		case ANJUTA_REPORT_DOCMAN:
		anjuta_report_set_docman (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




