/* provider.c generated by valac, the Vala compiler
 * generated from provider.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <libanjuta/libanjuta.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>


#define TYPE_VALA_PROVIDER (vala_provider_get_type ())
#define VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PROVIDER, ValaProvider))
#define VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PROVIDER, ValaProviderClass))
#define IS_VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PROVIDER))
#define IS_VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PROVIDER))
#define VALA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PROVIDER, ValaProviderClass))

typedef struct _ValaProvider ValaProvider;
typedef struct _ValaProviderClass ValaProviderClass;
typedef struct _ValaProviderPrivate ValaProviderPrivate;

#define TYPE_VALA_PLUGIN (vala_plugin_get_type ())
#define VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PLUGIN, ValaPlugin))
#define VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PLUGIN, ValaPluginClass))
#define IS_VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PLUGIN))
#define IS_VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PLUGIN))
#define VALA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PLUGIN, ValaPluginClass))

typedef struct _ValaPlugin ValaPlugin;
typedef struct _ValaPluginClass ValaPluginClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ValaPluginPrivate ValaPluginPrivate;
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define __g_list_free_vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_vala_code_node_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaProvider {
	GObject parent_instance;
	ValaProviderPrivate * priv;
};

struct _ValaProviderClass {
	GObjectClass parent_class;
};

struct _ValaProviderPrivate {
	IAnjutaIterable* start_pos;
	ValaPlugin* plugin;
};

struct _ValaPlugin {
	AnjutaPlugin parent_instance;
	ValaPluginPrivate * priv;
	IAnjutaEditor* current_editor;
};

struct _ValaPluginClass {
	AnjutaPluginClass parent_class;
};


static GRegex* vala_provider_member_access;
static GRegex* vala_provider_member_access = NULL;
static GRegex* vala_provider_member_access_split;
static GRegex* vala_provider_member_access_split = NULL;
static GRegex* vala_provider_function_call;
static GRegex* vala_provider_function_call = NULL;
static gpointer vala_provider_parent_class = NULL;
static IAnjutaProviderIface* vala_provider_ianjuta_provider_parent_iface = NULL;
static GType vala_provider_type_id = 0;

GType vala_provider_get_type (void) G_GNUC_CONST;
GType vala_provider_register_type (GTypeModule * module);
GType vala_plugin_get_type (void) G_GNUC_CONST;
GType vala_plugin_register_type (GTypeModule * module);
#define VALA_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VALA_PROVIDER, ValaProviderPrivate))
enum  {
	VALA_PROVIDER_DUMMY_PROPERTY
};
ValaProvider* vala_provider_new (ValaPlugin* plugin);
ValaProvider* vala_provider_construct (GType object_type, ValaPlugin* plugin);
static const char* vala_provider_real_get_name (IAnjutaProvider* base, GError** error);
GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const char* name, gboolean prefix_match, ValaBlock* block);
static ValaExpression* vala_provider_construct_member_access (ValaProvider* self, char** names, int names_length1);
ValaBlock* vala_plugin_get_current_block (ValaPlugin* self, IAnjutaEditor* editor);
static void _g_list_free_g_free (GList* self);
static void _g_list_free_vala_code_node_unref (GList* self);
static IAnjutaEditorAssistProposal* _ianjuta_editor_assist_proposal_dup (IAnjutaEditorAssistProposal* self);
static void vala_provider_real_populate (IAnjutaProvider* base, IAnjutaIterable* iter, GError** error);
static IAnjutaIterable* vala_provider_real_get_start_iter (IAnjutaProvider* base, GError** error);
static void vala_provider_real_activate (IAnjutaProvider* base, IAnjutaIterable* iter, void* data, GError** error);
void vala_provider_show_call_tip (ValaProvider* self, IAnjutaEditorTip* editor, const char* to_complete);
static void vala_provider_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaProvider* vala_provider_construct (GType object_type, ValaPlugin* plugin) {
	ValaProvider * self;
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (ValaProvider*) g_object_new (object_type, NULL);
	self->priv->plugin = plugin;
	return self;
}


ValaProvider* vala_provider_new (ValaPlugin* plugin) {
	return vala_provider_construct (TYPE_VALA_PROVIDER, plugin);
}


static const char* vala_provider_real_get_name (IAnjutaProvider* base, GError** error) {
	ValaProvider * self;
	const char* result = NULL;
	self = (ValaProvider*) base;
	result = "Vala";
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void _g_list_free_vala_code_node_unref (GList* self) {
	g_list_foreach (self, (GFunc) vala_code_node_unref, NULL);
	g_list_free (self);
}


static IAnjutaEditorAssistProposal* _ianjuta_editor_assist_proposal_dup (IAnjutaEditorAssistProposal* self) {
	IAnjutaEditorAssistProposal* dup;
	dup = g_new0 (IAnjutaEditorAssistProposal, 1);
	memcpy (dup, self, sizeof (IAnjutaEditorAssistProposal));
	return dup;
}


static gpointer __ianjuta_editor_assist_proposal_dup0 (gpointer self) {
	return self ? _ianjuta_editor_assist_proposal_dup (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_provider_real_populate (IAnjutaProvider* base, IAnjutaIterable* iter, GError** error) {
	ValaProvider * self;
	GError * _inner_error_;
	IAnjutaEditor* _tmp0_;
	IAnjutaEditorAssist* editor;
	gint _tmp1_;
	IAnjutaIterable* line_start;
	char* current_text;
	GMatchInfo* match_info;
	GMatchInfo* _tmp4_;
	gboolean _tmp3_;
	GMatchInfo* _tmp2_ = NULL;
	char* _tmp5_;
	gboolean _tmp6_;
	IAnjutaIterable* _tmp7_;
	IAnjutaIterable* _tmp8_;
	gint _tmp9_;
	char* _tmp10_;
	char** _tmp14_;
	gint _names_size_;
	gint names_length1;
	char** _tmp12_;
	char* _tmp11_;
	char** _tmp13_;
	char** names;
	ValaBlock* _tmp17_;
	char* _tmp16_;
	ValaExpression* _tmp15_;
	GList* _tmp18_;
	GList* syms;
	GList* proposals;
	self = (ValaProvider*) base;
	g_return_if_fail (iter != NULL);
	_inner_error_ = NULL;
	editor = _g_object_ref0 ((_tmp0_ = self->priv->plugin->current_editor, IANJUTA_IS_EDITOR_ASSIST (_tmp0_) ? ((IAnjutaEditorAssist*) _tmp0_) : NULL));
	_tmp1_ = ianjuta_editor_get_lineno ((IAnjutaEditor*) editor, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (editor);
		return;
	}
	line_start = _g_object_ref0 (ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) editor, _tmp1_, &_inner_error_));
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (editor);
		return;
	}
	current_text = g_strdup (ianjuta_editor_get_text ((IAnjutaEditor*) editor, line_start, iter, &_inner_error_));
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	match_info = NULL;
	if (!(_tmp3_ = g_regex_match (vala_provider_member_access, current_text, 0, &_tmp2_), match_info = (_tmp4_ = _tmp2_, _g_match_info_free0 (match_info), _tmp4_), _tmp3_)) {
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	if ((_tmp6_ = string_get_length (_tmp5_ = g_match_info_fetch (match_info, 0)) < 2, _g_free0 (_tmp5_), _tmp6_)) {
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	_tmp7_ = ianjuta_iterable_clone (iter, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	self->priv->start_pos = (_tmp8_ = _g_object_ref0 (_tmp7_), _g_object_unref0 (self->priv->start_pos), _tmp8_);
	_tmp9_ = ianjuta_iterable_get_position (iter, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	ianjuta_iterable_set_position (self->priv->start_pos, _tmp9_ - ((gint) string_get_length (_tmp10_ = g_match_info_fetch (match_info, 2))), &_inner_error_);
	_g_free0 (_tmp10_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	names = (_tmp14_ = (_tmp13_ = _tmp12_ = g_regex_split (vala_provider_member_access_split, _tmp11_ = g_match_info_fetch (match_info, 1), 0), _g_free0 (_tmp11_), _tmp13_), names_length1 = _vala_array_length (_tmp12_), _names_size_ = names_length1, _tmp14_);
	syms = (_tmp18_ = vala_plugin_lookup_symbol (self->priv->plugin, _tmp15_ = vala_provider_construct_member_access (self, names, names_length1), _tmp16_ = g_match_info_fetch (match_info, 2), TRUE, _tmp17_ = vala_plugin_get_current_block (self->priv->plugin, (IAnjutaEditor*) editor)), _vala_code_node_unref0 (_tmp17_), _g_free0 (_tmp16_), _vala_code_node_unref0 (_tmp15_), _tmp18_);
	proposals = NULL;
	{
		GList* symbol_collection;
		GList* symbol_it;
		symbol_collection = syms;
		for (symbol_it = symbol_collection; symbol_it != NULL; symbol_it = symbol_it->next) {
			ValaSymbol* symbol;
			symbol = _vala_code_node_ref0 ((ValaSymbol*) symbol_it->data);
			{
				gboolean _tmp19_ = FALSE;
				IAnjutaEditorAssistProposal prop = {0};
				if (VALA_IS_LOCAL_VARIABLE (symbol)) {
					gint _tmp20_;
					_tmp20_ = ianjuta_editor_get_lineno ((IAnjutaEditor*) editor, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (symbol);
						__g_list_free_g_free0 (proposals);
						__g_list_free_vala_code_node_unref0 (syms);
						names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
						_g_match_info_free0 (match_info);
						_g_free0 (current_text);
						_g_object_unref0 (line_start);
						_g_object_unref0 (editor);
						return;
					}
					_tmp19_ = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) symbol)) > _tmp20_;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					_vala_code_node_unref0 (symbol);
					continue;
				}
				memset (&prop, 0, sizeof (IAnjutaEditorAssistProposal));
				prop.data = symbol;
				prop.label = vala_symbol_get_name (symbol);
				proposals = g_list_prepend (proposals, __ianjuta_editor_assist_proposal_dup0 (&prop));
				_vala_code_node_unref0 (symbol);
			}
		}
	}
	proposals = g_list_reverse (proposals);
	ianjuta_editor_assist_proposals (editor, (IAnjutaProvider*) self, proposals, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_list_free_g_free0 (proposals);
		__g_list_free_vala_code_node_unref0 (syms);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	__g_list_free_g_free0 (proposals);
	__g_list_free_vala_code_node_unref0 (syms);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_match_info_free0 (match_info);
	_g_free0 (current_text);
	_g_object_unref0 (line_start);
	_g_object_unref0 (editor);
}


static IAnjutaIterable* vala_provider_real_get_start_iter (IAnjutaProvider* base, GError** error) {
	ValaProvider * self;
	IAnjutaIterable* result = NULL;
	self = (ValaProvider*) base;
	result = self->priv->start_pos;
	return result;
}


static void vala_provider_real_activate (IAnjutaProvider* base, IAnjutaIterable* iter, void* data, GError** error) {
	ValaProvider * self;
	GError * _inner_error_;
	void* _tmp0_;
	ValaSymbol* sym;
	IAnjutaEditor* _tmp1_;
	IAnjutaEditorAssist* editor;
	IAnjutaEditorAssist* _tmp2_;
	IAnjutaEditorAssist* _tmp3_;
	self = (ValaProvider*) base;
	g_return_if_fail (iter != NULL);
	_inner_error_ = NULL;
	sym = _vala_code_node_ref0 ((_tmp0_ = data, VALA_IS_SYMBOL (_tmp0_) ? ((ValaSymbol*) _tmp0_) : NULL));
	editor = _g_object_ref0 ((_tmp1_ = self->priv->plugin->current_editor, IANJUTA_IS_EDITOR_ASSIST (_tmp1_) ? ((IAnjutaEditorAssist*) _tmp1_) : NULL));
	ianjuta_document_begin_undo_action ((_tmp2_ = editor, IANJUTA_IS_DOCUMENT (_tmp2_) ? ((IAnjutaDocument*) _tmp2_) : NULL), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (editor);
		_vala_code_node_unref0 (sym);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ianjuta_editor_erase ((IAnjutaEditor*) editor, self->priv->start_pos, iter, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (editor);
		_vala_code_node_unref0 (sym);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ianjuta_editor_insert ((IAnjutaEditor*) editor, self->priv->start_pos, vala_symbol_get_name (sym), -1, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (editor);
		_vala_code_node_unref0 (sym);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ianjuta_document_end_undo_action ((_tmp3_ = editor, IANJUTA_IS_DOCUMENT (_tmp3_) ? ((IAnjutaDocument*) _tmp3_) : NULL), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (editor);
		_vala_code_node_unref0 (sym);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (editor);
	_vala_code_node_unref0 (sym);
}


void vala_provider_show_call_tip (ValaProvider* self, IAnjutaEditorTip* editor, const char* to_complete) {
	GError * _inner_error_;
	GList* tips;
	GMatchInfo* match_info;
	GMatchInfo* _tmp2_;
	gboolean _tmp1_;
	GMatchInfo* _tmp0_ = NULL;
	char* _tmp3_;
	gboolean _tmp4_;
	gboolean creation_method;
	char** _tmp8_;
	gint _names_size_;
	gint names_length1;
	char** _tmp6_;
	char* _tmp5_;
	char** _tmp7_;
	char** names;
	ValaBlock* _tmp11_;
	char* _tmp10_;
	ValaExpression* _tmp9_;
	GList* _tmp12_;
	GList* syms;
	IAnjutaIterable* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (to_complete != NULL);
	_inner_error_ = NULL;
	tips = NULL;
	match_info = NULL;
	if (!(_tmp1_ = g_regex_match (vala_provider_function_call, to_complete, 0, &_tmp0_), match_info = (_tmp2_ = _tmp0_, _g_match_info_free0 (match_info), _tmp2_), _tmp1_)) {
		_g_match_info_free0 (match_info);
		__g_list_free_g_free0 (tips);
		return;
	}
	creation_method = (_tmp4_ = _vala_strcmp0 (_tmp3_ = g_match_info_fetch (match_info, 1), "") != 0, _g_free0 (_tmp3_), _tmp4_);
	names = (_tmp8_ = (_tmp7_ = _tmp6_ = g_regex_split (vala_provider_member_access_split, _tmp5_ = g_match_info_fetch (match_info, 2), 0), _g_free0 (_tmp5_), _tmp7_), names_length1 = _vala_array_length (_tmp6_), _names_size_ = names_length1, _tmp8_);
	syms = (_tmp12_ = vala_plugin_lookup_symbol (self->priv->plugin, _tmp9_ = vala_provider_construct_member_access (self, names, names_length1), _tmp10_ = g_match_info_fetch (match_info, 3), FALSE, _tmp11_ = vala_plugin_get_current_block (self->priv->plugin, (IAnjutaEditor*) editor)), _vala_code_node_unref0 (_tmp11_), _g_free0 (_tmp10_), _vala_code_node_unref0 (_tmp9_), _tmp12_);
	{
		GList* sym_collection;
		GList* sym_it;
		sym_collection = syms;
		for (sym_it = sym_collection; sym_it != NULL; sym_it = sym_it->next) {
			ValaSymbol* sym;
			sym = _vala_code_node_ref0 ((ValaSymbol*) sym_it->data);
			{
				ValaList* parameters;
				GString* calltip;
				gboolean first;
				parameters = NULL;
				if (VALA_IS_METHOD (sym)) {
					ValaList* _tmp13_;
					parameters = (_tmp13_ = vala_method_get_parameters (VALA_METHOD (sym)), _vala_collection_object_unref0 (parameters), _tmp13_);
				} else {
					if (VALA_IS_SIGNAL (sym)) {
						ValaList* _tmp14_;
						parameters = (_tmp14_ = vala_signal_get_parameters (VALA_SIGNAL (sym)), _vala_collection_object_unref0 (parameters), _tmp14_);
					} else {
						gboolean _tmp15_ = FALSE;
						if (creation_method) {
							_tmp15_ = VALA_IS_CLASS (sym);
						} else {
							_tmp15_ = FALSE;
						}
						if (_tmp15_) {
							ValaList* _tmp16_;
							parameters = (_tmp16_ = vala_method_get_parameters (vala_class_get_default_construction_method (VALA_CLASS (sym))), _vala_collection_object_unref0 (parameters), _tmp16_);
						} else {
							if (VALA_IS_VARIABLE (sym)) {
								ValaDataType* var_type;
								var_type = _vala_code_node_ref0 (vala_variable_get_variable_type (VALA_VARIABLE (sym)));
								if (VALA_IS_DELEGATE_TYPE (var_type)) {
									ValaList* _tmp17_;
									parameters = (_tmp17_ = vala_delegate_get_parameters (vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (var_type))), _vala_collection_object_unref0 (parameters), _tmp17_);
								} else {
									_vala_code_node_unref0 (var_type);
									_vala_collection_object_unref0 (parameters);
									_vala_code_node_unref0 (sym);
									__g_list_free_vala_code_node_unref0 (syms);
									names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
									_g_match_info_free0 (match_info);
									__g_list_free_g_free0 (tips);
									return;
								}
								_vala_code_node_unref0 (var_type);
							} else {
								_vala_collection_object_unref0 (parameters);
								_vala_code_node_unref0 (sym);
								__g_list_free_vala_code_node_unref0 (syms);
								names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
								_g_match_info_free0 (match_info);
								__g_list_free_g_free0 (tips);
								return;
							}
						}
					}
				}
				calltip = g_string_new ("(");
				first = TRUE;
				{
					ValaIterator* _p_it;
					_p_it = vala_iterable_iterator ((ValaIterable*) parameters);
					while (TRUE) {
						ValaFormalParameter* p;
						if (!vala_iterator_next (_p_it)) {
							break;
						}
						p = (ValaFormalParameter*) vala_iterator_get (_p_it);
						if (first) {
							first = FALSE;
						} else {
							g_string_append (calltip, ", ");
						}
						if (vala_formal_parameter_get_ellipsis (p)) {
							g_string_append (calltip, "...");
						} else {
							char* _tmp18_;
							g_string_append (calltip, _tmp18_ = vala_data_type_to_qualified_string (vala_variable_get_variable_type ((ValaVariable*) p), NULL));
							_g_free0 (_tmp18_);
							g_string_append (g_string_append (calltip, " "), vala_symbol_get_name ((ValaSymbol*) p));
						}
						_vala_code_node_unref0 (p);
					}
					_vala_collection_object_unref0 (_p_it);
				}
				g_string_append (calltip, ")");
				tips = g_list_append (tips, g_strdup (calltip->str));
				_g_string_free0 (calltip);
				_vala_collection_object_unref0 (parameters);
				_vala_code_node_unref0 (sym);
			}
		}
	}
	_tmp19_ = ianjuta_editor_get_position ((IAnjutaEditor*) editor, &_inner_error_);
	if (_inner_error_ != NULL) {
		__g_list_free_vala_code_node_unref0 (syms);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_match_info_free0 (match_info);
		__g_list_free_g_free0 (tips);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ianjuta_editor_tip_show (editor, tips, _tmp19_, &_inner_error_);
	if (_inner_error_ != NULL) {
		__g_list_free_vala_code_node_unref0 (syms);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_match_info_free0 (match_info);
		__g_list_free_g_free0 (tips);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	__g_list_free_vala_code_node_unref0 (syms);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_match_info_free0 (match_info);
	__g_list_free_g_free0 (tips);
}


static char* string_chug (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchug (_result_);
	result = _result_;
	return result;
}


static ValaExpression* vala_provider_construct_member_access (ValaProvider* self, char** names, int names_length1) {
	ValaExpression* result = NULL;
	ValaExpression* expr;
	g_return_val_if_fail (self != NULL, NULL);
	expr = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(names[i] != NULL)) {
					break;
				}
				if (_vala_strcmp0 (names[i], "") != 0) {
					ValaExpression* _tmp1_;
					gboolean _tmp2_ = FALSE;
					expr = (_tmp1_ = (ValaExpression*) vala_member_access_new (expr, names[i], NULL), _vala_code_node_unref0 (expr), _tmp1_);
					if (names[i + 1] != NULL) {
						char* _tmp3_;
						_tmp2_ = g_str_has_prefix (_tmp3_ = string_chug (names[i + 1]), "(");
						_g_free0 (_tmp3_);
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						ValaExpression* _tmp4_;
						expr = (_tmp4_ = (ValaExpression*) vala_method_call_new (expr, NULL), _vala_code_node_unref0 (expr), _tmp4_);
						i++;
					}
				}
			}
		}
	}
	result = expr;
	return result;
}


static void vala_provider_class_init (ValaProviderClass * klass) {
	GError * _inner_error_;
	vala_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaProviderPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_provider_finalize;
	_inner_error_ = NULL;
	{
		{
			GRegex* _tmp0_;
			GRegex* _tmp1_;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			GRegex* _tmp4_;
			GRegex* _tmp5_;
			_tmp0_ = g_regex_new ("((?:\\w+(?:\\s*\\([^()]*\\))?\\.)*)(\\w*)$", 0, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			vala_provider_member_access = (_tmp1_ = _tmp0_, _g_regex_unref0 (vala_provider_member_access), _tmp1_);
			_tmp2_ = g_regex_new ("(\\s*\\([^()]*\\))?\\.", 0, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			vala_provider_member_access_split = (_tmp3_ = _tmp2_, _g_regex_unref0 (vala_provider_member_access_split), _tmp3_);
			_tmp4_ = g_regex_new ("(new )?((?:\\w+(?:\\s*\\([^()]*\\))?\\.)*)(\\w+)\\s*\\(([^(,)]+,)*([^(" \
",)]*)$", 0, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			vala_provider_function_call = (_tmp5_ = _tmp4_, _g_regex_unref0 (vala_provider_function_call), _tmp5_);
		}
		goto __finally7;
		__catch7_g_regex_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("provider.vala:32: Regular expressions failed to compile : %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally7:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
}


static void vala_provider_ianjuta_provider_interface_init (IAnjutaProviderIface * iface) {
	vala_provider_ianjuta_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = vala_provider_real_get_name;
	iface->populate = vala_provider_real_populate;
	iface->get_start_iter = vala_provider_real_get_start_iter;
	iface->activate = vala_provider_real_activate;
}


static void vala_provider_instance_init (ValaProvider * self) {
	self->priv = VALA_PROVIDER_GET_PRIVATE (self);
}


static void vala_provider_finalize (GObject* obj) {
	ValaProvider * self;
	self = VALA_PROVIDER (obj);
	_g_object_unref0 (self->priv->start_pos);
	G_OBJECT_CLASS (vala_provider_parent_class)->finalize (obj);
}


GType vala_provider_get_type (void) {
	return vala_provider_type_id;
}


GType vala_provider_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ValaProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaProvider), 0, (GInstanceInitFunc) vala_provider_instance_init, NULL };
	static const GInterfaceInfo ianjuta_provider_info = { (GInterfaceInitFunc) vala_provider_ianjuta_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	vala_provider_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ValaProvider", &g_define_type_info, 0);
	g_type_module_add_interface (module, vala_provider_type_id, IANJUTA_TYPE_PROVIDER, &ianjuta_provider_info);
	return vala_provider_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




