/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-breakpoint.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-debugger-breakpoint
 * @title: IAnjutaDebuggerBreakpoint
 * @short_description: Breakpoint Debugger interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-debugger-breakpoint.h
 * 
 */

#include "ianjuta-debugger-breakpoint.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_debugger_breakpoint_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-debugger-breakpoint-quark");
	}
	
	return quark;
}

/**
* ianjuta_debugger_breakpoint_clear_breakpoint:
* @obj: Self
* @id: Breakpoint identification number
* @callback: Callback to call when the breakpoint has been cleared
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Clear a breakpoint put by any set functions. The Id of the breakpoint
* is given in the callback of the set functions.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_breakpoint_clear_breakpoint (IAnjutaDebuggerBreakpoint *obj, guint id,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_BREAKPOINT(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE (obj)->clear_breakpoint (obj, id, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_breakpoint_clear_breakpoint_default (IAnjutaDebuggerBreakpoint *obj, guint id,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_breakpoint_condition_breakpoint:
* @obj: Self
* @id: Breakpoint identification number
* @condition: expression that has to be true
* @callback: Callback to call when the breakpoint has been changed
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Add a condition, evaluate in the program context, on the breakpoint,
* the program will stop when it reachs the breakpoint only if the
* condition is true. This function is optional.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_breakpoint_condition_breakpoint (IAnjutaDebuggerBreakpoint *obj, guint id,   const gchar* condition,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_BREAKPOINT(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE (obj)->condition_breakpoint (obj, id, condition, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_breakpoint_condition_breakpoint_default (IAnjutaDebuggerBreakpoint *obj, guint id,   const gchar* condition,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_breakpoint_enable_breakpoint:
* @obj: Self
* @id: Breakpoint identification number
* @enable: TRUE to enable the breakpoint, FALSE to disable it
* @callback: Callback to call when the breakpoint has been changed
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Enable of disable a breakpoint. This function is optional.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_breakpoint_enable_breakpoint (IAnjutaDebuggerBreakpoint *obj, guint id,   gboolean enable,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_BREAKPOINT(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE (obj)->enable_breakpoint (obj, id, enable, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_breakpoint_enable_breakpoint_default (IAnjutaDebuggerBreakpoint *obj, guint id,   gboolean enable,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_breakpoint_ignore_breakpoint:
* @obj: Self
* @id: Breakpoint identification number
* @ignore: Number of time a breakpoint must be ignored
* @callback: Callback to call when the breakpoint has been changed
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* This allow to ignore the breakpoint a number of time before stopping.
* This function is optional.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_breakpoint_ignore_breakpoint (IAnjutaDebuggerBreakpoint *obj, guint id,   guint ignore,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_BREAKPOINT(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE (obj)->ignore_breakpoint (obj, id, ignore, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_breakpoint_ignore_breakpoint_default (IAnjutaDebuggerBreakpoint *obj, guint id,   guint ignore,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_breakpoint_implement_breakpoint:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Return all implemented methods.
*
* Returns: A OR of IAnjutaDebuggerBreakpointMethod
* corresponding to all implemented optional methods.
*/
gint
ianjuta_debugger_breakpoint_implement_breakpoint (IAnjutaDebuggerBreakpoint *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_BREAKPOINT(obj), -1);
	return IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE (obj)->implement_breakpoint (obj, err);
}

/* Default implementation */
static gint
ianjuta_debugger_breakpoint_implement_breakpoint_default (IAnjutaDebuggerBreakpoint *obj, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
* ianjuta_debugger_breakpoint_list_breakpoint:
* @obj: Self
* @callback: Callback to call with the list of breakpoints
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* List all breakpoints set in the debugger. It is useful to
* know how many time a breakpoint has been hit.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_breakpoint_list_breakpoint (IAnjutaDebuggerBreakpoint *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_BREAKPOINT(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE (obj)->list_breakpoint (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_breakpoint_list_breakpoint_default (IAnjutaDebuggerBreakpoint *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_breakpoint_set_breakpoint_at_address:
* @obj: Self
* @address: Address of the breakpoint
* @callback: Callback to call when the breakpoint has been set
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Set a breakpoint at the specified address.
* This function is optional.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_breakpoint_set_breakpoint_at_address (IAnjutaDebuggerBreakpoint *obj, gulong address,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_BREAKPOINT(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE (obj)->set_breakpoint_at_address (obj, address, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_breakpoint_set_breakpoint_at_address_default (IAnjutaDebuggerBreakpoint *obj, gulong address,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_breakpoint_set_breakpoint_at_function:
* @obj: Self
* @file: File containing the breakpoint
* @function: Function name where the breakpoint is put
* @callback: Callback to call when the breakpoint has been set
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Set a breakpoint at the beginning of the specified function. 
* This function is optional.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_breakpoint_set_breakpoint_at_function (IAnjutaDebuggerBreakpoint *obj, const gchar* file,   const gchar* function,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_BREAKPOINT(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE (obj)->set_breakpoint_at_function (obj, file, function, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_breakpoint_set_breakpoint_at_function_default (IAnjutaDebuggerBreakpoint *obj, const gchar* file,   const gchar* function,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_breakpoint_set_breakpoint_at_line:
* @obj: Self
* @file: File containing the breakpoint
* @line: Line number where is the breakpoint
* @callback: Callback to call when the breakpoint has been set
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Set a breakpoint at the specified line in the file.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_breakpoint_set_breakpoint_at_line (IAnjutaDebuggerBreakpoint *obj, const gchar* file,   guint line,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_BREAKPOINT(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE (obj)->set_breakpoint_at_line (obj, file, line, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_breakpoint_set_breakpoint_at_line_default (IAnjutaDebuggerBreakpoint *obj, const gchar* file,   guint line,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_debugger_breakpoint_base_init (IAnjutaDebuggerBreakpointIface* klass)
{
	static gboolean initialized = FALSE;

	klass->clear_breakpoint = ianjuta_debugger_breakpoint_clear_breakpoint_default;
	klass->condition_breakpoint = ianjuta_debugger_breakpoint_condition_breakpoint_default;
	klass->enable_breakpoint = ianjuta_debugger_breakpoint_enable_breakpoint_default;
	klass->ignore_breakpoint = ianjuta_debugger_breakpoint_ignore_breakpoint_default;
	klass->implement_breakpoint = ianjuta_debugger_breakpoint_implement_breakpoint_default;
	klass->list_breakpoint = ianjuta_debugger_breakpoint_list_breakpoint_default;
	klass->set_breakpoint_at_address = ianjuta_debugger_breakpoint_set_breakpoint_at_address_default;
	klass->set_breakpoint_at_function = ianjuta_debugger_breakpoint_set_breakpoint_at_function_default;
	klass->set_breakpoint_at_line = ianjuta_debugger_breakpoint_set_breakpoint_at_line_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_debugger_breakpoint_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDebuggerBreakpointIface),
			(GBaseInitFunc) ianjuta_debugger_breakpoint_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDebuggerBreakpoint", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_DEBUGGER);
	}
	return type;			
}

GType
ianjuta_debugger_breakpoint_method_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_DEBUGGER_BREAKPOINT_SET_AT_ADDRESS, "IANJUTA_DEBUGGER_BREAKPOINT_SET_AT_ADDRESS", "set-at-address" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_SET_AT_FUNCTION, "IANJUTA_DEBUGGER_BREAKPOINT_SET_AT_FUNCTION", "set-at-function" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_ENABLE, "IANJUTA_DEBUGGER_BREAKPOINT_ENABLE", "enable" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_IGNORE, "IANJUTA_DEBUGGER_BREAKPOINT_IGNORE", "ignore" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_CONDITION, "IANJUTA_DEBUGGER_BREAKPOINT_CONDITION", "condition" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaDebuggerBreakpointMethod", values);
	}

	return type;
}

GType
ianjuta_debugger_breakpoint_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_DEBUGGER_BREAKPOINT_REMOVED, "IANJUTA_DEBUGGER_BREAKPOINT_REMOVED", "removed" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_UPDATED, "IANJUTA_DEBUGGER_BREAKPOINT_UPDATED", "updated" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_ON_LINE, "IANJUTA_DEBUGGER_BREAKPOINT_ON_LINE", "on-line" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_ON_ADDRESS, "IANJUTA_DEBUGGER_BREAKPOINT_ON_ADDRESS", "on-address" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_ON_FUNCTION, "IANJUTA_DEBUGGER_BREAKPOINT_ON_FUNCTION", "on-function" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_ON_READ, "IANJUTA_DEBUGGER_BREAKPOINT_ON_READ", "on-read" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_ON_WRITE, "IANJUTA_DEBUGGER_BREAKPOINT_ON_WRITE", "on-write" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_WITH_ENABLE, "IANJUTA_DEBUGGER_BREAKPOINT_WITH_ENABLE", "with-enable" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_WITH_IGNORE, "IANJUTA_DEBUGGER_BREAKPOINT_WITH_IGNORE", "with-ignore" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_WITH_TIME, "IANJUTA_DEBUGGER_BREAKPOINT_WITH_TIME", "with-time" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_WITH_CONDITION, "IANJUTA_DEBUGGER_BREAKPOINT_WITH_CONDITION", "with-condition" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_WITH_TEMPORARY, "IANJUTA_DEBUGGER_BREAKPOINT_WITH_TEMPORARY", "with-temporary" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT_WITH_PENDING, "IANJUTA_DEBUGGER_BREAKPOINT_WITH_PENDING", "with-pending" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaDebuggerBreakpointType", values);
	}

	return type;
}
