/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-language.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_LANGUAGE_H_
#define _IANJUTA_LANGUAGE_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-editor-language.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_LANGUAGE (ianjuta_language_get_type ())
#define IANJUTA_LANGUAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_LANGUAGE, IAnjutaLanguage))
#define IANJUTA_IS_LANGUAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_LANGUAGE))
#define IANJUTA_LANGUAGE_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_LANGUAGE, IAnjutaLanguageIface))

#define IANJUTA_LANGUAGE_ERROR ianjuta_language_error_quark()

typedef struct _IAnjutaLanguage IAnjutaLanguage;
typedef struct _IAnjutaLanguageIface IAnjutaLanguageIface;

typedef gint IAnjutaLanguageId;


struct _IAnjutaLanguageIface {
	GTypeInterface g_iface;
	

	IAnjutaLanguageId (*get_from_editor) (IAnjutaLanguage *obj, IAnjutaEditorLanguage* editor, GError **err);
	IAnjutaLanguageId (*get_from_mime_type) (IAnjutaLanguage *obj, const gchar* mime_type, GError **err);
	IAnjutaLanguageId (*get_from_string) (IAnjutaLanguage *obj, const gchar* string, GError **err);
	const gchar* (*get_name) (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err);
	const gchar* (*get_name_from_editor) (IAnjutaLanguage *obj, IAnjutaEditorLanguage* editor, GError **err);
	GList* (*get_strings) (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err);

};


GQuark ianjuta_language_error_quark     (void);
GType  ianjuta_language_get_type        (void);

IAnjutaLanguageId ianjuta_language_get_from_editor (IAnjutaLanguage *obj, IAnjutaEditorLanguage* editor, GError **err);

IAnjutaLanguageId ianjuta_language_get_from_mime_type (IAnjutaLanguage *obj, const gchar* mime_type, GError **err);

IAnjutaLanguageId ianjuta_language_get_from_string (IAnjutaLanguage *obj, const gchar* string, GError **err);

const gchar* ianjuta_language_get_name (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err);

const gchar* ianjuta_language_get_name_from_editor (IAnjutaLanguage *obj, IAnjutaEditorLanguage* editor, GError **err);

GList* ianjuta_language_get_strings (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err);


G_END_DECLS

#endif
