/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-help.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-help
 * @title: IAnjutaHelp
 * @short_description: Implemented by plugins that can provide help support
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-help.h
 * 
 */

#include "ianjuta-help.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_help_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-help-quark");
	}
	
	return quark;
}

/**
* ianjuta_help_search:
* @obj: Self
* @query: fixme
* @err: Error propagation and reporting
* 
* fixme
*/
void
ianjuta_help_search (IAnjutaHelp *obj, const gchar *query, GError **err)
{
	g_return_if_fail (IANJUTA_IS_HELP(obj));
	IANJUTA_HELP_GET_IFACE (obj)->search (obj, query, err);
}

/* Default implementation */
static void
ianjuta_help_search_default (IAnjutaHelp *obj, const gchar *query, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_help_base_init (IAnjutaHelpIface* klass)
{
	static gboolean initialized = FALSE;

	klass->search = ianjuta_help_search_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_help_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaHelpIface),
			(GBaseInitFunc) ianjuta_help_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaHelp", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
