/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-todo.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-todo
 * @title: IAnjutaTodo
 * @short_description: Task manager interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-todo.h
 * 
 */

#include "ianjuta-todo.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_todo_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-todo-quark");
	}
	
	return quark;
}

/**
* ianjuta_to_do_load:
* @obj: Self
* @uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_todo_load (IAnjutaTodo *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_TODO(obj));
	IANJUTA_TODO_GET_IFACE (obj)->load (obj, uri, err);
}

/* Default implementation */
static void
ianjuta_todo_load_default (IAnjutaTodo *obj, const gchar *uri, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_todo_base_init (IAnjutaTodoIface* klass)
{
	static gboolean initialized = FALSE;

	klass->load = ianjuta_todo_load_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_todo_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaTodoIface),
			(GBaseInitFunc) ianjuta_todo_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaTodo", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
