/* rygel-search.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-search.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;
typedef struct _RygelSearchPrivate RygelSearchPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _RygelSearchFetchResultsData RygelSearchFetchResultsData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	char* object_id;
	char* browse_flag;
	char* filter;
	guint index;
	guint requested_count;
	char* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	RygelXBoxHacks* xbox_hacks;
	char* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelSearch {
	RygelMediaQueryAction parent_instance;
	RygelSearchPrivate * priv;
	char* search_criteria;
};

struct _RygelSearchClass {
	RygelMediaQueryActionClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	char* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelSearchFetchResultsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearch* self;
	RygelMediaObject* media_object;
	RygelMediaObjects* result;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp0_;
	RygelSearchCriteriaParser* parser;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	GError * _inner_error_;
};


static gpointer rygel_search_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
GType rygel_search_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SEARCH_DUMMY_PROPERTY
};
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_search_real_parse_args (RygelMediaQueryAction* base, GError** error);
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error);
GQuark rygel_content_directory_error_quark (void);
static void rygel_search_real_fetch_results_data_free (gpointer _data);
static void rygel_search_real_fetch_results (RygelMediaQueryAction* base, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_search_fetch_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_search_real_fetch_results_co (RygelSearchFetchResultsData* data);
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const char* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const char* str, GError** error);
GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST;
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_search (RygelXBoxHacks* self, RygelMediaContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_xbox_hacks_search_finish (RygelXBoxHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_media_container_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_search_real_handle_error (RygelMediaQueryAction* base, GError* _error_);
void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_search_finalize (GObject* obj);



#line 35 "rygel-search.vala"
RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 296 "rygel-search.c"
	RygelSearch * self;
	char* _tmp0_;
#line 35 "rygel-search.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 35 "rygel-search.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 37 "rygel-search.vala"
	self = (RygelSearch*) rygel_media_query_action_construct (object_type, content_dir, action);
#line 39 "rygel-search.vala"
	((RygelMediaQueryAction*) self)->object_id_arg = (_tmp0_ = g_strdup ("ContainerID"), _g_free0 (((RygelMediaQueryAction*) self)->object_id_arg), _tmp0_);
#line 307 "rygel-search.c"
	return self;
}


#line 35 "rygel-search.vala"
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 35 "rygel-search.vala"
	return rygel_search_construct (RYGEL_TYPE_SEARCH, content_dir, action);
#line 316 "rygel-search.c"
}


#line 42 "rygel-search.vala"
static void rygel_search_real_parse_args (RygelMediaQueryAction* base, GError** error) {
#line 322 "rygel-search.c"
	RygelSearch * self;
	GError * _inner_error_ = NULL;
	self = (RygelSearch*) base;
#line 43 "rygel-search.vala"
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_search_parent_class)->parse_args (RYGEL_MEDIA_QUERY_ACTION (self), &_inner_error_);
#line 328 "rygel-search.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 45 "rygel-search.vala"
	gupnp_service_action_get (((RygelMediaQueryAction*) self)->action, "SearchCriteria", G_TYPE_STRING, &self->search_criteria, NULL);
#line 49 "rygel-search.vala"
	if (self->search_criteria == NULL) {
#line 337 "rygel-search.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "No search criteria given");
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
#line 54 "rygel-search.vala"
	g_debug ("rygel-search.vala:54: Executing search request: %s", self->search_criteria);
#line 346 "rygel-search.c"
}


static void rygel_search_real_fetch_results_data_free (gpointer _data) {
	RygelSearchFetchResultsData* data;
	data = _data;
	_g_object_unref0 (data->media_object);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelSearchFetchResultsData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_search_real_fetch_results (RygelMediaQueryAction* base, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearch * self;
	RygelSearchFetchResultsData* _data_;
	self = (RygelSearch*) base;
	_data_ = g_slice_new0 (RygelSearchFetchResultsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_search_real_fetch_results);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_search_real_fetch_results_data_free);
	_data_->self = g_object_ref (self);
	_data_->media_object = _g_object_ref0 (media_object);
	rygel_search_real_fetch_results_co (_data_);
}


static RygelMediaObjects* rygel_search_real_fetch_results_finish (RygelMediaQueryAction* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSearchFetchResultsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_search_fetch_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchFetchResultsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_search_real_fetch_results_co (data);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_search_real_fetch_results_co (RygelSearchFetchResultsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 35:
		goto _state_35;
		case 36:
		goto _state_36;
		case 37:
		goto _state_37;
	}
	_state_0:
	data->container = _g_object_ref0 ((data->_tmp0_ = data->media_object, RYGEL_IS_MEDIA_CONTAINER (data->_tmp0_) ? ((RygelMediaContainer*) data->_tmp0_) : NULL));
	data->parser = rygel_search_criteria_parser_new (data->self->search_criteria, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->container);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_state_ = 35;
	rygel_state_machine_run ((RygelStateMachine*) data->parser, rygel_search_fetch_results_ready, data);
	return FALSE;
	_state_35:
#line 62 "rygel-search.vala"
	rygel_state_machine_run_finish ((RygelStateMachine*) data->parser, data->_res_);
#line 64 "rygel-search.vala"
	if (data->parser->err != NULL) {
#line 442 "rygel-search.c"
		data->_inner_error_ = _g_error_copy0 (data->parser->err);
		{
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->parser);
			_g_object_unref0 (data->container);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
#line 68 "rygel-search.vala"
	if (((RygelMediaQueryAction*) data->self)->xbox_hacks != NULL) {
#line 462 "rygel-search.c"
		data->_state_ = 36;
		rygel_xbox_hacks_search (((RygelMediaQueryAction*) data->self)->xbox_hacks, data->container, data->parser->expression, ((RygelMediaQueryAction*) data->self)->index, ((RygelMediaQueryAction*) data->self)->requested_count, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_search_fetch_results_ready, data);
		return FALSE;
		_state_36:
		data->_tmp1_ = rygel_xbox_hacks_search_finish (((RygelMediaQueryAction*) data->self)->xbox_hacks, data->_res_, &((RygelMediaQueryAction*) data->self)->total_matches, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->parser);
			_g_object_unref0 (data->container);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = data->_tmp1_;
		_g_object_unref0 (data->parser);
		_g_object_unref0 (data->container);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	} else {
		data->_state_ = 37;
		rygel_media_container_search (data->container, data->parser->expression, ((RygelMediaQueryAction*) data->self)->index, ((RygelMediaQueryAction*) data->self)->requested_count, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_search_fetch_results_ready, data);
		return FALSE;
		_state_37:
		data->_tmp2_ = rygel_media_container_search_finish (data->container, data->_res_, &((RygelMediaQueryAction*) data->self)->total_matches, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->parser);
			_g_object_unref0 (data->container);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = data->_tmp2_;
		_g_object_unref0 (data->parser);
		_g_object_unref0 (data->container);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (data->parser);
	_g_object_unref0 (data->container);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 84 "rygel-search.vala"
static void rygel_search_real_handle_error (RygelMediaQueryAction* base, GError* _error_) {
#line 545 "rygel-search.c"
	RygelSearch * self;
	self = (RygelSearch*) base;
#line 85 "rygel-search.vala"
	g_warning (_ ("Failed to search in '%s': %s"), ((RygelMediaQueryAction*) self)->object_id, _error_->message);
#line 89 "rygel-search.vala"
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_search_parent_class)->handle_error (RYGEL_MEDIA_QUERY_ACTION (self), _error_);
#line 552 "rygel-search.c"
}


static void rygel_search_class_init (RygelSearchClass * klass) {
	rygel_search_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->parse_args = rygel_search_real_parse_args;
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->fetch_results = rygel_search_real_fetch_results;
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->fetch_results_finish = rygel_search_real_fetch_results_finish;
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->handle_error = rygel_search_real_handle_error;
	G_OBJECT_CLASS (klass)->finalize = rygel_search_finalize;
}


static void rygel_search_instance_init (RygelSearch * self) {
}


static void rygel_search_finalize (GObject* obj) {
	RygelSearch * self;
	self = RYGEL_SEARCH (obj);
	_g_free0 (self->search_criteria);
	G_OBJECT_CLASS (rygel_search_parent_class)->finalize (obj);
}


/**
 * Search action implementation.
 */
GType rygel_search_get_type (void) {
	static volatile gsize rygel_search_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearch), 0, (GInstanceInitFunc) rygel_search_instance_init, NULL };
		GType rygel_search_type_id;
		rygel_search_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_QUERY_ACTION, "RygelSearch", &g_define_type_info, 0);
		g_once_init_leave (&rygel_search_type_id__volatile, rygel_search_type_id);
	}
	return rygel_search_type_id__volatile;
}




