/* rygel-media-objects.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-media-objects.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
typedef struct _RygelMediaObjectsPrivate RygelMediaObjectsPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaObjects {
	GeeArrayList parent_instance;
	RygelMediaObjectsPrivate * priv;
};

struct _RygelMediaObjectsClass {
	GeeArrayListClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	RygelMediaObjects * self;
	char** sort_props;
	gint sort_props_length1;
	gint _sort_props_size_;
};


static gpointer rygel_media_objects_parent_class = NULL;

GType rygel_media_objects_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECTS_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "dc:artist,dc:author,upnp:album,dc:date"
GType rygel_media_object_get_type (void) G_GNUC_CONST;
static GeeList* rygel_media_objects_real_slice (GeeAbstractList* base, gint start, gint stop);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const char* sort_criteria);
static gint _lambda0_ (void* a, void* b, Block3Data* _data3_);
static gint rygel_media_objects_compare_media_objects (RygelMediaObjects* self, RygelMediaObject* a, RygelMediaObject* b, char** sort_props, int sort_props_length1);
static gint __lambda0__gcompare_data_func (void* a, void* b, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
void rygel_media_objects_serialize (RygelMediaObjects* self, GUPnPDIDLLiteWriter* didl_writer, RygelHTTPServer* http_server, RygelXBoxHacks* xbox_hacks, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



#line 33 "rygel-media-objects.vala"
static GeeList* rygel_media_objects_real_slice (GeeAbstractList* base, gint start, gint stop) {
#line 150 "rygel-media-objects.c"
	RygelMediaObjects * self;
	GeeList* result = NULL;
	GeeList* slice;
	RygelMediaObjects* ret;
	self = (RygelMediaObjects*) base;
#line 34 "rygel-media-objects.vala"
	slice = GEE_ABSTRACT_LIST_CLASS (rygel_media_objects_parent_class)->slice ((GeeAbstractList*) GEE_ARRAY_LIST (self), start, stop);
#line 35 "rygel-media-objects.vala"
	ret = rygel_media_objects_new ();
#line 37 "rygel-media-objects.vala"
	gee_abstract_collection_add_all ((GeeAbstractCollection*) ret, (GeeCollection*) slice);
#line 162 "rygel-media-objects.c"
	result = (GeeList*) ret;
	_g_object_unref0 (slice);
#line 39 "rygel-media-objects.vala"
	return result;
#line 167 "rygel-media-objects.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 48 "rygel-media-objects.vala"
static gint _lambda0_ (void* a, void* b, Block3Data* _data3_) {
#line 178 "rygel-media-objects.c"
	RygelMediaObjects * self;
	gint result = 0;
	void* _tmp0_;
	RygelMediaObject* object_a;
	void* _tmp1_;
	RygelMediaObject* object_b;
	self = _data3_->self;
#line 49 "rygel-media-objects.vala"
	object_a = _g_object_ref0 ((_tmp0_ = a, RYGEL_IS_MEDIA_OBJECT (_tmp0_) ? ((RygelMediaObject*) _tmp0_) : NULL));
#line 50 "rygel-media-objects.vala"
	object_b = _g_object_ref0 ((_tmp1_ = b, RYGEL_IS_MEDIA_OBJECT (_tmp1_) ? ((RygelMediaObject*) _tmp1_) : NULL));
#line 190 "rygel-media-objects.c"
	result = rygel_media_objects_compare_media_objects (self, object_a, object_b, _data3_->sort_props, _data3_->sort_props_length1);
	_g_object_unref0 (object_b);
	_g_object_unref0 (object_a);
#line 52 "rygel-media-objects.vala"
	return result;
#line 196 "rygel-media-objects.c"
}


#line 48 "rygel-media-objects.vala"
static gint __lambda0__gcompare_data_func (void* a, void* b, gpointer self) {
#line 202 "rygel-media-objects.c"
	gint result;
	result = _lambda0_ (a, b, self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_data3_->sort_props = (_vala_array_free (_data3_->sort_props, _data3_->sort_props_length1, (GDestroyNotify) g_free), NULL);
		g_slice_free (Block3Data, _data3_);
	}
}


#line 42 "rygel-media-objects.vala"
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const char* sort_criteria) {
#line 226 "rygel-media-objects.c"
	Block3Data* _data3_;
	char** _tmp1_;
	char** _tmp0_;
#line 42 "rygel-media-objects.vala"
	g_return_if_fail (self != NULL);
#line 42 "rygel-media-objects.vala"
	g_return_if_fail (sort_criteria != NULL);
#line 234 "rygel-media-objects.c"
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->sort_props = (_tmp1_ = _tmp0_ = g_strsplit (sort_criteria, ",", 0), _data3_->sort_props_length1 = _vala_array_length (_tmp0_), _tmp1_);
#line 44 "rygel-media-objects.vala"
	if (_data3_->sort_props_length1 == 0) {
#line 241 "rygel-media-objects.c"
		block3_data_unref (_data3_);
#line 45 "rygel-media-objects.vala"
		return;
#line 245 "rygel-media-objects.c"
	}
#line 48 "rygel-media-objects.vala"
	gee_array_list_sort_with_data ((GeeArrayList*) self, __lambda0__gcompare_data_func, _data3_);
#line 249 "rygel-media-objects.c"
	block3_data_unref (_data3_);
}


#line 56 "rygel-media-objects.vala"
void rygel_media_objects_serialize (RygelMediaObjects* self, GUPnPDIDLLiteWriter* didl_writer, RygelHTTPServer* http_server, RygelXBoxHacks* xbox_hacks, GError** error) {
#line 256 "rygel-media-objects.c"
	GError * _inner_error_ = NULL;
#line 56 "rygel-media-objects.vala"
	g_return_if_fail (self != NULL);
#line 56 "rygel-media-objects.vala"
	g_return_if_fail (didl_writer != NULL);
#line 56 "rygel-media-objects.vala"
	g_return_if_fail (http_server != NULL);
#line 264 "rygel-media-objects.c"
	{
		GeeIterator* _result_it;
#line 59 "rygel-media-objects.vala"
		_result_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
#line 59 "rygel-media-objects.vala"
		while (TRUE) {
#line 271 "rygel-media-objects.c"
			RygelMediaObject* _result_;
			gboolean _tmp0_ = FALSE;
			GUPnPDIDLLiteObject* _tmp2_;
#line 59 "rygel-media-objects.vala"
			if (!gee_iterator_next (_result_it)) {
#line 59 "rygel-media-objects.vala"
				break;
#line 279 "rygel-media-objects.c"
			}
#line 59 "rygel-media-objects.vala"
			_result_ = (RygelMediaObject*) gee_iterator_get (_result_it);
#line 60 "rygel-media-objects.vala"
			if (RYGEL_IS_MEDIA_ITEM (_result_)) {
#line 60 "rygel-media-objects.vala"
				_tmp0_ = xbox_hacks != NULL;
#line 287 "rygel-media-objects.c"
			} else {
#line 60 "rygel-media-objects.vala"
				_tmp0_ = FALSE;
#line 291 "rygel-media-objects.c"
			}
#line 60 "rygel-media-objects.vala"
			if (_tmp0_) {
#line 295 "rygel-media-objects.c"
				RygelMediaObject* _tmp1_;
#line 61 "rygel-media-objects.vala"
				rygel_xbox_hacks_apply (xbox_hacks, (_tmp1_ = _result_, RYGEL_IS_MEDIA_ITEM (_tmp1_) ? ((RygelMediaItem*) _tmp1_) : NULL));
#line 299 "rygel-media-objects.c"
			}
#line 64 "rygel-media-objects.vala"
			_tmp2_ = rygel_media_object_serialize (_result_, didl_writer, http_server, &_inner_error_);
#line 303 "rygel-media-objects.c"
			_g_object_unref0 (_tmp2_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (_result_);
				_g_object_unref0 (_result_it);
				return;
			}
			_g_object_unref0 (_result_);
		}
		_g_object_unref0 (_result_it);
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
#line 1190 "glib-2.0.vapi"
	return result;
#line 324 "rygel-media-objects.c"
}


#line 1106 "glib-2.0.vapi"
static char* string_substring (const char* self, glong offset, glong len) {
#line 330 "rygel-media-objects.c"
	char* result = NULL;
	glong string_length;
	const char* start;
#line 1106 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1107 "glib-2.0.vapi"
	string_length = string_get_length (self);
#line 1108 "glib-2.0.vapi"
	if (offset < 0) {
#line 1109 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1110 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= 0, NULL);
#line 344 "rygel-media-objects.c"
	} else {
#line 1112 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 348 "rygel-media-objects.c"
	}
#line 1114 "glib-2.0.vapi"
	if (len < 0) {
#line 1115 "glib-2.0.vapi"
		len = string_length - offset;
#line 354 "rygel-media-objects.c"
	}
#line 1117 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1118 "glib-2.0.vapi"
	start = g_utf8_offset_to_pointer (self, offset);
#line 360 "rygel-media-objects.c"
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
#line 1119 "glib-2.0.vapi"
	return result;
#line 364 "rygel-media-objects.c"
}


#line 68 "rygel-media-objects.vala"
static gint rygel_media_objects_compare_media_objects (RygelMediaObjects* self, RygelMediaObject* a, RygelMediaObject* b, char** sort_props, int sort_props_length1) {
#line 370 "rygel-media-objects.c"
	gint result = 0;
	gint i = 0;
	gint ret;
#line 68 "rygel-media-objects.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 68 "rygel-media-objects.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 68 "rygel-media-objects.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 72 "rygel-media-objects.vala"
	ret = 0;
#line 382 "rygel-media-objects.c"
	{
		gboolean _tmp0_;
#line 74 "rygel-media-objects.vala"
		i = 0;
#line 74 "rygel-media-objects.vala"
		_tmp0_ = TRUE;
#line 74 "rygel-media-objects.vala"
		while (TRUE) {
#line 391 "rygel-media-objects.c"
			gboolean _tmp1_ = FALSE;
			char* property;
#line 74 "rygel-media-objects.vala"
			if (!_tmp0_) {
#line 74 "rygel-media-objects.vala"
				i++;
#line 398 "rygel-media-objects.c"
			}
#line 74 "rygel-media-objects.vala"
			_tmp0_ = FALSE;
#line 74 "rygel-media-objects.vala"
			if (ret == 0) {
#line 74 "rygel-media-objects.vala"
				_tmp1_ = i < sort_props_length1;
#line 406 "rygel-media-objects.c"
			} else {
#line 74 "rygel-media-objects.vala"
				_tmp1_ = FALSE;
#line 410 "rygel-media-objects.c"
			}
#line 74 "rygel-media-objects.vala"
			if (!_tmp1_) {
#line 74 "rygel-media-objects.vala"
				break;
#line 416 "rygel-media-objects.c"
			}
#line 75 "rygel-media-objects.vala"
			property = string_substring (sort_props[i], (glong) 1, -1);
#line 77 "rygel-media-objects.vala"
			ret = rygel_media_object_compare_by_property (a, b, property);
#line 79 "rygel-media-objects.vala"
			if (g_utf8_get_char (g_utf8_offset_to_pointer (sort_props[i], 0)) == '-') {
#line 81 "rygel-media-objects.vala"
				ret = 0 - ret;
#line 426 "rygel-media-objects.c"
			}
			_g_free0 (property);
		}
	}
	result = ret;
#line 85 "rygel-media-objects.vala"
	return result;
#line 434 "rygel-media-objects.c"
}


#line 29 "rygel-media-objects.vala"
RygelMediaObjects* rygel_media_objects_construct (GType object_type) {
#line 440 "rygel-media-objects.c"
	RygelMediaObjects * self;
#line 29 "rygel-media-objects.vala"
	self = (RygelMediaObjects*) gee_array_list_construct (object_type, RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 444 "rygel-media-objects.c"
	return self;
}


#line 29 "rygel-media-objects.vala"
RygelMediaObjects* rygel_media_objects_new (void) {
#line 29 "rygel-media-objects.vala"
	return rygel_media_objects_construct (RYGEL_TYPE_MEDIA_OBJECTS);
#line 453 "rygel-media-objects.c"
}


static void rygel_media_objects_class_init (RygelMediaObjectsClass * klass) {
	rygel_media_objects_parent_class = g_type_class_peek_parent (klass);
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = rygel_media_objects_real_slice;
}


static void rygel_media_objects_instance_init (RygelMediaObjects * self) {
}


/**
 * An array list that keeps media objects.
 */
GType rygel_media_objects_get_type (void) {
	static volatile gsize rygel_media_objects_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_objects_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_objects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObjects), 0, (GInstanceInitFunc) rygel_media_objects_instance_init, NULL };
		GType rygel_media_objects_type_id;
		rygel_media_objects_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "RygelMediaObjects", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_objects_type_id__volatile, rygel_media_objects_type_id);
	}
	return rygel_media_objects_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




