#! /usr/bin/env python

# Copyright (C) 2006 Intel Corporation
# 
# This program is free software; you can redistribute it and/or modify it under
# the terms of version 2 of the GNU Lesser General Public License as published
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
# 
# Author: Ross Burton <ross@openedhand.com>

import sys

var = None
strings = []

def output():
    print "static const gchar %s_table[] = {" % var
    for s in strings:
        print "  \"%s\\0\"" % s
    print "};"

    print "static const guint %s_index[] = {" % var
    index = 0
    for s in strings:
        print "  %d," % index
        index += len(s) + 1
    print "};\n"
    
(S_VAR, S_STRING) = range(0, 2)
state = S_VAR

print "/* This file is generated by gen-western-table.py. DO NOT EDIT */"

for l in sys.stdin.readlines():
    l = l.strip()
    if l == "":
        state = S_VAR
        output()
        var = None
        strings = []
    elif state == S_VAR:
        var = l
        state = S_STRING
    elif state == S_STRING:
        strings.append(l)

output()
