/* rygel-free-desktop-interfaces.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-free-desktop-interfaces.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define FREE_DESKTOP_TYPE_DBUS_REQUEST_NAME_REPLY (free_desktop_dbus_request_name_reply_get_type ())

#define FREE_DESKTOP_TYPE_DBUS_OBJECT (free_desktop_dbus_object_get_type ())
#define FREE_DESKTOP_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObject))
#define FREE_DESKTOP_IS_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT))
#define FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObjectIface))

typedef struct _FreeDesktopDBusObject FreeDesktopDBusObject;
typedef struct _FreeDesktopDBusObjectIface FreeDesktopDBusObjectIface;

#define FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY (free_desktop_dbus_object_proxy_get_type ())
typedef GDBusProxy FreeDesktopDBusObjectProxy;
typedef GDBusProxyClass FreeDesktopDBusObjectProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FREE_DESKTOP_TYPE_PROPERTIES (free_desktop_properties_get_type ())
#define FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopProperties))
#define FREE_DESKTOP_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_PROPERTIES))
#define FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopPropertiesIface))

typedef struct _FreeDesktopProperties FreeDesktopProperties;
typedef struct _FreeDesktopPropertiesIface FreeDesktopPropertiesIface;

#define FREE_DESKTOP_TYPE_PROPERTIES_PROXY (free_desktop_properties_proxy_get_type ())
typedef GDBusProxy FreeDesktopPropertiesProxy;
typedef GDBusProxyClass FreeDesktopPropertiesProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

typedef enum  {
	FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER = 1,
	FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_IN_QUEUE,
	FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_EXISTS,
	FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_ALREADY_OWNER
} FreeDesktopDBusRequestNameReply;

struct _FreeDesktopDBusObjectIface {
	GTypeInterface parent_iface;
	guint32 (*request_name) (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error);
	guint32 (*start_service_by_name) (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error);
	void (*list_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*list_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_activatable_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*list_activatable_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _FreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
	void (*get_all) (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*get_all_finish) (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
};



#define FREE_DESKTOP_DBUS_SERVICE "org.freedesktop.DBus"
#define FREE_DESKTOP_DBUS_OBJECT "/org/freedesktop/DBus"
GType free_desktop_dbus_request_name_reply_get_type (void) G_GNUC_CONST;
GType free_desktop_dbus_object_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_dbus_object_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_dbus_object_get_type (void) G_GNUC_CONST;
guint32 free_desktop_dbus_object_request_name (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error);
guint32 free_desktop_dbus_object_start_service_by_name (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error);
void free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** free_desktop_dbus_object_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
void free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** free_desktop_dbus_object_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void free_desktop_dbus_object_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* self, GVariant* parameters);
static guint32 free_desktop_dbus_object_proxy_request_name (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error);
static guint32 free_desktop_dbus_object_proxy_start_service_by_name (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error);
static void free_desktop_dbus_object_proxy_list_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static char** free_desktop_dbus_object_proxy_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void free_desktop_dbus_object_proxy_list_activatable_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static char** free_desktop_dbus_object_proxy_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void free_desktop_dbus_object_proxy_free_desktop_dbus_object_interface_init (FreeDesktopDBusObjectIface* iface);
static void free_desktop_dbus_object_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static void _dbus_free_desktop_dbus_object_request_name (FreeDesktopDBusObject* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_free_desktop_dbus_object_start_service_by_name (FreeDesktopDBusObject* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_free_desktop_dbus_object_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static void _dbus_free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_free_desktop_dbus_object_list_activatable_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static GVariant* free_desktop_dbus_object_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean free_desktop_dbus_object_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_free_desktop_dbus_object_name_owner_changed (GObject* _sender, const char* name, const char* old_owner, const char* new_owner, gpointer* _data);
static void _free_desktop_dbus_object_unregister_object (gpointer user_data);
GType free_desktop_properties_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_properties_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_properties_get_type (void) G_GNUC_CONST;
void free_desktop_properties_get_all (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* free_desktop_properties_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
static void free_desktop_properties_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_free_desktop_properties_properties_changed (FreeDesktopProperties* self, GVariant* parameters);
static void free_desktop_properties_proxy_get_all_async (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GHashTable* free_desktop_properties_proxy_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
static void free_desktop_properties_proxy_free_desktop_properties_interface_init (FreeDesktopPropertiesIface* iface);
static void free_desktop_properties_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static void _dbus_free_desktop_properties_get_all (FreeDesktopProperties* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_free_desktop_properties_get_all_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static GVariant* free_desktop_properties_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean free_desktop_properties_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_free_desktop_properties_properties_changed (GObject* _sender, const char* iface, GHashTable* changed, char** invalidated, int invalidated_length1, gpointer* _data);
static void _free_desktop_properties_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_request_name_name = {-1, "name", "s"};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_request_name_flags = {-1, "flags", "u"};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_request_name_result = {-1, "result", "u"};
static const GDBusArgInfo * const _free_desktop_dbus_object_dbus_arg_info_request_name_in[] = {&_free_desktop_dbus_object_dbus_arg_info_request_name_name, &_free_desktop_dbus_object_dbus_arg_info_request_name_flags, NULL};
static const GDBusArgInfo * const _free_desktop_dbus_object_dbus_arg_info_request_name_out[] = {&_free_desktop_dbus_object_dbus_arg_info_request_name_result, NULL};
static const GDBusMethodInfo _free_desktop_dbus_object_dbus_method_info_request_name = {-1, "RequestName", (GDBusArgInfo **) (&_free_desktop_dbus_object_dbus_arg_info_request_name_in), (GDBusArgInfo **) (&_free_desktop_dbus_object_dbus_arg_info_request_name_out)};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_start_service_by_name_name = {-1, "name", "s"};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_start_service_by_name_flags = {-1, "flags", "u"};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_start_service_by_name_result = {-1, "result", "u"};
static const GDBusArgInfo * const _free_desktop_dbus_object_dbus_arg_info_start_service_by_name_in[] = {&_free_desktop_dbus_object_dbus_arg_info_start_service_by_name_name, &_free_desktop_dbus_object_dbus_arg_info_start_service_by_name_flags, NULL};
static const GDBusArgInfo * const _free_desktop_dbus_object_dbus_arg_info_start_service_by_name_out[] = {&_free_desktop_dbus_object_dbus_arg_info_start_service_by_name_result, NULL};
static const GDBusMethodInfo _free_desktop_dbus_object_dbus_method_info_start_service_by_name = {-1, "StartServiceByName", (GDBusArgInfo **) (&_free_desktop_dbus_object_dbus_arg_info_start_service_by_name_in), (GDBusArgInfo **) (&_free_desktop_dbus_object_dbus_arg_info_start_service_by_name_out)};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_list_names_result = {-1, "result", "as"};
static const GDBusArgInfo * const _free_desktop_dbus_object_dbus_arg_info_list_names_in[] = {NULL};
static const GDBusArgInfo * const _free_desktop_dbus_object_dbus_arg_info_list_names_out[] = {&_free_desktop_dbus_object_dbus_arg_info_list_names_result, NULL};
static const GDBusMethodInfo _free_desktop_dbus_object_dbus_method_info_list_names = {-1, "ListNames", (GDBusArgInfo **) (&_free_desktop_dbus_object_dbus_arg_info_list_names_in), (GDBusArgInfo **) (&_free_desktop_dbus_object_dbus_arg_info_list_names_out)};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_list_activatable_names_result = {-1, "result", "as"};
static const GDBusArgInfo * const _free_desktop_dbus_object_dbus_arg_info_list_activatable_names_in[] = {NULL};
static const GDBusArgInfo * const _free_desktop_dbus_object_dbus_arg_info_list_activatable_names_out[] = {&_free_desktop_dbus_object_dbus_arg_info_list_activatable_names_result, NULL};
static const GDBusMethodInfo _free_desktop_dbus_object_dbus_method_info_list_activatable_names = {-1, "ListActivatableNames", (GDBusArgInfo **) (&_free_desktop_dbus_object_dbus_arg_info_list_activatable_names_in), (GDBusArgInfo **) (&_free_desktop_dbus_object_dbus_arg_info_list_activatable_names_out)};
static const GDBusMethodInfo * const _free_desktop_dbus_object_dbus_method_info[] = {&_free_desktop_dbus_object_dbus_method_info_request_name, &_free_desktop_dbus_object_dbus_method_info_start_service_by_name, &_free_desktop_dbus_object_dbus_method_info_list_names, &_free_desktop_dbus_object_dbus_method_info_list_activatable_names, NULL};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_name_owner_changed_name = {-1, "name", "s"};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_name_owner_changed_old_owner = {-1, "old_owner", "s"};
static const GDBusArgInfo _free_desktop_dbus_object_dbus_arg_info_name_owner_changed_new_owner = {-1, "new_owner", "s"};
static const GDBusArgInfo * const _free_desktop_dbus_object_dbus_arg_info_name_owner_changed[] = {&_free_desktop_dbus_object_dbus_arg_info_name_owner_changed_name, &_free_desktop_dbus_object_dbus_arg_info_name_owner_changed_old_owner, &_free_desktop_dbus_object_dbus_arg_info_name_owner_changed_new_owner, NULL};
static const GDBusSignalInfo _free_desktop_dbus_object_dbus_signal_info_name_owner_changed = {-1, "NameOwnerChanged", (GDBusArgInfo **) (&_free_desktop_dbus_object_dbus_arg_info_name_owner_changed)};
static const GDBusSignalInfo * const _free_desktop_dbus_object_dbus_signal_info[] = {&_free_desktop_dbus_object_dbus_signal_info_name_owner_changed, NULL};
static const GDBusPropertyInfo * const _free_desktop_dbus_object_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _free_desktop_dbus_object_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_free_desktop_dbus_object_dbus_method_info), (GDBusSignalInfo **) (&_free_desktop_dbus_object_dbus_signal_info), (GDBusPropertyInfo **) (&_free_desktop_dbus_object_dbus_property_info)};
static const GDBusInterfaceVTable _free_desktop_dbus_object_dbus_interface_vtable = {free_desktop_dbus_object_dbus_interface_method_call, free_desktop_dbus_object_dbus_interface_get_property, free_desktop_dbus_object_dbus_interface_set_property};
static const GDBusArgInfo _free_desktop_properties_dbus_arg_info_get_all_iface = {-1, "iface", "s"};
static const GDBusArgInfo _free_desktop_properties_dbus_arg_info_get_all_result = {-1, "result", "a{sv}"};
static const GDBusArgInfo * const _free_desktop_properties_dbus_arg_info_get_all_in[] = {&_free_desktop_properties_dbus_arg_info_get_all_iface, NULL};
static const GDBusArgInfo * const _free_desktop_properties_dbus_arg_info_get_all_out[] = {&_free_desktop_properties_dbus_arg_info_get_all_result, NULL};
static const GDBusMethodInfo _free_desktop_properties_dbus_method_info_get_all = {-1, "GetAll", (GDBusArgInfo **) (&_free_desktop_properties_dbus_arg_info_get_all_in), (GDBusArgInfo **) (&_free_desktop_properties_dbus_arg_info_get_all_out)};
static const GDBusMethodInfo * const _free_desktop_properties_dbus_method_info[] = {&_free_desktop_properties_dbus_method_info_get_all, NULL};
static const GDBusArgInfo _free_desktop_properties_dbus_arg_info_properties_changed_iface = {-1, "iface", "s"};
static const GDBusArgInfo _free_desktop_properties_dbus_arg_info_properties_changed_changed = {-1, "changed", "a{sv}"};
static const GDBusArgInfo _free_desktop_properties_dbus_arg_info_properties_changed_invalidated = {-1, "invalidated", "as"};
static const GDBusArgInfo * const _free_desktop_properties_dbus_arg_info_properties_changed[] = {&_free_desktop_properties_dbus_arg_info_properties_changed_iface, &_free_desktop_properties_dbus_arg_info_properties_changed_changed, &_free_desktop_properties_dbus_arg_info_properties_changed_invalidated, NULL};
static const GDBusSignalInfo _free_desktop_properties_dbus_signal_info_properties_changed = {-1, "PropertiesChanged", (GDBusArgInfo **) (&_free_desktop_properties_dbus_arg_info_properties_changed)};
static const GDBusSignalInfo * const _free_desktop_properties_dbus_signal_info[] = {&_free_desktop_properties_dbus_signal_info_properties_changed, NULL};
static const GDBusPropertyInfo * const _free_desktop_properties_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _free_desktop_properties_dbus_interface_info = {-1, "org.freedesktop.DBus.Properties", (GDBusMethodInfo **) (&_free_desktop_properties_dbus_method_info), (GDBusSignalInfo **) (&_free_desktop_properties_dbus_signal_info), (GDBusPropertyInfo **) (&_free_desktop_properties_dbus_property_info)};
static const GDBusInterfaceVTable _free_desktop_properties_dbus_interface_vtable = {free_desktop_properties_dbus_interface_method_call, free_desktop_properties_dbus_interface_get_property, free_desktop_properties_dbus_interface_set_property};

static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GType free_desktop_dbus_request_name_reply_get_type (void) {
	static volatile gsize free_desktop_dbus_request_name_reply_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_dbus_request_name_reply_type_id__volatile)) {
		static const GEnumValue values[] = {{FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER, "FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER", "primary-owner"}, {FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_IN_QUEUE, "FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_IN_QUEUE", "in-queue"}, {FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_EXISTS, "FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_EXISTS", "exists"}, {FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_ALREADY_OWNER, "FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_ALREADY_OWNER", "already-owner"}, {0, NULL, NULL}};
		GType free_desktop_dbus_request_name_reply_type_id;
		free_desktop_dbus_request_name_reply_type_id = g_enum_register_static ("FreeDesktopDBusRequestNameReply", values);
		g_once_init_leave (&free_desktop_dbus_request_name_reply_type_id__volatile, free_desktop_dbus_request_name_reply_type_id);
	}
	return free_desktop_dbus_request_name_reply_type_id__volatile;
}


#line 26 "rygel-volume.vala"
guint32 free_desktop_dbus_object_request_name (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error) {
#line 26 "rygel-volume.vala"
	return FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->request_name (self, name, flags, error);
#line 205 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
guint32 free_desktop_dbus_object_start_service_by_name (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error) {
#line 26 "rygel-volume.vala"
	return FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->start_service_by_name (self, name, flags, error);
#line 213 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
void free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 26 "rygel-volume.vala"
	FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_names (self, _callback_, _user_data_);
#line 221 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
char** free_desktop_dbus_object_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
#line 26 "rygel-volume.vala"
	return FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_names_finish (self, _res_, result_length1, error);
#line 229 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
void free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 26 "rygel-volume.vala"
	FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_activatable_names (self, _callback_, _user_data_);
#line 237 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
char** free_desktop_dbus_object_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
#line 26 "rygel-volume.vala"
	return FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_activatable_names_finish (self, _res_, result_length1, error);
#line 245 "rygel-free-desktop-interfaces.c"
}


static void free_desktop_dbus_object_base_init (FreeDesktopDBusObjectIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("name_owner_changed", FREE_DESKTOP_TYPE_DBUS_OBJECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	}
}


GType free_desktop_dbus_object_get_type (void) {
	static volatile gsize free_desktop_dbus_object_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_dbus_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FreeDesktopDBusObjectIface), (GBaseInitFunc) free_desktop_dbus_object_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType free_desktop_dbus_object_type_id;
		free_desktop_dbus_object_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreeDesktopDBusObject", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (free_desktop_dbus_object_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&free_desktop_dbus_object_type_id__volatile, free_desktop_dbus_object_type_id);
	}
	return free_desktop_dbus_object_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (FreeDesktopDBusObjectProxy, free_desktop_dbus_object_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (FREE_DESKTOP_TYPE_DBUS_OBJECT, free_desktop_dbus_object_proxy_free_desktop_dbus_object_interface_init) );
static void free_desktop_dbus_object_proxy_class_init (FreeDesktopDBusObjectProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = free_desktop_dbus_object_proxy_g_signal;
}


static void _dbus_handle_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* self, GVariant* parameters) {
	char* name = NULL;
	GVariant* _tmp0_;
	char* old_owner = NULL;
	GVariant* _tmp1_;
	char* new_owner = NULL;
	GVariant* _tmp2_;
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	old_owner = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	new_owner = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	g_signal_emit_by_name (self, "name-owner-changed", name, old_owner, new_owner);
	_g_free0 (name);
	_g_free0 (old_owner);
	_g_free0 (new_owner);
}


static void free_desktop_dbus_object_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "NameOwnerChanged") == 0) {
		_dbus_handle_free_desktop_dbus_object_name_owner_changed (proxy, parameters);
	}
}


static void free_desktop_dbus_object_proxy_init (FreeDesktopDBusObjectProxy* self) {
}


static guint32 free_desktop_dbus_object_proxy_request_name (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error) {
	GVariant *_arguments, *_reply;
	GVariantBuilder _arguments_builder;
	GVariantIter _reply_iter;
	guint32 _result;
	GVariant* _tmp3_;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.RequestName", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, error);
	if (!_reply) {
		return 0U;
	}
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp3_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	g_variant_unref (_reply);
	return _result;
}


static guint32 free_desktop_dbus_object_proxy_start_service_by_name (FreeDesktopDBusObject* self, const char* name, guint32 flags, GError** error) {
	GVariant *_arguments, *_reply;
	GVariantBuilder _arguments_builder;
	GVariantIter _reply_iter;
	guint32 _result;
	GVariant* _tmp4_;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.StartServiceByName", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, error);
	if (!_reply) {
		return 0U;
	}
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp4_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	g_variant_unref (_reply);
	return _result;
}


static void free_desktop_dbus_object_proxy_list_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_proxy_call ((GDBusProxy *) self, "org.freedesktop.DBus.ListNames", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, _callback_, _user_data_);
}


static char** free_desktop_dbus_object_proxy_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GVariant *_reply;
	GVariantIter _reply_iter;
	char** _result;
	int _result_length1;
	GVariant* _tmp9_;
	char** _tmp10_;
	int _tmp10__length;
	int _tmp10__size;
	int _tmp10__length1;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	_reply = g_dbus_proxy_call_finish ((GDBusProxy *) self, _res_, error);
	if (!_reply) {
		return NULL;
	}
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp9_ = g_variant_iter_next_value (&_reply_iter);
	_tmp10_ = g_new (char*, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	g_variant_iter_init (&_tmp11_, _tmp9_);
	for (; _tmp12_ = g_variant_iter_next_value (&_tmp11_); _tmp10__length1++) {
		if (_tmp10__size == _tmp10__length) {
			_tmp10__size = 2 * _tmp10__size;
			_tmp10_ = g_renew (char*, _tmp10_, _tmp10__size + 1);
		}
		_tmp10_[_tmp10__length++] = g_variant_dup_string (_tmp12_, NULL);
		g_variant_unref (_tmp12_);
	}
	_result_length1 = _tmp10__length1;
	_tmp10_[_tmp10__length] = NULL;
	_result = _tmp10_;
	g_variant_unref (_tmp9_);
	*result_length1 = _result_length1;
	g_variant_unref (_reply);
	return _result;
}


static void free_desktop_dbus_object_proxy_list_activatable_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_proxy_call ((GDBusProxy *) self, "org.freedesktop.DBus.ListActivatableNames", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, _callback_, _user_data_);
}


static char** free_desktop_dbus_object_proxy_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GVariant *_reply;
	GVariantIter _reply_iter;
	char** _result;
	int _result_length1;
	GVariant* _tmp17_;
	char** _tmp18_;
	int _tmp18__length;
	int _tmp18__size;
	int _tmp18__length1;
	GVariantIter _tmp19_;
	GVariant* _tmp20_;
	_reply = g_dbus_proxy_call_finish ((GDBusProxy *) self, _res_, error);
	if (!_reply) {
		return NULL;
	}
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp17_ = g_variant_iter_next_value (&_reply_iter);
	_tmp18_ = g_new (char*, 5);
	_tmp18__length = 0;
	_tmp18__size = 4;
	_tmp18__length1 = 0;
	g_variant_iter_init (&_tmp19_, _tmp17_);
	for (; _tmp20_ = g_variant_iter_next_value (&_tmp19_); _tmp18__length1++) {
		if (_tmp18__size == _tmp18__length) {
			_tmp18__size = 2 * _tmp18__size;
			_tmp18_ = g_renew (char*, _tmp18_, _tmp18__size + 1);
		}
		_tmp18_[_tmp18__length++] = g_variant_dup_string (_tmp20_, NULL);
		g_variant_unref (_tmp20_);
	}
	_result_length1 = _tmp18__length1;
	_tmp18_[_tmp18__length] = NULL;
	_result = _tmp18_;
	g_variant_unref (_tmp17_);
	*result_length1 = _result_length1;
	g_variant_unref (_reply);
	return _result;
}


static void free_desktop_dbus_object_proxy_free_desktop_dbus_object_interface_init (FreeDesktopDBusObjectIface* iface) {
	iface->request_name = free_desktop_dbus_object_proxy_request_name;
	iface->start_service_by_name = free_desktop_dbus_object_proxy_start_service_by_name;
	iface->list_names = free_desktop_dbus_object_proxy_list_names_async;
	iface->list_names_finish = free_desktop_dbus_object_proxy_list_names_finish;
	iface->list_activatable_names = free_desktop_dbus_object_proxy_list_activatable_names_async;
	iface->list_activatable_names_finish = free_desktop_dbus_object_proxy_list_activatable_names_finish;
}


static void _dbus_free_desktop_dbus_object_request_name (FreeDesktopDBusObject* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error;
	char* name = NULL;
	GVariant* _tmp21_;
	guint32 flags = 0U;
	GVariant* _tmp22_;
	guint32 result;
	GVariantIter _arguments_iter;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	error = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp22_);
	g_variant_unref (_tmp22_);
	result = free_desktop_dbus_object_request_name (self, name, flags, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_g_free0 (name);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_method_invocation_return_value (invocation, _reply);
}


static void _dbus_free_desktop_dbus_object_start_service_by_name (FreeDesktopDBusObject* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error;
	char* name = NULL;
	GVariant* _tmp23_;
	guint32 flags = 0U;
	GVariant* _tmp24_;
	guint32 result;
	GVariantIter _arguments_iter;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	error = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp24_);
	g_variant_unref (_tmp24_);
	result = free_desktop_dbus_object_start_service_by_name (self, name, flags, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_g_free0 (name);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_method_invocation_return_value (invocation, _reply);
}


static void _dbus_free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	free_desktop_dbus_object_list_names (self, (GAsyncReadyCallback) _dbus_free_desktop_dbus_object_list_names_ready, g_object_ref (invocation));
}


static void _dbus_free_desktop_dbus_object_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error;
	char** result;
	int result_length1;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char** _tmp25_;
	GVariantBuilder _tmp26_;
	int _tmp27_;
	invocation = _user_data_;
	error = NULL;
	result_length1 = 0;
	result = free_desktop_dbus_object_list_names_finish ((FreeDesktopDBusObject*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp25_ = result;
	g_variant_builder_init (&_tmp26_, G_VARIANT_TYPE_ARRAY);
	for (_tmp27_ = 0; _tmp27_ < result_length1; _tmp27_++) {
		g_variant_builder_add_value (&_tmp26_, g_variant_new_string (*_tmp25_));
		_tmp25_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp26_));
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_method_invocation_return_value (invocation, _reply);
	g_object_unref (invocation);
	g_variant_unref (_reply);
}


static void _dbus_free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	free_desktop_dbus_object_list_activatable_names (self, (GAsyncReadyCallback) _dbus_free_desktop_dbus_object_list_activatable_names_ready, g_object_ref (invocation));
}


static void _dbus_free_desktop_dbus_object_list_activatable_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error;
	char** result;
	int result_length1;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char** _tmp28_;
	GVariantBuilder _tmp29_;
	int _tmp30_;
	invocation = _user_data_;
	error = NULL;
	result_length1 = 0;
	result = free_desktop_dbus_object_list_activatable_names_finish ((FreeDesktopDBusObject*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp28_ = result;
	g_variant_builder_init (&_tmp29_, G_VARIANT_TYPE_ARRAY);
	for (_tmp30_ = 0; _tmp30_ < result_length1; _tmp30_++) {
		g_variant_builder_add_value (&_tmp29_, g_variant_new_string (*_tmp28_));
		_tmp28_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp29_));
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_method_invocation_return_value (invocation, _reply);
	g_object_unref (invocation);
	g_variant_unref (_reply);
}


static void free_desktop_dbus_object_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "RequestName") == 0) {
		_dbus_free_desktop_dbus_object_request_name (object, parameters, invocation);
	} else if (strcmp (method_name, "StartServiceByName") == 0) {
		_dbus_free_desktop_dbus_object_start_service_by_name (object, parameters, invocation);
	} else if (strcmp (method_name, "ListNames") == 0) {
		_dbus_free_desktop_dbus_object_list_names (object, parameters, invocation);
	} else if (strcmp (method_name, "ListActivatableNames") == 0) {
		_dbus_free_desktop_dbus_object_list_activatable_names (object, parameters, invocation);
	}
}


static GVariant* free_desktop_dbus_object_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean free_desktop_dbus_object_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_free_desktop_dbus_object_name_owner_changed (GObject* _sender, const char* name, const char* old_owner, const char* new_owner, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (old_owner));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_owner));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameOwnerChanged", _arguments, NULL);
}


guint free_desktop_dbus_object_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, &_free_desktop_dbus_object_dbus_interface_info, &_free_desktop_dbus_object_dbus_interface_vtable, data, _free_desktop_dbus_object_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_free_desktop_dbus_object_name_owner_changed, data);
	return result;
}


static void _free_desktop_dbus_object_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


#line 26 "rygel-volume.vala"
void free_desktop_properties_get_all (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 26 "rygel-volume.vala"
	FREE_DESKTOP_PROPERTIES_GET_INTERFACE (self)->get_all (self, iface, _callback_, _user_data_);
#line 696 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
GHashTable* free_desktop_properties_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error) {
#line 26 "rygel-volume.vala"
	return FREE_DESKTOP_PROPERTIES_GET_INTERFACE (self)->get_all_finish (self, _res_, error);
#line 704 "rygel-free-desktop-interfaces.c"
}


static void free_desktop_properties_base_init (FreeDesktopPropertiesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("properties_changed", FREE_DESKTOP_TYPE_PROPERTIES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_HASH_TABLE, G_TYPE_STRV, G_TYPE_INT);
	}
}


GType free_desktop_properties_get_type (void) {
	static volatile gsize free_desktop_properties_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FreeDesktopPropertiesIface), (GBaseInitFunc) free_desktop_properties_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType free_desktop_properties_type_id;
		free_desktop_properties_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreeDesktopProperties", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (free_desktop_properties_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&free_desktop_properties_type_id__volatile, free_desktop_properties_type_id);
	}
	return free_desktop_properties_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (FreeDesktopPropertiesProxy, free_desktop_properties_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (FREE_DESKTOP_TYPE_PROPERTIES, free_desktop_properties_proxy_free_desktop_properties_interface_init) );
static void free_desktop_properties_proxy_class_init (FreeDesktopPropertiesProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = free_desktop_properties_proxy_g_signal;
}


static void _dbus_handle_free_desktop_properties_properties_changed (FreeDesktopProperties* self, GVariant* parameters) {
	char* iface = NULL;
	GVariant* _tmp31_;
	GHashTable* changed = NULL;
	GVariant* _tmp32_;
	GHashTable* _tmp33_;
	GVariantIter _tmp34_;
	GVariant* _tmp35_;
	GVariant* _tmp36_;
	char** invalidated = NULL;
	int invalidated_length1;
	GVariant* _tmp37_;
	char** _tmp38_;
	int _tmp38__length;
	int _tmp38__size;
	int _tmp38__length1;
	GVariantIter _tmp39_;
	GVariant* _tmp40_;
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	iface = g_variant_dup_string (_tmp31_, NULL);
	g_variant_unref (_tmp31_);
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp33_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp34_, _tmp32_);
	while (g_variant_iter_loop (&_tmp34_, "{?*}", &_tmp35_, &_tmp36_)) {
		g_hash_table_insert (_tmp33_, g_variant_dup_string (_tmp35_, NULL), g_variant_get_variant (_tmp36_));
	}
	changed = _tmp33_;
	g_variant_unref (_tmp32_);
	invalidated_length1 = 0;
	_tmp37_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp38_ = g_new (char*, 5);
	_tmp38__length = 0;
	_tmp38__size = 4;
	_tmp38__length1 = 0;
	g_variant_iter_init (&_tmp39_, _tmp37_);
	for (; _tmp40_ = g_variant_iter_next_value (&_tmp39_); _tmp38__length1++) {
		if (_tmp38__size == _tmp38__length) {
			_tmp38__size = 2 * _tmp38__size;
			_tmp38_ = g_renew (char*, _tmp38_, _tmp38__size + 1);
		}
		_tmp38_[_tmp38__length++] = g_variant_dup_string (_tmp40_, NULL);
		g_variant_unref (_tmp40_);
	}
	invalidated_length1 = _tmp38__length1;
	_tmp38_[_tmp38__length] = NULL;
	invalidated = _tmp38_;
	g_variant_unref (_tmp37_);
	g_signal_emit_by_name (self, "properties-changed", iface, changed, invalidated, invalidated_length1);
	_g_free0 (iface);
	_g_hash_table_unref0 (changed);
	invalidated = (_vala_array_free (invalidated, invalidated_length1, (GDestroyNotify) g_free), NULL);
}


static void free_desktop_properties_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "PropertiesChanged") == 0) {
		_dbus_handle_free_desktop_properties_properties_changed (proxy, parameters);
	}
}


static void free_desktop_properties_proxy_init (FreeDesktopPropertiesProxy* self) {
}


static void free_desktop_properties_proxy_get_all_async (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (iface));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_proxy_call ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.GetAll", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, _callback_, _user_data_);
}


static GHashTable* free_desktop_properties_proxy_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error) {
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable* _result;
	GVariant* _tmp46_;
	GHashTable* _tmp47_;
	GVariantIter _tmp48_;
	GVariant* _tmp49_;
	GVariant* _tmp50_;
	_reply = g_dbus_proxy_call_finish ((GDBusProxy *) self, _res_, error);
	if (!_reply) {
		return NULL;
	}
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp46_ = g_variant_iter_next_value (&_reply_iter);
	_tmp47_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp48_, _tmp46_);
	while (g_variant_iter_loop (&_tmp48_, "{?*}", &_tmp49_, &_tmp50_)) {
		g_hash_table_insert (_tmp47_, g_variant_dup_string (_tmp49_, NULL), g_variant_get_variant (_tmp50_));
	}
	_result = _tmp47_;
	g_variant_unref (_tmp46_);
	g_variant_unref (_reply);
	return _result;
}


static void free_desktop_properties_proxy_free_desktop_properties_interface_init (FreeDesktopPropertiesIface* iface) {
	iface->get_all = free_desktop_properties_proxy_get_all_async;
	iface->get_all_finish = free_desktop_properties_proxy_get_all_finish;
}


static void _dbus_free_desktop_properties_get_all (FreeDesktopProperties* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	char* iface = NULL;
	GVariant* _tmp51_;
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp51_ = g_variant_iter_next_value (&_arguments_iter);
	iface = g_variant_dup_string (_tmp51_, NULL);
	g_variant_unref (_tmp51_);
	free_desktop_properties_get_all (self, iface, (GAsyncReadyCallback) _dbus_free_desktop_properties_get_all_ready, g_object_ref (invocation));
	_g_free0 (iface);
}


static void _dbus_free_desktop_properties_get_all_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error;
	GHashTable* result;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariantBuilder _tmp52_;
	GHashTableIter _tmp53_;
	gpointer _tmp54_, _tmp55_;
	invocation = _user_data_;
	error = NULL;
	result = free_desktop_properties_get_all_finish ((FreeDesktopProperties*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp53_, result);
	g_variant_builder_init (&_tmp52_, G_VARIANT_TYPE_DICTIONARY);
	while (g_hash_table_iter_next (&_tmp53_, &_tmp54_, &_tmp55_)) {
		char* _key;
		GVariant* _value;
		_key = (char*) _tmp54_;
		_value = (GVariant*) _tmp55_;
		g_variant_builder_add (&_tmp52_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp52_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_method_invocation_return_value (invocation, _reply);
	g_object_unref (invocation);
	g_variant_unref (_reply);
}


static void free_desktop_properties_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetAll") == 0) {
		_dbus_free_desktop_properties_get_all (object, parameters, invocation);
	}
}


static GVariant* free_desktop_properties_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean free_desktop_properties_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_free_desktop_properties_properties_changed (GObject* _sender, const char* iface, GHashTable* changed, char** invalidated, int invalidated_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp56_;
	GHashTableIter _tmp57_;
	gpointer _tmp58_, _tmp59_;
	char** _tmp60_;
	GVariantBuilder _tmp61_;
	int _tmp62_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (iface));
	g_hash_table_iter_init (&_tmp57_, changed);
	g_variant_builder_init (&_tmp56_, G_VARIANT_TYPE_DICTIONARY);
	while (g_hash_table_iter_next (&_tmp57_, &_tmp58_, &_tmp59_)) {
		char* _key;
		GVariant* _value;
		_key = (char*) _tmp58_;
		_value = (GVariant*) _tmp59_;
		g_variant_builder_add (&_tmp56_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp56_));
	_tmp60_ = invalidated;
	g_variant_builder_init (&_tmp61_, G_VARIANT_TYPE_ARRAY);
	for (_tmp62_ = 0; _tmp62_ < invalidated_length1; _tmp62_++) {
		g_variant_builder_add_value (&_tmp61_, g_variant_new_string (*_tmp60_));
		_tmp60_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp61_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus.Properties", "PropertiesChanged", _arguments, NULL);
}


guint free_desktop_properties_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, &_free_desktop_properties_dbus_interface_info, &_free_desktop_properties_dbus_interface_vtable, data, _free_desktop_properties_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "properties-changed", (GCallback) _dbus_free_desktop_properties_properties_changed, data);
	return result;
}


static void _free_desktop_properties_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_BOXED_INT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_boxed (param_values + 3), g_value_get_int (param_values + 4), data2);
}



