#ifndef __GDICT_SPELLER_H_
#define __GDICT_SPELLER_H_

/* $Id: gdict-speller.h,v 1.11 2004/12/13 20:10:20 vnoel Exp $ */

/*
 *  Mike Hughes <mfh@psilord.com>
 *  Papadimitriou Spiros <spapadim@cs.cmu.edu>
 *  Bradford Hovinen <hovinen@udel.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict main window
 *
 */

#include <gtk/gtk.h>
#include "dict.h"
#include "gdict-app.h"

#define GDICT_TYPE_SPELLER            (gdict_speller_get_type ())
#define GDICT_SPELLER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDICT_TYPE_SPELLER, GDictSpeller))
#define GDICT_SPELLER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GDICT_TYPE_SPELLER, GDictSpellerClass))
#define GDICT_IS_SPELLER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDICT_TYPE_SPELLER))
#define GDICT_IS_SPELLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDICT_TYPE_SPELLER))
#define GDICT_SPELLER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GDICT_TYPE_SPELLER, GDictSpellerClass))


typedef struct _GDictSpeller        GDictSpeller;
typedef struct _GDictSpellerClass   GDictSpellerClass;

struct _GDictSpeller {
    GtkVBox      vbox;
    
    dict_context_t *context;
    dict_command_t *spell_cmd;
    gchar          *database;
    gchar          *strat;
    
    GtkWidget      *hbox;
    GtkWidget	   *word_list;
    
    gchar          *current_word;

    GDictWindow    *gdict;
};

struct _GDictSpellerClass {
    GtkVBoxClass  parent_class;
    
    void (*word_lookup_start) (GDictSpeller *);
    void (*word_lookup_done)  (GDictSpeller *);
    void (*word_not_found)    (GDictSpeller *);
    void (*socket_error)      (GDictSpeller *, gchar *);
};

GType      gdict_speller_get_type    (void);
GtkWidget *gdict_speller_new         (GDictWindow *gdict);
gint       gdict_speller_lookup      (GDictWindow *gdict, GDictSpeller *speller, gchar *text);
void       gdict_speller_clear       (GDictSpeller *speller);
void       gdict_speller_reset       (GDictSpeller *speller, dict_context_t *context);
void       gdict_speller_reset_strat (GDictWindow *gdict, GDictSpeller *speller);
void       gdict_speller_change_strategy (GDictSpeller *speller, gchar *new_strategy);
void       gdict_speller_change_db (GDictSpeller *speller, gchar *new_db);

#endif /* __GDICT_SPELLER_H_ */
