/*
 *  Copyright (C) 2002 Jorn Baayen <jorn@nl.linux.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: ephy-node-view.h,v 1.13 2004/10/27 13:58:55 chpe Exp $
 */

#ifndef __EPHY_NODE_VIEW_H
#define __EPHY_NODE_VIEW_H

#include <gtk/gtktreeview.h>
#include <gtk/gtkdnd.h>

#include "ephy-tree-model-node.h"
#include "ephy-node-filter.h"

G_BEGIN_DECLS

#define EPHY_TYPE_NODE_VIEW         (ephy_node_view_get_type ())
#define EPHY_NODE_VIEW(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), EPHY_TYPE_NODE_VIEW, EphyNodeView))
#define EPHY_NODE_VIEW_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), EPHY_TYPE_NODE_VIEW, EphyNodeViewClass))
#define EPHY_IS_NODE_VIEW(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), EPHY_TYPE_NODE_VIEW))
#define EPHY_IS_NODE_VIEW_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), EPHY_TYPE_NODE_VIEW))
#define EPHY_NODE_VIEW_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), EPHY_TYPE_NODE_VIEW, EphyNodeViewClass))

typedef struct EphyNodeViewPrivate EphyNodeViewPrivate;

typedef struct
{
	GtkTreeView parent;

	/*< private >*/
	EphyNodeViewPrivate *priv;
} EphyNodeView;

typedef enum
{
	EPHY_NODE_VIEW_ALL_PRIORITY,
	EPHY_NODE_VIEW_SPECIAL_PRIORITY,
	EPHY_NODE_VIEW_NORMAL_PRIORITY
} EphyNodeViewPriority;

typedef enum
{
	EPHY_NODE_VIEW_SHOW_PRIORITY = 1 << 0,
	EPHY_NODE_VIEW_SORTABLE = 1 << 1,
	EPHY_NODE_VIEW_EDITABLE = 1 << 2,
	EPHY_NODE_VIEW_SEARCHABLE = 1 << 3
} EphyNodeViewFlags;

typedef struct
{
	GtkTreeViewClass parent;

	void (*node_toggled)	    (EphyNodeView *view, EphyNode *node, gboolean checked);
	void (*node_activated)      (EphyNodeView *view, EphyNode *node);
	void (*node_selected)       (EphyNodeView *view, EphyNode *node);
	void (*node_dropped)        (EphyNodeView *view, EphyNode *node, GList *uris);
} EphyNodeViewClass;

GType              ephy_node_view_get_type	      (void);

GtkWidget         *ephy_node_view_new                 (EphyNode *root,
					               EphyNodeFilter *filter);

void	           ephy_node_view_enable_dnd	      (EphyNodeView *view);

void		   ephy_node_view_add_toggle	      (EphyNodeView *view,
						       EphyTreeModelNodeValueFunc value_func,
						       gpointer data);

GtkTreeViewColumn *ephy_node_view_add_column	      (EphyNodeView *view,
						       const char  *title,
						       GType value_type,
						       guint prop_id,
						       EphyNodeViewFlags flags,
						       EphyTreeModelNodeValueFunc icon_func);

int		   ephy_node_view_add_data_column     (EphyNodeView *view,
			                               GType value_type,
						       guint prop_id,
			                               EphyTreeModelNodeValueFunc func,
						       gpointer data);

void		   ephy_node_view_set_sort            (EphyNodeView *view,
			                               GType value_type,
						       guint prop_id,
						       GtkSortType sort_type);

void		   ephy_node_view_set_priority        (EphyNodeView *view,
						       guint priority_prop_id);

void		   ephy_node_view_remove              (EphyNodeView *view);

gboolean           ephy_node_view_has_selection       (EphyNodeView *view,
						       gboolean *multiple);

GList             *ephy_node_view_get_selection       (EphyNodeView *view);

void	           ephy_node_view_select_node         (EphyNodeView *view,
			                               EphyNode *node);

void	           ephy_node_view_enable_drag_source  (EphyNodeView *view,
						       GtkTargetEntry *types,
						       int n_types,
						       int column_id);

void	           ephy_node_view_enable_drag_dest    (EphyNodeView *view,
						       GtkTargetEntry *types,
						       int n_types);

void		   ephy_node_view_edit		      (EphyNodeView *view,
						       gboolean remove_if_cancelled);

gboolean	   ephy_node_view_is_target	      (EphyNodeView *view);

void		   ephy_node_view_popup		      (EphyNodeView *view,
						       GtkWidget *menu);

G_END_DECLS

#endif /* EPHY_NODE_VIEW_H */
