
#ifndef CD_RECORDER_H
#define CD_RECORDER_H

#include <glib-object.h>
#include "cd-drive.h"

typedef void (*CancelFunc) (gpointer       data);

enum {
	RESULT_ERROR,
	RESULT_CANCEL,
	RESULT_FINISHED,
	RESULT_RETRY
};

typedef enum {
  TRACK_TYPE_AUDIO,
  TRACK_TYPE_DATA
} TrackType;

typedef struct Track Track;

struct Track {
  TrackType type;
  union {
    struct {
      char *filename;
      char *cdtext;
    } audio;
    struct {
      char *filename;
    } data;
  };
};

#define CD_TYPE_RECORDER            (cd_recorder_get_type ())
#define CD_RECORDER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), CD_TYPE_RECORDER, CDRecorder))
#define CD_RECORDER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), CD_TYPE_RECORDER, CDRecorderClass))
#define CD_IS_RECORDER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CD_TYPE_RECORDER))
#define CD_IS_RECORDER_CLASS(klass) (G_TYPE_INSTANCE_GET_CLASS ((klass), CD_TYPE_RECORDER))

typedef struct CDRecorder                CDRecorder;
typedef struct CDRecorderClass           CDRecorderClass;
typedef struct CDRecorderPrivate         CDRecorderPrivate;

struct CDRecorder {
	GObject parent;
	CDRecorderPrivate *priv;
};

struct CDRecorderClass {
	GObjectClass parent_class;

	void (*progress_changed)	(CDRecorder *cdrecorder,
					 gdouble fraction);
	void (*action_changed)		(CDRecorder *cdrecorder,
					 gint index);
	void (*animation_changed)	(CDRecorder *cdrecorder,
					 gboolean spinning);
	void (*cancel_func_changed)	(CDRecorder *cdrecorder,
					 CancelFunc  cancel_func,
					 gboolean    cancel_dangerous);
	void (*insert_cd_request)	(CDRecorder *cdrecorder,
					 gboolean is_reload);
	void (*insert_cd_rw_request)	(CDRecorder *cdrecorder,
					 gboolean is_reload);
};

GType		cd_recorder_get_type		(void);
CDRecorder     *cd_recorder_new			(void);

GList	       *cd_recorder_list_actions	(CDRecorder *cdrecorder);

int		cd_recorder_write_tracks		(CDRecorder *cdrecorder,
						 CDDrive *recorder,
						 GList *tracks,
						 gint speed,
						 gboolean eject,
						 gboolean blank,
						 gboolean dummy_write,
						 gboolean disc_at_once);

const char*	cd_recorder_get_error_message	(CDRecorder *cdrecorder);
const char*	cd_recorder_get_error_message_details
						(CDRecorder *cdrecorder);
void		cd_recorder_insert_cd_retry	(CDRecorder *cdrecorder,
						 gboolean is_reload);

#endif /* CD_RECORDER_H */
