import time
import threading


class _Poller:

    #
    # A timeout value of 0 means that the data will be polled only once.
    #
    def __init__(self, poller, timeout, args):

        self.__poller = poller
        self.__timeout = timeout
        self.__next_poll = 0
        self.__value = None
        self.__args = args

        self.__no_more_polls = 0
        self.__lock = threading.Lock()



    def poll(self, *args):

        t = time.time()
        if (t >= self.__next_poll and not self.__no_more_polls):
            try:
                self.__lock.acquire()
                self.__value = apply(self.__poller, list(args) +
                                     list(self.__args))
                self.__lock.release()
                
            except StandardError, e:
                import traceback; traceback.print_exc()
                print e

            if (self.__timeout == 0):
                self.__no_more_polls = 1
            else:
                self.__next_poll = t + self.__timeout                

        time.sleep(0.01)
        return self.__value




#
# Wraps the given polling function and adds caching and thread safety.
#
def wrap(poller, timeout, *args):

    f = _Poller(poller, timeout, args)
    return f.poll
