import polling
import glibtop

import os, stat


class Memory:

    def __init__(self):

        self.get_ram         = polling.wrap(self.__poll_mem, 0.5, 0)
        self.get_swap        = polling.wrap(self.__poll_mem, 0.5, 1)



    def __poll_mem(self, mode):

        # RAM
        if (mode == 0):
            total, used, free = glibtop.get_mem()[:3]

        # Swap
        elif (mode == 1):
            total, used, free = glibtop.get_swap()[:3]

        return (total / 1024, used / 1024)
