/* rygel-media-export-media-cache.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <rygel.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
typedef struct _Block6Data Block6Data;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
typedef struct _Block7Data Block7Data;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef gboolean (*RygelMediaExportDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA
} RygelMediaExportSQLString;

typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE
} RygelMediaExportDetailColumn;

struct _Block2Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	RygelMediaObject* parent;
};

struct _Block3Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gint count;
};

struct _Block4Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gboolean exists;
	gint64 tmp_timestamp;
	gint64 tmp_size;
};

struct _Block5Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	RygelMediaObjects* children;
	RygelMediaContainer* container;
};

struct _Block6Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	glong count;
};

struct _Block7Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	RygelMediaObjects* children;
	RygelMediaContainer* parent;
};

struct _Block8Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gint rows;
};

struct _Block9Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* children;
};

struct _Block10Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* data;
};

struct _Block11Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* uris;
};


static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;
static gpointer rygel_media_export_media_cache_parent_class = NULL;

GQuark rygel_media_export_media_cache_error_quark (void);
GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
char* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error);
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const char* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const char* object_id, GError** error);
static gboolean _lambda3_ (sqlite3_stmt* statement, Block2Data* _data2_);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement);
GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST;
static gboolean __lambda3__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
RygelMediaItem* rygel_media_export_media_cache_get_item (RygelMediaExportMediaCache* self, const char* item_id, GError** error);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
static gboolean _lambda4_ (sqlite3_stmt* statement, Block3Data* _data3_);
static gboolean __lambda4__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
static gboolean _lambda5_ (sqlite3_stmt* statement, Block4Data* _data4_);
static gboolean __lambda5__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, glong offset, glong max_count, GError** error);
static gboolean _lambda6_ (sqlite3_stmt* statement, Block5Data* _data5_);
static gboolean __lambda6__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, guint* total_matches, GError** error);
static char* rygel_media_export_media_cache_translate_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, const char* prefix, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, GError** error);
static gboolean _lambda0_ (sqlite3_stmt* statement, Block6Data* _data6_);
static gboolean __lambda0__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static gboolean _lambda2_ (sqlite3_stmt* statement, Block7Data* _data7_);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
static gboolean __lambda2__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const char* name, GError** error);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
RygelMediaExportDatabase* rygel_media_export_database_new (const char* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const char* name, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version "10"
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
static gboolean _lambda11_ (sqlite3_stmt* statement, Block8Data* _data8_);
static gboolean __lambda11__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
void rygel_media_export_database_null (GValue* result);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
RygelMediaContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const char* id, const char* title, guint child_count);
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
static gboolean _lambda12_ (sqlite3_stmt* statement, Block9Data* _data9_);
static gboolean __lambda12__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static char* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error);
static char* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error);
static char* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error);
static char* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const char* operand, GError** error);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const char* column, const char* filter, GValueArray* args, glong offset, glong max_count, GError** error);
static gboolean _lambda1_ (sqlite3_stmt* statement, Block10Data* _data10_);
static gboolean __lambda1__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const char* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const char* flag, GError** error);
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const char* flag, GError** error);
static gboolean _lambda13_ (sqlite3_stmt* statement, Block11Data* _data11_);
static gboolean __lambda13__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void rygel_media_export_media_cache_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_media_export_media_cache_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_media_cache_error-quark");
}


GType rygel_media_export_object_type_get_type (void) {
	static volatile gsize rygel_media_export_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
		g_once_init_leave (&rygel_media_export_object_type_type_id__volatile, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__volatile;
}


#line 52 "rygel-media-export-media-cache.vala"
char* rygel_media_export_media_cache_get_id (GFile* file) {
#line 413 "rygel-media-export-media-cache.c"
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
#line 52 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 419 "rygel-media-export-media-cache.c"
	result = (_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_ = g_file_get_uri (file), -1), _g_free0 (_tmp0_), _tmp1_);
#line 53 "rygel-media-export-media-cache.vala"
	return result;
#line 423 "rygel-media-export-media-cache.c"
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


#line 57 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error) {
#line 440 "rygel-media-export-media-cache.c"
	gint values_length1;
	gint _values_size_;
	GValue* _tmp2_;
	GValue _tmp0_ = {0};
	GValue* _tmp1_ = NULL;
	GValue* values;
	GError * _inner_error_ = NULL;
#line 57 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 57 "rygel-media-export-media-cache.vala"
	g_return_if_fail (id != NULL);
#line 452 "rygel-media-export-media-cache.c"
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 59 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE), values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 456 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 62 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
#line 475 "rygel-media-export-media-cache.c"
	GError * _inner_error_ = NULL;
#line 62 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 62 "rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 64 "rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_remove_by_id (self, object->id, &_inner_error_);
#line 483 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


#line 67 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
#line 504 "rygel-media-export-media-cache.c"
	GError * _inner_error_ = NULL;
#line 67 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 67 "rygel-media-export-media-cache.vala"
	g_return_if_fail (container != NULL);
#line 510 "rygel-media-export-media-cache.c"
	{
#line 69 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 514 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch4_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 70 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) container, &_inner_error_);
#line 525 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch4_rygel_media_export_database_error;
			}
			goto __finally4;
		}
#line 71 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 534 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch4_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 73 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 553 "rygel-media-export-media-cache.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				goto __finally4;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 79 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
#line 572 "rygel-media-export-media-cache.c"
	GError * _inner_error_ = NULL;
#line 79 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 79 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 578 "rygel-media-export-media-cache.c"
	{
#line 81 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 582 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch5_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 82 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_metadata (self, item, &_inner_error_);
#line 593 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch5_rygel_media_export_database_error;
			}
			goto __finally5;
		}
#line 83 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) item, &_inner_error_);
#line 602 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch5_rygel_media_export_database_error;
			}
			goto __finally5;
		}
#line 84 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 611 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch5_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally5;
	__catch5_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 86 "rygel-media-export-media-cache.vala"
			g_warning (_ ("Failed to add item with ID %s: %s"), ((RygelMediaObject*) item)->id, _error_->message);
#line 89 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 632 "rygel-media-export-media-cache.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				goto __finally5;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 99 "rygel-media-export-media-cache.vala"
static gboolean _lambda3_ (sqlite3_stmt* statement, Block2Data* _data2_) {
#line 656 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	RygelMediaObject* _tmp0_;
	RygelMediaContainer* parent_container;
	RygelMediaObject* object;
	RygelMediaObject* _tmp1_;
	self = _data2_->self;
#line 99 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 100 "rygel-media-export-media-cache.vala"
	parent_container = _g_object_ref0 ((_tmp0_ = _data2_->parent, RYGEL_IS_MEDIA_CONTAINER (_tmp0_) ? ((RygelMediaContainer*) _tmp0_) : NULL));
#line 101 "rygel-media-export-media-cache.vala"
	object = rygel_media_export_media_cache_get_object_from_statement (self, parent_container, sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID), statement);
#line 105 "rygel-media-export-media-cache.vala"
	rygel_media_object_set_parent_ref (object, parent_container);
#line 106 "rygel-media-export-media-cache.vala"
	_data2_->parent = (_tmp1_ = _g_object_ref0 (object), _g_object_unref0 (_data2_->parent), _tmp1_);
#line 674 "rygel-media-export-media-cache.c"
	result = TRUE;
	_g_object_unref0 (object);
	_g_object_unref0 (parent_container);
#line 108 "rygel-media-export-media-cache.vala"
	return result;
#line 680 "rygel-media-export-media-cache.c"
}


#line 99 "rygel-media-export-media-cache.vala"
static gboolean __lambda3__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 686 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda3_ (stmt, self);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->parent);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 95 "rygel-media-export-media-cache.vala"
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const char* object_id, GError** error) {
#line 710 "rygel-media-export-media-cache.c"
	RygelMediaObject* result = NULL;
	Block2Data* _data2_;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp2_;
	GValue _tmp0_ = {0};
	GValue* _tmp1_ = NULL;
	GValue* values;
	void* cb_target = NULL;
	GDestroyNotify cb_target_destroy_notify = NULL;
	RygelMediaExportDatabaseRowCallback _tmp3_;
	RygelMediaExportDatabaseRowCallback cb;
	GError * _inner_error_ = NULL;
#line 95 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 728 "rygel-media-export-media-cache.c"
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
	_data2_->parent = NULL;
	cb = (_tmp3_ = __lambda3__rygel_media_export_database_row_callback, cb_target = block2_data_ref (_data2_), cb_target_destroy_notify = block2_data_unref, _tmp3_);
#line 111 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT), values, values_length1, cb, cb_target, NULL, &_inner_error_);
#line 737 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block2_data_unref (_data2_);
			return NULL;
		} else {
			(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block2_data_unref (_data2_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data2_->parent);
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block2_data_unref (_data2_);
#line 113 "rygel-media-export-media-cache.vala"
	return result;
#line 769 "rygel-media-export-media-cache.c"
}


#line 116 "rygel-media-export-media-cache.vala"
RygelMediaItem* rygel_media_export_media_cache_get_item (RygelMediaExportMediaCache* self, const char* item_id, GError** error) {
#line 775 "rygel-media-export-media-cache.c"
	RygelMediaItem* result = NULL;
	RygelMediaObject* object;
	gboolean _tmp0_ = FALSE;
	RygelMediaObject* _tmp1_;
	GError * _inner_error_ = NULL;
#line 116 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 116 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 118 "rygel-media-export-media-cache.vala"
	object = rygel_media_export_media_cache_get_object (self, item_id, &_inner_error_);
#line 787 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 119 "rygel-media-export-media-cache.vala"
	if (object != NULL) {
#line 119 "rygel-media-export-media-cache.vala"
		_tmp0_ = !RYGEL_IS_MEDIA_ITEM (object);
#line 802 "rygel-media-export-media-cache.c"
	} else {
#line 119 "rygel-media-export-media-cache.vala"
		_tmp0_ = FALSE;
#line 806 "rygel-media-export-media-cache.c"
	}
#line 119 "rygel-media-export-media-cache.vala"
	if (_tmp0_) {
#line 810 "rygel-media-export-media-cache.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, _ ("Object %s is not an item"), item_id);
		{
			if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (object);
				return NULL;
			} else {
				_g_object_unref0 (object);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 ((_tmp1_ = object, RYGEL_IS_MEDIA_ITEM (_tmp1_) ? ((RygelMediaItem*) _tmp1_) : NULL));
	_g_object_unref0 (object);
#line 125 "rygel-media-export-media-cache.vala"
	return result;
#line 829 "rygel-media-export-media-cache.c"
	_g_object_unref0 (object);
}


#line 128 "rygel-media-export-media-cache.vala"
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const char* container_id, GError** error) {
#line 836 "rygel-media-export-media-cache.c"
	RygelMediaContainer* result = NULL;
	RygelMediaObject* object;
	gboolean _tmp0_ = FALSE;
	RygelMediaObject* _tmp1_;
	GError * _inner_error_ = NULL;
#line 128 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 128 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 131 "rygel-media-export-media-cache.vala"
	object = rygel_media_export_media_cache_get_object (self, container_id, &_inner_error_);
#line 848 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 132 "rygel-media-export-media-cache.vala"
	if (object != NULL) {
#line 132 "rygel-media-export-media-cache.vala"
		_tmp0_ = !RYGEL_IS_MEDIA_CONTAINER (object);
#line 863 "rygel-media-export-media-cache.c"
	} else {
#line 132 "rygel-media-export-media-cache.vala"
		_tmp0_ = FALSE;
#line 867 "rygel-media-export-media-cache.c"
	}
#line 132 "rygel-media-export-media-cache.vala"
	if (_tmp0_) {
#line 871 "rygel-media-export-media-cache.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", container_id);
		{
			if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (object);
				return NULL;
			} else {
				_g_object_unref0 (object);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 ((_tmp1_ = object, RYGEL_IS_MEDIA_CONTAINER (_tmp1_) ? ((RygelMediaContainer*) _tmp1_) : NULL));
	_g_object_unref0 (object);
#line 138 "rygel-media-export-media-cache.vala"
	return result;
#line 890 "rygel-media-export-media-cache.c"
	_g_object_unref0 (object);
}


#line 147 "rygel-media-export-media-cache.vala"
static gboolean _lambda4_ (sqlite3_stmt* statement, Block3Data* _data3_) {
#line 897 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data3_->self;
#line 147 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 148 "rygel-media-export-media-cache.vala"
	_data3_->count = sqlite3_column_int (statement, 0);
#line 905 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 150 "rygel-media-export-media-cache.vala"
	return result;
#line 909 "rygel-media-export-media-cache.c"
}


#line 147 "rygel-media-export-media-cache.vala"
static gboolean __lambda4__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 915 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda4_ (stmt, self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


#line 141 "rygel-media-export-media-cache.vala"
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const char* container_id, GError** error) {
#line 938 "rygel-media-export-media-cache.c"
	gint result = 0;
	Block3Data* _data3_;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp2_;
	GValue _tmp0_ = {0};
	GValue* _tmp1_ = NULL;
	GValue* values;
	GError * _inner_error_ = NULL;
#line 141 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 141 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0);
#line 952 "rygel-media-export-media-cache.c"
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->count = 0;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 145 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT), values, values_length1, __lambda4__rygel_media_export_database_row_callback, _data3_, NULL, &_inner_error_);
#line 960 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block3_data_unref (_data3_);
			return 0;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block3_data_unref (_data3_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _data3_->count;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block3_data_unref (_data3_);
#line 153 "rygel-media-export-media-cache.vala"
	return result;
#line 980 "rygel-media-export-media-cache.c"
}


#line 166 "rygel-media-export-media-cache.vala"
static gboolean _lambda5_ (sqlite3_stmt* statement, Block4Data* _data4_) {
#line 986 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data4_->self;
#line 166 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 167 "rygel-media-export-media-cache.vala"
	_data4_->exists = sqlite3_column_int (statement, 0) == 1;
#line 168 "rygel-media-export-media-cache.vala"
	_data4_->tmp_timestamp = sqlite3_column_int64 (statement, 1);
#line 169 "rygel-media-export-media-cache.vala"
	_data4_->tmp_size = sqlite3_column_int64 (statement, 2);
#line 998 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 171 "rygel-media-export-media-cache.vala"
	return result;
#line 1002 "rygel-media-export-media-cache.c"
}


#line 166 "rygel-media-export-media-cache.vala"
static gboolean __lambda5__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1008 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda5_ (stmt, self);
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		g_slice_free (Block4Data, _data4_);
	}
}


#line 156 "rygel-media-export-media-cache.vala"
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error) {
#line 1031 "rygel-media-export-media-cache.c"
	gboolean result = FALSE;
	Block4Data* _data4_;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp2_;
	GValue _tmp0_ = {0};
	GValue* _tmp1_ = NULL;
	GValue* values;
	GError * _inner_error_ = NULL;
#line 156 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 156 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 1045 "rygel-media-export-media-cache.c"
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->exists = FALSE;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_take_string (&_tmp0_, g_file_get_uri (file)), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
	_data4_->tmp_timestamp = (gint64) 0;
	_data4_->tmp_size = (gint64) 0;
#line 164 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS), values, values_length1, __lambda5__rygel_media_export_database_row_callback, _data4_, NULL, &_inner_error_);
#line 1055 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block4_data_unref (_data4_);
			return FALSE;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block4_data_unref (_data4_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
#line 175 "rygel-media-export-media-cache.vala"
	*timestamp = _data4_->tmp_timestamp;
#line 176 "rygel-media-export-media-cache.vala"
	*size = _data4_->tmp_size;
#line 1074 "rygel-media-export-media-cache.c"
	result = _data4_->exists;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block4_data_unref (_data4_);
#line 178 "rygel-media-export-media-cache.vala"
	return result;
#line 1080 "rygel-media-export-media-cache.c"
}


#line 190 "rygel-media-export-media-cache.vala"
static gboolean _lambda6_ (sqlite3_stmt* statement, Block5Data* _data5_) {
#line 1086 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	char* child_id;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	self = _data5_->self;
#line 190 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 191 "rygel-media-export-media-cache.vala"
	child_id = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID));
#line 192 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data5_->children, _tmp0_ = rygel_media_export_media_cache_get_object_from_statement (self, _data5_->container, child_id, statement));
#line 1099 "rygel-media-export-media-cache.c"
	_g_object_unref0 (_tmp0_);
#line 195 "rygel-media-export-media-cache.vala"
	rygel_media_object_set_parent_ref (_tmp1_ = (RygelMediaObject*) gee_abstract_list_last ((GeeAbstractList*) _data5_->children), _data5_->container);
#line 1103 "rygel-media-export-media-cache.c"
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	_g_free0 (child_id);
#line 197 "rygel-media-export-media-cache.vala"
	return result;
#line 1109 "rygel-media-export-media-cache.c"
}


#line 190 "rygel-media-export-media-cache.vala"
static gboolean __lambda6__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1115 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda6_ (stmt, self);
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->children);
		_g_object_unref0 (_data5_->container);
		g_slice_free (Block5Data, _data5_);
	}
}


#line 181 "rygel-media-export-media-cache.vala"
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, glong offset, glong max_count, GError** error) {
#line 1140 "rygel-media-export-media-cache.c"
	RygelMediaObjects* result = NULL;
	Block5Data* _data5_;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp4_;
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue* _tmp3_ = NULL;
	GValue* values;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	RygelMediaExportDatabaseRowCallback _tmp5_;
	RygelMediaExportDatabaseRowCallback callback;
	GError * _inner_error_ = NULL;
#line 181 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 1160 "rygel-media-export-media-cache.c"
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->container = _g_object_ref0 (container);
	_data5_->children = rygel_media_objects_new ();
	values = (_tmp4_ = (_tmp3_ = g_new0 (GValue, 3), _tmp3_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, ((RygelMediaObject*) _data5_->container)->id), _tmp0_), _tmp3_[1] = (g_value_init (&_tmp1_, G_TYPE_INT64), g_value_set_int64 (&_tmp1_, (gint64) offset), _tmp1_), _tmp3_[2] = (g_value_init (&_tmp2_, G_TYPE_INT64), g_value_set_int64 (&_tmp2_, (gint64) max_count), _tmp2_), _tmp3_), values_length1 = 3, _values_size_ = values_length1, _tmp4_);
	callback = (_tmp5_ = __lambda6__rygel_media_export_database_row_callback, callback_target = block5_data_ref (_data5_), callback_target_destroy_notify = block5_data_unref, _tmp5_);
#line 200 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN), values, values_length1, callback, callback_target, NULL, &_inner_error_);
#line 1170 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		block5_data_unref (_data5_);
		return NULL;
	}
	result = _g_object_ref0 (_data5_->children);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block5_data_unref (_data5_);
#line 204 "rygel-media-export-media-cache.vala"
	return result;
#line 1190 "rygel-media-export-media-cache.c"
}


#line 207 "rygel-media-export-media-cache.vala"
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
#line 1196 "rygel-media-export-media-cache.c"
	guint result = 0U;
#line 207 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 208 "rygel-media-export-media-cache.vala"
	if (max_count == 0) {
#line 1202 "rygel-media-export-media-cache.c"
		result = (guint) (-1);
#line 209 "rygel-media-export-media-cache.vala"
		return result;
#line 1206 "rygel-media-export-media-cache.c"
	} else {
		result = max_count;
#line 211 "rygel-media-export-media-cache.vala"
		return result;
#line 1211 "rygel-media-export-media-cache.c"
	}
}


#line 215 "rygel-media-export-media-cache.vala"
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, guint* total_matches, GError** error) {
#line 1218 "rygel-media-export-media-cache.c"
	RygelMediaObjects* result = NULL;
	GValueArray* args;
	char* filter;
	guint max_objects;
	glong _tmp2_;
	RygelMediaObjects* _tmp3_;
	GError * _inner_error_ = NULL;
#line 215 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 215 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 222 "rygel-media-export-media-cache.vala"
	args = g_value_array_new ((guint) 0);
#line 223 "rygel-media-export-media-cache.vala"
	filter = rygel_media_export_media_cache_translate_search_expression (self, expression, args, "WHERE", &_inner_error_);
#line 1234 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
#line 225 "rygel-media-export-media-cache.vala"
	if (expression != NULL) {
#line 1242 "rygel-media-export-media-cache.c"
		char* _tmp0_;
#line 226 "rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:226: Original search: %s", _tmp0_ = rygel_search_expression_to_string (expression));
#line 1246 "rygel-media-export-media-cache.c"
		_g_free0 (_tmp0_);
#line 227 "rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:227: Parsed search expression: %s", filter);
#line 1250 "rygel-media-export-media-cache.c"
	}
	{
		gint i;
#line 230 "rygel-media-export-media-cache.vala"
		i = 0;
#line 1256 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp1_;
#line 230 "rygel-media-export-media-cache.vala"
			_tmp1_ = TRUE;
#line 230 "rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 230 "rygel-media-export-media-cache.vala"
				if (!_tmp1_) {
#line 230 "rygel-media-export-media-cache.vala"
					i++;
#line 1267 "rygel-media-export-media-cache.c"
				}
#line 230 "rygel-media-export-media-cache.vala"
				_tmp1_ = FALSE;
#line 230 "rygel-media-export-media-cache.vala"
				if (!(i < args->n_values)) {
#line 230 "rygel-media-export-media-cache.vala"
					break;
#line 1275 "rygel-media-export-media-cache.c"
				}
#line 231 "rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:231: Arg %d: %s", i, g_value_get_string (g_value_array_get_nth (args, (guint) i)));
#line 1279 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 234 "rygel-media-export-media-cache.vala"
	max_objects = rygel_media_export_media_cache_modify_limit (self, max_count);
#line 235 "rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_export_media_cache_get_object_count_by_filter (self, filter, args, container_id, &_inner_error_);
#line 1287 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
#line 235 "rygel-media-export-media-cache.vala"
	*total_matches = (guint) _tmp2_;
#line 239 "rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_get_objects_by_filter (self, filter, args, container_id, (glong) offset, (glong) max_objects, &_inner_error_);
#line 1298 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	result = _tmp3_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
#line 239 "rygel-media-export-media-cache.vala"
	return result;
#line 1310 "rygel-media-export-media-cache.c"
}


#line 246 "rygel-media-export-media-cache.vala"
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, GError** error) {
#line 1316 "rygel-media-export-media-cache.c"
	glong result = 0L;
	GValueArray* args;
	char* filter;
	glong _tmp2_;
	GError * _inner_error_ = NULL;
#line 246 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 246 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0L);
#line 250 "rygel-media-export-media-cache.vala"
	args = g_value_array_new ((guint) 0);
#line 251 "rygel-media-export-media-cache.vala"
	filter = rygel_media_export_media_cache_translate_search_expression (self, expression, args, "WHERE", &_inner_error_);
#line 1330 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return 0L;
	}
#line 253 "rygel-media-export-media-cache.vala"
	if (expression != NULL) {
#line 1338 "rygel-media-export-media-cache.c"
		char* _tmp0_;
#line 254 "rygel-media-export-media-cache.vala"
		g_debug (_ ("Original search: %s"), _tmp0_ = rygel_search_expression_to_string (expression));
#line 1342 "rygel-media-export-media-cache.c"
		_g_free0 (_tmp0_);
#line 255 "rygel-media-export-media-cache.vala"
		g_debug (_ ("Parsed search expression: %s"), filter);
#line 1346 "rygel-media-export-media-cache.c"
	}
	{
		gint i;
#line 258 "rygel-media-export-media-cache.vala"
		i = 0;
#line 1352 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp1_;
#line 258 "rygel-media-export-media-cache.vala"
			_tmp1_ = TRUE;
#line 258 "rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 258 "rygel-media-export-media-cache.vala"
				if (!_tmp1_) {
#line 258 "rygel-media-export-media-cache.vala"
					i++;
#line 1363 "rygel-media-export-media-cache.c"
				}
#line 258 "rygel-media-export-media-cache.vala"
				_tmp1_ = FALSE;
#line 258 "rygel-media-export-media-cache.vala"
				if (!(i < args->n_values)) {
#line 258 "rygel-media-export-media-cache.vala"
					break;
#line 1371 "rygel-media-export-media-cache.c"
				}
#line 259 "rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:259: Arg %d: %s", i, g_value_get_string (g_value_array_get_nth (args, (guint) i)));
#line 1375 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 262 "rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_export_media_cache_get_object_count_by_filter (self, filter, args, container_id, &_inner_error_);
#line 1381 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return 0L;
	}
	result = _tmp2_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
#line 262 "rygel-media-export-media-cache.vala"
	return result;
#line 1393 "rygel-media-export-media-cache.c"
}


#line 278 "rygel-media-export-media-cache.vala"
static gboolean _lambda0_ (sqlite3_stmt* statement, Block6Data* _data6_) {
#line 1399 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data6_->self;
#line 278 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 279 "rygel-media-export-media-cache.vala"
	_data6_->count = (glong) sqlite3_column_int (statement, 0);
#line 1407 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 281 "rygel-media-export-media-cache.vala"
	return result;
#line 1411 "rygel-media-export-media-cache.c"
}


#line 278 "rygel-media-export-media-cache.vala"
static gboolean __lambda0__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1417 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda0_ (stmt, self);
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		g_slice_free (Block6Data, _data6_);
	}
}


#line 267 "rygel-media-export-media-cache.vala"
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, GError** error) {
#line 1440 "rygel-media-export-media-cache.c"
	glong result = 0L;
	Block6Data* _data6_;
	GValue _tmp0_ = {0};
	GValue v;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	RygelMediaExportDatabaseRowCallback _tmp1_;
	RygelMediaExportDatabaseRowCallback callback;
	const char* sql;
	char* _tmp2_;
	GError * _inner_error_ = NULL;
#line 267 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 267 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, 0L);
#line 267 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, 0L);
#line 267 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0L);
#line 1460 "rygel-media-export-media-cache.c"
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
#line 272 "rygel-media-export-media-cache.vala"
	v = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_);
#line 273 "rygel-media-export-media-cache.vala"
	g_value_array_prepend (args, &v);
#line 1468 "rygel-media-export-media-cache.c"
	_data6_->count = (glong) 0;
#line 276 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:276: Parameters to bind: %u", args->n_values);
#line 1472 "rygel-media-export-media-cache.c"
	callback = (_tmp1_ = __lambda0__rygel_media_export_database_row_callback, callback_target = block6_data_ref (_data6_), callback_target_destroy_notify = block6_data_unref, _tmp1_);
#line 284 "rygel-media-export-media-cache.vala"
	sql = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER);
#line 287 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, _tmp2_ = g_strdup_printf (sql, filter), args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
#line 1478 "rygel-media-export-media-cache.c"
	_g_free0 (_tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		block6_data_unref (_data6_);
		return 0L;
	}
	result = _data6_->count;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	block6_data_unref (_data6_);
#line 291 "rygel-media-export-media-cache.vala"
	return result;
#line 1499 "rygel-media-export-media-cache.c"
}


#line 310 "rygel-media-export-media-cache.vala"
static gboolean _lambda2_ (sqlite3_stmt* statement, Block7Data* _data7_) {
#line 1505 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	char* child_id;
	char* parent_id;
	GError * _inner_error_ = NULL;
	self = _data7_->self;
#line 310 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 311 "rygel-media-export-media-cache.vala"
	child_id = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID));
#line 312 "rygel-media-export-media-cache.vala"
	parent_id = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT));
#line 1518 "rygel-media-export-media-cache.c"
	{
		gboolean _tmp0_ = FALSE;
#line 314 "rygel-media-export-media-cache.vala"
		if (_data7_->parent == NULL) {
#line 314 "rygel-media-export-media-cache.vala"
			_tmp0_ = TRUE;
#line 1525 "rygel-media-export-media-cache.c"
		} else {
#line 314 "rygel-media-export-media-cache.vala"
			_tmp0_ = _vala_strcmp0 (parent_id, ((RygelMediaObject*) _data7_->parent)->id) != 0;
#line 1529 "rygel-media-export-media-cache.c"
		}
#line 314 "rygel-media-export-media-cache.vala"
		if (_tmp0_) {
#line 1533 "rygel-media-export-media-cache.c"
			RygelMediaContainer* _tmp1_;
			char* _tmp2_;
#line 315 "rygel-media-export-media-cache.vala"
			_data7_->parent = (_tmp1_ = (RygelMediaContainer*) rygel_null_container_new (), _g_object_unref0 (_data7_->parent), _tmp1_);
#line 316 "rygel-media-export-media-cache.vala"
			((RygelMediaObject*) _data7_->parent)->id = (_tmp2_ = g_strdup (parent_id), _g_free0 (((RygelMediaObject*) _data7_->parent)->id), _tmp2_);
#line 1540 "rygel-media-export-media-cache.c"
		}
#line 319 "rygel-media-export-media-cache.vala"
		if (_data7_->parent != NULL) {
#line 1544 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp3_;
			RygelMediaObject* _tmp4_;
#line 320 "rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data7_->children, _tmp3_ = rygel_media_export_media_cache_get_object_from_statement (self, _data7_->parent, child_id, statement));
#line 1549 "rygel-media-export-media-cache.c"
			_g_object_unref0 (_tmp3_);
#line 323 "rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp4_ = (RygelMediaObject*) gee_abstract_list_last ((GeeAbstractList*) _data7_->children), _data7_->parent);
#line 1553 "rygel-media-export-media-cache.c"
			_g_object_unref0 (_tmp4_);
		} else {
#line 325 "rygel-media-export-media-cache.vala"
			g_warning ("Inconsistent database: item %s " "has no parent %s", child_id, parent_id);
#line 1558 "rygel-media-export-media-cache.c"
		}
		result = TRUE;
		_g_free0 (parent_id);
		_g_free0 (child_id);
#line 331 "rygel-media-export-media-cache.vala"
		return result;
#line 1565 "rygel-media-export-media-cache.c"
	}
	goto __finally6;
	__catch6_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 333 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:333: Failed to get parent item: %s", _error_->message);
#line 1576 "rygel-media-export-media-cache.c"
			result = FALSE;
			_g_error_free0 (_error_);
			_g_free0 (parent_id);
			_g_free0 (child_id);
#line 335 "rygel-media-export-media-cache.vala"
			return result;
#line 1583 "rygel-media-export-media-cache.c"
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_free0 (parent_id);
		_g_free0 (child_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (parent_id);
	_g_free0 (child_id);
}


#line 310 "rygel-media-export-media-cache.vala"
static gboolean __lambda2__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1601 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda2_ (stmt, self);
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->parent);
		_g_object_unref0 (_data7_->children);
		g_slice_free (Block7Data, _data7_);
	}
}


#line 295 "rygel-media-export-media-cache.vala"
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error) {
#line 1626 "rygel-media-export-media-cache.c"
	RygelMediaObjects* result = NULL;
	Block7Data* _data7_;
	GValue _tmp0_ = {0};
	GValue v;
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	RygelMediaExportDatabaseRowCallback _tmp3_;
	RygelMediaExportDatabaseRowCallback callback;
	char* sql;
	char* _tmp4_;
	GError * _inner_error_ = NULL;
#line 295 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 295 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 295 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 295 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1648 "rygel-media-export-media-cache.c"
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->children = rygel_media_objects_new ();
#line 302 "rygel-media-export-media-cache.vala"
	v = (g_value_init (&_tmp0_, G_TYPE_LONG), g_value_set_long (&_tmp0_, offset), _tmp0_);
#line 303 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 304 "rygel-media-export-media-cache.vala"
	v = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_LONG), g_value_set_long (&_tmp1_, max_count), _tmp1_), G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp2_);
#line 305 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 1661 "rygel-media-export-media-cache.c"
	_data7_->parent = NULL;
#line 308 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:308: Parameters to bind: %u", args->n_values);
#line 1665 "rygel-media-export-media-cache.c"
	callback = (_tmp3_ = __lambda2__rygel_media_export_database_row_callback, callback_target = block7_data_ref (_data7_), callback_target_destroy_notify = block7_data_unref, _tmp3_);
#line 339 "rygel-media-export-media-cache.vala"
	sql = g_strdup (rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER));
#line 340 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, _tmp4_ = g_strdup_printf (sql, filter), args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
#line 1671 "rygel-media-export-media-cache.c"
	_g_free0 (_tmp4_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sql);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		block7_data_unref (_data7_);
		return NULL;
	}
	result = _g_object_ref0 (_data7_->children);
	_g_free0 (sql);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	block7_data_unref (_data7_);
#line 344 "rygel-media-export-media-cache.vala"
	return result;
#line 1694 "rygel-media-export-media-cache.c"
}


#line 347 "rygel-media-export-media-cache.vala"
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error) {
#line 1700 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache* result = NULL;
	GError * _inner_error_ = NULL;
#line 348 "rygel-media-export-media-cache.vala"
	if (rygel_media_export_media_cache_instance == NULL) {
#line 1705 "rygel-media-export-media-cache.c"
		RygelMediaExportMediaCache* _tmp0_;
		RygelMediaExportMediaCache* _tmp1_;
#line 349 "rygel-media-export-media-cache.vala"
		_tmp0_ = rygel_media_export_media_cache_new (&_inner_error_);
#line 1710 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
#line 349 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_instance = (_tmp1_ = _tmp0_, _g_object_unref0 (rygel_media_export_media_cache_instance), _tmp1_);
#line 1717 "rygel-media-export-media-cache.c"
	}
	result = _g_object_ref0 (rygel_media_export_media_cache_instance);
#line 352 "rygel-media-export-media-cache.vala"
	return result;
#line 1722 "rygel-media-export-media-cache.c"
}


#line 355 "rygel-media-export-media-cache.vala"
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error) {
#line 1728 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	RygelMediaExportSQLFactory* _tmp0_;
	RygelMediaExportObjectFactory* _tmp1_;
	GError * _inner_error_ = NULL;
#line 355 "rygel-media-export-media-cache.vala"
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
#line 356 "rygel-media-export-media-cache.vala"
	self->priv->sql = (_tmp0_ = rygel_media_export_sql_factory_new (), _g_object_unref0 (self->priv->sql), _tmp0_);
#line 357 "rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_open_db (self, "media-export", &_inner_error_);
#line 1739 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 358 "rygel-media-export-media-cache.vala"
	self->priv->factory = (_tmp1_ = rygel_media_export_object_factory_new (), _g_object_unref0 (self->priv->factory), _tmp1_);
#line 1747 "rygel-media-export-media-cache.c"
	return self;
}


#line 355 "rygel-media-export-media-cache.vala"
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error) {
#line 355 "rygel-media-export-media-cache.vala"
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
#line 1756 "rygel-media-export-media-cache.c"
}


#line 390 "rygel-media-export-media-cache.vala"
static gboolean _lambda11_ (sqlite3_stmt* statement, Block8Data* _data8_) {
#line 1762 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data8_->self;
#line 390 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 391 "rygel-media-export-media-cache.vala"
	_data8_->rows = sqlite3_column_int (statement, 0);
#line 1770 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 393 "rygel-media-export-media-cache.vala"
	return result;
#line 1774 "rygel-media-export-media-cache.c"
}


#line 390 "rygel-media-export-media-cache.vala"
static gboolean __lambda11__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1780 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda11_ (stmt, self);
	return result;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		g_slice_free (Block8Data, _data8_);
	}
}


#line 361 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const char* name, GError** error) {
#line 1803 "rygel-media-export-media-cache.c"
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportDatabase* _tmp1_;
	gint old_version;
	gint current_version;
	GError * _inner_error_ = NULL;
#line 361 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 361 "rygel-media-export-media-cache.vala"
	g_return_if_fail (name != NULL);
#line 362 "rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_database_new (name, &_inner_error_);
#line 1815 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 362 "rygel-media-export-media-cache.vala"
	self->priv->db = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->db), _tmp1_);
#line 363 "rygel-media-export-media-cache.vala"
	old_version = -1;
#line 364 "rygel-media-export-media-cache.vala"
	current_version = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
#line 1826 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportMediaCacheUpgrader* upgrader;
		gboolean _tmp2_;
#line 367 "rygel-media-export-media-cache.vala"
		upgrader = rygel_media_export_media_cache_upgrader_new (self->priv->db, self->priv->sql);
#line 368 "rygel-media-export-media-cache.vala"
		_tmp2_ = rygel_media_export_media_cache_upgrader_needs_upgrade (upgrader, &old_version, &_inner_error_);
#line 1834 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch7_rygel_media_export_database_error;
			}
			goto __finally7;
		}
#line 368 "rygel-media-export-media-cache.vala"
		if (_tmp2_) {
#line 369 "rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_upgrader_upgrade (upgrader, old_version);
#line 1846 "rygel-media-export-media-cache.c"
		} else {
#line 370 "rygel-media-export-media-cache.vala"
			if (old_version == current_version) {
#line 371 "rygel-media-export-media-cache.vala"
				rygel_media_export_media_cache_upgrader_fix_schema (upgrader, &_inner_error_);
#line 1852 "rygel-media-export-media-cache.c"
				if (_inner_error_ != NULL) {
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch7_rygel_media_export_database_error;
					}
					goto __finally7;
				}
			} else {
				RygelMediaExportDatabase* _tmp3_;
#line 373 "rygel-media-export-media-cache.vala"
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", old_version, current_version);
#line 377 "rygel-media-export-media-cache.vala"
				self->priv->db = (_tmp3_ = NULL, _g_object_unref0 (self->priv->db), _tmp3_);
#line 1866 "rygel-media-export-media-cache.c"
				_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
				{
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch7_rygel_media_export_database_error;
					}
					goto __finally7;
				}
			}
		}
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
	}
	goto __finally7;
	__catch7_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 383 "rygel-media-export-media-cache.vala"
			g_debug ("rygel-media-export-media-cache.vala:383: %s", "Could not find schema version;" " checking for empty database...");
#line 1888 "rygel-media-export-media-cache.c"
			{
				Block8Data* _data8_;
				_data8_ = g_slice_new0 (Block8Data);
				_data8_->_ref_count_ = 1;
				_data8_->self = g_object_ref (self);
				_data8_->rows = -1;
#line 387 "rygel-media-export-media-cache.vala"
				rygel_media_export_database_exec (self->priv->db, "SELECT count(type) FROM sqlite_master " "WHERE rowid=1", NULL, 0, __lambda11__rygel_media_export_database_row_callback, _data8_, NULL, &_inner_error_);
#line 1897 "rygel-media-export-media-cache.c"
				if (_inner_error_ != NULL) {
					block8_data_unref (_data8_);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch8_rygel_media_export_database_error;
					}
					block8_data_unref (_data8_);
					_g_error_free0 (_error_);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
#line 395 "rygel-media-export-media-cache.vala"
				if (_data8_->rows == 0) {
#line 396 "rygel-media-export-media-cache.vala"
					g_debug ("rygel-media-export-media-cache.vala:396: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
#line 398 "rygel-media-export-media-cache.vala"
					if (!rygel_media_export_media_cache_create_schema (self)) {
#line 1915 "rygel-media-export-media-cache.c"
						RygelMediaExportDatabase* _tmp4_;
#line 399 "rygel-media-export-media-cache.vala"
						self->priv->db = (_tmp4_ = NULL, _g_object_unref0 (self->priv->db), _tmp4_);
#line 1919 "rygel-media-export-media-cache.c"
						block8_data_unref (_data8_);
						_g_error_free0 (_error_);
#line 401 "rygel-media-export-media-cache.vala"
						return;
#line 1924 "rygel-media-export-media-cache.c"
					}
				} else {
					RygelMediaExportDatabase* _tmp5_;
#line 404 "rygel-media-export-media-cache.vala"
					g_warning ("rygel-media-export-media-cache.vala:404: Incompatible schema... cannot" \
" proceed");
#line 405 "rygel-media-export-media-cache.vala"
					self->priv->db = (_tmp5_ = NULL, _g_object_unref0 (self->priv->db), _tmp5_);
#line 1932 "rygel-media-export-media-cache.c"
					block8_data_unref (_data8_);
					_g_error_free0 (_error_);
#line 407 "rygel-media-export-media-cache.vala"
					return;
#line 1937 "rygel-media-export-media-cache.c"
				}
				block8_data_unref (_data8_);
			}
			goto __finally8;
			__catch8_rygel_media_export_database_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
					RygelMediaExportDatabase* _tmp6_;
#line 410 "rygel-media-export-media-cache.vala"
					g_warning ("rygel-media-export-media-cache.vala:410: Something weird going on: %s", _error_->message);
#line 411 "rygel-media-export-media-cache.vala"
					self->priv->db = (_tmp6_ = NULL, _g_object_unref0 (self->priv->db), _tmp6_);
#line 1953 "rygel-media-export-media-cache.c"
					_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
					{
						_g_error_free0 (_error_);
						_g_error_free0 (_error_);
						goto __finally8;
					}
					_g_error_free0 (_error_);
				}
			}
			__finally8:
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally7;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 418 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
#line 1981 "rygel-media-export-media-cache.c"
	gint values_length1;
	gint _values_size_;
	GValue* _tmp19_;
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp4_ = {0};
	GValue _tmp5_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	GValue _tmp17_ = {0};
	GValue* _tmp18_ = NULL;
	GValue* values;
	GError * _inner_error_ = NULL;
#line 418 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 418 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 2010 "rygel-media-export-media-cache.c"
	values = (_tmp19_ = (_tmp18_ = g_new0 (GValue, 18), _tmp18_[0] = (g_value_init (&_tmp0_, G_TYPE_INT64), g_value_set_int64 (&_tmp0_, item->size), _tmp0_), _tmp18_[1] = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, item->mime_type), _tmp1_), _tmp18_[2] = (g_value_init (&_tmp2_, G_TYPE_INT), g_value_set_int (&_tmp2_, item->width), _tmp2_), _tmp18_[3] = (g_value_init (&_tmp3_, G_TYPE_INT), g_value_set_int (&_tmp3_, item->height), _tmp3_), _tmp18_[4] = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_set_string (&_tmp4_, ((RygelMediaObject*) item)->upnp_class), _tmp4_), _tmp18_[5] = (g_value_init (&_tmp5_, G_TYPE_STRING), g_value_set_string (&_tmp5_, item->author), _tmp5_), _tmp18_[6] = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_set_string (&_tmp6_, item->album), _tmp6_), _tmp18_[7] = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, item->date), _tmp7_), _tmp18_[8] = (g_value_init (&_tmp8_, G_TYPE_INT), g_value_set_int (&_tmp8_, item->bitrate), _tmp8_), _tmp18_[9] = (g_value_init (&_tmp9_, G_TYPE_INT), g_value_set_int (&_tmp9_, item->sample_freq), _tmp9_), _tmp18_[10] = (g_value_init (&_tmp10_, G_TYPE_INT), g_value_set_int (&_tmp10_, item->bits_per_sample), _tmp10_), _tmp18_[11] = (g_value_init (&_tmp11_, G_TYPE_INT), g_value_set_int (&_tmp11_, item->n_audio_channels), _tmp11_), _tmp18_[12] = (g_value_init (&_tmp12_, G_TYPE_INT), g_value_set_int (&_tmp12_, item->track_number), _tmp12_), _tmp18_[13] = (g_value_init (&_tmp13_, G_TYPE_INT), g_value_set_int (&_tmp13_, item->color_depth), _tmp13_), _tmp18_[14] = (g_value_init (&_tmp14_, G_TYPE_LONG), g_value_set_long (&_tmp14_, item->duration), _tmp14_), _tmp18_[15] = (g_value_init (&_tmp15_, G_TYPE_STRING), g_value_set_string (&_tmp15_, ((RygelMediaObject*) item)->id), _tmp15_), _tmp18_[16] = (g_value_init (&_tmp16_, G_TYPE_STRING), g_value_set_string (&_tmp16_, item->dlna_profile), _tmp16_), _tmp18_[17] = (g_value_init (&_tmp17_, G_TYPE_STRING), g_value_set_string (&_tmp17_, item->genre), _tmp17_), _tmp18_), values_length1 = 18, _values_size_ = values_length1, _tmp19_);
#line 437 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA), values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 2014 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 440 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error) {
#line 2026 "rygel-media-export-media-cache.c"
	gint type;
	GValue parent = {0};
	char* _tmp4_;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp14_;
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue* _tmp13_ = NULL;
	GValue* values;
	GError * _inner_error_ = NULL;
#line 440 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 440 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 441 "rygel-media-export-media-cache.vala"
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
#line 444 "rygel-media-export-media-cache.vala"
	if (RYGEL_IS_MEDIA_ITEM (item)) {
#line 445 "rygel-media-export-media-cache.vala"
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
#line 2052 "rygel-media-export-media-cache.c"
	}
#line 448 "rygel-media-export-media-cache.vala"
	if (item->parent == NULL) {
#line 2056 "rygel-media-export-media-cache.c"
		GValue _tmp0_ = {0};
		GValue _tmp1_;
#line 449 "rygel-media-export-media-cache.vala"
		parent = (_tmp1_ = (rygel_media_export_database_null (&_tmp0_), _tmp0_), G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL, _tmp1_);
#line 2061 "rygel-media-export-media-cache.c"
	} else {
		GValue _tmp2_ = {0};
		GValue _tmp3_;
#line 451 "rygel-media-export-media-cache.vala"
		parent = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, ((RygelMediaObject*) item->parent)->id), _tmp2_), G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL, _tmp3_);
#line 2067 "rygel-media-export-media-cache.c"
	}
	_tmp4_ = NULL;
#line 459 "rygel-media-export-media-cache.vala"
	if (gee_collection_get_size ((GeeCollection*) item->uris) == 0) {
#line 2072 "rygel-media-export-media-cache.c"
		char* _tmp5_;
#line 459 "rygel-media-export-media-cache.vala"
		_tmp4_ = (_tmp5_ = NULL, _g_free0 (_tmp4_), _tmp5_);
#line 2076 "rygel-media-export-media-cache.c"
	} else {
		char* _tmp6_;
		_tmp4_ = (_tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) item->uris, 0), _g_free0 (_tmp4_), _tmp6_);
	}
	values = (_tmp14_ = (_tmp13_ = g_new0 (GValue, 6), _tmp13_[0] = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, item->id), _tmp7_), _tmp13_[1] = (g_value_init (&_tmp8_, G_TYPE_STRING), g_value_set_string (&_tmp8_, rygel_media_object_get_title (item)), _tmp8_), _tmp13_[2] = (g_value_init (&_tmp9_, G_TYPE_INT), g_value_set_int (&_tmp9_, type), _tmp9_), _tmp13_[3] = G_IS_VALUE (&parent) ? (g_value_init (&_tmp10_, G_VALUE_TYPE (&parent)), g_value_copy (&parent, &_tmp10_), _tmp10_) : parent, _tmp13_[4] = (g_value_init (&_tmp11_, G_TYPE_INT64), g_value_set_int64 (&_tmp11_, (gint64) item->modified), _tmp11_), _tmp13_[5] = (g_value_init (&_tmp12_, G_TYPE_STRING), g_value_set_string (&_tmp12_, _tmp4_), _tmp12_), _tmp13_), values_length1 = 6, _values_size_ = values_length1, _tmp14_);
#line 461 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT), values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 2084 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (_tmp4_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (_tmp4_);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}


/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
#line 472 "rygel-media-export-media-cache.vala"
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
#line 2108 "rygel-media-export-media-cache.c"
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 472 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2113 "rygel-media-export-media-cache.c"
	{
#line 474 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 2117 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
#line 475 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA), NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2123 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
#line 476 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON), NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2129 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
#line 477 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE), NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2135 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
#line 478 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON), NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2141 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
#line 479 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE), NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2147 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
#line 480 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 2153 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
#line 481 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_analyze (self->priv->db);
#line 2159 "rygel-media-export-media-cache.c"
		result = TRUE;
#line 483 "rygel-media-export-media-cache.vala"
		return result;
#line 2163 "rygel-media-export-media-cache.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 485 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:485: Failed to create schema: %s", err->message);
#line 486 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 2176 "rygel-media-export-media-cache.c"
			_g_error_free0 (err);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
#line 489 "rygel-media-export-media-cache.vala"
	return result;
#line 2189 "rygel-media-export-media-cache.c"
}


#line 492 "rygel-media-export-media-cache.vala"
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement) {
#line 2195 "rygel-media-export-media-cache.c"
	RygelMediaObject* result = NULL;
	RygelMediaObject* object;
#line 492 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 492 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 492 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, NULL);
#line 495 "rygel-media-export-media-cache.vala"
	object = NULL;
#line 496 "rygel-media-export-media-cache.vala"
	switch (sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE)) {
#line 2208 "rygel-media-export-media-cache.c"
		case 0:
		{
			RygelMediaObject* _tmp0_;
			RygelMediaObject* _tmp1_;
			RygelMediaContainer* container;
			char* uri;
#line 499 "rygel-media-export-media-cache.vala"
			object = (_tmp0_ = (RygelMediaObject*) rygel_media_export_object_factory_get_container (self->priv->factory, self, object_id, sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE), (guint) 0), _g_object_unref0 (object), _tmp0_);
#line 505 "rygel-media-export-media-cache.vala"
			container = _g_object_ref0 ((_tmp1_ = object, RYGEL_IS_MEDIA_CONTAINER (_tmp1_) ? ((RygelMediaContainer*) _tmp1_) : NULL));
#line 506 "rygel-media-export-media-cache.vala"
			uri = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI));
#line 507 "rygel-media-export-media-cache.vala"
			if (uri != NULL) {
#line 508 "rygel-media-export-media-cache.vala"
				rygel_media_container_set_uri (container, uri, NULL);
#line 2225 "rygel-media-export-media-cache.c"
			}
			_g_free0 (uri);
			_g_object_unref0 (container);
#line 510 "rygel-media-export-media-cache.vala"
			break;
#line 2231 "rygel-media-export-media-cache.c"
		}
		case 1:
		{
			char* upnp_class;
			RygelMediaObject* _tmp2_;
			RygelMediaObject* _tmp3_;
			char* uri;
#line 513 "rygel-media-export-media-cache.vala"
			upnp_class = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS));
#line 514 "rygel-media-export-media-cache.vala"
			object = (_tmp2_ = (RygelMediaObject*) rygel_media_export_object_factory_get_item (self->priv->factory, self, parent, object_id, sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE), upnp_class), _g_object_unref0 (object), _tmp2_);
#line 520 "rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_fill_item (self, statement, (_tmp3_ = object, RYGEL_IS_MEDIA_ITEM (_tmp3_) ? ((RygelMediaItem*) _tmp3_) : NULL));
#line 522 "rygel-media-export-media-cache.vala"
			if (g_str_has_prefix (upnp_class, RYGEL_MEDIA_ITEM_AUDIO_CLASS)) {
#line 2247 "rygel-media-export-media-cache.c"
				RygelMediaObject* _tmp4_;
#line 523 "rygel-media-export-media-cache.vala"
				rygel_media_item_lookup_album_art ((_tmp4_ = object, RYGEL_IS_MEDIA_ITEM (_tmp4_) ? ((RygelMediaItem*) _tmp4_) : NULL));
#line 2251 "rygel-media-export-media-cache.c"
			}
#line 526 "rygel-media-export-media-cache.vala"
			uri = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI));
#line 527 "rygel-media-export-media-cache.vala"
			if (uri != NULL) {
#line 2257 "rygel-media-export-media-cache.c"
				RygelMediaObject* _tmp5_;
#line 528 "rygel-media-export-media-cache.vala"
				rygel_media_item_add_uri ((_tmp5_ = object, RYGEL_IS_MEDIA_ITEM (_tmp5_) ? ((RygelMediaItem*) _tmp5_) : NULL), uri, NULL);
#line 2261 "rygel-media-export-media-cache.c"
			}
			_g_free0 (uri);
			_g_free0 (upnp_class);
#line 530 "rygel-media-export-media-cache.vala"
			break;
#line 2267 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 532 "rygel-media-export-media-cache.vala"
			g_assert_not_reached ();
#line 2273 "rygel-media-export-media-cache.c"
		}
	}
#line 535 "rygel-media-export-media-cache.vala"
	if (object != NULL) {
#line 536 "rygel-media-export-media-cache.vala"
		object->modified = (guint64) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP);
#line 2280 "rygel-media-export-media-cache.c"
	}
	result = object;
#line 539 "rygel-media-export-media-cache.vala"
	return result;
#line 2285 "rygel-media-export-media-cache.c"
}


#line 542 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item) {
#line 2291 "rygel-media-export-media-cache.c"
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
#line 542 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 542 "rygel-media-export-media-cache.vala"
	g_return_if_fail (statement != NULL);
#line 542 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 543 "rygel-media-export-media-cache.vala"
	item->author = (_tmp0_ = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR)), _g_free0 (item->author), _tmp0_);
#line 544 "rygel-media-export-media-cache.vala"
	item->album = (_tmp1_ = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM)), _g_free0 (item->album), _tmp1_);
#line 545 "rygel-media-export-media-cache.vala"
	item->date = (_tmp2_ = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE)), _g_free0 (item->date), _tmp2_);
#line 546 "rygel-media-export-media-cache.vala"
	item->mime_type = (_tmp3_ = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE)), _g_free0 (item->mime_type), _tmp3_);
#line 547 "rygel-media-export-media-cache.vala"
	item->duration = (glong) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION);
#line 549 "rygel-media-export-media-cache.vala"
	item->size = sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE);
#line 550 "rygel-media-export-media-cache.vala"
	item->bitrate = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE);
#line 552 "rygel-media-export-media-cache.vala"
	item->sample_freq = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ);
#line 553 "rygel-media-export-media-cache.vala"
	item->bits_per_sample = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE);
#line 555 "rygel-media-export-media-cache.vala"
	item->n_audio_channels = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS);
#line 557 "rygel-media-export-media-cache.vala"
	item->track_number = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK);
#line 559 "rygel-media-export-media-cache.vala"
	item->width = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH);
#line 560 "rygel-media-export-media-cache.vala"
	item->height = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT);
#line 561 "rygel-media-export-media-cache.vala"
	item->color_depth = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH);
#line 562 "rygel-media-export-media-cache.vala"
	item->dlna_profile = (_tmp4_ = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE)), _g_free0 (item->dlna_profile), _tmp4_);
#line 563 "rygel-media-export-media-cache.vala"
	item->genre = (_tmp5_ = g_strdup (sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE)), _g_free0 (item->genre), _tmp5_);
#line 2336 "rygel-media-export-media-cache.c"
}


#line 573 "rygel-media-export-media-cache.vala"
static gboolean _lambda12_ (sqlite3_stmt* statement, Block9Data* _data9_) {
#line 2342 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data9_->self;
#line 573 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 574 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data9_->children, sqlite3_column_text (statement, 0));
#line 2350 "rygel-media-export-media-cache.c"
	result = TRUE;
#line 576 "rygel-media-export-media-cache.vala"
	return result;
#line 2354 "rygel-media-export-media-cache.c"
}


#line 573 "rygel-media-export-media-cache.vala"
static gboolean __lambda12__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 2360 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda12_ (stmt, self);
	return result;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->children);
		g_slice_free (Block9Data, _data9_);
	}
}


#line 566 "rygel-media-export-media-cache.vala"
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const char* container_id, GError** error) {
#line 2384 "rygel-media-export-media-cache.c"
	GeeArrayList* result = NULL;
	Block9Data* _data9_;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp2_;
	GValue _tmp0_ = {0};
	GValue* _tmp1_ = NULL;
	GValue* values;
	GError * _inner_error_ = NULL;
#line 566 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 566 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 2398 "rygel-media-export-media-cache.c"
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->children = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 571 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS), values, values_length1, __lambda12__rygel_media_export_database_row_callback, _data9_, NULL, &_inner_error_);
#line 2406 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block9_data_unref (_data9_);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data9_->children);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block9_data_unref (_data9_);
#line 579 "rygel-media-export-media-cache.vala"
	return result;
#line 2426 "rygel-media-export-media-cache.c"
}


#line 582 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_translate_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, const char* prefix, GError** error) {
#line 2432 "rygel-media-export-media-cache.c"
	char* result = NULL;
	char* filter;
	GError * _inner_error_ = NULL;
#line 582 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 582 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 582 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 587 "rygel-media-export-media-cache.vala"
	if (expression == NULL) {
#line 2444 "rygel-media-export-media-cache.c"
		result = g_strdup ("");
#line 588 "rygel-media-export-media-cache.vala"
		return result;
#line 2448 "rygel-media-export-media-cache.c"
	}
#line 591 "rygel-media-export-media-cache.vala"
	filter = rygel_media_export_media_cache_search_expression_to_sql (self, expression, args, &_inner_error_);
#line 2452 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = g_strdup_printf (" %s %s", prefix, filter);
	_g_free0 (filter);
#line 593 "rygel-media-export-media-cache.vala"
	return result;
#line 2461 "rygel-media-export-media-cache.c"
}


#line 596 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error) {
#line 2467 "rygel-media-export-media-cache.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 596 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 596 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 599 "rygel-media-export-media-cache.vala"
	if (expression == NULL) {
#line 2476 "rygel-media-export-media-cache.c"
		result = g_strdup ("");
#line 600 "rygel-media-export-media-cache.vala"
		return result;
#line 2480 "rygel-media-export-media-cache.c"
	}
#line 603 "rygel-media-export-media-cache.vala"
	if (RYGEL_IS_LOGICAL_EXPRESSION (expression)) {
#line 2484 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp0_;
		char* _tmp1_;
#line 604 "rygel-media-export-media-cache.vala"
		_tmp1_ = rygel_media_export_media_cache_logical_expression_to_sql (self, (_tmp0_ = expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp0_) ? ((RygelLogicalExpression*) _tmp0_) : NULL), args, &_inner_error_);
#line 2489 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp1_;
#line 604 "rygel-media-export-media-cache.vala"
		return result;
#line 2497 "rygel-media-export-media-cache.c"
	} else {
		RygelSearchExpression* _tmp2_;
		char* _tmp3_;
#line 607 "rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_media_cache_relational_expression_to_sql (self, (_tmp2_ = expression, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp2_) ? ((RygelRelationalExpression*) _tmp2_) : NULL), args, &_inner_error_);
#line 2503 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp3_;
#line 607 "rygel-media-export-media-cache.vala"
		return result;
#line 2511 "rygel-media-export-media-cache.c"
	}
}


#line 613 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error) {
#line 2518 "rygel-media-export-media-cache.c"
	char* result = NULL;
	char* left_sql_string;
	char* right_sql_string;
	char* operator_sql_string;
	GError * _inner_error_ = NULL;
#line 613 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 613 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 616 "rygel-media-export-media-cache.vala"
	left_sql_string = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand1, args, &_inner_error_);
#line 2530 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 618 "rygel-media-export-media-cache.vala"
	right_sql_string = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand2, args, &_inner_error_);
#line 2537 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (left_sql_string);
		return NULL;
	}
#line 620 "rygel-media-export-media-cache.vala"
	operator_sql_string = g_strdup ("OR");
#line 622 "rygel-media-export-media-cache.vala"
	if (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op) == RYGEL_LOGICAL_OPERATOR_AND) {
#line 2547 "rygel-media-export-media-cache.c"
		char* _tmp0_;
#line 623 "rygel-media-export-media-cache.vala"
		operator_sql_string = (_tmp0_ = g_strdup ("AND"), _g_free0 (operator_sql_string), _tmp0_);
#line 2551 "rygel-media-export-media-cache.c"
	}
	result = g_strdup_printf ("(%s %s %s)", left_sql_string, operator_sql_string, right_sql_string);
	_g_free0 (operator_sql_string);
	_g_free0 (right_sql_string);
	_g_free0 (left_sql_string);
#line 626 "rygel-media-export-media-cache.vala"
	return result;
#line 2559 "rygel-media-export-media-cache.c"
}


#line 631 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const char* operand, GError** error) {
#line 2565 "rygel-media-export-media-cache.c"
	char* result = NULL;
	char* column;
	const char* _tmp9_;
	GQuark _tmp10_;
	static GQuark _tmp10__label0 = 0;
	static GQuark _tmp10__label1 = 0;
	static GQuark _tmp10__label2 = 0;
	static GQuark _tmp10__label3 = 0;
	static GQuark _tmp10__label4 = 0;
	static GQuark _tmp10__label5 = 0;
	static GQuark _tmp10__label6 = 0;
	static GQuark _tmp10__label7 = 0;
	static GQuark _tmp10__label8 = 0;
	static GQuark _tmp10__label9 = 0;
	GError * _inner_error_ = NULL;
#line 631 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 631 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (operand != NULL, NULL);
#line 632 "rygel-media-export-media-cache.vala"
	column = NULL;
#line 2587 "rygel-media-export-media-cache.c"
	_tmp9_ = operand;
	_tmp10_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
	if (_tmp10_ == ((0 != _tmp10__label0) ? _tmp10__label0 : (_tmp10__label0 = g_quark_from_static_string ("res"))))
	switch (0) {
		default:
		{
			char* _tmp0_;
#line 636 "rygel-media-export-media-cache.vala"
			column = (_tmp0_ = g_strdup ("o.uri"), _g_free0 (column), _tmp0_);
#line 637 "rygel-media-export-media-cache.vala"
			break;
#line 2599 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp10_ == ((0 != _tmp10__label1) ? _tmp10__label1 : (_tmp10__label1 = g_quark_from_static_string ("@id"))))
	switch (0) {
		default:
		{
			char* _tmp1_;
#line 639 "rygel-media-export-media-cache.vala"
			column = (_tmp1_ = g_strdup ("o.upnp_id"), _g_free0 (column), _tmp1_);
#line 640 "rygel-media-export-media-cache.vala"
			break;
#line 2610 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp10_ == ((0 != _tmp10__label2) ? _tmp10__label2 : (_tmp10__label2 = g_quark_from_static_string ("@parentID"))))
	switch (0) {
		default:
		{
			char* _tmp2_;
#line 642 "rygel-media-export-media-cache.vala"
			column = (_tmp2_ = g_strdup ("o.parent"), _g_free0 (column), _tmp2_);
#line 643 "rygel-media-export-media-cache.vala"
			break;
#line 2621 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp10_ == ((0 != _tmp10__label3) ? _tmp10__label3 : (_tmp10__label3 = g_quark_from_static_string ("upnp:class"))))
	switch (0) {
		default:
		{
			char* _tmp3_;
#line 645 "rygel-media-export-media-cache.vala"
			column = (_tmp3_ = g_strdup ("m.class"), _g_free0 (column), _tmp3_);
#line 646 "rygel-media-export-media-cache.vala"
			break;
#line 2632 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp10_ == ((0 != _tmp10__label4) ? _tmp10__label4 : (_tmp10__label4 = g_quark_from_static_string ("dc:title"))))
	switch (0) {
		default:
		{
			char* _tmp4_;
#line 648 "rygel-media-export-media-cache.vala"
			column = (_tmp4_ = g_strdup ("o.title"), _g_free0 (column), _tmp4_);
#line 649 "rygel-media-export-media-cache.vala"
			break;
#line 2643 "rygel-media-export-media-cache.c"
		}
	} else if ((_tmp10_ == ((0 != _tmp10__label5) ? _tmp10__label5 : (_tmp10__label5 = g_quark_from_static_string ("upnp:artist")))) || (_tmp10_ == ((0 != _tmp10__label6) ? _tmp10__label6 : (_tmp10__label6 = g_quark_from_static_string ("dc:creator")))))
	switch (0) {
		default:
		{
			char* _tmp5_;
#line 652 "rygel-media-export-media-cache.vala"
			column = (_tmp5_ = g_strdup ("m.author"), _g_free0 (column), _tmp5_);
#line 653 "rygel-media-export-media-cache.vala"
			break;
#line 2654 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp10_ == ((0 != _tmp10__label7) ? _tmp10__label7 : (_tmp10__label7 = g_quark_from_static_string ("dc:date"))))
	switch (0) {
		default:
		{
			char* _tmp6_;
#line 655 "rygel-media-export-media-cache.vala"
			column = (_tmp6_ = g_strdup ("strftime(\"%Y\", m.date)"), _g_free0 (column), _tmp6_);
#line 656 "rygel-media-export-media-cache.vala"
			break;
#line 2665 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp10_ == ((0 != _tmp10__label8) ? _tmp10__label8 : (_tmp10__label8 = g_quark_from_static_string ("upnp:album"))))
	switch (0) {
		default:
		{
			char* _tmp7_;
#line 658 "rygel-media-export-media-cache.vala"
			column = (_tmp7_ = g_strdup ("m.album"), _g_free0 (column), _tmp7_);
#line 659 "rygel-media-export-media-cache.vala"
			break;
#line 2676 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp10_ == ((0 != _tmp10__label9) ? _tmp10__label9 : (_tmp10__label9 = g_quark_from_static_string ("dc:genre"))))
	switch (0) {
		default:
		{
			char* _tmp8_;
#line 661 "rygel-media-export-media-cache.vala"
			column = (_tmp8_ = g_strdup ("m.genre"), _g_free0 (column), _tmp8_);
#line 662 "rygel-media-export-media-cache.vala"
			break;
#line 2687 "rygel-media-export-media-cache.c"
		}
	} else
	switch (0) {
		default:
		{
			char* message;
#line 664 "rygel-media-export-media-cache.vala"
			message = g_strdup_printf ("Unsupported column %s", operand);
#line 2696 "rygel-media-export-media-cache.c"
			_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, message);
			{
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_free0 (column);
				return NULL;
			}
		}
	}
	result = column;
#line 669 "rygel-media-export-media-cache.vala"
	return result;
#line 2709 "rygel-media-export-media-cache.c"
}


#line 672 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error) {
#line 2715 "rygel-media-export-media-cache.c"
	char* result = NULL;
	char* sql_function;
	GValue* v;
	char* column;
	GError * _inner_error_ = NULL;
#line 672 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 672 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 675 "rygel-media-export-media-cache.vala"
	sql_function = NULL;
#line 676 "rygel-media-export-media-cache.vala"
	v = NULL;
#line 678 "rygel-media-export-media-cache.vala"
	column = rygel_media_export_media_cache_map_operand_to_column (self, (const char*) ((RygelSearchExpression*) exp)->operand1, &_inner_error_);
#line 2731 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (v);
		_g_free0 (sql_function);
		return NULL;
	}
#line 680 "rygel-media-export-media-cache.vala"
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op)) {
#line 2740 "rygel-media-export-media-cache.c"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
#line 682 "rygel-media-export-media-cache.vala"
			if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) exp)->operand2, "true") == 0) {
#line 2745 "rygel-media-export-media-cache.c"
				char* _tmp0_;
#line 683 "rygel-media-export-media-cache.vala"
				sql_function = (_tmp0_ = g_strdup ("IS NOT NULL AND %s != ''"), _g_free0 (sql_function), _tmp0_);
#line 2749 "rygel-media-export-media-cache.c"
			} else {
				char* _tmp1_;
#line 685 "rygel-media-export-media-cache.vala"
				sql_function = (_tmp1_ = g_strdup ("IS NULL OR %s = ''"), _g_free0 (sql_function), _tmp1_);
#line 2754 "rygel-media-export-media-cache.c"
			}
#line 687 "rygel-media-export-media-cache.vala"
			break;
#line 2758 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			char* _tmp2_;
			GValue* _tmp3_ = NULL;
			GValue* _tmp4_;
#line 689 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp2_ = g_strdup ("="), _g_free0 (sql_function), _tmp2_);
#line 690 "rygel-media-export-media-cache.vala"
			v = (_tmp4_ = (_tmp3_ = g_new0 (GValue, 1), g_value_init (_tmp3_, G_TYPE_STRING), g_value_set_string (_tmp3_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp3_), _g_free0 (v), _tmp4_);
#line 691 "rygel-media-export-media-cache.vala"
			break;
#line 2771 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			char* _tmp5_;
			GValue* _tmp6_ = NULL;
			GValue* _tmp7_;
#line 693 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp5_ = g_strdup ("!="), _g_free0 (sql_function), _tmp5_);
#line 694 "rygel-media-export-media-cache.vala"
			v = (_tmp7_ = (_tmp6_ = g_new0 (GValue, 1), g_value_init (_tmp6_, G_TYPE_STRING), g_value_set_string (_tmp6_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp6_), _g_free0 (v), _tmp7_);
#line 695 "rygel-media-export-media-cache.vala"
			break;
#line 2784 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		{
			char* _tmp8_;
			GValue* _tmp9_ = NULL;
			GValue* _tmp10_;
#line 697 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp8_ = g_strdup ("<"), _g_free0 (sql_function), _tmp8_);
#line 698 "rygel-media-export-media-cache.vala"
			v = (_tmp10_ = (_tmp9_ = g_new0 (GValue, 1), g_value_init (_tmp9_, G_TYPE_STRING), g_value_set_string (_tmp9_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp9_), _g_free0 (v), _tmp10_);
#line 699 "rygel-media-export-media-cache.vala"
			break;
#line 2797 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		{
			char* _tmp11_;
			GValue* _tmp12_ = NULL;
			GValue* _tmp13_;
#line 701 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp11_ = g_strdup ("<="), _g_free0 (sql_function), _tmp11_);
#line 702 "rygel-media-export-media-cache.vala"
			v = (_tmp13_ = (_tmp12_ = g_new0 (GValue, 1), g_value_init (_tmp12_, G_TYPE_STRING), g_value_set_string (_tmp12_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp12_), _g_free0 (v), _tmp13_);
#line 703 "rygel-media-export-media-cache.vala"
			break;
#line 2810 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		{
			char* _tmp14_;
			GValue* _tmp15_ = NULL;
			GValue* _tmp16_;
#line 705 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp14_ = g_strdup (">"), _g_free0 (sql_function), _tmp14_);
#line 706 "rygel-media-export-media-cache.vala"
			v = (_tmp16_ = (_tmp15_ = g_new0 (GValue, 1), g_value_init (_tmp15_, G_TYPE_STRING), g_value_set_string (_tmp15_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp15_), _g_free0 (v), _tmp16_);
#line 707 "rygel-media-export-media-cache.vala"
			break;
#line 2823 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			char* _tmp17_;
			GValue* _tmp18_ = NULL;
			GValue* _tmp19_;
#line 709 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp17_ = g_strdup (">="), _g_free0 (sql_function), _tmp17_);
#line 710 "rygel-media-export-media-cache.vala"
			v = (_tmp19_ = (_tmp18_ = g_new0 (GValue, 1), g_value_init (_tmp18_, G_TYPE_STRING), g_value_set_string (_tmp18_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp18_), _g_free0 (v), _tmp19_);
#line 711 "rygel-media-export-media-cache.vala"
			break;
#line 2836 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			char* _tmp20_;
			GValue* _tmp21_ = NULL;
			GValue* _tmp22_;
#line 713 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp20_ = g_strdup ("LIKE"), _g_free0 (sql_function), _tmp20_);
#line 714 "rygel-media-export-media-cache.vala"
			v = (_tmp22_ = (_tmp21_ = g_new0 (GValue, 1), g_value_init (_tmp21_, G_TYPE_STRING), g_value_take_string (_tmp21_, g_strdup_printf ("%%%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp21_), _g_free0 (v), _tmp22_);
#line 715 "rygel-media-export-media-cache.vala"
			break;
#line 2849 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			char* _tmp23_;
			GValue* _tmp24_ = NULL;
			GValue* _tmp25_;
#line 717 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp23_ = g_strdup ("NOT LIKE"), _g_free0 (sql_function), _tmp23_);
#line 718 "rygel-media-export-media-cache.vala"
			v = (_tmp25_ = (_tmp24_ = g_new0 (GValue, 1), g_value_init (_tmp24_, G_TYPE_STRING), g_value_take_string (_tmp24_, g_strdup_printf ("%%%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp24_), _g_free0 (v), _tmp25_);
#line 719 "rygel-media-export-media-cache.vala"
			break;
#line 2862 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			char* _tmp26_;
			GValue* _tmp27_ = NULL;
			GValue* _tmp28_;
#line 721 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp26_ = g_strdup ("LIKE"), _g_free0 (sql_function), _tmp26_);
#line 722 "rygel-media-export-media-cache.vala"
			v = (_tmp28_ = (_tmp27_ = g_new0 (GValue, 1), g_value_init (_tmp27_, G_TYPE_STRING), g_value_take_string (_tmp27_, g_strdup_printf ("%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp27_), _g_free0 (v), _tmp28_);
#line 723 "rygel-media-export-media-cache.vala"
			break;
#line 2875 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 725 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:725: Unsupported op %d", (gint) GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op));
#line 726 "rygel-media-export-media-cache.vala"
			break;
#line 2883 "rygel-media-export-media-cache.c"
		}
	}
#line 729 "rygel-media-export-media-cache.vala"
	if (v != NULL) {
#line 730 "rygel-media-export-media-cache.vala"
		g_value_array_append (args, v);
#line 2890 "rygel-media-export-media-cache.c"
	}
	result = g_strdup_printf ("%s %s ?", column, sql_function);
	_g_free0 (column);
	_g_free0 (v);
	_g_free0 (sql_function);
#line 733 "rygel-media-export-media-cache.vala"
	return result;
#line 2898 "rygel-media-export-media-cache.c"
}


#line 749 "rygel-media-export-media-cache.vala"
static gboolean _lambda1_ (sqlite3_stmt* statement, Block10Data* _data10_) {
#line 2904 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data10_->self;
#line 749 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 750 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data10_->data, sqlite3_column_text (statement, 0));
#line 2912 "rygel-media-export-media-cache.c"
	result = TRUE;
#line 752 "rygel-media-export-media-cache.vala"
	return result;
#line 2916 "rygel-media-export-media-cache.c"
}


#line 749 "rygel-media-export-media-cache.vala"
static gboolean __lambda1__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 2922 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda1_ (stmt, self);
	return result;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->data);
		g_slice_free (Block10Data, _data10_);
	}
}


#line 736 "rygel-media-export-media-cache.vala"
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const char* column, const char* filter, GValueArray* args, glong offset, glong max_count, GError** error) {
#line 2946 "rygel-media-export-media-cache.c"
	GeeList* result = NULL;
	Block10Data* _data10_;
	GValue _tmp0_ = {0};
	GValue v;
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	RygelMediaExportDatabaseRowCallback _tmp3_;
	RygelMediaExportDatabaseRowCallback callback;
	char* sql;
	char* _tmp4_;
	GError * _inner_error_ = NULL;
#line 736 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 736 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (column != NULL, NULL);
#line 736 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 736 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 2968 "rygel-media-export-media-cache.c"
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
#line 743 "rygel-media-export-media-cache.vala"
	v = (g_value_init (&_tmp0_, G_TYPE_LONG), g_value_set_long (&_tmp0_, offset), _tmp0_);
#line 744 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 745 "rygel-media-export-media-cache.vala"
	v = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_LONG), g_value_set_long (&_tmp1_, max_count), _tmp1_), G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp2_);
#line 746 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 2980 "rygel-media-export-media-cache.c"
	_data10_->data = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	callback = (_tmp3_ = __lambda1__rygel_media_export_database_row_callback, callback_target = block10_data_ref (_data10_), callback_target_destroy_notify = block10_data_unref, _tmp3_);
#line 755 "rygel-media-export-media-cache.vala"
	sql = g_strdup (rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN));
#line 756 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, _tmp4_ = g_strdup_printf (sql, column, filter), args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
#line 2987 "rygel-media-export-media-cache.c"
	_g_free0 (_tmp4_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sql);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		block10_data_unref (_data10_);
		return NULL;
	}
	result = _g_object_ref0 ((GeeList*) _data10_->data);
	_g_free0 (sql);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	block10_data_unref (_data10_);
#line 760 "rygel-media-export-media-cache.vala"
	return result;
#line 3010 "rygel-media-export-media-cache.c"
}


#line 763 "rygel-media-export-media-cache.vala"
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const char* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error) {
#line 3016 "rygel-media-export-media-cache.c"
	GeeList* result = NULL;
	GValueArray* args;
	char* filter;
	char* column;
	guint max_objects;
	GeeList* _tmp0_;
	GError * _inner_error_ = NULL;
#line 763 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 763 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (attribute != NULL, NULL);
#line 769 "rygel-media-export-media-cache.vala"
	args = g_value_array_new ((guint) 0);
#line 770 "rygel-media-export-media-cache.vala"
	filter = rygel_media_export_media_cache_translate_search_expression (self, expression, args, "AND", &_inner_error_);
#line 3032 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
#line 774 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:774: Parsed filter: %s", filter);
#line 776 "rygel-media-export-media-cache.vala"
	column = rygel_media_export_media_cache_map_operand_to_column (self, attribute, &_inner_error_);
#line 3042 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
#line 777 "rygel-media-export-media-cache.vala"
	max_objects = rygel_media_export_media_cache_modify_limit (self, max_count);
#line 779 "rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, column, filter, args, offset, (glong) max_objects, &_inner_error_);
#line 3053 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (column);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	result = _tmp0_;
	_g_free0 (column);
	_g_free0 (filter);
	_g_value_array_free0 (args);
#line 779 "rygel-media-export-media-cache.vala"
	return result;
#line 3067 "rygel-media-export-media-cache.c"
}


#line 786 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const char* flag, GError** error) {
#line 3073 "rygel-media-export-media-cache.c"
	gint args_length1;
	gint _args_size_;
	GValue* _tmp3_;
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* args;
	GError * _inner_error_ = NULL;
#line 786 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 786 "rygel-media-export-media-cache.vala"
	g_return_if_fail (file != NULL);
#line 786 "rygel-media-export-media-cache.vala"
	g_return_if_fail (flag != NULL);
#line 3088 "rygel-media-export-media-cache.c"
	args = (_tmp3_ = (_tmp2_ = g_new0 (GValue, 2), _tmp2_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, flag), _tmp0_), _tmp2_[1] = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_take_string (&_tmp1_, g_file_get_uri (file)), _tmp1_), _tmp2_), args_length1 = 2, _args_size_ = args_length1, _tmp3_);
#line 788 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, "UPDATE Object SET flags = ? WHERE uri = ?", args, args_length1, NULL, NULL, NULL, &_inner_error_);
#line 3092 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		args = (_vala_GValue_array_free (args, args_length1), NULL);
		return;
	}
	args = (_vala_GValue_array_free (args, args_length1), NULL);
}


#line 796 "rygel-media-export-media-cache.vala"
static gboolean _lambda13_ (sqlite3_stmt* statement, Block11Data* _data11_) {
#line 3104 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data11_->self;
#line 796 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 797 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data11_->uris, sqlite3_column_text (statement, 0));
#line 3112 "rygel-media-export-media-cache.c"
	result = TRUE;
#line 799 "rygel-media-export-media-cache.vala"
	return result;
#line 3116 "rygel-media-export-media-cache.c"
}


#line 796 "rygel-media-export-media-cache.vala"
static gboolean __lambda13__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 3122 "rygel-media-export-media-cache.c"
	gboolean result;
	result = _lambda13_ (stmt, self);
	return result;
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->uris);
		g_slice_free (Block11Data, _data11_);
	}
}


#line 791 "rygel-media-export-media-cache.vala"
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const char* flag, GError** error) {
#line 3146 "rygel-media-export-media-cache.c"
	GeeList* result = NULL;
	Block11Data* _data11_;
	gint args_length1;
	gint _args_size_;
	GValue* _tmp2_;
	GValue _tmp0_ = {0};
	GValue* _tmp1_ = NULL;
	GValue* args;
	GError * _inner_error_ = NULL;
#line 791 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 791 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (flag != NULL, NULL);
#line 3160 "rygel-media-export-media-cache.c"
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->uris = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	args = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, flag), _tmp0_), _tmp1_), args_length1 = 1, _args_size_ = args_length1, _tmp2_);
#line 794 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, "SELECT uri FROM object WHERE flags = ?", args, args_length1, __lambda13__rygel_media_export_database_row_callback, _data11_, NULL, &_inner_error_);
#line 3168 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		args = (_vala_GValue_array_free (args, args_length1), NULL);
		block11_data_unref (_data11_);
		return NULL;
	}
	result = _g_object_ref0 ((GeeList*) _data11_->uris);
	args = (_vala_GValue_array_free (args, args_length1), NULL);
	block11_data_unref (_data11_);
#line 802 "rygel-media-export-media-cache.vala"
	return result;
#line 3180 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
	self = RYGEL_MEDIA_EXPORT_MEDIA_CACHE (obj);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->sql);
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
}


/**
 * Persistent storage of media objects
 *
 *  MediaExportDB is a sqlite3 backed persistent storage of media objects
 */
GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




