/* rygel-environment-config.c generated by valac, the Vala compiler
 * generated from rygel-environment-config.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_ENVIRONMENT_CONFIG (rygel_environment_config_get_type ())
#define RYGEL_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfig))
#define RYGEL_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))
#define RYGEL_IS_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_IS_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_ENVIRONMENT_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))

typedef struct _RygelEnvironmentConfig RygelEnvironmentConfig;
typedef struct _RygelEnvironmentConfigClass RygelEnvironmentConfigClass;
typedef struct _RygelEnvironmentConfigPrivate RygelEnvironmentConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	char* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	char* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_title) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_string) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const char* section, const char* key, GError** error);
};

struct _RygelEnvironmentConfig {
	GObject parent_instance;
	RygelEnvironmentConfigPrivate * priv;
};

struct _RygelEnvironmentConfigClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static char* rygel_environment_config_RYGEL_PREFIX;
static char* rygel_environment_config_RYGEL_PREFIX = NULL;
static char* rygel_environment_config_TITLE_KEY;
static char* rygel_environment_config_TITLE_KEY = NULL;
static char* rygel_environment_config_ENABLED_KEY;
static char* rygel_environment_config_ENABLED_KEY = NULL;
static char* rygel_environment_config_INTERFACE_ENV;
static char* rygel_environment_config_INTERFACE_ENV = NULL;
static char* rygel_environment_config_PORT_ENV;
static char* rygel_environment_config_PORT_ENV = NULL;
static char* rygel_environment_config_TRANSCODING_ENV;
static char* rygel_environment_config_TRANSCODING_ENV = NULL;
static char* rygel_environment_config_MP3_TRANSCODING_ENV;
static char* rygel_environment_config_MP3_TRANSCODING_ENV = NULL;
static char* rygel_environment_config_LPCM_TRANSCODING_ENV;
static char* rygel_environment_config_LPCM_TRANSCODING_ENV = NULL;
static char* rygel_environment_config_MP2TS_TRANSCODING_ENV;
static char* rygel_environment_config_MP2TS_TRANSCODING_ENV = NULL;
static char* rygel_environment_config_WMV_TRANSCODING_ENV;
static char* rygel_environment_config_WMV_TRANSCODING_ENV = NULL;
static char* rygel_environment_config_LOG_LEVEL_ENV;
static char* rygel_environment_config_LOG_LEVEL_ENV = NULL;
static char* rygel_environment_config_PLUGIN_PATH_ENV;
static char* rygel_environment_config_PLUGIN_PATH_ENV = NULL;
static RygelEnvironmentConfig* rygel_environment_config_config;
static RygelEnvironmentConfig* rygel_environment_config_config = NULL;
static gpointer rygel_environment_config_parent_class = NULL;
static RygelConfigurationIface* rygel_environment_config_rygel_configuration_parent_iface = NULL;

GType rygel_log_level_get_type (void);
GType rygel_configuration_get_type (void);
GType rygel_environment_config_get_type (void);
enum  {
	RYGEL_ENVIRONMENT_CONFIG_DUMMY_PROPERTY
};
RygelEnvironmentConfig* rygel_environment_config_new (void);
RygelEnvironmentConfig* rygel_environment_config_construct (GType object_type);
RygelEnvironmentConfig* rygel_environment_config_get_default (void);
static gboolean rygel_environment_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
static char* rygel_environment_config_get_string_variable (RygelEnvironmentConfig* self, const char* variable, GError** error);
static char* rygel_environment_config_real_get_interface (RygelConfiguration* base, GError** error);
static gint rygel_environment_config_get_int_variable (RygelEnvironmentConfig* self, const char* variable, gint min, gint max, GError** error);
static gint rygel_environment_config_real_get_port (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_get_bool_variable (RygelEnvironmentConfig* self, const char* variable, GError** error);
static gboolean rygel_environment_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
static RygelLogLevel rygel_environment_config_real_get_log_level (RygelConfiguration* base, GError** error);
static char* rygel_environment_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const char* section, const char* key, GError** error);
static gboolean rygel_environment_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error);
char* rygel_configuration_get_string (RygelConfiguration* self, const char* section, const char* key, GError** error);
static char* rygel_environment_config_real_get_title (RygelConfiguration* base, const char* section, GError** error);
static char* rygel_environment_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error);
static GeeArrayList* rygel_environment_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
static gint rygel_environment_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_environment_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
static gboolean rygel_environment_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error);
GQuark rygel_configuration_error_quark (void);
static void rygel_environment_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 47 "rygel-environment-config.vala"
RygelEnvironmentConfig* rygel_environment_config_get_default (void) {
#line 181 "rygel-environment-config.c"
	RygelEnvironmentConfig* result = NULL;
#line 48 "rygel-environment-config.vala"
	if (rygel_environment_config_config == NULL) {
#line 185 "rygel-environment-config.c"
		RygelEnvironmentConfig* _tmp0_;
#line 49 "rygel-environment-config.vala"
		rygel_environment_config_config = (_tmp0_ = rygel_environment_config_new (), _g_object_unref0 (rygel_environment_config_config), _tmp0_);
#line 189 "rygel-environment-config.c"
	}
	result = _g_object_ref0 (rygel_environment_config_config);
#line 52 "rygel-environment-config.vala"
	return result;
#line 194 "rygel-environment-config.c"
}


#line 56 "rygel-environment-config.vala"
static gboolean rygel_environment_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
#line 200 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	self = (RygelEnvironmentConfig*) base;
	result = TRUE;
#line 57 "rygel-environment-config.vala"
	return result;
#line 207 "rygel-environment-config.c"
}


#line 60 "rygel-environment-config.vala"
static char* rygel_environment_config_real_get_interface (RygelConfiguration* base, GError** error) {
#line 213 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	self = (RygelEnvironmentConfig*) base;
	_inner_error_ = NULL;
#line 61 "rygel-environment-config.vala"
	_tmp0_ = rygel_environment_config_get_string_variable (self, rygel_environment_config_INTERFACE_ENV, &_inner_error_);
#line 222 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
#line 61 "rygel-environment-config.vala"
	return result;
#line 230 "rygel-environment-config.c"
}


#line 64 "rygel-environment-config.vala"
static gint rygel_environment_config_real_get_port (RygelConfiguration* base, GError** error) {
#line 236 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gint result = 0;
	GError * _inner_error_;
	gint _tmp0_;
	self = (RygelEnvironmentConfig*) base;
	_inner_error_ = NULL;
#line 65 "rygel-environment-config.vala"
	_tmp0_ = rygel_environment_config_get_int_variable (self, rygel_environment_config_PORT_ENV, 0, (gint) G_MAXINT16, &_inner_error_);
#line 245 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp0_;
#line 65 "rygel-environment-config.vala"
	return result;
#line 253 "rygel-environment-config.c"
}


#line 68 "rygel-environment-config.vala"
static gboolean rygel_environment_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
#line 259 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelEnvironmentConfig*) base;
	_inner_error_ = NULL;
#line 69 "rygel-environment-config.vala"
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_TRANSCODING_ENV, &_inner_error_);
#line 268 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 69 "rygel-environment-config.vala"
	return result;
#line 276 "rygel-environment-config.c"
}


#line 72 "rygel-environment-config.vala"
static gboolean rygel_environment_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
#line 282 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelEnvironmentConfig*) base;
	_inner_error_ = NULL;
#line 73 "rygel-environment-config.vala"
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_MP3_TRANSCODING_ENV, &_inner_error_);
#line 291 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 73 "rygel-environment-config.vala"
	return result;
#line 299 "rygel-environment-config.c"
}


#line 76 "rygel-environment-config.vala"
static gboolean rygel_environment_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
#line 305 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelEnvironmentConfig*) base;
	_inner_error_ = NULL;
#line 77 "rygel-environment-config.vala"
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_MP2TS_TRANSCODING_ENV, &_inner_error_);
#line 314 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 77 "rygel-environment-config.vala"
	return result;
#line 322 "rygel-environment-config.c"
}


#line 80 "rygel-environment-config.vala"
static gboolean rygel_environment_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
#line 328 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelEnvironmentConfig*) base;
	_inner_error_ = NULL;
#line 81 "rygel-environment-config.vala"
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_WMV_TRANSCODING_ENV, &_inner_error_);
#line 337 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 81 "rygel-environment-config.vala"
	return result;
#line 345 "rygel-environment-config.c"
}


#line 84 "rygel-environment-config.vala"
static gboolean rygel_environment_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
#line 351 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelEnvironmentConfig*) base;
	_inner_error_ = NULL;
#line 85 "rygel-environment-config.vala"
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_LPCM_TRANSCODING_ENV, &_inner_error_);
#line 360 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 85 "rygel-environment-config.vala"
	return result;
#line 368 "rygel-environment-config.c"
}


#line 88 "rygel-environment-config.vala"
static RygelLogLevel rygel_environment_config_real_get_log_level (RygelConfiguration* base, GError** error) {
#line 374 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	RygelLogLevel result = 0;
	GError * _inner_error_;
	gint _tmp0_;
	self = (RygelEnvironmentConfig*) base;
	_inner_error_ = NULL;
#line 89 "rygel-environment-config.vala"
	_tmp0_ = rygel_environment_config_get_int_variable (self, rygel_environment_config_LOG_LEVEL_ENV, (gint) RYGEL_LOG_LEVEL_CRITICAL, (gint) RYGEL_LOG_LEVEL_DEBUG, &_inner_error_);
#line 383 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = (RygelLogLevel) _tmp0_;
#line 89 "rygel-environment-config.vala"
	return result;
#line 391 "rygel-environment-config.c"
}


#line 94 "rygel-environment-config.vala"
static char* rygel_environment_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
#line 397 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	self = (RygelEnvironmentConfig*) base;
	_inner_error_ = NULL;
#line 95 "rygel-environment-config.vala"
	_tmp0_ = rygel_environment_config_get_string_variable (self, rygel_environment_config_PLUGIN_PATH_ENV, &_inner_error_);
#line 406 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
#line 95 "rygel-environment-config.vala"
	return result;
#line 414 "rygel-environment-config.c"
}


#line 98 "rygel-environment-config.vala"
static gboolean rygel_environment_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error) {
#line 420 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelEnvironmentConfig*) base;
#line 98 "rygel-environment-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 428 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 99 "rygel-environment-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, section, rygel_environment_config_ENABLED_KEY, &_inner_error_);
#line 432 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 99 "rygel-environment-config.vala"
	return result;
#line 440 "rygel-environment-config.c"
}


#line 102 "rygel-environment-config.vala"
static char* rygel_environment_config_real_get_title (RygelConfiguration* base, const char* section, GError** error) {
#line 446 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char* _tmp3_;
	self = (RygelEnvironmentConfig*) base;
#line 102 "rygel-environment-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 457 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 103 "rygel-environment-config.vala"
	_tmp3_ = (_tmp2_ = rygel_configuration_get_string ((RygelConfiguration*) self, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_", NULL), section, NULL), rygel_environment_config_TITLE_KEY, &_inner_error_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
#line 461 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp3_;
#line 103 "rygel-environment-config.vala"
	return result;
#line 469 "rygel-environment-config.c"
}


#line 106 "rygel-environment-config.vala"
static char* rygel_environment_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 475 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp5_;
	char* _tmp6_;
	self = (RygelEnvironmentConfig*) base;
#line 106 "rygel-environment-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 106 "rygel-environment-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 491 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 108 "rygel-environment-config.vala"
	_tmp6_ = (_tmp5_ = rygel_environment_config_get_string_variable (self, _tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp0_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_", NULL), _tmp1_ = g_utf8_strup (section, -1), NULL), "_", NULL), key, NULL), &_inner_error_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp5_);
#line 495 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp6_;
#line 108 "rygel-environment-config.vala"
	return result;
#line 503 "rygel-environment-config.c"
}


#line 113 "rygel-environment-config.vala"
static GeeArrayList* rygel_environment_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 509 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	char* str;
	GeeArrayList* value;
	self = (RygelEnvironmentConfig*) base;
#line 113 "rygel-environment-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 113 "rygel-environment-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 520 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 116 "rygel-environment-config.vala"
	str = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error_);
#line 524 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 117 "rygel-environment-config.vala"
	value = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 531 "rygel-environment-config.c"
	{
		char** _tmp0_;
		char** token_collection;
		int token_collection_length1;
		int token_it;
#line 118 "rygel-environment-config.vala"
		token_collection = _tmp0_ = g_strsplit (str, ",", -1);
#line 539 "rygel-environment-config.c"
		token_collection_length1 = _vala_array_length (_tmp0_);
		for (token_it = 0; token_it < _vala_array_length (_tmp0_); token_it = token_it + 1) {
			char* token;
			token = g_strdup (token_collection[token_it]);
			{
#line 119 "rygel-environment-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) value, token);
#line 547 "rygel-environment-config.c"
				_g_free0 (token);
			}
		}
#line 118 "rygel-environment-config.vala"
		token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
#line 553 "rygel-environment-config.c"
	}
	result = value;
	_g_free0 (str);
#line 122 "rygel-environment-config.vala"
	return result;
#line 559 "rygel-environment-config.c"
}


#line 125 "rygel-environment-config.vala"
static gint rygel_environment_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error) {
#line 565 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gint result = 0;
	GError * _inner_error_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	gint _tmp5_;
	gint _tmp6_;
	self = (RygelEnvironmentConfig*) base;
#line 125 "rygel-environment-config.vala"
	g_return_val_if_fail (section != NULL, 0);
#line 125 "rygel-environment-config.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 581 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 130 "rygel-environment-config.vala"
	_tmp6_ = (_tmp5_ = rygel_environment_config_get_int_variable (self, _tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp0_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_", NULL), _tmp1_ = g_utf8_strup (section, -1), NULL), "_", NULL), key, NULL), min, max, &_inner_error_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp5_);
#line 585 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp6_;
#line 130 "rygel-environment-config.vala"
	return result;
#line 593 "rygel-environment-config.c"
}


#line 136 "rygel-environment-config.vala"
static GeeArrayList* rygel_environment_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 599 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	char* str;
	GeeArrayList* value;
	self = (RygelEnvironmentConfig*) base;
#line 136 "rygel-environment-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 136 "rygel-environment-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 610 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 139 "rygel-environment-config.vala"
	str = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error_);
#line 614 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 140 "rygel-environment-config.vala"
	value = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
#line 621 "rygel-environment-config.c"
	{
		char** _tmp0_;
		char** token_collection;
		int token_collection_length1;
		int token_it;
#line 141 "rygel-environment-config.vala"
		token_collection = _tmp0_ = g_strsplit (str, ",", -1);
#line 629 "rygel-environment-config.c"
		token_collection_length1 = _vala_array_length (_tmp0_);
		for (token_it = 0; token_it < _vala_array_length (_tmp0_); token_it = token_it + 1) {
			char* token;
			token = g_strdup (token_collection[token_it]);
			{
#line 142 "rygel-environment-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) value, GINT_TO_POINTER (atoi (token)));
#line 637 "rygel-environment-config.c"
				_g_free0 (token);
			}
		}
#line 141 "rygel-environment-config.vala"
		token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
#line 643 "rygel-environment-config.c"
	}
	result = value;
	_g_free0 (str);
#line 145 "rygel-environment-config.vala"
	return result;
#line 649 "rygel-environment-config.c"
}


#line 148 "rygel-environment-config.vala"
static gboolean rygel_environment_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 655 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	self = (RygelEnvironmentConfig*) base;
#line 148 "rygel-environment-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 148 "rygel-environment-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 671 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 151 "rygel-environment-config.vala"
	_tmp6_ = (_tmp5_ = rygel_environment_config_get_bool_variable (self, _tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp0_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_", NULL), _tmp1_ = g_utf8_strup (section, -1), NULL), "_", NULL), key, NULL), &_inner_error_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp5_);
#line 675 "rygel-environment-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp6_;
#line 151 "rygel-environment-config.vala"
	return result;
#line 683 "rygel-environment-config.c"
}


#line 156 "rygel-environment-config.vala"
static char* rygel_environment_config_get_string_variable (RygelEnvironmentConfig* self, const char* variable, GError** error) {
#line 689 "rygel-environment-config.c"
	char* result = NULL;
	GError * _inner_error_;
	char* str;
#line 156 "rygel-environment-config.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 156 "rygel-environment-config.vala"
	g_return_val_if_fail (variable != NULL, NULL);
#line 697 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 157 "rygel-environment-config.vala"
	str = g_strdup (g_getenv (variable));
#line 158 "rygel-environment-config.vala"
	if (str == NULL) {
#line 703 "rygel-environment-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (str);
			return NULL;
		}
	}
	result = str;
#line 162 "rygel-environment-config.vala"
	return result;
#line 714 "rygel-environment-config.c"
}


#line 165 "rygel-environment-config.vala"
static gint rygel_environment_config_get_int_variable (RygelEnvironmentConfig* self, const char* variable, gint min, gint max, GError** error) {
#line 720 "rygel-environment-config.c"
	gint result = 0;
	GError * _inner_error_;
	char* val;
#line 165 "rygel-environment-config.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 165 "rygel-environment-config.vala"
	g_return_val_if_fail (variable != NULL, 0);
#line 728 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 168 "rygel-environment-config.vala"
	val = g_strdup (g_getenv (variable));
#line 169 "rygel-environment-config.vala"
	if (val == NULL) {
#line 734 "rygel-environment-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			return 0;
		}
	}
	result = CLAMP (atoi (val), min, max);
	_g_free0 (val);
#line 173 "rygel-environment-config.vala"
	return result;
#line 746 "rygel-environment-config.c"
}


#line 1048 "glib-2.0.vapi"
static gboolean string_to_bool (const char* self) {
#line 752 "rygel-environment-config.c"
	gboolean result = FALSE;
#line 1048 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1049 "glib-2.0.vapi"
	if (_vala_strcmp0 (self, "true") == 0) {
#line 758 "rygel-environment-config.c"
		result = TRUE;
#line 1050 "glib-2.0.vapi"
		return result;
#line 762 "rygel-environment-config.c"
	} else {
		result = FALSE;
#line 1052 "glib-2.0.vapi"
		return result;
#line 767 "rygel-environment-config.c"
	}
}


#line 176 "rygel-environment-config.vala"
static gboolean rygel_environment_config_get_bool_variable (RygelEnvironmentConfig* self, const char* variable, GError** error) {
#line 774 "rygel-environment-config.c"
	gboolean result = FALSE;
	GError * _inner_error_;
	char* enabled;
#line 176 "rygel-environment-config.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 176 "rygel-environment-config.vala"
	g_return_val_if_fail (variable != NULL, FALSE);
#line 782 "rygel-environment-config.c"
	_inner_error_ = NULL;
#line 177 "rygel-environment-config.vala"
	enabled = g_strdup (g_getenv (variable));
#line 178 "rygel-environment-config.vala"
	if (enabled == NULL) {
#line 788 "rygel-environment-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (enabled);
			return FALSE;
		}
	}
	result = string_to_bool (enabled);
	_g_free0 (enabled);
#line 182 "rygel-environment-config.vala"
	return result;
#line 800 "rygel-environment-config.c"
}


#line 30 "rygel-environment-config.vala"
RygelEnvironmentConfig* rygel_environment_config_construct (GType object_type) {
#line 806 "rygel-environment-config.c"
	RygelEnvironmentConfig * self;
#line 30 "rygel-environment-config.vala"
	self = (RygelEnvironmentConfig*) g_object_new (object_type, NULL);
#line 810 "rygel-environment-config.c"
	return self;
}


#line 30 "rygel-environment-config.vala"
RygelEnvironmentConfig* rygel_environment_config_new (void) {
#line 30 "rygel-environment-config.vala"
	return rygel_environment_config_construct (RYGEL_TYPE_ENVIRONMENT_CONFIG);
#line 819 "rygel-environment-config.c"
}


static void rygel_environment_config_class_init (RygelEnvironmentConfigClass * klass) {
	rygel_environment_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_environment_config_finalize;
	rygel_environment_config_RYGEL_PREFIX = g_strdup ("RYGEL");
	rygel_environment_config_TITLE_KEY = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_TITLE", NULL);
	rygel_environment_config_ENABLED_KEY = g_strdup ("ENABLED");
	rygel_environment_config_INTERFACE_ENV = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_IFACE", NULL);
	rygel_environment_config_PORT_ENV = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_PORT", NULL);
	rygel_environment_config_TRANSCODING_ENV = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_TRANSCODING", NULL);
	rygel_environment_config_MP3_TRANSCODING_ENV = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_MP3_TRANS", NULL);
	rygel_environment_config_LPCM_TRANSCODING_ENV = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_LPCM_TRANS", NULL);
	rygel_environment_config_MP2TS_TRANSCODING_ENV = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_MP2TS_TRANS", NULL);
	rygel_environment_config_WMV_TRANSCODING_ENV = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_WMV_TRANS", NULL);
	rygel_environment_config_LOG_LEVEL_ENV = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_LOG", NULL);
	rygel_environment_config_PLUGIN_PATH_ENV = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_PLUGIN_PATH", NULL);
}


static void rygel_environment_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_environment_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = rygel_environment_config_real_get_upnp_enabled;
	iface->get_interface = rygel_environment_config_real_get_interface;
	iface->get_port = rygel_environment_config_real_get_port;
	iface->get_transcoding = rygel_environment_config_real_get_transcoding;
	iface->get_mp3_transcoder = rygel_environment_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = rygel_environment_config_real_get_mp2ts_transcoder;
	iface->get_wmv_transcoder = rygel_environment_config_real_get_wmv_transcoder;
	iface->get_lpcm_transcoder = rygel_environment_config_real_get_lpcm_transcoder;
	iface->get_log_level = rygel_environment_config_real_get_log_level;
	iface->get_plugin_path = rygel_environment_config_real_get_plugin_path;
	iface->get_enabled = rygel_environment_config_real_get_enabled;
	iface->get_title = rygel_environment_config_real_get_title;
	iface->get_string = rygel_environment_config_real_get_string;
	iface->get_string_list = rygel_environment_config_real_get_string_list;
	iface->get_int = rygel_environment_config_real_get_int;
	iface->get_int_list = rygel_environment_config_real_get_int_list;
	iface->get_bool = rygel_environment_config_real_get_bool;
}


static void rygel_environment_config_instance_init (RygelEnvironmentConfig * self) {
}


static void rygel_environment_config_finalize (GObject* obj) {
	RygelEnvironmentConfig * self;
	self = RYGEL_ENVIRONMENT_CONFIG (obj);
	G_OBJECT_CLASS (rygel_environment_config_parent_class)->finalize (obj);
}


GType rygel_environment_config_get_type (void) {
	static volatile gsize rygel_environment_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_environment_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelEnvironmentConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_environment_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelEnvironmentConfig), 0, (GInstanceInitFunc) rygel_environment_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_environment_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_environment_config_type_id;
		rygel_environment_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelEnvironmentConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_environment_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_environment_config_type_id__volatile, rygel_environment_config_type_id);
	}
	return rygel_environment_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




