/* rygel-gst-renderer-player.c generated by valac, the Vala compiler
 * generated from rygel-gst-renderer-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define RYGEL_GST_RENDERER_TYPE_PLAYER (rygel_gst_renderer_player_get_type ())
#define RYGEL_GST_RENDERER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_GST_RENDERER_TYPE_PLAYER, RygelGstRendererPlayer))
#define RYGEL_GST_RENDERER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_GST_RENDERER_TYPE_PLAYER, RygelGstRendererPlayerClass))
#define RYGEL_GST_RENDERER_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_GST_RENDERER_TYPE_PLAYER))
#define RYGEL_GST_RENDERER_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_GST_RENDERER_TYPE_PLAYER))
#define RYGEL_GST_RENDERER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_GST_RENDERER_TYPE_PLAYER, RygelGstRendererPlayerClass))

typedef struct _RygelGstRendererPlayer RygelGstRendererPlayer;
typedef struct _RygelGstRendererPlayerClass RygelGstRendererPlayerClass;
typedef struct _RygelGstRendererPlayerPrivate RygelGstRendererPlayerPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelGstRendererPlayer {
	GObject parent_instance;
	RygelGstRendererPlayerPrivate * priv;
};

struct _RygelGstRendererPlayerClass {
	GObjectClass parent_class;
};

struct _RygelGstRendererPlayerPrivate {
	GstElement* playbin;
	char* _playback_state;
};


static RygelGstRendererPlayer* rygel_gst_renderer_player_player;
static RygelGstRendererPlayer* rygel_gst_renderer_player_player = NULL;
static gpointer rygel_gst_renderer_player_parent_class = NULL;

GType rygel_gst_renderer_player_get_type (void);
#define RYGEL_GST_RENDERER_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_GST_RENDERER_TYPE_PLAYER, RygelGstRendererPlayerPrivate))
enum  {
	RYGEL_GST_RENDERER_PLAYER_DUMMY_PROPERTY,
	RYGEL_GST_RENDERER_PLAYER_PLAYBACK_STATE,
	RYGEL_GST_RENDERER_PLAYER_URI,
	RYGEL_GST_RENDERER_PLAYER_VOLUME,
	RYGEL_GST_RENDERER_PLAYER_DURATION,
	RYGEL_GST_RENDERER_PLAYER_POSITION
};
static gboolean rygel_gst_renderer_player_bus_handler (RygelGstRendererPlayer* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_gst_renderer_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static RygelGstRendererPlayer* rygel_gst_renderer_player_new (void);
static RygelGstRendererPlayer* rygel_gst_renderer_player_construct (GType object_type);
RygelGstRendererPlayer* rygel_gst_renderer_player_get_default (void);
GstClockTime rygel_gst_renderer_time_from_string (const char* str);
gboolean rygel_gst_renderer_player_seek (RygelGstRendererPlayer* self, const char* time);
void rygel_gst_renderer_player_set_playback_state (RygelGstRendererPlayer* self, const char* value);
const char* rygel_gst_renderer_player_get_playback_state (RygelGstRendererPlayer* self);
static inline const char* _dynamic_get_uri0 (GstElement* obj);
const char* rygel_gst_renderer_player_get_uri (RygelGstRendererPlayer* self);
static inline void _dynamic_set_uri1 (GstElement* obj, const char* value);
void rygel_gst_renderer_player_set_uri (RygelGstRendererPlayer* self, const char* value);
static inline double _dynamic_get_volume2 (GstElement* obj);
double rygel_gst_renderer_player_get_volume (RygelGstRendererPlayer* self);
static inline void _dynamic_set_volume3 (GstElement* obj, double value);
void rygel_gst_renderer_player_set_volume (RygelGstRendererPlayer* self, double value);
char* rygel_gst_renderer_time_to_string (GstClockTime time);
char* rygel_gst_renderer_player_get_duration (RygelGstRendererPlayer* self);
char* rygel_gst_renderer_player_get_position (RygelGstRendererPlayer* self);
static void rygel_gst_renderer_player_finalize (GObject* obj);
static void rygel_gst_renderer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_gst_renderer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



#line 133 "rygel-gst-renderer-player.vala"
static gboolean _rygel_gst_renderer_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
#line 109 "rygel-gst-renderer-player.c"
	gboolean result;
	result = rygel_gst_renderer_player_bus_handler (self, bus, message);
	return result;
}


#line 105 "rygel-gst-renderer-player.vala"
static RygelGstRendererPlayer* rygel_gst_renderer_player_construct (GType object_type) {
#line 118 "rygel-gst-renderer-player.c"
	RygelGstRendererPlayer * self;
	GstElement* _tmp0_;
	GstBus* bus;
#line 105 "rygel-gst-renderer-player.vala"
	self = (RygelGstRendererPlayer*) g_object_new (object_type, NULL);
#line 106 "rygel-gst-renderer-player.vala"
	self->priv->playbin = (_tmp0_ = gst_element_factory_make ("playbin2", NULL), _gst_object_unref0 (self->priv->playbin), _tmp0_);
#line 107 "rygel-gst-renderer-player.vala"
	g_assert (self->priv->playbin != NULL);
#line 110 "rygel-gst-renderer-player.vala"
	bus = gst_element_get_bus (self->priv->playbin);
#line 111 "rygel-gst-renderer-player.vala"
	gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_gst_renderer_player_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
#line 132 "rygel-gst-renderer-player.c"
	_gst_object_unref0 (bus);
	return self;
}


#line 105 "rygel-gst-renderer-player.vala"
static RygelGstRendererPlayer* rygel_gst_renderer_player_new (void) {
#line 105 "rygel-gst-renderer-player.vala"
	return rygel_gst_renderer_player_construct (RYGEL_GST_RENDERER_TYPE_PLAYER);
#line 142 "rygel-gst-renderer-player.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 114 "rygel-gst-renderer-player.vala"
RygelGstRendererPlayer* rygel_gst_renderer_player_get_default (void) {
#line 153 "rygel-gst-renderer-player.c"
	RygelGstRendererPlayer* result = NULL;
#line 115 "rygel-gst-renderer-player.vala"
	if (rygel_gst_renderer_player_player == NULL) {
#line 157 "rygel-gst-renderer-player.c"
		RygelGstRendererPlayer* _tmp0_;
#line 116 "rygel-gst-renderer-player.vala"
		rygel_gst_renderer_player_player = (_tmp0_ = rygel_gst_renderer_player_new (), _g_object_unref0 (rygel_gst_renderer_player_player), _tmp0_);
#line 161 "rygel-gst-renderer-player.c"
	}
	result = _g_object_ref0 (rygel_gst_renderer_player_player);
#line 119 "rygel-gst-renderer-player.vala"
	return result;
#line 166 "rygel-gst-renderer-player.c"
}


#line 122 "rygel-gst-renderer-player.vala"
gboolean rygel_gst_renderer_player_seek (RygelGstRendererPlayer* self, const char* time) {
#line 172 "rygel-gst-renderer-player.c"
	gboolean result = FALSE;
#line 122 "rygel-gst-renderer-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 122 "rygel-gst-renderer-player.vala"
	g_return_val_if_fail (time != NULL, FALSE);
#line 123 "rygel-gst-renderer-player.vala"
	g_debug (_ ("Seeking to %s."), time);
#line 180 "rygel-gst-renderer-player.c"
	result = gst_element_seek (self->priv->playbin, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, (gint64) rygel_gst_renderer_time_from_string (time), GST_SEEK_TYPE_NONE, (gint64) (-1));
#line 124 "rygel-gst-renderer-player.vala"
	return result;
#line 184 "rygel-gst-renderer-player.c"
}


#line 133 "rygel-gst-renderer-player.vala"
static gboolean rygel_gst_renderer_player_bus_handler (RygelGstRendererPlayer* self, GstBus* bus, GstMessage* message) {
#line 190 "rygel-gst-renderer-player.c"
	gboolean result = FALSE;
#line 133 "rygel-gst-renderer-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 133 "rygel-gst-renderer-player.vala"
	g_return_val_if_fail (bus != NULL, FALSE);
#line 133 "rygel-gst-renderer-player.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 135 "rygel-gst-renderer-player.vala"
	if (message->type == GST_MESSAGE_EOS) {
#line 136 "rygel-gst-renderer-player.vala"
		g_debug ("rygel-gst-renderer-player.vala:136: EOS");
#line 137 "rygel-gst-renderer-player.vala"
		rygel_gst_renderer_player_set_playback_state (self, "STOPPED");
#line 204 "rygel-gst-renderer-player.c"
	}
	result = TRUE;
#line 140 "rygel-gst-renderer-player.vala"
	return result;
#line 209 "rygel-gst-renderer-player.c"
}


const char* rygel_gst_renderer_player_get_playback_state (RygelGstRendererPlayer* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_playback_state;
#line 34 "rygel-gst-renderer-player.vala"
	return result;
#line 219 "rygel-gst-renderer-player.c"
}


void rygel_gst_renderer_player_set_playback_state (RygelGstRendererPlayer* self, const char* value) {
	char* _tmp0_;
	GQuark _tmp2_;
	const char* _tmp1_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	g_return_if_fail (self != NULL);
#line 38 "rygel-gst-renderer-player.vala"
	g_debug (_ ("Changing playback state to %s.."), value);
#line 39 "rygel-gst-renderer-player.vala"
	self->priv->_playback_state = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_playback_state), _tmp0_);
#line 235 "rygel-gst-renderer-player.c"
	_tmp1_ = self->priv->_playback_state;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("STOPPED"))))
	switch (0) {
		default:
		{
#line 43 "rygel-gst-renderer-player.vala"
			gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 44 "rygel-gst-renderer-player.vala"
			break;
#line 246 "rygel-gst-renderer-player.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("PAUSED_PLAYBACK"))))
	switch (0) {
		default:
		{
#line 46 "rygel-gst-renderer-player.vala"
			gst_element_set_state (self->priv->playbin, GST_STATE_PAUSED);
#line 47 "rygel-gst-renderer-player.vala"
			break;
#line 256 "rygel-gst-renderer-player.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("PLAYING"))))
	switch (0) {
		default:
		{
#line 49 "rygel-gst-renderer-player.vala"
			gst_element_set_state (self->priv->playbin, GST_STATE_PLAYING);
#line 50 "rygel-gst-renderer-player.vala"
			break;
#line 266 "rygel-gst-renderer-player.c"
		}
	} else
	switch (0) {
		default:
		{
#line 52 "rygel-gst-renderer-player.vala"
			break;
#line 274 "rygel-gst-renderer-player.c"
		}
	}
	g_object_notify ((GObject *) self, "playback-state");
}


static inline const char* _dynamic_get_uri0 (GstElement* obj) {
	const char* result;
	g_object_get (obj, "uri", &result, NULL);
	return result;
}


const char* rygel_gst_renderer_player_get_uri (RygelGstRendererPlayer* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = _dynamic_get_uri0 (self->priv->playbin);
#line 59 "rygel-gst-renderer-player.vala"
	return result;
#line 294 "rygel-gst-renderer-player.c"
}


static inline void _dynamic_set_uri1 (GstElement* obj, const char* value) {
	g_object_set (obj, "uri", value, NULL);
}


void rygel_gst_renderer_player_set_uri (RygelGstRendererPlayer* self, const char* value) {
	g_return_if_fail (self != NULL);
#line 63 "rygel-gst-renderer-player.vala"
	_dynamic_set_uri1 (self->priv->playbin, value);
#line 64 "rygel-gst-renderer-player.vala"
	g_debug (_ ("URI set to %s."), value);
#line 309 "rygel-gst-renderer-player.c"
	g_object_notify ((GObject *) self, "uri");
}


static inline double _dynamic_get_volume2 (GstElement* obj) {
	double result;
	g_object_get (obj, "volume", &result, NULL);
	return result;
}


double rygel_gst_renderer_player_get_volume (RygelGstRendererPlayer* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = _dynamic_get_volume2 (self->priv->playbin);
#line 70 "rygel-gst-renderer-player.vala"
	return result;
#line 327 "rygel-gst-renderer-player.c"
}


static inline void _dynamic_set_volume3 (GstElement* obj, double value) {
	g_object_set (obj, "volume", value, NULL);
}


void rygel_gst_renderer_player_set_volume (RygelGstRendererPlayer* self, double value) {
	g_return_if_fail (self != NULL);
#line 74 "rygel-gst-renderer-player.vala"
	_dynamic_set_volume3 (self->priv->playbin, value);
#line 75 "rygel-gst-renderer-player.vala"
	g_debug (_ ("volume set to %f."), value);
#line 342 "rygel-gst-renderer-player.c"
	g_object_notify ((GObject *) self, "volume");
}


char* rygel_gst_renderer_player_get_duration (RygelGstRendererPlayer* self) {
	char* result;
	GstFormat format;
	gint64 dur = 0LL;
	g_return_val_if_fail (self != NULL, NULL);
#line 81 "rygel-gst-renderer-player.vala"
	format = GST_FORMAT_TIME;
#line 84 "rygel-gst-renderer-player.vala"
	if (gst_element_query_duration (self->priv->playbin, &format, &dur)) {
#line 356 "rygel-gst-renderer-player.c"
		result = rygel_gst_renderer_time_to_string ((GstClockTime) dur);
#line 85 "rygel-gst-renderer-player.vala"
		return result;
#line 360 "rygel-gst-renderer-player.c"
	} else {
		result = g_strdup ("00:00:00");
#line 87 "rygel-gst-renderer-player.vala"
		return result;
#line 365 "rygel-gst-renderer-player.c"
	}
}


char* rygel_gst_renderer_player_get_position (RygelGstRendererPlayer* self) {
	char* result;
	GstFormat format;
	gint64 pos = 0LL;
	g_return_val_if_fail (self != NULL, NULL);
#line 94 "rygel-gst-renderer-player.vala"
	format = GST_FORMAT_TIME;
#line 97 "rygel-gst-renderer-player.vala"
	if (gst_element_query_position (self->priv->playbin, &format, &pos)) {
#line 379 "rygel-gst-renderer-player.c"
		result = rygel_gst_renderer_time_to_string ((GstClockTime) pos);
#line 98 "rygel-gst-renderer-player.vala"
		return result;
#line 383 "rygel-gst-renderer-player.c"
	} else {
		result = g_strdup ("00:00:00");
#line 100 "rygel-gst-renderer-player.vala"
		return result;
#line 388 "rygel-gst-renderer-player.c"
	}
}


static void rygel_gst_renderer_player_class_init (RygelGstRendererPlayerClass * klass) {
	rygel_gst_renderer_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstRendererPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_gst_renderer_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_gst_renderer_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_renderer_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_PLAYER_DURATION, g_param_spec_string ("duration", "duration", "duration", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_PLAYER_POSITION, g_param_spec_string ("position", "position", "position", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_gst_renderer_player_instance_init (RygelGstRendererPlayer * self) {
	self->priv = RYGEL_GST_RENDERER_PLAYER_GET_PRIVATE (self);
	self->priv->_playback_state = g_strdup ("STOPPED");
}


static void rygel_gst_renderer_player_finalize (GObject* obj) {
	RygelGstRendererPlayer * self;
	self = RYGEL_GST_RENDERER_PLAYER (obj);
	_gst_object_unref0 (self->priv->playbin);
	_g_free0 (self->priv->_playback_state);
	G_OBJECT_CLASS (rygel_gst_renderer_player_parent_class)->finalize (obj);
}


GType rygel_gst_renderer_player_get_type (void) {
	static volatile gsize rygel_gst_renderer_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_renderer_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstRendererPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_renderer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstRendererPlayer), 0, (GInstanceInitFunc) rygel_gst_renderer_player_instance_init, NULL };
		GType rygel_gst_renderer_player_type_id;
		rygel_gst_renderer_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstRendererPlayer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_gst_renderer_player_type_id__volatile, rygel_gst_renderer_player_type_id);
	}
	return rygel_gst_renderer_player_type_id__volatile;
}


static void rygel_gst_renderer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelGstRendererPlayer * self;
	self = RYGEL_GST_RENDERER_PLAYER (object);
	switch (property_id) {
		case RYGEL_GST_RENDERER_PLAYER_PLAYBACK_STATE:
		g_value_set_string (value, rygel_gst_renderer_player_get_playback_state (self));
		break;
		case RYGEL_GST_RENDERER_PLAYER_URI:
		g_value_set_string (value, rygel_gst_renderer_player_get_uri (self));
		break;
		case RYGEL_GST_RENDERER_PLAYER_VOLUME:
		g_value_set_double (value, rygel_gst_renderer_player_get_volume (self));
		break;
		case RYGEL_GST_RENDERER_PLAYER_DURATION:
		g_value_take_string (value, rygel_gst_renderer_player_get_duration (self));
		break;
		case RYGEL_GST_RENDERER_PLAYER_POSITION:
		g_value_take_string (value, rygel_gst_renderer_player_get_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_gst_renderer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelGstRendererPlayer * self;
	self = RYGEL_GST_RENDERER_PLAYER (object);
	switch (property_id) {
		case RYGEL_GST_RENDERER_PLAYER_PLAYBACK_STATE:
		rygel_gst_renderer_player_set_playback_state (self, g_value_get_string (value));
		break;
		case RYGEL_GST_RENDERER_PLAYER_URI:
		rygel_gst_renderer_player_set_uri (self, g_value_get_string (value));
		break;
		case RYGEL_GST_RENDERER_PLAYER_VOLUME:
		rygel_gst_renderer_player_set_volume (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




