/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <gnome.h>
#include <libbonobo.h>
#define BONOBO_UI_INTERNAL
#include <libbonoboui.h>

#include <libxklavier/xklavier_config.h>

#include "xkb_capplet_private.h"

static BonoboUIEngine *buie;

static void popup_handle( BonoboUIComponent * uic,
                          GSwitchItCapplet * gswic, const gchar * verbname )
{
  XklDebug( 150, "Verb: [%s]\n", verbname );
}

static BonoboUIVerb verbs[] = {
  BONOBO_UI_UNSAFE_VERB( "RemoveAppletFromPanel", popup_handle ),
  BONOBO_UI_UNSAFE_VERB( "MoveApplet", XkbCappletPreviewClicked ),
  BONOBO_UI_VERB_END
};

static void _XkbCappletPreviewZoomDo( GSwitchItCapplet * gswic, int action )
{
  GtkWidget *preview =
    g_object_get_data( G_OBJECT( gswic->capplet ), BONOBO_PREVIEW_PROPERTY );
  Bonobo_Zoomable zoomable;

  if( preview == NULL )
    return;

#if 0
  BonoboControlFrame *bcf =
    bonobo_widget_get_control_frame( BONOBO_WIDGET( preview ) );
  XklDebug( 150, "bcf: %p\n", bcf );
  BonoboUIComponent *buic =
    bonobo_control_frame_get_popup_component( bcf, NULL );
  XklDebug( 150, "buic: %p\n", buic );
  CORBA_char *uidata = bonobo_ui_component_get( buic, "/", True, NULL );
  XklDebug( 150, "data: [%s]\n", uidata );

  Bonobo_Control b_c = bonobo_control_frame_get_control( bcf );
  XklDebug( 150, "b_c: %p\n", b_c );
  Bonobo_UIContainer b_uic1 =
    bonobo_widget_get_ui_container( BONOBO_WIDGET( preview ) );
  XklDebug( 150, "b_uic1: %p\n", b_uic1 );
  Bonobo_Unknown bu = Bonobo_UIContainer_getObject( b_uic1, "/", NULL );
  XklDebug( 150, "bu: %p\n", bu );

  Bonobo_UIContainer b_uic = Bonobo_Control_getPopupContainer( b_c, NULL );
  XklDebug( 150, "b_uic: %p\n", b_uic );

  CORBA_char *xml = bonobo_ui_engine_xml_get( buie, "/",
                                              False );
  XklDebug( 150, "xml from engine: [%s]\n", xml );
#endif
  zoomable =
    ( Bonobo_Zoomable )
    Bonobo_Unknown_queryInterface( bonobo_widget_get_objref
                                   ( BONOBO_WIDGET( preview ) ),
                                   "IDL:Bonobo/Zoomable:1.0", NULL );

  if( zoomable != CORBA_OBJECT_NIL )
  {
    Bonobo_Unknown_ref( zoomable, NULL );
    switch ( action )
    {
      case 0:
        Bonobo_Zoomable_zoomIn( zoomable, NULL );
        break;
      case 1:
        Bonobo_Zoomable_zoomOut( zoomable, NULL );
        break;
      case 2:
        Bonobo_Zoomable_zoomFit( zoomable, NULL );
        break;
      case 3:
        Bonobo_Zoomable_zoomDefault( zoomable, NULL );
        break;
    }
    Bonobo_Unknown_unref( zoomable, NULL );
  }
}

static void XklCappletPreviewRealize( GtkWidget * preview,
                                      GSwitchItCapplet * gswic )
{
  XkbCappletPreviewZoomFit( NULL, gswic );
}

void XkbCappletPreviewClicked( GtkButton * button, GSwitchItCapplet * gswic )
{
  GtkWidget *container = CappletGetGladeWidget( gswic, "framePreview" );
  GtkWidget *oldChild = GTK_BIN( container )->child;
  GtkWidget *newChild;
  char *home = getenv( "HOME" );
  char psFileMoniker[PATH_MAX + 6];
  gboolean isZoomable = FALSE;

  g_snprintf( psFileMoniker, sizeof( psFileMoniker ),
              "file:/%s/.gnome_private/xkbpreview.ps", home );

  XkbCappletUpdateConfigFromGui( gswic );

  GSwitchItConfigXkbDumpSettings( &gswic->config, psFileMoniker + 6 );  // just skip the prefix

  XklDebug( 150, "So, creating control for [%s]\n", psFileMoniker );
  if( oldChild != NULL )
  {
    gtk_container_remove( GTK_CONTAINER( container ), oldChild );
  }
//#define PERVERTED_BW

#ifdef PERVERTED_BW
  BonoboUIContainer *buic = bonobo_ui_container_new(  );
  XklDebug( 150, "bui before creation: %p\n", buic );
  buie = bonobo_ui_engine_new( NULL );
  XklDebug( 150, "buie before creation: %p\n", buie );

  GtkWidget *bd = bonobo_dock_new(  );
  bonobo_dock_allow_floating_items( BONOBO_DOCK( bd ), True );

  BonoboDockItemBehavior behavior = BONOBO_DOCK_ITEM_BEH_NORMAL;
  GtkWidget *menuItem = bonobo_dock_item_new( "menu", behavior );
  GtkWidget *menuBar = gtk_menu_bar_new(  );
  gtk_menu_shell_insert( GTK_MENU_SHELL( menuBar ),
                         gtk_menu_item_new_with_label( "TeSt1" ), 0 );
  gtk_menu_shell_insert( GTK_MENU_SHELL( menuBar ),
                         gtk_menu_item_new_with_label( "tEsT2" ), 0 );
  gtk_container_add( GTK_CONTAINER( menuItem ), menuBar );
  bonobo_dock_add_item( BONOBO_DOCK( bd ), BONOBO_DOCK_ITEM( menuItem ),
                        BONOBO_DOCK_TOP, 0, 0, 0, TRUE );
  BonoboUISync *buism =
    bonobo_ui_sync_menu_new( buie, menuBar, menuItem, NULL );
  bonobo_ui_engine_add_sync( buie, buism );

  BonoboUISync *buist = bonobo_ui_sync_toolbar_new( buie, BONOBO_DOCK( bd ) );
  bonobo_ui_engine_add_sync( buie, buist );

  GtkWidget *vbox = gtk_vbox_new( False, 5 );
  gtk_container_add( GTK_CONTAINER( container ), vbox );
  gtk_box_pack_start( GTK_BOX( vbox ), GTK_WIDGET( bd ), TRUE, TRUE, 0 );
  GtkWidget *status = gtk_hbox_new( FALSE, 0 );
  gtk_box_pack_end( GTK_BOX( vbox ), GTK_WIDGET( status ), FALSE, FALSE, 0 );
  BonoboUISync *buiss = bonobo_ui_sync_status_new( buie, status );
  bonobo_ui_engine_add_sync( buie, buiss );

  bonobo_ui_container_set_engine( buic, buie );
  Bonobo_UIContainer b_uic =
    ( Bonobo_UIContainer )
    bonobo_object_query_interface( BONOBO_OBJECT( buic ),
                                   "IDL:Bonobo/UIContainer:1.0", NULL );
  XklDebug( 150, "b_uic before creation: %p\n", b_uic );
#endif

//  BonoboControlFrame * bcf = bonobo_control_frame_new( b_uic );
//  bonobo_control_frame_bind_to_control( bcf, bonobo_widget_get_objref( newChild ), NULL );
//  bonobo_control_frame_set_autoactivate ( bcf, TRUE );

  //newChild = bonobo_widget_new_control( psFileMoniker, b_uic );
#if 1
  newChild = bonobo_widget_new_control( psFileMoniker, CORBA_OBJECT_NIL );
#else
  newChild =
    bonobo_widget_new_control( "file://usr/share/pixmaps/epiphany.png",
//    bonobo_widget_new_control( "file://archive/Docs/refcard.ps",
                               NULL );
#endif

  if( newChild != NULL )        // some error?
  {
    Bonobo_Zoomable zoomable =
      ( Bonobo_Zoomable )
      Bonobo_Unknown_queryInterface
      ( bonobo_widget_get_objref( BONOBO_WIDGET( newChild ) ),
        "IDL:Bonobo/Zoomable:1.0", NULL );
    XkbCappletPrepareWidget( gswic, newChild, NULL, BONOBO_PREVIEW_PROPERTY );
    if( zoomable != CORBA_OBJECT_NIL )
    {
      g_signal_connect( G_OBJECT( newChild ),
                        "realize",
                        G_CALLBACK( XklCappletPreviewRealize ), gswic );
      isZoomable = True;
    }
#ifdef PERVERTED_BW
    bonobo_dock_set_client_area( BONOBO_DOCK( bd ), newChild );
    gtk_widget_show_all( vbox );
#endif

#if 0
    BonoboControlFrame *bcf =
      bonobo_widget_get_control_frame( BONOBO_WIDGET( newChild ) );
    BonoboUIComponent *buico =
      bonobo_control_frame_get_popup_component( bcf, NULL );
    //bonobo_ui_util_set_ui( buico, "/usr/share/gnome-2.0/ui",
    bonobo_ui_util_set_ui( buico, "/home/svu/GSwitchIt/container",
                           "container-ui.xml", "panel", NULL );
    bonobo_ui_component_add_verb_list_with_data( buico, verbs, gswic );
#endif

#ifndef PERVERTED_BW
    gtk_container_add( GTK_CONTAINER( container ), newChild );
    gtk_widget_show_all( newChild );
#endif
  } else
  {
    GtkWidget *msg = gtk_message_dialog_new( NULL,
                                             GTK_DIALOG_MODAL,
                                             GTK_MESSAGE_ERROR,
                                             GTK_BUTTONS_CLOSE,
                                             _( "Bonobo Error" ) );
    gtk_dialog_run( GTK_DIALOG( msg ) );
    gtk_widget_destroy( msg );
  }

  gtk_widget_set_sensitive
    ( CappletGetGladeWidget( gswic, "btnZoomIn" ), isZoomable );
  gtk_widget_set_sensitive
    ( CappletGetGladeWidget( gswic, "btnZoomOut" ), isZoomable );
  gtk_widget_set_sensitive
    ( CappletGetGladeWidget( gswic, "btnZoomFit" ), isZoomable );
  gtk_widget_set_sensitive
    ( CappletGetGladeWidget( gswic, "btnZoomDefault" ), isZoomable );
}

void XkbCappletPreviewZoomIn( GtkWidget * w, GSwitchItCapplet * gswic )
{
  _XkbCappletPreviewZoomDo( gswic, 0 );
}

void XkbCappletPreviewZoomOut( GtkWidget * w, GSwitchItCapplet * gswic )
{
  _XkbCappletPreviewZoomDo( gswic, 1 );
}

void XkbCappletPreviewZoomFit( GtkWidget * btn, GSwitchItCapplet * gswic )
{
  _XkbCappletPreviewZoomDo( gswic, 2 );
}

void XkbCappletPreviewZoomDefault( GtkWidget * w, GSwitchItCapplet * gswic )
{
  _XkbCappletPreviewZoomDo( gswic, 3 );
}
