/*
 *  Copyright (C) 2002 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __sidebarproxy_h
#define __sidebarproxy_h

#include <nsISidebar.h>
#include <nsIClassInfo.h>
#include <nsError.h>
#include "SideBar.h"

// {b0ac1c8f-2960-46e0-afe4-bf74ed7e6659}
#define G_SIDEBAR_CID \
{ 0xb0ac1c8f, 0x2960, 0x46e0, { 0xaf, 0xe4, 0xbf, 0x74, 0xed, 0x7e, 0x66, 0x59 } }

extern GSidebar *GlobalSidebar;

class GSidebarProxy : public nsISidebar, nsIClassInfo
{
  public:
	NS_DECL_ISUPPORTS
	NS_DECL_NSICLASSINFO
	NS_FORWARD_SAFE_NSISIDEBAR(GlobalSidebar);

	GSidebarProxy();
	virtual ~GSidebarProxy();
  private:
};

nsresult NS_NewSidebarFactory(nsIFactory** aFactory);

#endif //__sidebarproxy_h

