"""
Provides human readable strings, icon names and animations for internal 
enumerations

This file was autogenerated from src/gpk-enum.c by msg-converter.py
"""

from packagekit.enums import *
import gettext
from gettext import gettext as _

gettext.textdomain("gnome-packagekit")

GPK_BUGZILLA_URL = "https://bugs.freedesktop.org/"

ICONS_INFO = {
    INFO_UNKNOWN:'help-browser',
    INFO_INSTALLED:'pk-package-installed',
    INFO_AVAILABLE:'pk-package-available',
    INFO_LOW:'pk-update-low',
    INFO_NORMAL:'pk-update-normal',
    INFO_IMPORTANT:'pk-update-high',
    INFO_SECURITY:'pk-update-security',
    INFO_BUGFIX:'pk-update-bugfix',
    INFO_ENHANCEMENT:'pk-update-enhancement',
    INFO_BLOCKED:'pk-package-blocked',
    INFO_DOWNLOADING:'pk-package-download',
    INFO_UPDATING:'pk-package-update',
    INFO_INSTALLING:'pk-package-add',
    INFO_REMOVING:'pk-package-delete',
    INFO_OBSOLETING:'pk-package-cleanup',
    INFO_CLEANUP:'pk-package-cleanup',
    INFO_COLLECTION_INSTALLED:'pk-collection-installed',
    INFO_COLLECTION_AVAILABLE:'pk-collection-available',
    INFO_FINISHED:'dialog-information',
    INFO_REINSTALLING:'dialog-information',
    INFO_DOWNGRADING:'pk-package-update',
    }

def get_info_icon_name_from_enum(enum):
   if ICONS_INFO.has_key(enum):
       return ICONS_INFO[enum]
   else:
       return None

ICONS_STATUS = {
    STATUS_UNKNOWN:'help-browser',
    STATUS_CANCEL:'pk-package-cleanup',
    STATUS_CLEANUP:'pk-package-cleanup',
    STATUS_COMMIT:'pk-setup',
    STATUS_DEP_RESOLVE:'pk-package-info',
    STATUS_DOWNLOAD_CHANGELOG:'pk-refresh-cache',
    STATUS_DOWNLOAD_FILELIST:'pk-refresh-cache',
    STATUS_DOWNLOAD_GROUP:'pk-refresh-cache',
    STATUS_DOWNLOAD_PACKAGELIST:'pk-refresh-cache',
    STATUS_DOWNLOAD:'pk-package-download',
    STATUS_DOWNLOAD_REPOSITORY:'pk-refresh-cache',
    STATUS_DOWNLOAD_UPDATEINFO:'pk-refresh-cache',
    STATUS_FINISHED:'pk-package-cleanup',
    STATUS_GENERATE_PACKAGE_LIST:'pk-refresh-cache',
    STATUS_WAITING_FOR_LOCK:'pk-package-blocked',
    STATUS_WAITING_FOR_AUTH:'gtk-dialog-authentication',
    STATUS_INFO:'pk-package-info',
    STATUS_INSTALL:'pk-package-add',
    STATUS_LOADING_CACHE:'pk-refresh-cache',
    STATUS_OBSOLETE:'pk-package-cleanup',
    STATUS_QUERY:'pk-package-search',
    STATUS_REFRESH_CACHE:'pk-refresh-cache',
    STATUS_REMOVE:'pk-package-delete',
    STATUS_REPACKAGING:'pk-package-cleanup',
    STATUS_REQUEST:'pk-package-search',
    STATUS_ROLLBACK:'pk-package-info',
    STATUS_RUNNING:'pk-setup',
    STATUS_SCAN_APPLICATIONS:'pk-package-search',
    STATUS_SETUP:'pk-setup',
    STATUS_SIG_CHECK:'pk-package-info',
    STATUS_TEST_COMMIT:'pk-package-info',
    STATUS_UPDATE:'pk-package-update',
    STATUS_WAIT:'pk-wait',
    STATUS_SCAN_PROCESS_LIST:'pk-package-info',
    STATUS_CHECK_EXECUTABLE_FILES:'pk-package-info',
    STATUS_CHECK_LIBRARIES:'pk-package-info',
    }

def get_status_icon_name_from_enum(enum):
   if ICONS_STATUS.has_key(enum):
       return ICONS_STATUS[enum]
   else:
       return None

ICONS_ROLE = {
    ROLE_UNKNOWN:'help-browser',
    ROLE_ACCEPT_EULA:'pk-package-info',
    ROLE_CANCEL:'process-stop',
    ROLE_DOWNLOAD_PACKAGES:'pk-package-download',
    ROLE_GET_CATEGORIES:'pk-package-info',
    ROLE_GET_DEPENDS:'pk-package-info',
    ROLE_GET_DETAILS:'pk-package-info',
    ROLE_GET_DISTRO_UPGRADES:'pk-package-info',
    ROLE_GET_FILES:'pk-package-search',
    ROLE_GET_OLD_TRANSACTIONS:'pk-package-info',
    ROLE_GET_PACKAGES:'pk-package-search',
    ROLE_GET_REPO_LIST:'pk-package-sources',
    ROLE_GET_REQUIRES:'pk-package-info',
    ROLE_GET_UPDATE_DETAIL:'pk-package-info',
    ROLE_GET_UPDATES:'pk-package-info',
    ROLE_INSTALL_FILES:'pk-package-add',
    ROLE_INSTALL_PACKAGES:'pk-package-add',
    ROLE_INSTALL_SIGNATURE:'emblem-system',
    ROLE_REFRESH_CACHE:'pk-refresh-cache',
    ROLE_REMOVE_PACKAGES:'pk-package-delete',
    ROLE_REPO_ENABLE:'pk-package-sources',
    ROLE_REPO_SET_DATA:'pk-package-sources',
    ROLE_RESOLVE:'pk-package-search',
    ROLE_ROLLBACK:'pk-rollback',
    ROLE_SEARCH_DETAILS:'pk-package-search',
    ROLE_SEARCH_FILE:'pk-package-search',
    ROLE_SEARCH_GROUP:'pk-package-search',
    ROLE_SEARCH_NAME:'pk-package-search',
    ROLE_UPDATE_PACKAGES:'pk-package-update',
    ROLE_UPDATE_SYSTEM:'system-software-update',
    ROLE_WHAT_PROVIDES:'pk-package-search',
    ROLE_SIMULATE_INSTALL_FILES:'pk-package-add',
    ROLE_SIMULATE_INSTALL_PACKAGES:'pk-package-add',
    ROLE_SIMULATE_REMOVE_PACKAGES:'pk-package-delete',
    ROLE_SIMULATE_UPDATE_PACKAGES:'pk-package-update',
    }

def get_role_icon_name_from_enum(enum):
   if ICONS_ROLE.has_key(enum):
       return ICONS_ROLE[enum]
   else:
       return None

ICONS_GROUP = {
    GROUP_UNKNOWN:'help-browser',
    GROUP_ACCESSIBILITY:'preferences-desktop-accessibility',
    GROUP_ACCESSORIES:'applications-accessories',
    GROUP_ADMIN_TOOLS:'system-lock-screen',
    GROUP_COLLECTIONS:'pk-collection-installed',
    GROUP_COMMUNICATION:'folder-remote',
    GROUP_DESKTOP_GNOME:'pk-desktop-gnome',
    GROUP_DESKTOP_KDE:'pk-desktop-kde',
    GROUP_DESKTOP_OTHER:'user-desktop',
    GROUP_DESKTOP_XFCE:'pk-desktop-xfce',
    GROUP_DOCUMENTATION:'x-office-address-book',
    GROUP_EDUCATION:'utilities-system-monitor',
    GROUP_ELECTRONICS:'video-display',
    GROUP_FONTS:'preferences-desktop-font',
    GROUP_GAMES:'applications-games',
    GROUP_GRAPHICS:'applications-graphics',
    GROUP_INTERNET:'applications-internet',
    GROUP_LEGACY:'media-floppy',
    GROUP_LOCALIZATION:'preferences-desktop-locale',
    GROUP_MAPS:'applications-multimedia',
    GROUP_MULTIMEDIA:'applications-multimedia',
    GROUP_NETWORK:'network-wired',
    GROUP_OFFICE:'applications-office',
    GROUP_OTHER:'applications-other',
    GROUP_POWER_MANAGEMENT:'battery',
    GROUP_PROGRAMMING:'applications-development',
    GROUP_PUBLISHING:'accessories-dictionary',
    GROUP_REPOS:'system-file-manager',
    GROUP_SCIENCE:'application-certificate',
    GROUP_SECURITY:'network-wireless-encrypted',
    GROUP_SERVERS:'network-server',
    GROUP_SYSTEM:'applications-system',
    GROUP_VIRTUALIZATION:'computer',
    GROUP_VENDOR:'application-certificate',
    GROUP_NEWEST:'dialog-information',
    }

def get_group_icon_name_from_enum(enum):
   if ICONS_GROUP.has_key(enum):
       return ICONS_GROUP[enum]
   else:
       return None

ICONS_RESTART = {
    RESTART_UNKNOWN:'help-browser',
    RESTART_SYSTEM:'system-shutdown',
    RESTART_SESSION:'system-log-out',
    RESTART_APPLICATION:'emblem-symbolic-link',
    RESTART_SECURITY_SYSTEM:'system-shutdown',
    RESTART_SECURITY_SESSION:'system-log-out',
    }

def get_restart_icon_name_from_enum(enum):
   if ICONS_RESTART.has_key(enum):
       return ICONS_RESTART[enum]
   else:
       return None

ICONS_RESTART_DIALOG = {
    RESTART_UNKNOWN:'help-browser',
    RESTART_NONE:'dialog-information',
    RESTART_SYSTEM:'dialog-error',
    RESTART_SESSION:'dialog-warning',
    RESTART_APPLICATION:'dialog-warning',
    RESTART_SECURITY_SYSTEM:'dialog-error',
    RESTART_SECURITY_SESSION:'dialog-error',
    }

def get_restart_dialog_icon_name_from_enum(enum):
   if ICONS_RESTART_DIALOG.has_key(enum):
       return ICONS_RESTART_DIALOG[enum]
   else:
       return None

ICONS_MESSAGE = {
    MESSAGE_UNKNOWN:'help-browser',
    MESSAGE_BROKEN_MIRROR:'dialog-error',
    MESSAGE_CONNECTION_REFUSED:'dialog-error',
    MESSAGE_PARAMETER_INVALID:'dialog-error',
    MESSAGE_PRIORITY_INVALID:'dialog-error',
    MESSAGE_BACKEND_ERROR:'dialog-error',
    MESSAGE_DAEMON_ERROR:'dialog-error',
    MESSAGE_CACHE_BEING_REBUILT:'dialog-information',
    MESSAGE_UNTRUSTED_PACKAGE:'dialog-warning',
    MESSAGE_NEWER_PACKAGE_EXISTS:'dialog-information',
    MESSAGE_CONFIG_FILES_CHANGED:'dialog-information',
    MESSAGE_PACKAGE_ALREADY_INSTALLED:'dialog-information',
    MESSAGE_AUTOREMOVE_IGNORED:'dialog-information',
    MESSAGE_REPO_METADATA_DOWNLOAD_FAILED:'dialog-warning',
    }

def get_message_icon_name_from_enum(enum):
   if ICONS_MESSAGE.has_key(enum):
       return ICONS_MESSAGE[enum]
   else:
       return None

ANIMATIONS_STATUS = {
    STATUS_UNKNOWN:'help-browser',
    STATUS_CANCEL:'pk-action-cleanup',
    STATUS_CLEANUP:'pk-action-cleanup',
    STATUS_COMMIT:'pk-setup',
    STATUS_DEP_RESOLVE:'pk-action-testing',
    STATUS_DOWNLOAD_CHANGELOG:'pk-action-refresh-cache',
    STATUS_DOWNLOAD_FILELIST:'pk-action-refresh-cache',
    STATUS_DOWNLOAD_GROUP:'pk-action-refresh-cache',
    STATUS_DOWNLOAD_PACKAGELIST:'pk-action-refresh-cache',
    STATUS_DOWNLOAD:'pk-action-download',
    STATUS_DOWNLOAD_REPOSITORY:'pk-action-refresh-cache',
    STATUS_DOWNLOAD_UPDATEINFO:'pk-action-refresh-cache',
    STATUS_FINISHED:'pk-package-cleanup',
    STATUS_GENERATE_PACKAGE_LIST:'pk-action-searching',
    STATUS_WAITING_FOR_LOCK:'pk-action-waiting',
    STATUS_WAITING_FOR_AUTH:'pk-action-waiting',
    STATUS_INFO:'process-working',
    STATUS_INSTALL:'pk-action-installing',
    STATUS_LOADING_CACHE:'pk-action-refresh-cache',
    STATUS_OBSOLETE:'pk-package-cleanup',
    STATUS_QUERY:'pk-action-searching',
    STATUS_REFRESH_CACHE:'pk-action-refresh-cache',
    STATUS_REMOVE:'pk-action-removing',
    STATUS_REPACKAGING:'pk-package-info',
    STATUS_REQUEST:'process-working',
    STATUS_ROLLBACK:'pk-action-removing',
    STATUS_RUNNING:'pk-setup',
    STATUS_SCAN_APPLICATIONS:'pk-action-searching',
    STATUS_SETUP:'pk-package-info',
    STATUS_SIG_CHECK:'pk-package-info',
    STATUS_TEST_COMMIT:'pk-action-testing',
    STATUS_UPDATE:'pk-action-installing',
    STATUS_WAIT:'pk-action-waiting',
    STATUS_SCAN_PROCESS_LIST:'pk-package-info',
    STATUS_CHECK_EXECUTABLE_FILES:'pk-package-info',
    STATUS_CHECK_LIBRARIES:'pk-package-info',
    }

def get_status_animation_name_from_enum(enum):
   if ANIMATIONS_STATUS.has_key(enum):
       return ANIMATIONS_STATUS[enum]
   else:
       return None

PAST_INFO = {
    }

def get_info_localised_past_from_enum(enum):
   if PAST_INFO.has_key(enum):
       return PAST_INFO[enum]
   else:
       return None

PAST_ROLE = {
    }

def get_role_localised_past_from_enum(enum):
   if PAST_ROLE.has_key(enum):
       return PAST_ROLE[enum]
   else:
       return None

PRESENT_INFO = {
    }

def get_info_localised_present_from_enum(enum):
   if PRESENT_INFO.has_key(enum):
       return PRESENT_INFO[enum]
   else:
       return None

PRESENT_ROLE = {
    }

def get_role_localised_present_from_enum(enum):
   if PRESENT_ROLE.has_key(enum):
       return PRESENT_ROLE[enum]
   else:
       return None

DESCS_ERROR = {
    ERROR_NO_NETWORK:_("There is no network connection available.\n"
			 "Please check your connection settings and try again."),
    ERROR_NO_CACHE:_("The package list needs to be rebuilt.\n"
			 "This should have been done by the backend automatically."),
    ERROR_OOM:_("The service that is responsible for handling user requests is out of memory.\n"
			 "Please restart your computer."),
    ERROR_CREATE_THREAD_FAILED:_("A thread could not be created to service the user request."),
    ERROR_NOT_SUPPORTED:_("The action is not supported by this backend.\n"
			 "Please report a bug in your distribution bugtracker as this should not have happened."),
    ERROR_INTERNAL_ERROR:_("A problem that we were not expecting has occurred.\n"
			 "Please report this bug in your distribution bugtracker with the error description."),
    ERROR_GPG_FAILURE:_("A security trust relationship could not be made with software source.\n"
			 "Please check your security settings."),
    ERROR_PACKAGE_NOT_INSTALLED:_("The package that is trying to be removed or updated is not already installed."),
    ERROR_PACKAGE_NOT_FOUND:_("The package that is being modified was not found on your system or in any software source."),
    ERROR_PACKAGE_ALREADY_INSTALLED:_("The package that is trying to be installed is already installed."),
    ERROR_PACKAGE_DOWNLOAD_FAILED:_("The package download failed.\n"
			 "Please check your network connectivity."),
    ERROR_GROUP_NOT_FOUND:_("The group type was not found.\n"
			 "Please check your group list and try again."),
    ERROR_GROUP_LIST_INVALID:_("The group list could not be loaded.\n"
			 "Refreshing your cache may help, although this is normally a software "
			 "source error."),
    ERROR_DEP_RESOLUTION_FAILED:_("A package could not be found that allows the action to complete.\n"
			 "More information is available in the detailed report."),
    ERROR_FILTER_INVALID:_("The search filter was not correctly formed."),
    ERROR_PACKAGE_ID_INVALID:_("The package identifier was not well formed when sent to the server.\n"
			 "This normally indicates an internal error and should be reported."),
    ERROR_TRANSACTION_ERROR:_("An unspecified transaction error has occurred.\n"
			 "More information is available in the detailed report."),
    ERROR_REPO_NOT_FOUND:_("The remote software source name was not found.\n"
			 "You may need to enable an item in Software Sources."),
    ERROR_CANNOT_REMOVE_SYSTEM_PACKAGE:_("Removing a protected system package is not allowed."),
    ERROR_TRANSACTION_CANCELLED:_("The action was canceled successfully and no packages were changed."),
    ERROR_PROCESS_KILL:_("The action was canceled successfully and no packages were changed.\n"
			 "The backend did not exit cleanly."),
    ERROR_FAILED_CONFIG_PARSING:_("The native package configuration file could not be opened.\n"
			 "Please make sure configuration is valid."),
    ERROR_CANNOT_CANCEL:_("The action cannot be canceled at this time."),
    ERROR_CANNOT_INSTALL_SOURCE_PACKAGE:_("Source packages are not normally installed this way.\n"
			 "Check the extension of the file you are trying to install."),
    ERROR_NO_LICENSE_AGREEMENT:_("The license agreement was not agreed to.\n"
			 "To use this software you have to accept the license."),
    ERROR_FILE_CONFLICTS:_("Two packages provide the same file.\n"
			 "This is usually due to mixing packages from different software sources."),
    ERROR_PACKAGE_CONFLICTS:_("Multiple packages exist that are not compatible with each other.\n"
			 "This is usually due to mixing packages from different software sources."),
    ERROR_REPO_NOT_AVAILABLE:_("There was a (possibly temporary) problem connecting to a software source.\n"
			 "Please check the detailed error for further details."),
    ERROR_FAILED_INITIALIZATION:_("Failed to initialize packaging backend.\n"
			 "This may occur if other packaging tools are being used simultaneously."),
    ERROR_FAILED_FINALISE:_("Failed to close down the backend instance.\n"
			 "This error can normally be ignored."),
    ERROR_CANNOT_GET_LOCK:_("Cannot get the exclusive lock on the packaging backend.\n"
			 "Please close any other legacy packaging tools that may be open."),
    ERROR_NO_PACKAGES_TO_UPDATE:_("None of the selected packages could be updated."),
    ERROR_CANNOT_WRITE_REPO_CONFIG:_("The repository configuration could not be modified."),
    ERROR_LOCAL_INSTALL_FAILED:_("Installing the local file failed.\n"
			 "More information is available in the detailed report."),
    ERROR_BAD_GPG_SIGNATURE:_("The package security signature could not be verified."),
    ERROR_MISSING_GPG_SIGNATURE:_("The package security signature is missing and this package is untrusted.\n"
			 "This package was not signed when created."),
    ERROR_REPO_CONFIGURATION_ERROR:_("Repository configuration was invalid and could not be read."),
    ERROR_INVALID_PACKAGE_FILE:_("The package you are attempting to install is not valid.\n"
			 "The package file could be corrupt, or not a proper package."),
    ERROR_PACKAGE_INSTALL_BLOCKED:_("Installation of this package prevented by your packaging system's configuration."),
    ERROR_PACKAGE_CORRUPT:_("The package that was downloaded is corrupt and needs to be downloaded again."),
    ERROR_ALL_PACKAGES_ALREADY_INSTALLED:_("All of the packages selected for install are already installed on the system."),
    ERROR_FILE_NOT_FOUND:_("The specified file could not be found on the system.\n"
			 "Check the file still exists and has not been deleted."),
    ERROR_NO_MORE_MIRRORS_TO_TRY:_("Required data could not be found on any of the configured software sources.\n"
			 "There were no more download mirrors that could be tried."),
    ERROR_NO_DISTRO_UPGRADE_DATA:_("Required upgrade data could not be found in any of the configured software sources.\n"
			 "The list of distribution upgrades will be unavailable."),
    ERROR_INCOMPATIBLE_ARCHITECTURE:_("The package that is trying to be installed is incompatible with this system."),
    ERROR_NO_SPACE_ON_DEVICE:_("There is insufficient space on the device.\n"
			 "Free some space on the system disk to perform this operation."),
    ERROR_MEDIA_CHANGE_REQUIRED:_("Additional media is required to complete the transaction."),
    ERROR_NOT_AUTHORIZED:_("You have failed to provide correct authentication.\n"
			 "Please check any passwords or account settings."),
    ERROR_UPDATE_NOT_FOUND:_("The specified update could not be found.\n"
			 "It could have already been installed or no longer available on the remote server."),
    ERROR_CANNOT_INSTALL_REPO_UNSIGNED:_("The package could not be installed from untrusted source."),
    ERROR_CANNOT_UPDATE_REPO_UNSIGNED:_("The package could not be updated from untrusted source."),
    ERROR_CANNOT_GET_FILELIST:_("The file list is not available for this package."),
    ERROR_CANNOT_GET_REQUIRES:_("The information about what requires this package could not be obtained."),
    ERROR_CANNOT_DISABLE_REPOSITORY:_("The specified software source could not be disabled."),
    ERROR_RESTRICTED_DOWNLOAD:_("The download could not be done automatically and should be done manually.\n"
			 "More information is available in the detailed report."),
    ERROR_PACKAGE_FAILED_TO_CONFIGURE:_("One of the selected packages failed to configure correctly.\n"
			 "More information is available in the detailed report."),
    ERROR_PACKAGE_FAILED_TO_BUILD:_("One of the selected packages failed to build correctly.\n"
			 "More information is available in the detailed report."),
    ERROR_PACKAGE_FAILED_TO_INSTALL:_("One of the selected packages failed to install correctly.\n"
			 "More information is available in the detailed report."),
    ERROR_PACKAGE_FAILED_TO_REMOVE:_("One of the selected packages failed to be removed correctly.\n"
			 "More information is available in the detailed report."),
    }

def get_error_description_from_enum(enum):
   if DESCS_ERROR.has_key(enum):
       return DESCS_ERROR[enum]
   else:
       return None

STRINGS_ERROR = {
    ERROR_NO_NETWORK:_("No network connection available"),
    ERROR_NO_CACHE:_("No package cache is available."),
    ERROR_OOM:_("Out of memory"),
    ERROR_CREATE_THREAD_FAILED:_("Failed to create a thread"),
    ERROR_NOT_SUPPORTED:_("Not supported by this backend"),
    ERROR_INTERNAL_ERROR:_("An internal system error has occurred"),
    ERROR_GPG_FAILURE:_("A security signature is not present"),
    ERROR_PACKAGE_NOT_INSTALLED:_("The package is not installed"),
    ERROR_PACKAGE_NOT_FOUND:_("The package was not found"),
    ERROR_PACKAGE_ALREADY_INSTALLED:_("The package is already installed"),
    ERROR_PACKAGE_DOWNLOAD_FAILED:_("The package download failed"),
    ERROR_GROUP_NOT_FOUND:_("The group was not found"),
    ERROR_GROUP_LIST_INVALID:_("The group list was invalid"),
    ERROR_DEP_RESOLUTION_FAILED:_("Dependency resolution failed"),
    ERROR_FILTER_INVALID:_("Search filter was invalid"),
    ERROR_PACKAGE_ID_INVALID:_("The package identifier was not well formed"),
    ERROR_TRANSACTION_ERROR:_("Transaction error"),
    ERROR_REPO_NOT_FOUND:_("Repository name was not found"),
    ERROR_CANNOT_REMOVE_SYSTEM_PACKAGE:_("Could not remove a protected system package"),
    ERROR_TRANSACTION_CANCELLED:_("The action was canceled"),
    ERROR_PROCESS_KILL:_("The action was forcibly canceled"),
    ERROR_FAILED_CONFIG_PARSING:_("Reading the configuration file failed"),
    ERROR_CANNOT_CANCEL:_("The action cannot be canceled"),
    ERROR_CANNOT_INSTALL_SOURCE_PACKAGE:_("Source packages cannot be installed"),
    ERROR_NO_LICENSE_AGREEMENT:_("The license agreement failed"),
    ERROR_FILE_CONFLICTS:_("Local file conflict between packages"),
    ERROR_PACKAGE_CONFLICTS:_("Packages are not compatible"),
    ERROR_REPO_NOT_AVAILABLE:_("Problem connecting to a software source"),
    ERROR_FAILED_INITIALIZATION:_("Failed to initialize"),
    ERROR_FAILED_FINALISE:_("Failed to finalise"),
    ERROR_CANNOT_GET_LOCK:_("Cannot get lock"),
    ERROR_NO_PACKAGES_TO_UPDATE:_("No packages to update"),
    ERROR_CANNOT_WRITE_REPO_CONFIG:_("Cannot write repository configuration"),
    ERROR_LOCAL_INSTALL_FAILED:_("Local install failed"),
    ERROR_BAD_GPG_SIGNATURE:_("Bad security signature"),
    ERROR_MISSING_GPG_SIGNATURE:_("Missing security signature"),
    ERROR_REPO_CONFIGURATION_ERROR:_("Repository configuration invalid"),
    ERROR_INVALID_PACKAGE_FILE:_("Invalid package file"),
    ERROR_PACKAGE_INSTALL_BLOCKED:_("Package install blocked"),
    ERROR_PACKAGE_CORRUPT:_("Package is corrupt"),
    ERROR_ALL_PACKAGES_ALREADY_INSTALLED:_("All packages are already installed"),
    ERROR_FILE_NOT_FOUND:_("The specified file could not be found"),
    ERROR_NO_MORE_MIRRORS_TO_TRY:_("No more mirrors are available"),
    ERROR_NO_DISTRO_UPGRADE_DATA:_("No distribution upgrade data is available"),
    ERROR_INCOMPATIBLE_ARCHITECTURE:_("Package is incompatible with this system"),
    ERROR_NO_SPACE_ON_DEVICE:_("No space is left on the disk"),
    ERROR_MEDIA_CHANGE_REQUIRED:_("A media change is required"),
    ERROR_NOT_AUTHORIZED:_("Authorization failed"),
    ERROR_UPDATE_NOT_FOUND:_("Update not found"),
    ERROR_CANNOT_INSTALL_REPO_UNSIGNED:_("Cannot install from untrusted source"),
    ERROR_CANNOT_UPDATE_REPO_UNSIGNED:_("Cannot update from untrusted source"),
    ERROR_CANNOT_GET_FILELIST:_("Cannot get the file list"),
    ERROR_CANNOT_GET_REQUIRES:_("Cannot get package requires"),
    ERROR_CANNOT_DISABLE_REPOSITORY:_("Cannot disable source"),
    ERROR_RESTRICTED_DOWNLOAD:_("The download failed"),
    ERROR_PACKAGE_FAILED_TO_CONFIGURE:_("Package failed to configure"),
    ERROR_PACKAGE_FAILED_TO_BUILD:_("Package failed to build"),
    ERROR_PACKAGE_FAILED_TO_INSTALL:_("Package failed to install"),
    ERROR_PACKAGE_FAILED_TO_REMOVE:_("Package failed to be removed"),
    }

def get_error_string_from_enum(enum):
   if STRINGS_ERROR.has_key(enum):
       return STRINGS_ERROR[enum]
   else:
       return None

STRINGS_RESTART = {
    RESTART_NONE:_("No restart is required."),
    RESTART_SYSTEM:_("A restart is required."),
    RESTART_SESSION:_("You need to log out and log back in."),
    RESTART_APPLICATION:_("You need to restart the application."),
    RESTART_SECURITY_SESSION:_("You need to log out and log back in to remain secure."),
    RESTART_SECURITY_SYSTEM:_("A restart is required to remain secure."),
    }

def get_restart_string_from_enum(enum):
   if STRINGS_RESTART.has_key(enum):
       return STRINGS_RESTART[enum]
   else:
       return None

STRINGS_MESSAGE = {
    MESSAGE_BROKEN_MIRROR:_("A mirror is possibly broken"),
    MESSAGE_CONNECTION_REFUSED:_("The connection was refused"),
    MESSAGE_PARAMETER_INVALID:_("The parameter was invalid"),
    MESSAGE_PRIORITY_INVALID:_("The priority was invalid"),
    MESSAGE_BACKEND_ERROR:_("Backend warning"),
    MESSAGE_DAEMON_ERROR:_("Daemon warning"),
    MESSAGE_CACHE_BEING_REBUILT:_("The package list cache is being rebuilt"),
    MESSAGE_UNTRUSTED_PACKAGE:_("An untrusted package was installed"),
    MESSAGE_NEWER_PACKAGE_EXISTS:_("A newer package exists"),
    MESSAGE_COULD_NOT_FIND_PACKAGE:_("Could not find package"),
    MESSAGE_CONFIG_FILES_CHANGED:_("Configuration files were changed"),
    MESSAGE_PACKAGE_ALREADY_INSTALLED:_("Package is already installed"),
    MESSAGE_AUTOREMOVE_IGNORED:_("Automatic cleanup is being ignored"),
    MESSAGE_REPO_METADATA_DOWNLOAD_FAILED:_("The package download failed"),
    }

def get_message_string_from_enum(enum):
   if STRINGS_MESSAGE.has_key(enum):
       return STRINGS_MESSAGE[enum]
   else:
       return None

STRINGS_STATUS = {
    }

def get_status_string_from_enum(enum):
   if STRINGS_STATUS.has_key(enum):
       return STRINGS_STATUS[enum]
   else:
       return None

STRINGS_INFO = {
    }

def get_info_string_from_enum(enum):
   if STRINGS_INFO.has_key(enum):
       return STRINGS_INFO[enum]
   else:
       return None

STRINGS_GROUP = {
    }

def get_group_string_from_enum(enum):
   if STRINGS_GROUP.has_key(enum):
       return STRINGS_GROUP[enum]
   else:
       return None

