#include <glibtop.h>
#include <glibtop/procmap.h>

#include <stdlib.h>

#include <unistd.h>

int main(int argc, char **argv)
{
  int i;
  pid_t pid = 0;

  if (argc == 2)
    pid = strtol(argv[1], NULL, 10);

  if (!pid)
    pid = getpid();

  glibtop_init();

  g_print("pid = %u\n", (unsigned)pid);

  for (i = 0; i != 1000; ++i) {
    glibtop_proc_map buf;
    glibtop_map_entry* entries;

    entries = glibtop_get_proc_map(&buf, pid);

    /* g_print("%u\n", (unsigned)buf.number); */

    g_free(entries);
  }

  glibtop_close();

  return 0;
}

