%define glib2_base_version 2.0.0
%define glib2_version %{glib2_base_version}-1
%define pkgconfig_version 0.12
%define freetype_version 2.1.2-2
%define fontconfig_version 0.0.1.020626.1517-2
%define xft_version 1.9.1.020626.1517-1

Summary: System for layout and rendering of internationalized text.
Name: pango
Version: 1.2.0
Release: 1
License: LGPL
Group: System Environment/Libraries
Source: ftp://ftp.gtk.org/pub/gtk/v2.1/pango-%{version}.tar.bz2
URL: http://www.pango.org
BuildRoot: %{_tmppath}/pango-%{PACKAGE_VERSION}-root

# We need to prereq this so we can run pango-querymodules
Prereq: glib2 >= %{glib2_version}
BuildRequires: libtool >= 1.4.2-10
BuildRequires: glib2-devel >= %{glib2_version}
BuildRequires: pkgconfig >= %{pkgconfig_version}
BuildRequires: freetype-devel >= %{freetype_version}
BuildRequires: fontconfig-devel >= %{fontconfig_version}
BuildRequires: Xft-devel >= %{xft_version}
BuildRequires: XFree86-devel >= 4.0.2
Obsoletes: pango-gtkbeta, fribidi-gtkbeta

%description
Pango is a system for layout and rendering of internationalized text.


%package devel
Summary: System for layout and rendering of internationalized text.
Group: Development/Libraries
Requires: pango = %{PACKAGE_VERSION}
Requires: XFree86-devel
Requires: glib2-devel >= %{glib2_version}
Requires: freetype-devel >= %{freetype_version}
Requires: fontconfig-devel >= %{fontconfig_version}
Requires: Xft-devel >= %{xft_version}
Obsoletes: fribidi-gtkbeta-devel, pango-gtkbeta-devel

%description devel
The pango-devel package includes the static libraries, header files,
and developer docs for the pango package.

Install pango-devel if you want to develop programs which will use
pango.

%prep
%setup -q -n pango-%{version}

%build

%configure --without-qt --disable-gtk-doc
make

%install
rm -rf $RPM_BUILD_ROOT

%makeinstall
rm -rf $RPM_BUILD_ROOT%{_libdir}/*.la
%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
%{_prefix}/bin/pango-querymodules > /etc/pango/pango.modules

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%doc README AUTHORS COPYING ChangeLog TODO
%doc examples/HELLO.utf8
%{_prefix}/lib/libpango*-*.so.*
%{_prefix}/bin/pango-querymodules
%{_prefix}/lib/pango
%config /etc/pango/pangox.aliases
%ghost /etc/pango/pango.modules


%files devel
%defattr(-, root, root)
%{_prefix}/lib/libpango*.so
%{_prefix}/include/*
%{_prefix}/lib/pkgconfig/*
%{_prefix}/share/gtk-doc/*


%changelog
* Mon Nov 04 2002 Christian Schaller <Uraeus@linuxrising.org>
- Update for use in CVS package

* Fri Feb 11 2000 Owen Taylor <otaylor@redhat.com>
- Created spec file
